/* This file is -*-C++-*-
------------------------------------------------------------------------------
MetaCam - Extract EXIF information from digital camera files, with
support for Vendor specific blocks.
Copyright (C) 2000 Daniel Stephens (daniel@cheeseplant.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
------------------------------------------------------------------------------

$Id: dpyfuncs.h,v 1.5 2001/12/25 19:47:39 daniel Exp $

*/

#ifndef DPYFUNCS_H_INCLUDED
#define DPYFUNCS_H_INCLUDED

#include "metacam.h"

// Display functions

extern void dpyISO(ostream &os, const char *, const IFDEntry &e);
extern void dpyString(ostream &os, const char *, const IFDEntry &e);
extern void dpyLens(ostream &os, const char *, const IFDEntry &e);
extern void dpyZoom(ostream &os, const char *, const IFDEntry &e);
extern void dpyExpAdjust(ostream &os, const char *, const IFDEntry &e);
extern void dpyShutter(ostream &os, const char *, const IFDEntry &e);
extern void dpyAperture(ostream &os, const char *, const IFDEntry &e);
extern void dpyPixels(ostream &os, const char *, const IFDEntry &e);
extern void dpySigned(ostream &os, const char *, const IFDEntry &e);
extern void dpyUnsigned(ostream &os, const char *, const IFDEntry &e);
extern void dpyResolution(ostream &os, const char *, const IFDEntry &e);
extern void dpyNULL(ostream &os, const char *, const IFDEntry &e);
extern void dpyYes(ostream &os, const char *, const IFDEntry &e);
extern void dpyResolutionType(ostream &os, const char *, const IFDEntry &e);
extern void dpyBitsPerSample(ostream &os, const char *, const IFDEntry &e);
extern void dpyPhotometric(ostream &os, const char *, const IFDEntry &e);
extern void dpyCompression(ostream &os, const char *, const IFDEntry &e);
extern void dpyYCbCrPositioning(ostream &os, const char *, const IFDEntry &e);
extern void dpyExposureProgram(ostream &os, const char *, const IFDEntry &e);
extern void dpyMeteringMode(ostream &os, const char *, const IFDEntry &e);
extern void dpyLightSource(ostream &os, const char *, const IFDEntry &e);
extern void dpyYesNo(ostream &os, const char *, const IFDEntry &e);
extern void dpySensingMethod(ostream &os, const char *, const IFDEntry &e);
extern void dpyExifVersion(ostream &os, const char *, const IFDEntry &e);
extern void dpyExifAperture(ostream &os, const char *, const IFDEntry &e);
extern void dpyExifShutter(ostream &os, const char *, const IFDEntry &e);
extern void dpyRationalAsDouble(ostream &os, const char *, const IFDEntry &e);
extern void dpyOlymJPEGQuality(ostream &os, const char *, const IFDEntry &e);
extern void dpyOlymSpecialMode(ostream &os, const char *, const IFDEntry &e);
extern void dpyOlymZoom(ostream &os, const char *name, const IFDEntry &e);
extern void dpyCanonBlock1(ostream &os, const char *name, const IFDEntry &e);
extern void dpyCanonBlock4(ostream &os, const char *name, const IFDEntry &e);
extern void dpyCanonImageNumber(ostream &os, const char *name, const IFDEntry &e);
extern void dpyCanonSerialNumber(ostream &os, const char *name, const IFDEntry &e);
extern void dpyCasioRecMode(ostream &os, const char *name, const IFDEntry &e);
extern void dpyCasioQuality(ostream &os, const char *name, const IFDEntry &e);
extern void dpyCasioFocusMode(ostream &os, const char *name, const IFDEntry &e);
extern void dpyCasioFlashMode(ostream &os, const char *name, const IFDEntry &e);
extern void dpyCasioFlashInten(ostream &os, const char *name, const IFDEntry &e);
extern void dpyCasioDistance(ostream &os, const char *name, const IFDEntry &e);
extern void dpyCasioWhiteBalance(ostream &os, const char *name, const IFDEntry &e);
extern void dpyCasioDigitalZoom(ostream &os, const char *name, const IFDEntry &e);
extern void dpyCasioSharpness(ostream &os, const char *name, const IFDEntry &e);
extern void dpyCasioContrast(ostream &os, const char *name, const IFDEntry &e);
extern void dpyCasioSaturation(ostream &os, const char *name, const IFDEntry &e);
extern void dpyCasioSensitivity(ostream &os, const char *name, const IFDEntry &e);

// Tag Format Lists

extern knowntag main_known[];
extern knowntag exif_known[];
extern knowntag empty_known[];

extern knowntag nikon_known[];

extern knowntag olympus_known[];

extern knowntag canon_known[];

extern knowntag casio_known[];

extern const char *resolution_unit; // hack 8-(

#endif /* DPYFUNCS_H_INCLUDED */
