/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "MvQFolderItemProperty.h"

#include <QApplication>

//========================================
//
//     MvQAbstractIconItemProperty
//
//========================================

MvQAbstractIconItemProperty::MvQAbstractIconItemProperty() :
  refIconSize_(32),
  fm_(QApplication::font()),
  refFm_(QApplication::font())
{
	iconSize_=refIconSize_;
	scaling_=1.;
	font_=QApplication::font();
	refFont_=QApplication::font();   
	refFm_=QFontMetrics(font_);    
}  

bool MvQAbstractIconItemProperty::setIconSize(int size)
{
  	if(iconSize_ == size)
	  	return false;
	  
	iconSize_=size;	
	update();

	return true;
}  

//========================================
//
//     MvQClassicIconItemProperty
//
//========================================

MvQClassicIconItemProperty::MvQClassicIconItemProperty()    
{ 	
	textOffset_=5;		
	height_=iconSize_+textOffset_+fm_.height();	
	refHeight_=height_;
}  

void MvQClassicIconItemProperty::update()
{  	
  	if(iconSize_ != refIconSize_)
	{
	  	if(iconSize_ > 32)
		{  
	  		float dScale=static_cast<float>(iconSize_)/32.;	
			int h=refFont_.pointSize();		
			font_.setPointSize(2*(static_cast<int>(h*dScale)/2));   
		}
		else
		{
		  	font_=refFont_;
		}
		
		fm_=QFontMetrics(font_);		
		height_=iconSize_+textOffset_+fm_.height();				
		scaling_=static_cast<float>(height_)/static_cast<float>(refHeight_);
	}
	else
	{  	
	  	font_=refFont_;   
		fm_=refFm_;
		height_=refHeight_;		
		scaling_=1.;
	}  
}  


QPoint MvQClassicIconItemProperty::position(QString name, QPoint refPos)
{	
	if(iconSize_ != refIconSize_)
	{		
		//Ref centre
		int refTextW=refFm_.width(name);
		int refW=(refTextW < 32)?32:refTextW;
		int cx=refPos.x()+refW/2;
		//int cy=refPos.y()+refHeight_/2;
			
		//Item width
		int textW=fm_.width(name);
		int w=(textW < iconSize_)?iconSize_:textW;
		
		int x=cx*((iconSize_>32)?(scaling_+1)*0.5:1)-w/2;
		int y=refPos.y()*scaling_;  //cy*scaling_-height_/2;		
		return QPoint(x,y);		
	}
	
	return refPos;
}

QPoint MvQClassicIconItemProperty::positionFromHotSpot(QString name, QPoint pos,QPointF hotSpotAtPos)
{	
	//hotSpotAtPos is the relative position inside the icon pixmap
	QSize s=size(name);
	QPoint d(iconSize_*hotSpotAtPos.x(),iconSize_*hotSpotAtPos.y());
  	return QPoint(pos.x()-d.x()-(s.width()-iconSize_)/2,pos.y()-d.y());
}	


QSize MvQClassicIconItemProperty::size(QString name)
{	  
	int textW=fm_.width(name);
	int w=(textW < iconSize_)?iconSize_:textW;
	return QSize(w,height_);
}


QPoint MvQClassicIconItemProperty::referencePosition(QString name,QPoint pos)
{
	if(iconSize_ != refIconSize_)
	{
	  	//Item width
		int textW=fm_.width(name);
		int w=(textW < iconSize_)?iconSize_:textW;
		
		//Item centre
		int cx=(pos.x()+w/2)/((iconSize_>32)?(scaling_+1)*0.5:1);
		//int cy=pos.y()+height_/2;
				
		//Ref width
		int refTextW=refFm_.width(name);
		int refW=(refTextW < 32)?32:refTextW;
		
		//Ref
		int refX=cx-refW/2;
		int refY=pos.y()/scaling_; //cy/scaling_-refHeight_/2;
		
		return QPoint(refX,refY);
	}
	
	return pos;
}	

QPoint MvQClassicIconItemProperty::adjsutReferencePosition(QString name,QString oriName,QPoint pos)
{
	//Ref width
	int oriW=refFm_.width(oriName);
	if(oriW < 32) oriW=32;
	int w=refFm_.width(name);
	if(w < 32) w=32;
	
	return QPoint(pos.x()-(w-oriW)/2.,pos.y());
}
 
//========================================
//
//     MvQSimpleIconItemProperty
//
//========================================

MvQSimpleIconItemProperty::MvQSimpleIconItemProperty()    
{ 
	textOffset_=5;		
	height_=iconSize_;	
	refHeight_=height_;
}  


void MvQSimpleIconItemProperty::update()
{  
	if(iconSize_ != refIconSize_)
	{
	  	if(iconSize_ > 32)
		{  
	  		float dScale=static_cast<float>(iconSize_)/32.;	
			int h=refFont_.pointSize();		
			font_.setPointSize(2*(static_cast<int>(h*dScale)/2));   
		}
		else
		{
		  	font_=refFont_;
		}
		
		fm_=QFontMetrics(font_);		
		height_=iconSize_;		
		scaling_=static_cast<float>(height_)/static_cast<float>(refHeight_);
	}
	else
	{  	
	  	font_=refFont_;   
		fm_=refFm_;		
		height_=refHeight_;
		scaling_=1.;
	}
}  


QPoint MvQSimpleIconItemProperty::position(QString, QPoint refPos)
{	
	if(iconSize_ != refIconSize_)
	{
		int x=refPos.x()*((iconSize_>32)?(scaling_+1)*0.5:1);
		int y=refPos.y()*scaling_; 	
		return QPoint(x,y);
	}
	
	return refPos;
}

QPoint MvQSimpleIconItemProperty::positionFromHotSpot(QString name, QPoint pos,QPointF hotSpotAtPos)
{	
	//hotSpotAtPos is the relative position inside the icon pixmap 		
	QSize s=size(name);
	QPoint d(iconSize_*hotSpotAtPos.x(),iconSize_*hotSpotAtPos.y());
  	return QPoint(pos.x()-d.x(),pos.y()-d.y());
}	


QSize MvQSimpleIconItemProperty::size(QString name)
{	
	int textW=fm_.width(name);
	int w=iconSize_+textOffset_+textW;
	return QSize(w,height_);
}


QPoint MvQSimpleIconItemProperty::referencePosition(QString,QPoint pos)
{
	if(iconSize_ != refIconSize_)
	{		
		//Ref
		int refX=pos.x()/((iconSize_>32)?(scaling_+1)*0.5:1);
		int refY=pos.y()/scaling_; 
		return QPoint(refX,refY);
	}
	
	return pos;
}	

QPoint MvQSimpleIconItemProperty::adjsutReferencePosition(QString /*name*/,QString /*oriName*/,QPoint /*pos*/)
{
	return QPoint();
}
//========================================
//
//     MvQDetailedIconItemProperty
//
//========================================

MvQDetailedIconItemProperty::MvQDetailedIconItemProperty()    
{ 	
	textOffset_=5;		
	height_=iconSize_;	
	refHeight_=height_;
}  

void MvQDetailedIconItemProperty::update()
{  	
  	if(iconSize_ != refIconSize_)
	{
	  	if(iconSize_ > 32)
		{  
	  		float dScale=static_cast<float>(iconSize_)/32.;	
			int h=refFont_.pointSize();		
			font_.setPointSize(2*(static_cast<int>(h*dScale)/2));   
		}
		else
		{
		  	font_=refFont_;
		}
		
		fm_=QFontMetrics(font_);		
		height_=iconSize_+textOffset_+fm_.height();				
		scaling_=static_cast<float>(height_)/static_cast<float>(refHeight_);
	}
	else
	{  	
	  	font_=refFont_;   
		fm_=refFm_;
		height_=refHeight_;		
		scaling_=1.;
	}  
}  


QPoint MvQDetailedIconItemProperty::position(QString /*name*/, QPoint refPos)
{	
	return refPos;
}

QPoint MvQDetailedIconItemProperty::positionFromHotSpot(QString /*name*/, QPoint pos,QPointF /*hotSpotAtPos*/)
{	
  	return pos;
}	


QSize MvQDetailedIconItemProperty::size(QString name)
{	  
	int textW=fm_.width(name);
	int w=iconSize_+textOffset_+textW;
	return QSize(w,height_);
}

QPoint MvQDetailedIconItemProperty::referencePosition(QString /*name*/,QPoint pos)
{
	return pos;
}	

QPoint MvQDetailedIconItemProperty::adjsutReferencePosition(QString /*name*/,QString /*oriName*/,QPoint pos)
{
	return pos;
}
 

//============================================
//
//   MvQFolderItemProperty
//
//============================================

MvQFolderItemProperty::MvQFolderItemProperty() :
    viewMode_(Desktop::IconViewMode),
    current_(0)
    
{ 
	prop_[Desktop::IconViewMode]=new MvQClassicIconItemProperty;
	prop_[Desktop::SimpleViewMode]=new MvQSimpleIconItemProperty;
	prop_[Desktop::DetailedViewMode]=new MvQDetailedIconItemProperty;
  	current_=prop_[viewMode_];
	iconSize_=current_->iconSize();
}  

MvQFolderItemProperty::~MvQFolderItemProperty()
{
  	QMap<Desktop::FolderViewMode,MvQAbstractIconItemProperty*>::iterator it = prop_.begin();
	while(it != prop_.end())
	{
		delete it.value();
		++it;
	}	
}

int MvQFolderItemProperty::iconSize()
{
  	return iconSize_;
}

float MvQFolderItemProperty::scaling()
{
  	return current_->scaling();
}

QFont MvQFolderItemProperty::font()
{
  	return current_->font();
}

int MvQFolderItemProperty::textHeight()
{
  	return current_->textHeight();
}	

int MvQFolderItemProperty::textOffset()
{
  	return current_->textOffset();
}

void MvQFolderItemProperty::setViewMode(Desktop::FolderViewMode mode)
{
  	viewMode_=mode;
	QMap<Desktop::FolderViewMode,MvQAbstractIconItemProperty*>::iterator it=prop_.find(mode);
	if( it != prop_.end())
	{
	  	current_=it.value();
		current_->setIconSize(iconSize_);
	}	
}  

/*void MvQFolderItemProperty::setTextPosMode(TextPosMode tp)
{
  	textPosMode_=tp;
	QMap<TextPosMode,MvQAbstractIconItemProperty*>::iterator it=prop_.find(tp);
	if( it != prop_.end())
	{
	  	current_=it.value();
	}	
} */ 

bool MvQFolderItemProperty::setIconSize(int size)
{
	if(iconSize_ == size)
	  	return false;
	  
	iconSize_=size;	
	current_->setIconSize(iconSize_);
	
	return true;
}
	
/*	retVal=it.value()->setIconSize(size);
	
	QMap<TextPosMode,MvQAbstractIconItemProperty*>::iterator it = prop_.begin();
	while(it != prop_.end())
	{
		if(it.value() == current_)
		{
		  	retVal=it.value()->setIconSize(size);
		}
		else
		{
		  	it.value()->setIconSize(size);
		}
		++it;
	}
	
	return retVal;
}  */

QPoint MvQFolderItemProperty::position(QString name, QPoint refPos)
{	
	return current_->position(name,refPos);
}		

QPoint MvQFolderItemProperty::positionFromHotSpot(QString name, QPoint pos,QPointF hotSpotAtPos)
{
	return current_->positionFromHotSpot(name,pos,hotSpotAtPos);
}	
	
QSize MvQFolderItemProperty::size(QString name)
{
 	return current_->size(name); 
}  

QPoint MvQFolderItemProperty::referencePosition(QString name,QPoint pos)
{
 	return current_->referencePosition(name,pos);
}  

QPoint MvQFolderItemProperty::adjsutReferencePosition(QString name,QString oriName,QPoint pos)
{
  	return current_->adjsutReferencePosition(name,oriName,pos);
}





/*


MvQFolderItemProperty::MvQFolderItemProperty() :
    fm_(QApplication::font()),
    refFm_(fm_),
    textOffset_(5),
    textPosMode_(TextBelow)
    
{ 
	iconSize_=32;
	
	refIconSize_=32;
	scaling_=1.;
	
	font_=QApplication::font();   
	fm_=QFontMetrics(font_);  
	
	height_[TextBelow]=iconSize_+5+fm_.height();
	height_[TextBeside]=iconSize_;
		  
	refFont_=QApplication::font();   
	refFm_=QFontMetrics(font_); 	
	
	refHeight_[TextBelow]=height_[TextBelow];
	refHeight_[TextBeside]=height_[TextBeside];
}  

void MvQFolderItemProperty::update()
{  
	if(iconSize_ != 32)
	{
	  	if(iconSize_ > 32)
		{  
	  		float dScale=static_cast<float>(iconSize_)/32.;	
			int h=refFont_.pointSize();		
			font_.setPointSize(2*(static_cast<int>(h*dScale)/2));   
		}
		
		fm_=QFontMetrics(font_);
		
		height_[TextBelow]=iconSize_+textOffset_+fm_.height();		
		height_[TextBeside]=iconSize_;
		
		scaling_=static_cast<float>(height_[TextBelow])/static_cast<float>(refHeight_[TextBelow]);
	}
	else
	{  	
	  	font_=refFont_;   
		fm_=refFm_;
		height_[TextBelow]=refHeight_[TextBelow];
		height_[TextBeside]=refHeight_[TextBeside];
		scaling_=1.;
	}
}  


void MvQFolderItemProperty::setTextPosMode(TextPosMode tp)
{
  	textPosMode_=tp;
	update();
}  

bool MvQFolderItemProperty::setIconSize(int size)
{
  	if(iconSize_ == size)
	  	return false;
	  
	iconSize_=size;	
	update();

	return true;
}  

QPoint MvQFolderItemProperty::position(QString name, QPoint refPos)
{	
	if(iconSize_ != 32)
	{
		if(textPosMode_ == TextBelow)
		{  
	  		//Ref centre
			int refTextW=refFm_.width(name);
			int refW=(refTextW < 32)?32:refTextW;
			int cx=refPos.x()+refW/2;
			//int cy=refPos.y()+refHeight_/2;
			
			//Item width
			int textW=fm_.width(name);
			int w=(textW < iconSize_)?iconSize_:textW;
		
			int x=cx*((iconSize_>32)?(scaling_+1)*0.5:1)-w/2;
			int y=refPos.y()*scaling_;  //cy*scaling_-height_/2;		
			return QPoint(x,y);
		}
		else if(textPosMode_ == TextBeside)
		{
			int x=refPos.x()*((iconSize_>32)?(scaling_+1)*0.5:1);
			int y=refPos.y()*scaling_; 	
			return QPoint(x,y);
		}  
	}
	
	return refPos;
}

QPoint MvQFolderItemProperty::positionFromHotSpot(QString name, QPoint pos,QPointF hotSpotAtPos)
{	
	//hotSpotAtPos is the relative position inside the icon pixmap
  	if(textPosMode_ == TextBelow)
	{ 
	  	QSize s=size(name);
		QPoint d(iconSize_*hotSpotAtPos.x(),iconSize_*hotSpotAtPos.y());
  		return QPoint(pos.x()-d.x()-(s.width()-iconSize_)/2,pos.y()-d.y());
	}
	else if(textPosMode_ == TextBeside)
	{
	  	QSize s=size(name);
		QPoint d(iconSize_*hotSpotAtPos.x(),iconSize_*hotSpotAtPos.y());
  		return QPoint(pos.x()-d.x(),pos.y()-d.y());
	}
	
	return QPoint();
}	


QSize MvQFolderItemProperty::size(QString name)
{
	if(textPosMode_ == TextBelow)
	{  
		int textW=fm_.width(name);
		int w=(textW < iconSize_)?iconSize_:textW;
		return QSize(w,height_[TextBelow]);
	}
	else if(textPosMode_ == TextBeside)
	{
	  	int textW=fm_.width(name);
		int w=iconSize_+textOffset_+textW;
		return QSize(w,height_[TextBeside]);
	}
	
	return QSize();
}


QPoint MvQFolderItemProperty::referencePosition(QString name,QPoint pos)
{
	if(iconSize_ != 32)
	{
		if(textPosMode_ == TextBelow)
		{  	  
	  		//Item width
			int textW=fm_.width(name);
			int w=(textW < iconSize_)?iconSize_:textW;
		
			//Item centre
			int cx=pos.x()/((iconSize_>32)?(scaling_+1)*0.5:1)+w/2;
			//int cy=pos.y()+height_/2;
				
			//Ref width
			int refTextW=refFm_.width(name);
			int refW=(refTextW < 32)?32:refTextW;
		
			//Ref
			int refX=cx-refW/2;
			int refY=pos.y()/scaling_; //cy/scaling_-refHeight_/2;
		
			return QPoint(refX,refY);
		}
		else if(textPosMode_ == TextBeside)
		{
			//Ref
			int refX=pos.x()/((iconSize_>32)?(scaling_+1)*0.5:1);
			int refY=pos.y()/scaling_; 
			return QPoint(refX,refY);
		
		}  
	}
	
	return pos;
}	

QPoint MvQFolderItemProperty::adjsutReferencePosition(QString name,QString oriName,QPoint pos)
{
	if(textPosMode_ == TextBelow)
	{  	
		//Ref width
		int oriW=refFm_.width(oriName);
		if(oriW < 32) oriW=32;
		int w=refFm_.width(name);
		if(w < 32) w=32;
	
		return QPoint(pos.x()-(w-oriW)/2.,pos.y());
	}
	else if(textPosMode_ == TextBeside)
	{
			
	}
	
	return QPoint();
}
*/

