/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQPalette_H
#define MvQPalette_H

#include <QColor>

#include <string>
using std::string;

struct request;
//struct RGBColor;
//struct HSLColor;

class PaletteScanner {
public:
	virtual void next(const string&,QColor) = 0;
};

class MvQPalette 
{
public:

	MvQPalette(int);
	~MvQPalette();

	static  string toString(QColor);
	static  QColor magics(const string&); 
	
	/*static Pixel pixel(const RGBColor&);
	static Pixel pixel(const HSLColor&);

	static Pixel  pixel(const string&); // Name is X name
	static Pixel  magics(const string&); // Name is Magics name

	static void convert(const RGBColor&,HSLColor&);
	static void convert(const HSLColor&,RGBColor&);

	// Names are magics names

	static void convert(const string&,RGBColor&);
	static bool convert(const RGBColor&,string&);
	static bool exists(const string&);*/


	//---

	static void scan(PaletteScanner&);
	static void load(request*);

protected:	
	static QColor hexaCharToColour(const char *);


private:
	MvQPalette(const MvQPalette&);
	MvQPalette& operator=(const MvQPalette&);
};

//inline void destroy(XPalette**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(XPalette);
//#endif

#endif
