/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File FamilyEditor.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef FamilyEditor_H
#define FamilyEditor_H

#ifndef InternalEditor_H
#include "InternalEditor.h"
#endif

#include "UIFamilyEditor.h"

#ifndef Parameter_H
#include "Parameter.h"
#endif

class RequestPanel;
class FamilyHelper;

#define MV_EXT_PANEL

#ifdef MV_EXT_PANEL
struct Panel {
	RequestPanel* panel_;
	IconObjectH   temp_;
	Request       first_;
	Widget        tab_;

	Panel():panel_(0),temp_(0),tab_(0){}
};
#endif

class FamilyEditor : public XEditor<UIFamilyEditor_c> {
public:

// -- Exceptions
	// None

// -- Contructors

	FamilyEditor(const IconClass&,const string&);

// -- Destructor

	virtual ~FamilyEditor(); // Change to virtual if base class  

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods
	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	FamilyEditor(const FamilyEditor&);
	FamilyEditor& operator=(const FamilyEditor&);

// -- Members

	FamilyHelper&              helper_;

#ifdef MV_EXT_PANEL
	Panel  pan_;
#else
	struct Panel {
		RequestPanel* panel_;
		IconObjectH   temp_;
		Request       first_;
		Widget        tab_;
	};
#endif
	map<string, Panel>  panels_;

// -- Methods

	void makeTabs(Widget,int,Request&);
	string choice();
	Panel& frontPanel();

// -- Overridden methods


	// From InternalEditor
	virtual void apply();
	virtual void reset();
	virtual void close();
	virtual void replace(IconObject*);
	virtual void merge(IconObject*);

	virtual IconObject* copy(const string&); 

	// From XD
	virtual void familyCB(Widget, XtPointer);


// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const FamilyEditor& p)
	//	{ p.print(s); return s; }

};

inline void destroy(FamilyEditor**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(FamilyEditor);
//#endif

#endif
