/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQObstatCurveToolBase_H
#define MvQObstatCurveToolBase_H

#include <QComboBox>
#include <QMainWindow>
#include <QStandardItemModel>

#include "MvQMainWindow.h"
#include "MvQMenuItem.h"
#include "MvQObstatCurveData.h"

class QColor;
class QGroupBox;
class QLabel;
class QListWidget;
class QListWidgetItem;
class QPushButton;
class QSortFilterProxyModel;
class QSplitter;
class QStackedWidget;
class QTextBrowser;
class QTreeView;
class QTreeWidget;
class QTreeWidgetItem;
class QVBoxLayout;

class MvKeyProfile;

class MvQFileInfoLabel;
class MvQKeyManager;
class MvQKeyProfileModel;
class MvQPlotWidget;
class MvQTreeView;

class MvQObstatCurveToolBase : public QObject
{
    Q_OBJECT

public:
    	MvQObstatCurveToolBase(QWidget *parent = 0);
    	~MvQObstatCurveToolBase();
    	void init(MvQObstatCurveData*);

	MvQFileInfoLabel* fileInfoLabel() {return fileInfoLabel_;}
	QWidget* itemPanel() {return itemPanel_;}
	QWidget* plotPanel() {return plotPanel_;}
	
	void updateFileInfoLabel();
	const MvQMainWindow::MenuItemMap menuItems () {return menuItems_;}

public slots:
	void slotSelectItem(QModelIndex);
	
signals:
	void logOutputChanged();
	void itemSelected(int);
	
private:	
	void setupViewActions();
	void setupSettingsActions();
	void setupItemBox();
	void setupPlotBox();
 
	void loadKeyProfile(MvKeyProfile *);

	void loadItems(int);
	void createPlot();
	
	MvQObstatCurveData *data_;
 	int currentItemNo_;

	MvQMainWindow::MenuItemMap menuItems_;

	MvQFileInfoLabel*  fileInfoLabel_;

	QWidget*     plotPanel_;
	QWidget*     itemPanel_;

	MvQTreeView*   itemTree_;
	MvQKeyProfileModel* itemModel_;
	QSortFilterProxyModel* itemSortModel_;

	QLabel *plotWidget_;

	QString magmlScript_;
};

#endif
