/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

//
// .NAME:
//  MagicsTranslator
//
// .AUTHOR:
//  Gilberto Camara, Baudouin Raoult and Fernando Ii
//
// .SUMMARY:
//  A general class for translatiopn of METVIEW requests
//  into MAGICS requests
//
// .CLIENTS:
//  MagicsAction, MapView
//
//
// .RESPONSABILITIES:
//  - Read the incoming METVIEW requests 
//  - Find the appropriate MAGIS equivalents
//  - Provide new magics request
//
// .COLLABORATORS:
//
//
//
// .BASE CLASS:
//  Prototype
//
// .DERIVED CLASSES:
//  GribTranslator, ImageTranslator, BufrTranslator
//
// .REFERENCES:
//
//
#ifndef MagicsTranslator_H
#define MagicsTranslator_H

#include <Prototype.hpp>
#include <MvRequest.h>

class MagicsTranslator;

struct MagicsTranslatorTraits {
        typedef MagicsTranslator         Type;
        static  Type&                DefaultObject();
};

class MagicsTranslator : public Prototype <MagicsTranslatorTraits> 
{
public:

	// Contructors
	MagicsTranslator(const Cached& actionName ) :
                Prototype<MagicsTranslatorTraits> ( actionName, this ){}

	// Destructor
	virtual ~MagicsTranslator();

	virtual MvRequest Execute ( const MvRequest&, const MvRequest&, MvRequest& ) = 0;
	virtual MvRequest Execute ( const MvRequest& ) = 0;
};

class GribTranslator : public MagicsTranslator
{
public:

	// Contructors
	GribTranslator(const Cached& actionName ) :
                MagicsTranslator ( actionName ){}

	// Destructor
	~GribTranslator() {}

	virtual MvRequest Execute ( const MvRequest&, const MvRequest&, MvRequest& );

	virtual MvRequest Execute ( const MvRequest& )
 		{ return MvRequest("EMPTY"); }

	static MagicsTranslator& Instance(); // for the default object
};

#if 0
class ImageTranslator : public MagicsTranslator
{
public:

	// Contructors
	ImageTranslator(const Cached& actionName ) :
                MagicsTranslator ( actionName ){}

	// Destructor
	~ImageTranslator() {}

	virtual MvRequest Execute ( const MvRequest&, long, const MvRequest&, MvRequest& );

	virtual MvRequest Execute ( const MvRequest& )
 		{ return MvRequest("EMPTY"); }
};
#endif

class BufrTranslator : public MagicsTranslator
{
public:

	// Contructors
	BufrTranslator(const Cached& actionName ):
                MagicsTranslator ( actionName ){}

	// Destructor
	~BufrTranslator() {}

	virtual MvRequest Execute ( const MvRequest&, const MvRequest&, MvRequest& );

	virtual MvRequest Execute ( const MvRequest& )
 		{ return MvRequest("EMPTY"); }
};

class ObsTranslator : public MagicsTranslator
{
public:

  // Contructors
  ObsTranslator(const Cached& actionName ):
    MagicsTranslator ( actionName ){}

  // Destructor
  ~ObsTranslator() {}

  virtual MvRequest Execute ( const MvRequest& );

  virtual MvRequest Execute ( const MvRequest&, const MvRequest&, MvRequest& )
    { return MvRequest("EMPTY"); }
};

class CoastTranslator : public MagicsTranslator 
{
public:

	// Contructors
	CoastTranslator(const Cached& actionName ): 
                MagicsTranslator ( actionName ){}

	// Destructor
	~CoastTranslator() {}

	virtual MvRequest Execute ( const MvRequest& );
	virtual MvRequest Execute ( const MvRequest&, const MvRequest&, MvRequest& )
		{ return MvRequest("EMPTY"); }
};

class ContTranslator : public MagicsTranslator
{
public:

	// Contructors
	ContTranslator(const Cached& actionName ): 
                MagicsTranslator ( actionName ){}

	// Destructor
	~ContTranslator() {}

	virtual MvRequest Execute ( const MvRequest& );
	virtual MvRequest Execute ( const MvRequest&, const MvRequest&, MvRequest& )
		{ return MvRequest("EMPTY"); }
};

#if 0
class FrameTranslator : public MagicsTranslator 
{
public:

// -- Contructors

	FrameTranslator(const Cached& actionName ): 
                MagicsTranslator ( actionName ){}

// -- Destructor

	~FrameTranslator() {}

	virtual MvRequest Execute ( const MvRequest& );
	virtual MvRequest Execute ( const MvRequest&, long, const MvRequest&, MvRequest& )
		{ return MvRequest("EMPTY"); }


};
#endif

class TextTranslator : public MagicsTranslator
{
public:

	// Contructors
	TextTranslator(const Cached& actionName ):
                MagicsTranslator ( actionName ){}

	// Destructor
	~TextTranslator() {}

	virtual MvRequest Execute ( const MvRequest& );
	virtual MvRequest Execute ( const MvRequest&, const MvRequest&, MvRequest& )
		{ return MvRequest("EMPTY"); }
};

class AxisTranslator : public MagicsTranslator
{
public:

	// Contructors
	AxisTranslator(const Cached& actionName ):
                MagicsTranslator ( actionName ){}

	// Destructor
	~AxisTranslator() {}

	virtual MvRequest Execute ( const MvRequest& );
	virtual MvRequest Execute ( const MvRequest&, const MvRequest&, MvRequest& )
		{ return MvRequest("EMPTY"); }
};

#if 0
class CurveTranslator : public MagicsTranslator 
{
public:

// -- Contructors

	CurveTranslator(const Cached& actionName ): 
                MagicsTranslator ( actionName ){}

// -- Destructor

	~CurveTranslator() {}

	virtual MvRequest Execute ( const MvRequest& );
	virtual MvRequest Execute ( const MvRequest&, long, const MvRequest&, MvRequest& );
};
#endif

class GraphTranslator : public MagicsTranslator 
{
public:

    // -- Contructors
    GraphTranslator(const Cached& actionName ): 
                   MagicsTranslator ( actionName ){}

    // -- Destructor
    ~GraphTranslator() {}

    virtual MvRequest Execute ( const MvRequest& );
    virtual MvRequest Execute ( const MvRequest&, const MvRequest&, MvRequest& )
        { return MvRequest("EMPTY"); }

};

class PageTranslator : public MagicsTranslator 
{
public:

	// Contructors
	PageTranslator(const Cached& actionName ):
                MagicsTranslator ( actionName ){}

	// Destructor
	~PageTranslator() {}

	virtual MvRequest Execute ( const MvRequest& );
	virtual MvRequest Execute ( const MvRequest&, const MvRequest&, MvRequest& )
		{ return MvRequest("EMPTY"); }
};

class GribVectorsTranslator : public MagicsTranslator
{
public:

   // -- Contructors
   GribVectorsTranslator (const Cached& actionName ):
                         MagicsTranslator ( actionName ) {}

   // -- Destructor
   ~GribVectorsTranslator() {}

   virtual MvRequest Execute ( const MvRequest& ) { return MvRequest("EMPTY"); }
   virtual MvRequest Execute ( const MvRequest&, const MvRequest&, MvRequest& );
};

#if 0

class PolarTranslator : public MagicsTranslator 
{
public:

// -- Contructors

	PolarTranslator(const Cached& actionName ): 
                MagicsTranslator ( actionName ){}

// -- Destructor

	~PolarTranslator() {}

	virtual MvRequest Execute ( const MvRequest& );
	virtual MvRequest Execute ( const MvRequest&, long, const MvRequest&, MvRequest& );
};
#endif

class WindTranslator : public MagicsTranslator 
{
public:

	// Contructors
	WindTranslator(const Cached& actionName ): 
                MagicsTranslator ( actionName ){}

	// Destructor
	~WindTranslator() {}

	virtual MvRequest Execute ( const MvRequest& );
	virtual MvRequest Execute ( const MvRequest&, const MvRequest&, MvRequest& )
		{ return MvRequest("EMPTY"); }
};

#if 0
class MatrixTranslator : public MagicsTranslator 
{
public:

	// -- Contructors
  
	MatrixTranslator(const Cached& actionName ): 
		MagicsTranslator ( actionName ){}
  
	// -- Destructor
  
	~MatrixTranslator() {}
  
	virtual MvRequest Execute ( const MvRequest& )
		{ return MvRequest("EMPTY"); }
	virtual MvRequest Execute ( const MvRequest&, long, const MvRequest&, MvRequest& );
};
#endif

class NetCDFTranslator : public MagicsTranslator 
{
public:

	// Contructors
	NetCDFTranslator(const Cached& actionName ): 
		MagicsTranslator ( actionName ){}
  
	// Destructor
	~NetCDFTranslator() {}
  
	virtual MvRequest Execute ( const MvRequest& )
		{ return MvRequest("EMPTY"); }

	virtual MvRequest Execute ( const MvRequest&, const MvRequest&, MvRequest& );
};

class VoidTranslator : public MagicsTranslator 
{
public:

	// Contructors
	VoidTranslator(const Cached& actionName ):
		MagicsTranslator ( actionName ) {}
  
	// Destructor
	~VoidTranslator() {}

	virtual MvRequest Execute ( const MvRequest& );
	virtual MvRequest Execute ( const MvRequest&, const MvRequest&, MvRequest& );
};

class VisDefTranslator : public MagicsTranslator
{
public:

	// Contructors
	VisDefTranslator(const Cached& actionName ):
		MagicsTranslator ( actionName ) {}
  
	// Destructor
	~VisDefTranslator() {}

	virtual MvRequest Execute ( const MvRequest& );
	virtual MvRequest Execute ( const MvRequest&, const MvRequest&, MvRequest& )
		{ return MvRequest("EMPTY"); }
};


#if 0
class PImageTranslator : public MagicsTranslator 
{
public:

	// -- Contructors
  
	PImageTranslator(const Cached& actionName ): 
		MagicsTranslator ( actionName ){}
  
	// -- Destructor
  
	~PImageTranslator() {}
  
	virtual MvRequest Execute ( const MvRequest& );
	virtual MvRequest Execute ( const MvRequest&, long, const MvRequest&, MvRequest& )
		{ return MvRequest("EMPTY"); }
};
#endif

class GeopointsTranslator : public MagicsTranslator
{
public:

   // Contructors
   GeopointsTranslator(const Cached& actionName ):
            MagicsTranslator ( actionName ){}

   // Destructor
   ~GeopointsTranslator() {}

   virtual MvRequest Execute ( const MvRequest& )
            { return MvRequest("EMPTY"); }

   virtual MvRequest Execute ( const MvRequest&, const MvRequest&, MvRequest& );
};

class SymbolTranslator : public MagicsTranslator
{
public:

	// Contructors
	SymbolTranslator(const Cached& actionName ):
		MagicsTranslator ( actionName ){}
  
	// Destructor
	~SymbolTranslator() {}
  
        virtual MvRequest Execute ( const MvRequest&  req );

	virtual MvRequest Execute ( const MvRequest&, const MvRequest&, MvRequest& )
	  { return MvRequest("EMPTY"); };
};

class ImportTranslator : public MagicsTranslator
{
public:

   // Contructors
   ImportTranslator(const char* actionName ):
      MagicsTranslator ( actionName ){}

   // Destructor
   ~ImportTranslator() {}

   virtual MvRequest Execute ( const MvRequest& );
   virtual MvRequest Execute ( const MvRequest&, const MvRequest&, MvRequest& )
      { return MvRequest("EMPTY"); }
};

#if 0
class DummyDataTranslator : public MagicsTranslator 
{
public:

  // -- Contructors
  
  DummyDataTranslator(const Cached& actionName ): 
    MagicsTranslator ( actionName ){}
  
  // -- Destructor
  
  ~DummyDataTranslator() {}
  
  virtual MvRequest Execute ( const MvRequest& ) { return MvRequest("EMPTY"); }
  virtual MvRequest Execute ( const MvRequest& req, long, const MvRequest&, MvRequest& );
};

class NoteTranslator : public MagicsTranslator 
{
public:

  // -- Contructors
  
  NoteTranslator(const Cached& actionName ): 
    MagicsTranslator ( actionName ){}
  
  // -- Destructor
  
  ~NoteTranslator() {}
  
  virtual MvRequest Execute ( const MvRequest& ) { return MvRequest("EMPTY"); }
  virtual MvRequest Execute ( const MvRequest& req, long, const MvRequest&, MvRequest& );
};

class StringTranslator : public MagicsTranslator 
{
public:

  // -- Contructors
  
  StringTranslator(const Cached& actionName ): 
    MagicsTranslator ( actionName ){}
  
  // -- Destructor
  
  ~StringTranslator() {}
  
  virtual MvRequest Execute ( const MvRequest& ) { return MvRequest("EMPTY"); }
  virtual MvRequest Execute ( const MvRequest& req, long, const MvRequest&, MvRequest& );
};

// Auxiliary Function

void CopyAndRemoveParameters ( MvRequest& inRequest, 
			       MvRequest& outRequest, 
			       const char* prefix );

#endif
#endif
