#!/usr/bin/python2

from distutils.core import setup
import os, sys

version = 'unknown'

try:
    import mic.__version__
    version = mic.__version__.version
except:
    version_path = 'VERSION'
    try:
        import re
        ver_pat = re.compile('^(.*)$')
        for line in open(version_path).xreadlines():
            match = re.match(ver_pat, line)
            if match:
                version = match.groups()[0]

        ver_file = open('mic/__version__.py', 'w')
        ver_file.write("version = \"%s\"\n" % version)
        ver_file.close()
    except:
        pass

PACKAGES = ['mic', 'mic.imgcreate', 'mic.appcreate', 'mic.imgconvert', 'mic.ec2convert', 'mic.imgcreate.kscommands', 'mic.chroot']

if sys.version_info[:2] > (2, 5):
    if len(sys.argv) > 1 and 'install' in sys.argv:
        import subprocess
        lsbcmd = None
        if os.path.exists('/usr/bin/lsb_release'):
            lsbcmd = '/usr/bin/lsb_release'
        elif os.path.exists('/bin/lsb_release'):
            lsbcmd = '/bin/lsb_release'
        if lsbcmd:
            res = subprocess.Popen([lsbcmd, '-i'],
                                   stdout=subprocess.PIPE
                                  ).communicate()[0]
            if 'Debian' in res or 'Ubuntu' in res:
                sys.argv.append('--install-layout=deb')

setup(name = 'mic',
      version = version,
      description = 'MeeGo Image Creator APIs',
      author = 'Yi Yang',
      author_email = 'yi.y.yang@intel.com',
      url = 'http://moblin.org/projects/moblin-image-creator-2',
      scripts = ['tools/mic-image-creator', 'tools/mic-livecd-iso-to-disk', 'tools/mic-image-convertor', 'tools/mic-chroot', 'tools/mic-rm-chroot-dir', 'tools/mic-create-recovery-image', 'tools/mic-create-isohybrid-recovery-image', 'tools/mic-create-bootstrap', 'tools/mic-image-writer', 'tools/mic-vm-launcher', 'tools/mic'],
      packages = PACKAGES)
