/* z-socket.c: compressed socket library
   This has nothing to do with cryptography.
   Copyright (C) 1998 Paul Sheer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _Z_SOCKET_H
#define _Z_SOCKET_H

#ifdef __cplusplus
extern "C" {
#endif

#undef accept
#undef connect
#undef rcmd
#undef send
#undef recv
#undef read
#undef write
#undef shutdown
#ifdef WIN32
#undef closesocket
#else
#undef close
#endif
#undef dup
#undef dup2

int z_socket_accept (int sock, struct sockaddr *addr, unsigned int *addrlen);
int z_socket_accept_fd (int fd);
int z_socket_connect (int fd, struct sockaddr *addr, int addrlen);
int z_socket_send (int s, const void *msg, int len, unsigned int flags);
int z_socket_recv (int s, void *buf, int len, unsigned int flags);
int z_socket_write (int s, void *buf, int len);
int z_socket_read (int s, void *buf, int len);
int z_socket_shutdown (int s, int how);
int z_socket_close (int s);
int z_socket_dup2 (int fd, int fd_new);
int z_socket_dup (int fd);

#define Z_SOCKET_COMPRESSION_OFF	1
#define Z_SOCKET_MAGIC			"GzIpSoCk"
#define Z_SOCKET_MAGIC_LEN		8

void z_socket_set_flags (unsigned int f);
unsigned int z_socket_get_flags (void);
void z_socket_set_compression (int on);

#define accept		z_socket_accept
#define connect		z_socket_connect
#define send		z_socket_send
#define recv		z_socket_recv
#define read		z_socket_read
#define write		z_socket_write
#define shutdown	z_socket_shutdown
#ifdef WIN32
#define closesocket	z_socket_close
#else
#define close		z_socket_close
#endif
#define dup		z_socket_dup
#define dup2		z_socket_dup2

#ifdef __cplusplus
}
#endif

#endif				/* ! _DIFFIE_SOCKET_H */





