/* mirrordir.h - public globals from mirrordir.c
   This has nothing to do with cryptography.
   Copyright (C) 1998 Paul Sheer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  
 */

#ifndef _MIRRIR_DIR_H
#define _MIRRIR_DIR_H

#undef MAX_PATH_LEN
#define MAX_PATH_LEN 2048

#define this_is_a_digit(x) ((x) >= '0' && (x) <= '9')
#define this_is_a_char(x) (((x) >= 'a' && (x) <= 'z') || ((x) >= 'A' && (x) <= 'Z'))
#define this_is_whitespace(x) ((x) == '\t' || (x) == '\n' || (x) == ' ')
#define lower_case(x) (((x) >= 'A' && (x) <= 'Z') ? (x) + 'A' - 'a' : (x))

#ifndef S_IFMT
#define S_IFMT 0170000
#endif
#define	is_file_type(mode, mask)	(((mode) & S_IFMT) == (mask))

#ifndef S_ISDIR
#define	S_ISDIR(mode)	is_file_type((mode), 0040000)
#endif
#ifndef S_ISCHR
#define	S_ISCHR(mode)	is_file_type((mode), 0020000)
#endif
#ifndef S_ISBLK
#define	S_ISBLK(mode)	is_file_type((mode), 0060000)
#endif
#ifndef S_ISREG
#define	S_ISREG(mode)	is_file_type((mode), 0100000)
#endif
#ifndef S_ISFIFO
#define	S_ISFIFO(mode)	is_file_type((mode), 0010000)
#endif
#ifndef S_ISLNK
#define	S_ISLNK(mode)	is_file_type((mode), 0120000)
#endif
#ifndef S_ISSOCK
#define	S_ISSOCK(mode)	is_file_type((mode), 0140000)
#endif

#define S_IS_SPECIAL(m) (S_ISCHR (m) || S_ISBLK (m) || S_ISFIFO (m) || S_ISSOCK (m))

void progmess (char *s, char *par);
void verbmess (char *s, char *par);
void progmess_strerror (char *s, char *p);
#ifdef HAVE_MAD
char *mad_pathdup (char *p, char *file, int line);
#define pathdup(p) mad_pathdup(p, __FILE__, __LINE__)
#else
char *pathdup (char *p);
#endif
int is_listed (char *path);
int load_exclude_file (char *filename);

void print_hardlinks (void);
int copy_regular_file (char *p, char *q, struct stat *s, struct stat *t);
void add_hardlink (char *path, struct stat *s, struct stat *m);
int correct_link (struct stat *s);
int is_hardlink (struct stat *s);
int find_hardlink (struct stat *s);
void reduce_hardlink (void);
void create_link (char *q);
void free_all_hardlinks (void);

unsigned long mode_t_to_unsigned_long (mode_t m);
int parse_permissions_command (char *p, unsigned long *mask);

#ifndef _MIRROR_DIR_C
extern int verbose;
extern int handle_hardlinks;
extern int only_test;
extern int only_erase;
#endif

#define RETURN_VALUE_SUCCESS		0
#define RETURN_VALUE_ERROR		1
#define RETURN_VALUE_FILE_IN_USE	2

/* PATH_INCLUDED must be zero for the default a of zero return from script */
#define PATH_UNKNOWN	0
#define PATH_INCLUDED	1
#define PATH_IGNORED	2
#define PATH_EXCLUDED	3

#ifdef WIN32
#define COPY_BUF_SIZE	8192
#else
#define COPY_BUF_SIZE	65536
#endif

#define rewind(l) while ((l)->prev) (l) = (l)->prev;
#define forward(l) while ((l)->next) (l) = (l)->next;

#ifndef HAVE_STRDUP
char *strdup (const char *s);
#endif

struct stated_file {
    char *name;
    struct stat stat;
};

struct directory_list {
    struct stat stat;
    char *name;
    struct directory_list *next;
    struct directory_list *prev;
};

#ifdef HAVE_MAD
struct directory_list *mad_read_list (char *path, char *file, int line);
#define read_list(x) mad_read_list(x,__FILE__,__LINE__)
#else
struct directory_list *read_list (char *path);
#endif

void free_list (struct directory_list *dl);

#endif

