(* Copyright (C) 2000, Luca Padovani <luca.padovani@cs.unibo.it>.
 *
 * This file is part of mlminidom, the Ocaml binding for minidom.
 * 
 * mlminidom is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * mlminidom is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with mlminidom; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * For details, send a mail to the author.
 *)

type mDOMString
type mDOMDoc
type mDOMNode
type mDOMAttr
type mDOMEntity

external string_of_mDOMString : mDOMString -> string = "ml_string_of_mDOMString"
external mDOMString_of_string : string -> mDOMString = "ml_mDOMString_of_string"
external mDOMString_eq : string -> string -> bool = "ml_mDOMString_eq"

external doc_load : string -> mDOMDoc = "ml_doc_load"
external doc_new : mDOMString -> mDOMDoc = "ml_doc_new"
external doc_get_root_node : mDOMDoc -> mDOMNode = "ml_doc_get_root_node"

external doc_add_entity : doc:mDOMDoc -> name:mDOMString -> content:mDOMString -> mDOMEntity = "ml_doc_add_entity"
external doc_get_entity : doc:mDOMDoc -> name:mDOMString -> mDOMEntity option = "ml_doc_get_entity"
external doc_get_predefined_entity : doc:mDOMDoc -> name:mDOMString -> mDOMEntity option = "ml_doc_get_predefined_entity"
external entity_get_content : mDOMEntity -> mDOMString = "ml_entity_get_content"

external node_is_text  : mDOMNode -> bool = "ml_node_is_text"
external node_is_element : mDOMNode -> bool = "ml_node_is_element"
external node_is_blank : mDOMNode -> bool = "ml_node_is_blank"
external node_is_entity_ref : mDOMNode -> bool = "ml_node_is_entity_ref"
external node_get_type : mDOMNode -> int = "ml_node_get_type"
external node_get_name : mDOMNode -> mDOMString option = "ml_node_get_name"
external node_get_ns_uri : mDOMNode -> mDOMString option = "ml_node_get_ns_uri"
external node_get_attribute : node:mDOMNode -> name:mDOMString -> mDOMString option = "ml_node_get_attribute"
external node_get_attribute_ns : node:mDOMNode -> name:mDOMString -> ns_uri:mDOMString -> mDOMString option = "ml_node_get_attribute_ns"
external node_has_attribute : node:mDOMNode -> name:mDOMString -> bool = "ml_node_has_attribute"
external node_has_attribute_ns : node:mDOMNode -> name:mDOMString -> ns_uri:mDOMString -> bool = "ml_node_has_attribute_ns"
external node_get_content : mDOMNode -> mDOMString option = "ml_node_get_content"
external node_get_parent : mDOMNode -> mDOMNode option = "ml_node_get_parent"
external node_get_prev_sibling : mDOMNode -> mDOMNode option = "ml_node_get_prev_sibling"
external node_get_next_sibling : mDOMNode -> mDOMNode option = "ml_node_get_next_sibling"
external node_get_first_child : mDOMNode -> mDOMNode option = "ml_node_get_first_child"
external node_get_first_attribute : mDOMNode -> mDOMAttr option = "ml_node_get_first_attribute"
external node_is_first : mDOMNode -> bool = "ml_node_is_first"
external node_is_last : mDOMNode -> bool = "ml_node_is_last"

external attr_get_name : mDOMAttr -> mDOMString option = "ml_attr_get_name"
external attr_get_ns_uri : mDOMAttr -> mDOMString option = "ml_attr_get_ns_uri"
external attr_get_value : mDOMAttr -> mDOMString option = "ml_attr_get_value"
external attr_get_prev_sibling : mDOMAttr -> mDOMAttr option = "ml_attr_get_prev_sibling"
external attr_get_next_sibling : mDOMAttr -> mDOMAttr option = "ml_attr_get_next_sibling"
external attr_get_parent : mDOMAttr -> mDOMNode option = "ml_attr_get_parent"

val node_get_children : mDOMNode -> mDOMNode list
val node_get_attributes : mDOMNode -> mDOMAttr list

