(* Copyright (C) 2000, Luca Padovani <luca.padovani@cs.unibo.it>.
 *
 * This file is part of mlminidom, the Ocaml binding for minidom.
 * 
 * mlminidom is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * mlminidom is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with mlminidom; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * For details, send a mail to the author.
 *)

let doc = Minidom.doc_load "test.xml"

let root = Minidom.doc_get_root_node doc

let check_attribute_ns attr =
  Printf.printf "\n\n";
  let ns_uri = Minidom.attr_get_ns_uri attr
  and attr_name = Minidom.attr_get_name attr
  and attr_value = Minidom.attr_get_value attr
  and parent = Minidom.attr_get_parent attr
  in
  match parent,ns_uri,attr_name,attr_value with
    Some parent_node,Some uri,Some attribute_name,Some attribute_value ->
      let attr_info =
       (Minidom.node_get_attribute_ns parent_node attribute_name uri,
        Minidom.node_has_attribute_ns parent_node attribute_name uri)
      in begin
        match attr_info with
          Some attr1, true ->
	    Printf.printf "found the attribute with ns %s (was %s)\n"
              (Minidom.string_of_mDOMString attr1) (Minidom.string_of_mDOMString attribute_value)
        | None, false ->
	    Printf.printf "attribute not found (uri was %s)!!!!\n" (Minidom.string_of_mDOMString uri)
        | _,_ -> assert false
      end
  | _ ->
      Printf.printf "parent_node == NULL || uri == NULL || attribute_name == NULL || attribute_value == NULL\n"
;;
    
let print_attribute attr =
  check_attribute_ns attr;
  let ns_uri = Minidom.attr_get_ns_uri attr
  in
  begin
    match ns_uri with
      Some uri -> Printf.printf " %s:" (Minidom.string_of_mDOMString uri);
    | None -> ()
  end;
  match ((Minidom.attr_get_name attr), (Minidom.attr_get_value attr)) with
    (Some attr_name, Some attr_value) ->
      Printf.printf " %s=\"%s\"" (Minidom.string_of_mDOMString attr_name) (Minidom.string_of_mDOMString attr_value) 
  | (Some attr_name, _) ->
      Printf.printf " ??? attribute %s has no value !!!" (Minidom.string_of_mDOMString attr_name)
  | (_,_) ->
      Printf.printf " ??? very strange attribute !!!"
;;

let rec print_node n node =
  if Minidom.node_is_blank node then ()
  else if Minidom.node_is_element node then begin
    match Minidom.node_get_name node with
      Some node_name -> 
        begin
          let children = Minidom.node_get_children node
          and attributes = Minidom.node_get_attributes node
          and ns_uri = Minidom.node_get_ns_uri node
          and is_first,is_last = (Minidom.node_is_first node), (Minidom.node_is_last node)
          in
          for i = 1 to n do print_char ' ' done;
          Printf.printf "<";
          begin
            match ns_uri with
              Some uri -> Printf.printf "%s:" (Minidom.string_of_mDOMString uri)
            | None     -> ()
          end;
          Printf.printf "%s" (Minidom.string_of_mDOMString node_name);
          List.iter print_attribute attributes;
          Printf.printf ">\n";
          List.iter (print_node (n + 2)) children;
          for i = 1 to n do print_char ' ' done;
          Printf.printf "</%s>\n" (Minidom.string_of_mDOMString node_name)
        end
    | None -> Printf.printf "??? this node has no name !!!\n"
  end else if Minidom.node_is_text node then begin
    match Minidom.node_get_content node with
      Some node_content ->
        for i = 1 to n do print_char ' ' done;
        Printf.printf "%s\n" (Minidom.string_of_mDOMString node_content)
    | None -> Printf.printf "??? this node has no content !!!\n"
  end else begin
    Printf.printf "don't know how to manage a node with type %d\n" (Minidom.node_get_type node)
  end
;;
  
print_node 0 root;;
