/*
 *	$Id: kik_unistd.c,v 1.2 2002/03/08 13:47:39 arakiken Exp $
 */

#include  "kik_unistd.h"

#include  <time.h>
#include  <unistd.h>	/* select */


/* --- global functions --- */

#ifndef  HAVE_USLEEP

int
__kik_usleep(
	u_int  microseconds
	)
{
	struct timeval  tval ;
	
	tval.tv_usec = microseconds % 1000000 ;
	tval.tv_sec = microseconds / 1000000 ;

	if( select( 0 , NULL , NULL , NULL , &tval) == 0)
	{
		return  0 ;
	}
	else
	{
		return  -1 ;
	}
}

#endif

#ifndef  HAVE_UNSETENV

void
__kik_unsetenv(
	char *  name
	)
{
}

#endif
