      SUBROUTINE MN_FFL(IUSEE,NMODE,NHI,IDAF,IDBF)
C
C     CALCULATES THE VALUE OF THE SELECTED FUNCTIONS AND STORES THEM
C     IN A HISTOGRAM FOR PLOTTING
C
C     NMODE = -1  Fine binning with bin width of 1.0 - only really
C                 used for the FUN PLOT command
C     NMODE = 0   DO IT WITH FINE BINNING AND USE GIVEN BINNING
C     NMODE = 1   DO IT WITH SAME BINS AS GIVEN PLOT
C     NHI         IS THE POINTER TO THE HISTOGRAM NUMBER ASSOCIATED
C                 WITH THE FUNCTION.
C                 IF WE ARE JUST PLOTTING A FUNCTION THE HISTOGRAM NUMBER
C                 SHOULD BE 98765&1 OR WHATEVER THE USER SET
C     IDBF        IF NEGATIVE MN_FFL WILL SET IT (I.E. THIS IS A DISPLAY
C                 OR IS FROM MN_BSB)
C                 POSITIVE MEANS CALL IS FROM MN_FUN
C
C     IF THE CALL IS FROM DISPLAY THEN MAKE 2 PLOTS
C     FIRST WITH INCLUDED STUFF
C     SECOND WITH EXCLUDED STUFF
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mnfit.inc"
#include "mninf.inc"
#include "mnfun.inc"
#include "mnhpj.inc"
#include "mnusr.inc"
#include "mnlun.inc"
C
      DOUBLE PRECISION XMNFUN,WMNHER,WFUN,WFERR2,WF00,WEE
     + ,WDEEL,WDEEH,WDEEL2,WDEEH2,WDCHI,WDLIK
C
      INTEGER IUSEE(*)
      INTEGER IUSED(MFUNMX)

C     A variable to indicate whether a point has been excluded because it is
C     outside an inclusion or inside an exclusion.  DN Brown 2-20-92
      INTEGER  IWHOEX
C
      CHARACTER*255 TXT1,TXT2,CONCAT
      CHARACTER*80  TITLE
      CHARACTER*32 TNAME(MDIMMX)
      INTEGER IDBINF(MDIMMX),IDBINU(MDIMMX)
      REAL ADLOU(MDIMMX),ADHIU(MDIMMX)
      LOGICAL QERRL,QERRH
      LOGICAL QQEXCL,QQEXLL,Q2PLOT,QFINTSV,QUFIT
C
C     PUT THE LATEST FIT VALUES IN FPAR ETC.
C
      CALL MN_FUP(1)
C
C     Save whether we are integrating the function over a bin
C
      Q2PLOT  = IDBF.EQ.-1
      QFINTSV = QFINTG
C
C     Overlay a function on a display
C
      IF(IDBF.LT.0 .OR. QDFIT) THEN
          QUFIT = .TRUE.
          IDA = IDFITA(NHI)
          IDB = IDFITB(NHI)
          CALL MN_FGT(IDA,IDB,NHT)
          NPTRHU = IFPTRH(NHI)
          NPTRDU = IFPTRD(NHI)
          NDIMU  = IFNDIM(NHI)
          NWPPTU = IFWPPT(NHI)
          NPNTU  = IFPFIT(NHI)
          CALL UCOPY_i(IDBIN,IDBINU,IABS(NDIMU))
          CALL UCOPY_r(ADLO,ADLOU,IABS(MDIMMX))
          CALL UCOPY_r(ADHI,ADHIU,IABS(MDIMMX))
          CALL TCOPY(TFNAM(1,NHI),TNAME,IABS(NDIMU))
          IF(IDBF.EQ.-1) IDBF   = 980 + NDFUN
          IDBF = IABS(IDBF)
          CALL UCOPY_i(IASSF(1,NHI),IUSED,MFUNMX)
C
C         AMNOFF is not correct for fitted histograms
C
          NOFF  = IABS(NDIMU) + 1
          NOFFL = 2*(IABS(NDIMU) + 1)
          NOFFH = 3*(IABS(NDIMU) + 1)
          QERRL = NWPPTU.GT.1*(IABS(NDIMU)+1)
          QERRH = NWPPTU.GT.2*(IABS(NDIMU)+1)
C
C     Just plot a function
C
      ELSE
          QUFIT = .FALSE.
          IDA = IDIDA(NHI)
          IDB = IDIDB(NHI)
          CALL MN_HGT(IDA,IDB,NHF)
          IF(NHF.LE.0) THEN
              CALL MN_ERR('MN_FFL','Error defining function range')
              GOTO 9000
          ENDIF
          NPTRHU = NPTRH
          NPTRDU = NPTRD
          NDIMU  = NDIM
          NWPPTU = NWPPT
          NPNTU  = NPNT
          CALL UCOPY_i(IDBIN,IDBINU,IABS(NDIMU))
          CALL UCOPY_r(ADLO,ADLOU,IABS(NDIMU))
          CALL UCOPY_r(ADHI,ADHIU,IABS(NDIMU))
          CALL TCOPY(TDNAM(1,NHI),TNAME,IABS(NDIMU))
          IF(IDBF.LT.0) IDBF = 999
          CALL VFILL(IUSED,MFUNMX,1)
          CALL AMNOFF(NDIMU,NWPPTU,NOFF,NOFFL,NOFFH,QERRL,QERRH)
      ENDIF
C
      IDAF = IDA
      XXFLO = ADLOU(1)
      XXFHI = ADHIU(1)
      IF(IABS(NDIMU).GE.2) THEN
          YYFLO = ADLOU(2)
          YYFHI = ADHIU(2)
      ENDIF
C
C     Sort out the number of points and whether the function should be
C     integrated over the bin
C
      IF(NMODE.EQ.0 .AND. IABS(NDIMU).EQ.1) THEN
          QFINTG = .FALSE.
          NPP = 10*(NPNTU)
          IF(NPP.GE.MFNPMX) NPP = MFNPMX - 1
          NPP = MAX0(1,(NPP / NPNTU))
          NPPT = NPP * NPNTU + 2
      ELSEIF(NMODE.EQ.-1 .OR. NMODE.EQ.0 .OR. NMODE.EQ.1) THEN
          IF(NMODE.LE.0) QFINTG = .FALSE.
          NPP = 1
          NPPT = NPNTU
      ELSE
          WRITE(TXTERR,'(''Unknown mode'',I4
     1     ,'' Returning'')',IOSTAT=IOERR) NMODE
          CALL MN_ERR('MN_FFL',TXTERR)
      ENDIF
C
      DYY = 1.0
      YBINNM = 1.0
      IF(NMODE.EQ.0 .AND. IABS(NDIMU).EQ.1) THEN
          XBINNM = (XXFHI-XXFLO)/FLOAT(NPNTU)
          DXX    = (XXFHI-XXFLO)/FLOAT(NPPT-2)
          IF(IABS(NDIMU).GE.2) THEN
              YBINNM = (YYFHI-YYFLO)/FLOAT(NPNTU)
              DYY    = (YYFHI-YYFLO)/FLOAT(NPPT-2)
          ENDIF
      ELSE IF(IABS(NDIMU).GT.1) THEN
          XBINNM = (XXFHI-XXFLO)/FLOAT(IDBINU(1))
          DXX    = (XXFHI-XXFLO)/FLOAT(IDBINU(1))
          IF(IABS(NDIMU).GE.2) THEN
              YBINNM = (YYFHI-YYFLO)/FLOAT(IDBINU(2))
              DYY    = (YYFHI-YYFLO)/FLOAT(IDBINU(2))
          ENDIF
      ELSE
          XBINNM = (XXFHI-XXFLO)/FLOAT(NPNTU)
          DXX    = (XXFHI-XXFLO)/FLOAT(NPPT)
          IF(IABS(NDIMU).GE.2) THEN
              YBINNM = (YYFHI-YYFLO)/FLOAT(NPNTU)
              DYY    = (YYFHI-YYFLO)/FLOAT(NPPT)
          ENDIF
      ENDIF
C
C     Reset the bin width if it is not being used.
C     If we are overlaying the bin width was fixed above - otherwise
C     if we are not making a histogram set the bin width to 1
C
      IF(.NOT.QFBINW .OR. NMODE.EQ.-1) THEN
          XBINNM = 1.0
          IF(IABS(NDIMU).GE.2) YBINNM = 1.0
      ENDIF
C
      ENTSCL = (DXX*DYY) / (XBINNM*YBINNM)
C
C     MAKE THE TITLE FOR THE FUNCTION PLOTS
C
      TXT1 = 'Functions:'
      NNF = 0
      DO 2000 IF=1,NFUN_MN
          IF(IUSEF(IF).EQ.0) GOTO 2000
          IF(IUSEE(IF).EQ.0) GOTO 2000
          NNF = NNF + 1
          IF(NNF.GT.1) THEN
              TXT2 = CONCAT(TXT1,'+')
              TXT1 = TXT2
          ENDIF
          TXT2 = CONCAT(TXT1,TUSEF(IF))
          TXT1 = TXT2
2000  CONTINUE
C
C     CREATE A HISTOGRAM FOR THE FUNCTION
C
      IF((NMODE.EQ.0 .AND. IABS(NDIMU).EQ.1) .OR.
     +   IDBINU(1).EQ.0) THEN
          NDIMF  = -IABS(NDIMU)
          NWPPTF = IABS(NDIMU) + 1
          NOFF2  = IABS(NDIMU) + 1
      ELSE
          NDIMF  = IABS(NDIMU)
          NWPPTF = 1
          NOFF2  = 1
      ENDIF
      NOFFL2 = 2*NOFF2
      NOFFL3 = 3*NOFF2
      NWRDF  = NPPT * NWPPTF
      IF(Q2PLOT .AND. IABS(NDIMU).EQ.1)
     1  NWRDF = NWRDF + 2*(IXEXCL(NHI)+IXINCL(NHI))*NWPPTF
C
C     Must set the number of bins correctly if the function is going to
C     to be a histogram
C
      CALL UCOPY_i(IDBINU,IDBINF,IABS(NDIMF))
      IF(NDIMF.EQ.1) THEN
          IDBINF(1) = NPPT
      ENDIF
C
      NBPPT = 32
      CALL MN_HNW(IDAF,IDBF,NDIMF,NWRDF,NHF,NPTRHF,NPTRDF,NWHF
     + ,NBPPT,NTMODE)
C
C     UPDATE THE HEADER AND POINTERS IMMEDIATELY SO THAT THE NEXT
C     HISTOGRAM CAN BE BOOKED
C
      NWTOT = NWHF + NWRDF
      IF(Q2PLOT .AND. IABS(NDIMU).EQ.1) THEN
          TITLE = 'Included area. ' // TXT1
      ELSE
          TITLE = TXT1
      ENDIF
      NPNTF = 0
      IF(Q2PLOT .AND. NDIMF.GT.0) CALL VZERO_r(RDAT(NPTRDF),NWRDF)
      CALL M_RTIM(NHDATF,NHTIMF)
      CALL MN_HDU(RDAT(NPTRHF),NWTOT,NWHF,NWRDF,IDAF,IDBF
     + ,NDIMF,NWPPTF,NPNTF,NHDATF,NHTIMF,NSDATE,NSTIME,NTMODE
     + ,EDENTF,EDLOF,EDHIF,IDBINF,ADLOU,ADHIU,NBPPT,ACONT)
      CALL MN_PTU(NHF,NWTOT,IDAF,IDBF,NPTRHF,NPTRDF,TITLE
     1 ,'Generated internally',' ',TNAME)
C
C     Now book the histogram for the excluded part
C     or the chi**2
C
      IF(Q2PLOT) THEN
        IF((IABS(NDIMU).EQ.1 .AND.
     +      (IXEXCL(NHI).GT.0 .OR. IXINCL(NHI).GT.0)) .OR.
     2     (IABS(NDIMU).GT.1)) THEN
C
C         INCREASE THE FUNCTION NUMBER DRAWN BY 1
C
          NDFUN = NDFUN + 1
          IDBF2 = 980 + NDFUN
          IF(IABS(NDIMU).EQ.1) THEN
              TITLE = 'Excluded area. ' // TXT1
          ELSE
              TITLE = '[h]^2! ' // TXT1
          ENDIF
          CALL MN_HNW(IDAF,IDBF2,NDIMF,NWRDF,NHF2,NPTHF2,NPTDF2
     1     ,NWHF2,NBPPT,NTMODE)
          NWTOT = NWHF2 + NWRDF
          NPNTF2 = 0
          IF(Q2PLOT .AND. NDIMF.GT.0) CALL VZERO_r(RDAT(NPTDF2),NWRDF)
          CALL MN_HDU(RDAT(NPTHF2),NWTOT,NWHF2,NWRDF,IDAF,IDBF2
     1     ,NDIMF,NWPPTF,NPNTF2,NHDATF,NHTIMF,NSDATE,NSTIME,NTMODE
     +     ,EDNTF2,EDLOF2,EDHIF2
     2     ,IDBINF,ADLOU,ADHIU,NBPPT,ACONT)
          CALL MN_PTU(NHF2,NWTOT,IDAF,IDBF2,NPTHF2,NPTDF2,TITLE
     1     ,'Generated internally',' ',TNAME)
        ENDIF
      ENDIF
C
      IF(Q2PLOT) THEN
          AFTTOT(1,NHI) = 0.0
          AFFTOT(1,NHI) = 0.0
      ENDIF
C
C     Decide whether the co-ordinates of the histogram being overlayed
C     should be used
C
      QUFIT = QUFIT .AND. NPPT.EQ.NPNTU .AND. NDIMU.LT.0
C
      NFN0 = 0
      NMESS = 0
      EDENTF = 0.0
      EDLOF  = 1.0E+30
      EDHIF  = -1.0E+30
      EDNTF2 = 0.0
      EDLOF2 = 1.0E+30
      EDHIF2 = -1.0E+30
      NPNTF  = 0
      NPNTF2 = 0
      QQEXLL = .FALSE.
      NNEXCL = 0
      NNINCL = 1
      NBX = 0
      NBY = 1
      IWHOEX = 0
      DO 3500 I=1,NPPT
          IF(NMODE.EQ.0 .AND. IABS(NDIMU).EQ.1) THEN
              IF(I.EQ.1 .OR. I.EQ.NPPT) THEN
                  IF(I.EQ.1) THEN
                      XX = XXFLO
                  ELSE
                      XX = XXFHI
                  ENDIF
              ELSE
                  XX = XXFLO + FLOAT(I-2)*DXX + 0.5*DXX
              ENDIF
          ELSE
              NPTR = NPTRDU + NWPPTU * (I-1) - 1
              IF(QUFIT) THEN
                  XX = RFIT(NPTR + 1)
                  IF(IABS(NDIMU).GT.1) THEN
                      YY = RFIT(NPTR + 2)
                  ENDIF
              ELSE
                  NBX = NBX + 1
                  IF(NBX.GT.IDBINU(1)) THEN
                      NBX = 1
                      NBY = NBY + 1
                  ENDIF
                  XX = XXFLO + FLOAT(NBX-1)*DXX + 0.5*DXX
                  IF(IABS(NDIMU).GT.1) THEN
                      YY = YYFLO + FLOAT(NBY-1)*DYY + 0.5*DYY
                  ENDIF
              ENDIF
              IF(IABS(NDIMU).GT.1 .AND. Q2PLOT) THEN
                  EE = RFIT(NPTR + NOFF)
                  IF(QERRL) DEEL = RFIT(NPTR + NOFFL)
                  IF(QERRH) DEEH = RFIT(NPTR + NOFFH)
                  WEE   = DBLE(EE)
                  IF(QERRL) THEN
                      WDEEL = DBLE(DEEL)
                      WDEEL2 = WDEEL * WDEEL
                  ENDIF
                  IF(QERRH) THEN
                      WDEEH  = DBLE(DEEH)
                      WDEEH2 = WDEEH * WDEEH
                  ELSE IF(QERRL) THEN
                      WDEEH  = WDEEL
                      WDEEH2 = WDEEL2
                  ENDIF
              ENDIF
          ENDIF
C
C         Check whether point is excluded or included
C
          QQEXCL = .FALSE.
          IF(Q2PLOT) THEN
            IF(IXEXCL(NHI).GT.0 .OR. IYEXCL(NHI).GT.0 .OR.
     +         IXINCL(NHI).GT.0 .OR. IYINCL(NHI).GT.0) THEN
              DO 3100 JJ=1,IXEXCL(NHI)
                  IF(XX.GE.XLEXCL(JJ,NHI) .AND.
     1               XX.LE.XHEXCL(JJ,NHI)) THEN
                      QQEXCL = .TRUE.
                      NNEXCL = JJ
                      IWHOEX = 1
                      GOTO 3130
                  ENDIF
3100          CONTINUE
              IF(IABS(NDIMU).GT.1) THEN
                  DO 3105 JJ=1,IYEXCL(NHI)
                      IF(YY.GE.YLEXCL(JJ,NHI) .AND.
     1                   YY.LE.YHEXCL(JJ,NHI)) THEN
                          QQEXCL = .TRUE.
                          NNEXCL = JJ
                          IWHOEX = 1
                          GOTO 3130
                      ENDIF
3105              CONTINUE
              ENDIF
C
              IF(IXINCL(NHI).LE.0) GOTO 3112
              DO 3110 JJ=1,IXINCL(NHI)
                  IF(XX.GE.XLINCL(JJ,NHI) .AND.
     1               XX.LE.XHINCL(JJ,NHI)) THEN
                         NNINCL = JJ
                         GOTO 3112
                  ENDIF
3110          CONTINUE
              IWHOEX = 2
              QQEXCL = .TRUE.
              GOTO 3130
3112          CONTINUE
C
              IF(IABS(NDIMU).GT.1) THEN
                  IF(IYINCL(NHI).LE.0) GOTO 3117
                  DO 3115 JJ=1,IYINCL(NHI)
                  IF(YY.GE.YLINCL(JJ,NHI) .AND.
     1               YY.LE.YHINCL(JJ,NHI)) THEN
                         NNINCL = JJ
                         GOTO 3117
                   ENDIF
3115              CONTINUE
                  IWHOEX = 2
                  QQEXCL = .TRUE.
                  GOTO 3130
3117              CONTINUE
              ENDIF
C
3130          CONTINUE
              IF(IABS(NDIMU).GE.2) THEN
                  GOTO 3200
              ENDIF
C
C             IF WE SWITCH FROM EXCLUDED TO INCLUDED OR VICE VERSA
C             CALCULATE FUNCTION AT THE POINT OF EXCLUSION
C             AND FLAG THIS AS A -9999.0 POINT
C
              IF(NDIMF.LT.0 .AND. I.GT.1 .AND.
     +           ((QQEXLL .AND. .NOT.QQEXCL) .OR.
     +            (.NOT.QQEXLL .AND. QQEXCL))) THEN
                  IF(QQEXCL .AND. (.NOT.QQEXLL)) THEN
                    IF(IWHOEX.EQ.1)THEN
                      XXEXCL = XLEXCL(NNEXCL,NHI)
                    ELSE
                      XXEXCL = XHINCL(NNINCL,NHI)
                    ENDIF
                  ELSE
                    IF(IWHOEX.EQ.1)THEN
                      XXEXCL = XHEXCL(NNEXCL,NHI)
                    ELSE
                      XXEXCL = XLINCL(NNINCL,NHI)
                    ENDIF
                  ENDIF
                  YYEXCL = 0.0
C
C                 GET THE VALUE OF THE SUM OF THE FUNCTIONS
C
                  WFUN   = 0.0
                  WFERR2 = 0.0
                  DO 3150 IF=1,NFUN_MN
                      IF(IUSEF(IF).EQ.0) GOTO 3150
                      IF(IUSEE(IF).EQ.0) GOTO 3150
                      IF(IUSED(IF).EQ.0) GOTO 3150
                      WFUN = WFUN + XMNFUN(XXEXCL,YYEXCL,IF,NHI
     1                   ,FPAR(1,IF),WMNHER)
                      WFERR2 = WFERR2 + WMNHER*WMNHER
3150              CONTINUE
                  IF(QSNORM) THEN
                      WF00 = DBLE(F00)
                      WFUN = WF00 * WFUN
                      WFERR2 = WF00 * WF00 * WFERR2
                  ENDIF
                  FUN = WFUN
C
C                 NOW STORE THE TRANSITION POINT
C
                  NPNTF = NPNTF + 1
                  NPTR  = NPTRDF + NWPPTF*(NPNTF-1) - 1
                  IF(NDIMF.LT.0) THEN
                      RDAT(NPTR + 1) = XXEXCL
                      RDAT(NPTR + 2) = FUN
                  ENDIF
C
                  NPNTF2 = NPNTF2 + 1
                  NPTR   = NPTDF2 + NWPPTF*(NPNTF2-1) - 1
                  IF(NDIMF.LT.0) THEN
                      RDAT(NPTR + 1) = XXEXCL
                      RDAT(NPTR + 2) = FUN
                  ENDIF
C
C                 FLAG THE TRANSITION POINT
C
                  IF(QQEXCL) THEN
                      NPNTF = NPNTF + 1
                      NPTR  = NPTRDF + NWPPTF*(NPNTF-1) - 1
                  ELSE
                      NPNTF2 = NPNTF2 + 1
                      NPTR   = NPTDF2 + NWPPTF*(NPNTF2-1) - 1
                  ENDIF
                  IF(NDIMF.LT.0) THEN
                      RDAT(NPTR + 1) = -9999.0
                      RDAT(NPTR + 2) = -9999.0
                  ENDIF
              ENDIF
            ENDIF
          ENDIF
C
C         GET THE VALUE OF THE SUM OF THE FUNCTIONS
C
3200      CONTINUE
          WFUN   = 0.0
          WFERR2 = 0.0
          DO 3300 IF=1,NFUN_MN
              IF(IUSEF(IF).EQ.0) GOTO 3300
              IF(IUSEE(IF).EQ.0) GOTO 3300
              IF(IUSED(IF).EQ.0) GOTO 3300
              WFUN = WFUN + XMNFUN(XX,YY,IF,NHI,FPAR(1,IF),WMNHER)
              WFERR2 = WFERR2 + WMNHER*WMNHER
3300      CONTINUE
          IF(QSNORM) THEN
              WF00 = DBLE(F00)
              WFUN = WF00 * WFUN
              WFERR2 = WF00 * WF00 * WFERR2
          ENDIF
C
C         STORE FUNCTION VALUES FOR DRAWING
C
          FUN = WFUN
C
C         FOR 2-D FITTING STORE THE CHI**2 FOR THIS POINT ALSO
C
          IF(Q2PLOT .AND. IABS(NDIMU).GE.2 .AND. .NOT.QQEXCL) THEN
              DF = WEE - WFUN
              CALL MN_LKC(NFITTP,WEE,WFUN,WF00
     +         ,WDEEL2,WDEEH2,WFERR2,WDCHI,WDLIK,NFN0,NMESS)
              DCHI = SNGL(WDCHI)
              DLIK = SNGL(WDLIK)
              NPNTF2 = NPNTF2 + 1
              NPTR = NPTDF2 + NWPPTF * (I-1) - 1
              IF(NDIMF.LT.0) THEN
                  RDAT(NPTR+1) = XX
                  IF(NDIMF.LT.-1) RDAT(NPTR+2) = YY
              ENDIF
              RDAT(NPTR + NOFF2) = SIGN(DCHI,DF)
C
              EDNTF2 = EDNTF2 + DCHI*ENTSCL
              EDLOF2 = AMIN1(EDLOF2,DCHI)
              EDHIF2 = AMAX1(EDHIF2,DCHI)
          ENDIF
C
          IF(Q2PLOT .AND. IABS(NDIMU).EQ.1 .AND. QQEXCL) THEN
              NPNTF2 = NPNTF2 + 1
              IF(NDIMF.GT.0) THEN
                  NPTR = NPTDF2 + NWPPTF*(I-1) - 1
              ELSE
                  NPTR = NPTDF2 + NWPPTF*(NPNTF2-1) - 1
              ENDIF
              EDNTF2 = EDNTF2 + FUN*ENTSCL
              EDLOF2 = AMIN1(EDLOF2,FUN)
              EDHIF2 = AMAX1(EDHIF2,FUN)
          ELSE
              NPNTF = NPNTF + 1
              IF(NDIMF.GT.0) THEN
                  NPTR = NPTRDF + NWPPTF*(I-1) - 1
              ELSE
                  NPTR = NPTRDF + NWPPTF*(NPNTF-1) - 1
              ENDIF
              EDENTF = EDENTF + FUN*ENTSCL
              EDLOF  = AMIN1(EDLOF,FUN)
              EDHIF  = AMAX1(EDHIF,FUN)
          ENDIF
C
          IF(NDIMF.LT.0) THEN
              RDAT(NPTR + 1) = XX
              IF(NDIMF.LT.-1) RDAT(NPTR + 2) = YY
          ENDIF
          RDAT(NPTR + NOFF2) = FUN
C
C         FOR FUNCTION STORED AS HISTOGRAM, MUST SET EXCLUDED PARTS
C         OF NON-EXCLUDED PLOT TO ZERO AND VICE-VERSA
C
          IF(Q2PLOT .AND. IABS(NDIMU).EQ.1 .AND. NDIMF.GT.0) THEN
              IF(IXEXCL(NHI).GT.0 .OR. IXINCL(NHI).GT.0) THEN
                  IF(QQEXCL) THEN
                      NPTR = NPTRDF + NWPPTF*(I-1) - 1
                  ELSE
                      NPTR = NPTDF2 + NWPPTF*(I-1) - 1
                  ENDIF
                  RDAT(NPTR + 1) = 0.0
              ENDIF
          ENDIF
C
          IF(Q2PLOT .AND.
     1       (NMODE.EQ.1 .OR. IABS(NDIMU).GT.1 .OR.
     2        (NMODE.EQ.0 .AND. I.NE.1 .AND. I.NE.NPPT))) THEN
              AFTTOT(1,NHI) = AFTTOT(1,NHI) + FUN*ENTSCL
              IF(.NOT.QQEXCL)
     1         AFFTOT(1,NHI) = AFFTOT(1,NHI) + FUN*ENTSCL
          ENDIF
C
          QQEXLL = QQEXCL
 3500 CONTINUE
C
C     FILL IN THE HEADERS
C
      IF(NDIMF.GT.0) THEN
          NPNTF  = NPPT
          NPNTF2 = NPPT
      ENDIF
C
      NWTOT = NWHF + NWRDF
      ACONT(2) = EDENTF
      CALL MN_HDU(RDAT(NPTRHF),NWTOT,NWHF,NWRDF,IDAF,IDBF
     + ,NDIMF,NWPPTF,NPNTF,NHDATF,NHTIMF,NSDATE,NSTIME,NTMODE
     + ,EDENTF,EDLOF,EDHIF,IDBINF,ADLOU,ADHIU,NBPPT,ACONT)
      CALL MN_MSU(IDAF,IDBF,NDIMF,NWHF,0)
      IF(Q2PLOT) THEN
        IF((IABS(NDIMU).EQ.1 .AND.
     +      (IXEXCL(NHI).GT.0 .OR. IXINCL(NHI).GT.0)) .OR.
     +     (IABS(NDIMU).GT.1)) THEN
          IF(IABS(NDIMU).GT.1) THEN
              EDLOF2 = 0.0
              EDHIF2 = 9.0
          ENDIF
          NWTOT = NWHF2 + NWRDF
          ACONT(2) = EDNTF2
          CALL MN_HDU(RDAT(NPTHF2),NWTOT,NWHF2,NWRDF,IDAF,IDBF2
     +     ,NDIMF,NWPPTF,NPNTF2,NHDATF,NHTIMF,NSDATE,NSTIME,NTMODE
     +     ,EDNTF2,EDLOF2,EDHIF2,IDBINF,ADLOU,ADHIU,NBPPT,ACONT)
          CALL MN_MSU(IDAF,IDBF2,NDIMF,NWHF2,0)
        ENDIF
      ENDIF
C
9000  CONTINUE
      QFINTG = QFINTSV
C
      END
