      SUBROUTINE M_MINU(IPAR,IFUN)
C
C-----------------------------------------------------------------------
C
C     Updates the MINUIT parameters from the Mn_Fit parameters.
C     This means you can use DEPOSIT to change a MINUIT parameter value
C
C     Called by MN_CLC
C
C-----------------------------------------------------------------------
C
#include "mnpar.inc"
#include "mnfit.inc"
#include "mnfun.inc"
#include "mnlun.inc"
C
      CHARACTER*10 TPNAME
      DOUBLE PRECISION VAL,ERROR,BND1,BND2
      INTEGER IVARBL,IERFLG
      INTEGER NUMQ
C
      IF(NHFIT.LE.0) RETURN
C
      IF(IFUN.GT.0) THEN
          NUMQ = IABS(ISFPAR(IPAR,IFUN))
      ELSE
          NUMQ = IABS(ISF00)
      ENDIF
C
      CALL MNPOUT(NUMQ,TPNAME,VAL,ERROR,BND1,BND2,IVARBL)
      IF(IFUN.GT.0) THEN
          VAL   = DBLE(FPAR(IPAR,IFUN))
          ERROR = DBLE(DFPAR(IPAR,IFUN))
          BND1  = DBLE(FPARLO(IPAR,IFUN))
          BND2  = DBLE(FPARHI(IPAR,IFUN))
      ELSE
          VAL   = DBLE(F00)
          ERROR = DBLE(DF00)
          BND1  = DBLE(F00LO)
          BND2  = DBLE(F00HI)
      ENDIF
C
      CALL MNPARM(NUMQ,TPNAME,VAL,ERROR,BND1,BND2,IERFLG)
      IF(IERFLG.NE.0) THEN
          WRITE(TXTERR,
     +     '(''Error modifying MINUIT parameter'',I3)',IOSTAT=IOERR)NUMQ
          CALL MN_ERR('M_MINU',TXTERR)
      ENDIF
C
C
9000  CONTINUE
      END
