      SUBROUTINE M_CALL
C
C-----------------------------------------------------------------------
C
C     Calls a Comis subroutine in a file given by the user
C
C     Called by MN_CMD
C
C-----------------------------------------------------------------------
C
      implicit none
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mncmd.inc"
#include "mnlun.inc"
C
      CHARACTER*80 TXT1
      CHARACTER*80 TFIL1,TFIL2,TFUNC
      CHARACTER*20 TARG
      INTEGER NCHR1,NADR,IERR,ind1,ind2,nh,kcmd,idelim
     + ,nnid,id1,idb,ndhis0
      REAL ARG
      LOGICAL QEXIST,accessf
      integer  icmtyq,isltyq
      real     valtyq
      external icmtyq,isltyq,valtyq
C
      CALL WAITYQ('Give the filename: ')
      NCHR1 = ISLTYQ(.TRUE.,IDELIM,TFIL1)
      IF(NCHR1.LE.0 .OR. IDELIM.GT.0) GOTO 9000
C
C     Look for an argument in the call
C
      IND1 = INDEX(TFIL1(1:NCHR1),'(')
      IND2 = INDEX(TFIL1(1:NCHR1),')')
      TARG = ' '
      IF(IND1.GT.1 .AND. IND2.GT.IND1) THEN
          NCHR1 = IND1 - 1
          IF(IND2.GT.IND1+1) TARG = TFIL1(IND1+1:IND2-1)
      ENDIF
C
C     See if the file exists and if not edit it
C
      tfil2 = tfil1(:nchr1)
      call m_pfil(1,tfil2,ierr)
      if(ierr.ne.0) goto 9000
#if ( defined(UNIX) )
      qexist = accessf(tfil2,0)
#endif
#if ( defined(VMS) )
      INQUIRE(FILE=TFIL2,EXIST=QEXIST)
#endif

      IF(.NOT.QEXIST) THEN
          NH = 0
          CALL M_SKEL(3,LUNTMP,NH,IERR,TFIL2)
          IF(IERR.NE.0) GOTO 9000
      ENDIF
C
C     Edit the COMIS function
C
      CALL WAITYQ('Edit the COMIS function file [Y/N]: ')
      KCMD = ICMTYQ(.TRUE.,IDELIM,LOGNAM)
      IF(MOD(KCMD,2).EQ.1) THEN
          CALL QUOTYQ(TFIL2)
          TXT1 = 'EDIT'
          CALL MN_SPW(TXT1,IDELIM)
      ENDIF
C
C     Compile the COMIS function
C
      CALL M_FCMS(-1,TFIL2,TFIL1,TFUNC,NADR,IERR)
      IF(IERR.NE.0) GOTO 9000
C
C     Convert the argument to a real number (if there is one)
C
      IF(TARG.NE.' ') THEN
          CALL QUOTYQ(TARG)
          ARG = VALTYQ(.TRUE.,IDELIM)
          CALL ZERTYQ('.FALSE.')
          CALL MN_RCK(ARG,IDELIM,IERR)
          IF(IERR.NE.0) THEN
              TXTERR = 'Error interpreting subroutine argument: ' //
     +         TARG
              CALL MN_ERR('M_CALL',TXTERR)
              GOTO 9000
          ENDIF
      ELSE
          ARG = 0.0
      ENDIF
C
C     Call the Comis subroutine
C
      CALL CSJCAL(NADR,1,ARG)
C
C     Update the Mn_Fit histograms from the current HBOOK directory
C
      ndhis0 = ndhis
      call m_hbmn(0,0,ndidb,4)
      nnid = 1
      id1  = 0
      idb  = ndidb
      call mn_hng('M_CALL',nnid,ndhis0,1,id1,id1,idb,idb)
C
9000  CONTINUE
      END
