      SUBROUTINE MN_DRW(NTYPFL,NDERR)
C
C     MEANING OF FLAGS ARE:
C     -3      Hardcopy of fit plot
C     -2      Redraw of fit plot
C     -1      Plot the fit results
C      0      Draw the latest plot
C      1      Draw all the plots which are stored
C      2      Redraw of a plot
C      3      Hardcopy of a plot
C
C     Segment numbers are defined as follows:
C     100*(NP-1) + 1           Main plot (MN_PLT)
C     100*(NP-1) + 11          Text in display
C     100*(NP-1) + 20 + NCOMM  Comments
C     100*(NP-1) + 60 + NKEY   Keys
C     15000      +      NDRAW  Lines, arrows etc.
C     In addition LPDEV*1000 is added to all segment numbers to keep the
C     segment numbers for different workstations separate
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mnfit.inc"
#include "mnflg.inc"
#include "mnhpj.inc"
#include "mndbg.inc"
#include "mnlun.inc"
C
      INTEGER NTYPFL,NDERR
C
      INTEGER NHP1,NHP2,NP,NOVEFL,IDA,IDB
      LOGICAL QMNHEX,QMNFEX,QEXIST
C
      IF(QDEBUG) THEN
          WRITE(LUNTTO,'('' MN_DRW: Flag'',I4)') NTYPFL
          CALL MN_SHW('PLOT')
      ENDIF
C
      NDERR = 0
C
C     DRAW THE RESULTS
C
      IF(NTYPFL.EQ.0) THEN
          NHP1 = NHPLT
          NHP2 = NHPLT
      ELSE
          NHP1 = 1
          NHP2 = NHPLT
      ENDIF
C
      NHF = 0
C
      DO 3000 NP=NHP1,NHP2
          IDA    = IPLTIA(NP)
          IDB    = IPLTIB(NP)
          NOVEFL = IPLTFL(NP)
C
C         CHECK THAT THE PLOT EXISTS
C
          NH = 0
          QEXIST = QMNFEX(IDA,IDB,NH) .OR. QMNHEX(IDA,IDB,NH)
          IF(.NOT.QEXIST) THEN
              CALL MN_TOF(.FALSE.)
              WRITE(TXTERR,'('' Plot'',I7,I4,'' does not exist'')')
     1         IDA,IDB
              CALL MN_ERR('MN_DRW',TXTERR)
              CALL MN_TON(IERR)
              GOTO 3000
          ENDIF
C
          IF((IABS(NTYPFL).EQ.0 .OR. IABS(NTYPFL).EQ.1) .AND.
     1       NOVEFL.EQ.1) THEN
C
C             DEFINE THE LAST PLOT TO BE THE DEFAULT
C             IF THE DEFAULT HAS NOT BEEN SET
C
              IF(.NOT.QSHIST) THEN
                  NIDADT = IDA
                  NIDBDT = IDB
                  NNHDT  = NH
              ENDIF
          ENDIF
C
C         IF THIS IS A NEW PLOT MAKE THE CURRENT SET OF SET
C         PARAMETERS THE USER PARAMETERS
C         IF ITS AN OVERLAY THEN USE THOSE FROM THE LAST PLOT
C         IF ITS A REDRAW OR HARDCOPY THEN GET THOSE FOR THIS PLOT
C
          CALL MN_PSP(IABS(NTYPFL),NP,IERR)
          IF(IERR.NE.0) GOTO 3000
C
C         DRAW THE PLOT
C
          CALL MN_PLH(IDA,IDB,NP,NTYPFL,NOVEFL,NDERR)
          IF(NDERR.NE.0) GOTO 8000
C
C         DISPLAY TEXT
C
          IF(NTYPFL.LT.0 .AND. NCLRU.EQ.1) THEN
              NHF = NHF + 1
C
C             Create a segment
C
              NSEGM = 100*(NP-1) + 11
              CALL M_CRSG(NSEGM)
C
              CALL MN_PLI(IDFITA(NHF),IDFITB(NHF))
C
C             Close the segment
C
              CALL M_CLSG(NSEGM)
          ENDIF
C
C         ADD ANY COMMENTS
C
          IF(IDA.GT.0 .AND.
     +       (NOVEFL.EQ.1 .OR. NOVEFL.EQ.3)) THEN
C
              DO 2500 NC=1,NPLTCM(NP)
C
C                 Create a segment
C
                  NSEGM = 100*(NP-1) + 20 + NC
                  CALL M_CRSG(NSEGM)
C
                  XX     = RPLTCM(1,NC,NP)
                  YY     = RPLTCM(2,NC,NP)
                  SZE    = RPLTCM(3,NC,NP)
                  ANGLE  = RPLTCM(4,NC,NP)
                  IOPT   = NINT(RPLTCM(5,NC,NP))
                  JMODE  = NINT(RPLTCM(6,NC,NP))
                  NFONT  = NINT(RPLTCM(7,NC,NP))
                  NCOL   = NINT(RPLTCM(8,NC,NP))
                  THICK  = RPLTCM(9,NC,NP)
                  CALL MN_CTR(XX,YY,XXX,YYY,1,JMODE)
                  CALL MN_TXT(XXX,YYY,TPLTCM(NC,NP),SZE,ANGLE,IOPT
     1             ,NFONT,NCOL,THICK)
C
C                 Close the segment
C
                  CALL M_CLSG(NSEGM)
2500          CONTINUE
C
C             ADD ANY KEY EXPLANATIONS
              DO 2600 NC=1,NPLTKY(NP)
C
C                 Create a segment
C
                  NSEGM = 100*(NP-1) + 60 + NC
                  CALL M_CRSG(NSEGM)
C
                  NCSYMB = LPLTKY(NC,NP)
                  XX     = RPLTKY(1,NC,NP)
                  YY     = RPLTKY(2,NC,NP)
                  SZE    = RPLTKY(3,NC,NP)
                  ANGLE  = RPLTKY(4,NC,NP)
                  IOPT   = NINT(RPLTKY(5,NC,NP))
                  JMODE  = NINT(RPLTKY(6,NC,NP))
                  NFONT  = NINT(RPLTKY(7,NC,NP))
                  NCOL   = NINT(RPLTKY(8,NC,NP))
                  THICK  = RPLTKY(9,NC,NP)
                  XUNIT  = RPLTKY(10,NC,NP)
                  ncolt  = nint(RPLTKY(11,NC,NP))
                  CALL MN_CTR(XX,YY,XXX,YYY,1,JMODE)
                  CALL MN_KEY(NCSYMB,XXX,YYY,TPLTKY(NC,NP)
     1             ,SZE,ANGLE,IOPT,NFONT,NCOL,THICK,XUNIT,ncolt)
C
C                 Close the segment
C
                  CALL M_CLSG(NSEGM)
2600          CONTINUE
          ENDIF
C
          CALL TVSHOW
C
C         STORE THE PLOT PARAMETERS FOR THIS PLOT
C
          CALL MN_PST(NP)
C
C         Add any drawing that should be done first
C
*ICB          IF(IABS(NTYPFL).GT.1 .AND. NP.EQ.1 .AND. NDRWLN.GT.0) THEN
*ICB              CALL MN_LDP(0,.TRUE.,1,IDA,IDB)
*ICB          ENDIF
3000  CONTINUE
C
C     Setup the page and draw the box round the plot
C     here if no plots have been made
C
      if(nhplt.eq.0) then
          call mn_ton(ierr)
          call tvnext
          call m_spage
      endif
*
*     Draw all items that should be drawn last that are in CM coords.
*     If no plots have been made draw all items.
*
      IF(IABS(NTYPFL).GT.1 .AND. NDRWLN.GT.0) THEN
          IF(NHPLT.GT.0) THEN
              CALL MN_LDP(0,.TRUE.,11,0,0)
          ELSE
              CALL MN_LDP(0,.FALSE.,0,0,0)
          ENDIF
      ENDIF
C
C     IF WE ARE JUST DOING LINES AND THERE ARE NO PLOTS THEN THE COMMENTS
C     AS IF THIS WERE THE FIRST PLOT SHOULD BE ADDED
C
      IF(NHPLT.EQ.0) THEN
          NP = 1
          DO 4500 NC=1,NPLTCM(NP)
C
C             Create a segment
C
              NSEGM = 100*(NP-1) + 20 + NC
              CALL M_CRSG(NSEGM)
C
              XX     = RPLTCM(1,NC,NP)
              YY     = RPLTCM(2,NC,NP)
              SZE    = RPLTCM(3,NC,NP)
              ANGLE  = RPLTCM(4,NC,NP)
              IOPT   = NINT(RPLTCM(5,NC,NP))
              JMODE  = NINT(RPLTCM(6,NC,NP))
              NFONT  = NINT(RPLTCM(7,NC,NP))
              NCOL   = NINT(RPLTCM(8,NC,NP))
              THICK  = RPLTCM(9,NC,NP)
              CALL MN_CTR(XX,YY,XXX,YYY,1,JMODE)
              CALL MN_TXT(XXX,YYY,TPLTCM(NC,NP),SZE,ANGLE,IOPT
     1         ,NFONT,NCOL,THICK)
C
C             Close the segment
C
              CALL M_CLSG(NSEGM)
4500      CONTINUE
      ENDIF
C
      CALL TVSHOW
8000  CONTINUE
      CALL MN_TOF(.TRUE.)
C
      RETURN
      END
