      SUBROUTINE MN_HIS
C
C     DO SOMETHING WITH A HISTOGRAM
C
      implicit none
*
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mnflg.inc"
#include "mnhpj.inc"
#include "mntim.inc"
#include "mntmp.inc"
#include "mncmd.inc"
#include "mnlun.inc"
C
      integer mhist
      PARAMETER (MHIST=13)
      CHARACTER*10 HSTNAM(MHIST)
      integer mplqul,movqul,mbkqul,mlegqul,msurqul,mcolqul
      PARAMETER (MPLQUL=7, MOVQUL=6, MBKQUL=6
     + , mlegqul=11, msurqul=12, mcolqul=3)
      CHARACTER*10 PLTQUL(MPLQUL),OVEQUL(MOVQUL),BOKQUL(MBKQUL)
     + ,legqul(mlegqul),surqul(msurqul),colqul(mcolqul)
C
      REAL ADAT(MDIMMX),AERN(MDIMMX),AERP(MDIMMX)
      INTEGER NQUAL,IQUAL(10)
      LOGICAL QERRL,QERRH
C
      REAL RNUM(10),rval
      integer ida,idb,ida1,idb1,ida2,idb2
      integer nsym,nhat,npat,nscol,nhcol,npcol
      integer nsyml,nhatl,npatl
      integer nflag,nderr,nmode,nd,npmax,nwrd,nwh,nwtot,nl,ndimo
     + ,nww,nloop,nval,nnum,ioerr,noff,noffl,noffh
      integer lenb,lene,lent,nchtit,nleg,nphi,ntheta
      integer i,ierr,nnid,nh,nnh,nnhp
     + ,modeh,modecl
      real err,weight
C
      LOGICAL QQUAL,QCLEAR,QSAME,QBIN,QERRS,QERRA,QPNTPL,QNEXT,QSMOOTH
     + ,QEMPTY
      CHARACTER TEXT*255,CONCAT*255,conct0*255,TITLE*80
      CHARACTER*30 TBIN,TERR
      character*10 tigopt(2),tigqul
      integer ligopt
*
      LOGICAL QSTART,QRNGE,QRNGSV
      INTEGER NNHLST
*
      integer idelim,jcmd,kcmd
      integer  inttyq,iqstyq,ivltyq,icmtyq
     + ,lnblnk
      real     valtyq
      external inttyq,iqstyq,ivltyq,icmtyq,valtyq,lnblnk
C
      DATA HSTNAM/'PLOT',    'OVERLAY',
     1 'DUMP',    'EXTRACT', 'LEGO',    'SURFACE','ERRORS',
     2 'BOOK',    'FILL',    'DISPLAY', 'IGTABLE','2DIM',
     + ' '/
      DATA PLTQUL/'CLEAR', 'NOCLEAR',   'NTUPLE', 'NEXT', 'SMOOTH',
     + 'EMPTY',' '/
      DATA OVEQUL/'SAME',  'DIFFERENT', 'NTUPLE', 'NEXT', 'SMOOTH', ' '/
      DATA BOKQUL/'BINNED','UNBINNED',
     1 'ERROR', 'NOERROR', 'ASYMMETRIC', ' '/
      data legqul/'IGTABLE','C1','C2','BAR',
     + 'POL','CYL','SPH','PSD','NFB','NBB',' '/
      data surqul/'IGTABLE','C1','C2','CONT','SHADE',
     + 'POL','CYL','SPH','PSD','NFB','NBB',' '/
      data colqul/'Z','NZ',' '/
      DATA QSTART/.TRUE./
      DATA NNHLST/0/
C
*ICB      IF(QSTART) THEN
*ICB          QSTART = .FALSE.
*ICB          DO 100 II=1,MDIMMX
*ICB              IF(II.EQ.1) THEN
*ICB                  TNDEF(II) = 'X'
*ICB              ELSE IF(II.EQ.2) THEN
*ICB                  TNDEF(II) = 'Y'
*ICB              ELSE IF(II.EQ.3) THEN
*ICB                  TNDEF(II) = 'Z'
*ICB              ELSE
*ICB                  TNDEF(II) = ' '
*ICB              ENDIF
*ICB100       CONTINUE
*ICB      ENDIF
C
      IF(COMND1.EQ.'PLOT'    .OR. COMND1.EQ.'OVERLAY' .OR.
     1   COMND1.EQ.'EXTRACT' .OR. COMND1.EQ.'DUMP'    .OR.
     1   COMND1.EQ.'LEGO'    .OR. COMND1.EQ.'SURFACE' .OR.
     2   COMND1.EQ.'BOOK'    .OR. COMND1.EQ.'FILL'    .OR.
     3   COMND1.EQ.'DISPLAY' .OR.
     +   COMND1.EQ.'IGTABLE' .OR. COMND1.EQ.'2DIM') THEN
          COMND1 = 'HISTOGRAM'
          CALL RESTYQ
      ENDIF
C
 2000 CONTINUE
      CALL WAITYQ('Give histogram operation or ?: ')
      JCMD = ICMTYQ(.TRUE.,IDELIM,HSTNAM)
      COMND2 = ' '
      IF(JCMD.GT.0) COMND2 = HSTNAM(JCMD)
      IF(JCMD.LT.0 .AND. IDELIM.EQ.ICHAR('?')) THEN
          CALL QUOTYQ('HISTOGRAM ' // COMND2)
          IDELIM = 0
          CALL MN_HLP(IDELIM,IERR)
          GOTO 2000
      ENDIF
      IF(JCMD.LT.0) GOTO 9000
      CALL MN_DCK(IDELIM,JCMD,MHIST,HSTNAM,IERR)
      IF(IERR.EQ.2) CALL MN_UNK('MN_HIS')
      IF(IERR.GT.0) GOTO 9000
*
*     Get the IGTABL mode for the 2DIM command
*
      IF(COMND2.EQ.'2DIM') THEN
          call m_sigopt(tigopt,ligopt,idelim,ierr)
          if(ierr.ne.0) goto 9000
          tigopts = tigopt(2)
          ligopts = ligopt
      endif
C
C     SET DEFAULT VALUES FOR QUALIFIERS
C
      QCLEAR  = .TRUE.
      QSAME   = .TRUE.
      QBIN    = .FALSE.
      QERRS   = .TRUE.
      QERRA   = .FALSE.
      QPNTPL  = .FALSE.
      QNEXT   = .FALSE.
      QSMOOTH = .FALSE.
      QEMPTY  = .FALSE.
C
C     Check for any qualifiers
C
2100  CONTINUE
      IF(COMND2.EQ.'PLOT' .OR. COMND2.EQ.'DISPLAY') THEN
          CALL M_QUAL(IDELIM,PLTQUL,MPLQUL,IQUAL,NQUAL)
          IF(NQUAL.LT.0) GOTO 9000
          DO 2200 I=1,NQUAL
              IF(IQUAL(I).EQ.1) THEN
                  QCLEAR  = .TRUE.
              ELSEIF(IQUAL(I).EQ.2) THEN
                  QCLEAR  = .FALSE.
              ELSEIF(IQUAL(I).EQ.3) THEN
                  QPNTPL  = .TRUE.
              ELSEIF(IQUAL(I).EQ.4) THEN
                  QNEXT   = .TRUE.
              ELSEIF(IQUAL(I).EQ.5) THEN
                  QSMOOTH = .TRUE.
              ELSEIF(IQUAL(I).EQ.6) THEN
                  QEMPTY  = .TRUE.
              ENDIF
2200      CONTINUE
      ELSEIF(COMND2.EQ.'OVERLAY') THEN
          CALL M_QUAL(IDELIM,OVEQUL,MOVQUL,IQUAL,NQUAL)
          IF(NQUAL.LT.0) GOTO 9000
          DO 2300 I=1,NQUAL
              IF(IQUAL(I).EQ.1) THEN
                  QSAME = .TRUE.
              ELSEIF(IQUAL(I).EQ.2) THEN
                  QSAME = .FALSE.
              ELSEIF(IQUAL(I).EQ.3) THEN
                  QPNTPL = .TRUE.
              ELSEIF(IQUAL(I).EQ.4) THEN
                  QNEXT  = .TRUE.
              ELSEIF(IQUAL(I).EQ.5) THEN
                  QSMOOTH = .TRUE.
              ENDIF
2300      CONTINUE
      ELSEIF(COMND2.EQ.'BOOK') THEN
          CALL M_QUAL(IDELIM,BOKQUL,MBKQUL,IQUAL,NQUAL)
          IF(NQUAL.LT.0) GOTO 9000
          DO 2400 I=1,NQUAL
              IF(IQUAL(I).EQ.1) THEN
                  QBIN  = .TRUE.
              ELSEIF(IQUAL(I).EQ.2) THEN
                  QBIN  = .FALSE.
              ELSEIF(IQUAL(I).EQ.3) THEN
                  QERRS = .TRUE.
                  QERRA = .FALSE.
              ELSEIF(IQUAL(I).EQ.4) THEN
                  QERRS = .FALSE.
                  QERRA = .FALSE.
              ELSEIF(IQUAL(I).EQ.5) THEN
                  QERRS = .FALSE.
                  QERRA = .TRUE.
              ENDIF
2400      CONTINUE
*
*     Qualifiers for LEGO and SURFACE.
*     Any qualifier means that IGTABLE will be used.
*     Convert the command to 2DIM and proceed.
*     Qualifer 1 also means use IGTABLE.
*
      elseif(comnd2.eq.'LEGO' .or.
     +       comnd2.eq.'2DIM' .and. tigopts(1:1).eq.'L') then
          call m_qual(idelim,legqul,mlegqul,iqual,nqual)
          if(nqual.lt.0) goto 9000
          tigqul = ' '
          do i=1,nqual
              if(iqual(i).eq.2) then
                  tigqul = conct0(tigqul,'1')
              elseif(iqual(i).eq.3) then
                  tigqul = conct0(tigqul,'2')
              elseif(iqual(i).eq.4) then
                  tigqul = conct0(tigqul,'B')
              elseif(iqual(i).eq.5) then
                  tigqul = conct0(tigqul,',POL')
              elseif(iqual(i).eq.6) then
                  tigqul = conct0(tigqul,',CYL')
              elseif(iqual(i).eq.7) then
                  tigqul = conct0(tigqul,',SPH')
              elseif(iqual(i).eq.8) then
                  tigqul = conct0(tigqul,',PSD')
              elseif(iqual(i).eq.9) then
                  tigqul = conct0(tigqul,',FB')
              elseif(iqual(i).eq.10) then
                  tigqul = conct0(tigqul,',BB')
              endif
          enddo
          if(nqual.gt.0) then
              tigopt(1) = 'LEGO'
              tigopt(2) = 'L'
              comnd2  = '2DIM'
              tigopts = conct0(tigopt(2),tigqul)
              ligopts = lnblnk(tigopts)
          endif
*
      elseif(comnd2.eq.'SURFACE' .or.
     +       comnd2.eq.'2DIM' .and. tigopts(1:1).eq.'S') then
          call m_qual(idelim,surqul,msurqul,iqual,nqual)
          if(nqual.lt.0) goto 9000
          tigqul = ' '
          do i=1,nqual
              if(iqual(i).eq.2) then
                  tigqul = conct0(tigqul,'1')
              elseif(iqual(i).eq.3) then
                  tigqul = conct0(tigqul,'2')
              elseif(iqual(i).eq.4) then
                  tigqul = conct0(tigqul,'3')
              elseif(iqual(i).eq.5) then
                  tigqul = conct0(tigqul,'4')
              elseif(iqual(i).eq.6) then
                  tigqul = conct0(tigqul,',POL')
              elseif(iqual(i).eq.7) then
                  tigqul = conct0(tigqul,',CYL')
              elseif(iqual(i).eq.8) then
                  tigqul = conct0(tigqul,',SPH')
              elseif(iqual(i).eq.9) then
                  tigqul = conct0(tigqul,',PSD')
              elseif(iqual(i).eq.10) then
                  tigqul = conct0(tigqul,',FB')
              elseif(iqual(i).eq.11) then
                  tigqul = conct0(tigqul,',BB')
              endif
          enddo
          if(nqual.gt.0) then
              tigopt(1) = 'SURF'
              tigopt(2) = 'S'
              comnd2  = '2DIM'
              tigopts = conct0(tigopt(2),tigqul)
              ligopts = lnblnk(tigopts)
          endif
*
*     Turn on or off the colour scale
*
      elseif(comnd2.eq.'2DIM' .and. tigopts(1:3).eq.'COL') then
          call m_qual(idelim,colqul,mcolqul,iqual,nqual)
          if(nqual.lt.0) goto 9000
          tigqul = 'Z'
          do i=1,nqual
              if(iqual(i).eq.1) then
                  tigqul = 'Z'
              elseif(iqual(i).eq.2) then
                  tigqul = ' '
              endif
          enddo
          if(nqual.gt.0) then
              tigopts = conct0(tigopts,tigqul)
              ligopts = lnblnk(tigopts)
          endif
      endif
C
C     PLOT, OVERLAY, 2D, LEGO or SURFACE PLOT
C
      IF(COMND2.EQ.'PLOT'    .OR. COMND2.EQ.'OVERLAY' .OR.
     1   COMND2.EQ.'LEGO'    .OR. COMND2.EQ.'SURFACE' .OR.
     3   COMND2.EQ.'DISPLAY' .OR.
     +   COMND2.EQ.'IGTABLE' .OR. COMND2.EQ.'2DIM') THEN
C
C         Set up any parameters needed for special displays
C         implemented for L3
C
          IF(COMND2.EQ.'DISPLAY') THEN
              CALL MN_DSC(IDELIM,IERR)
              IF(IERR.NE.0) GOTO 9000
          ENDIF
C
          IF(.NOT.QNEXT) THEN
              IDB1 = NDIDB
              IDB2 = NDIDB
              QHBPRT = .TRUE.
              CALL WAITYQ('Give histogram number: ')
              CALL MN_HRN(IDA1,IDA2,IDB1,IDB2,IDELIM,NNID)
              QHBPRT = .FALSE.
C
              IF(NNID.LE.0) GOTO 9000
              IF(IDA1.LT.0) GOTO 9000
              QRNGE = IDA1.EQ.0 .OR. IDA1.NE.IDA2 .OR. IDB1.NE.IDB2
          ELSE
              QRNGE = .FALSE.
          ENDIF
          QRNGSV = QRNGE
C
          IF(QRNGE) THEN
              IF(COMND2.EQ.'OVERLAY') THEN
                  CALL MN_ERR('MN_HIS'
     +             ,' You cannot overlay a range of plots')
                  GOTO 9000
              ENDIF
              NNH  = 0
              NNHP = 0
          ENDIF
C
 3000     CONTINUE
          IF(QRNGE) THEN
              NNH = NNH + 1
              IF(NNH.GT.NDHIS) GOTO 9000
              IF(IDPTRH(NNH).LE.0 .OR. IDPTRD(NNH).LE.0) GOTO 3000
              IDA = IDIDA(NNH)
              IDB = IDIDB(NNH)
              IF((IDA1.NE.0 .AND. (IDA.LT.IDA1 .OR. IDA.GT.IDA2)) .OR.
     1           (NNID.GT.1 .AND.
     2            (IDB.LT.IDB1 .OR. IDB.GT.IDB2))) GOTO 3000
              NNHP = NNHP + 1
          ELSEIF(QNEXT) THEN
              NNH = NNHLST
2900          CONTINUE
              NNH = NNH + 1
              IF(NNH.GT.NDHIS) THEN
                  CALL MN_MES(LUNTTO,'ME','No more plots to draw')
                  GOTO 9000
              ENDIF
              IF(IDPTRH(NNH).LE.0 .OR. IDPTRD(NNH).LE.0) GOTO 2900
              IDA = IDIDA(NNH)
              IDB = IDIDB(NNH)
              QRNGE = .FALSE.
          ELSE
              IDA = IDA1
              IDB = IDB1
          ENDIF
C
          IF(IDB.LT.0) THEN
              KCMD = -IDB
              CALL MN_HBP(IDA,IDB,HBPNAM(KCMD),IDELIM,IERR)
              IF(IERR.NE.0) GOTO 9000
              GOTO 3500
          ENDIF
C
 3500     CONTINUE
C
C         SEE IF THE PLOT EXISTS
C
          CALL MN_HGT(IDA,IDB,NH)
          IF(NH.LE.0) THEN
              WRITE(TXTERR,'(''Histogram'',I7,I4
     1         ,'' does not exist'')') IDA,IDB
              CALL MN_ERR('MN_HIS',TXTERR)
              GOTO 9000
          ENDIF
          NNHLST = NH
*
*         Check the plot dimensions, but not for displays.
*
          IF(COMND2.NE.'DISPLAY' .and.
     +       ((.NOT.QPNTPL .AND. IABS(NDIM).GT.2) .OR.
     +        (QPNTPL .AND. NDIM.GT.0))) THEN
              IF(QRNGE .OR. QNEXT) THEN
                  IF(QRNGE) NNHP = NNHP - 1
                  GOTO 3000
              ENDIF
              WRITE(TXTERR,'(''Plot'',I7,I4
     1           ,'' has a dimension of'',I4)') IDA,IDB,NDIM
              CALL M_EMSG('MN_HIS',TXTERR)
              WRITE(TXTERR,'(''I can only plot 2 dimensions.'')')
              CALL M_EMSG('MN_HIS',TXTERR)
              WRITE(TXTERR,'(''Use the command PROJECT to make the''
     2           ,'' projection you want'')')
              CALL MN_ERR('MN_HIS',TXTERR)
              GOTO 9000
          ELSEIF(QPNTPL .AND. (INTPMN(1).LE.0 .OR. INTPMN(2).LE.0)) THEN
              IF(QRNGE) THEN
                  NNHP = NNHP - 1
                  GOTO 3000
              ENDIF
              CALL MN_ERR('MN_HIS'
     +         ,'You must use the SET NTUPLE command' //
     +          ' to set the variables to plot')
              GOTO 9000
          ELSEIF(QPNTPL .AND. NWDAT.EQ.0) THEN
              IF(QRNGE) THEN
                  NNHP = NNHP - 1
                  GOTO 3000
              ENDIF
              CALL MN_ERR('MN_HIS'
     +         ,'You can only directly plot Ntuples' //
     +          ' if they are in memory (<50000 words)')
              GOTO 9000
          ELSEIF((COMND2.EQ.'IGTABLE' .OR. COMND2.EQ.'2DIM') .AND.
     +         NDIM.NE.2) THEN
              IF(QRNGE) THEN
                  NNHP = NNHP - 1
                  GOTO 3000
              ENDIF
              WRITE(TXTERR,'(''Plot'',I7,I4
     1           ,'' has a dimension of'',I4)') IDA,IDB,NDIM
              CALL M_EMSG('MN_HIS',TXTERR)
              TXTERR = 'I can only IGTABL or 2DIM plot 2 dimensions.'
              CALL MN_ERR('MN_HIS',TXTERR)
              GOTO 9000
          ENDIF
C
C         SET UP THE PLOT NUMBER IN THE BUFFER
C
          IF(COMND2.EQ.'PLOT'    .OR. COMND2.EQ.'LEGO'    .OR.
     +       COMND2.EQ.'SURFACE' .OR. COMND2.EQ.'DISPLAY' .OR.
     +       COMND2.EQ.'IGTABLE' .OR. COMND2.EQ.'2DIM') THEN
C
C             IF LAST PLOT WAS A FIT GET BACK THE PARAMETERS FOR
C             A NORMAL PLOT
C
              IF(QDFIT) CALL MN_FRP
C
C             Get the plot number
C
              IF(QRNGE .AND. NNHP.EQ.1) QRNGE = .FALSE.
              CALL M_NPLT(QRNGE,QCLEAR,IERR)
              QRNGE = QRNGSV
              IF(IERR.NE.0) GOTO 9000
C
              MODEH = 1
              MODECL= 1
              IF(NHPLT.EQ.1) NDRWLN = 0
C
              CALL MN_ZER(NHPLT,IDELIM)
C
          ELSEIF(COMND2.EQ.'OVERLAY') THEN
              IF(NHPLT.LT.MHPLT) THEN
                  NHPLT = NHPLT + 1
              ELSE
                  CALL MN_ERR('MN_HIS'
     +             ,'Buffer for overlaying histograms is full')
                  GOTO 9000
              ENDIF
C
              IF(QSAME) THEN
                  MODEH = 2
              ELSE
                  MODEH = 3
              ENDIF
              MODECL = 0
C
              NPLTCM(NHPLT) = 0
              NPLTKY(NHPLT) = 0
          ENDIF
C
C         Setup the symbol numbers
C
          IF(COMND2.EQ.'PLOT') THEN
              IF(.NOT.QCLEAR) MODECL = 0
              NSYM  = NSYMS
              NHAT  = NHATS
              NPAT  = NPATS
              nscol = icols(7)
              nhcol = icols(8)
              npcol = icols(9)
              QLEGO = .FALSE.
              NLEG  = 0
              IF(QEMPTY) THEN
                  NLEG = 10
              ELSEIF(QSMOOTH) THEN
                  NLEG = -1
                  NSYM = -IABS(MOD(NSYM,10))
              ENDIF
C
          ELSEIF(COMND2.EQ.'OVERLAY') THEN
              IF(QLEGO) THEN
                  CALL MN_ERR('MN_HIS'
     +             ,'You cannot do an overlay on a lego plot')
                  GOTO 9000
              ENDIF
              NSYM = ISIGN(IABS(NSYMU)+1,NSYMU)
              NHAT = 0
              NPAT = 0
              NLEG = 0
              nscol = icols(7)
              nhcol = icols(8)
              npcol = icols(9)
              IF(QSMOOTH) THEN
                  NLEG = -1
                  NSYM = -IABS(MOD(NSYM,10))
              ENDIF
C
          ELSEIF(COMND2.EQ.'LEGO'    .OR. COMND2.EQ.'SURFACE' .OR.
     +           COMND2.EQ.'IGTABLE' .OR. COMND2.EQ.'2DIM') THEN
              QLEGO = .TRUE.
              IF(COMND2.EQ.'LEGO') THEN
                  NLEG = 1
              ELSEIF(COMND2.EQ.'SURFACE') THEN
                  NLEG = 2
              ELSEIF((TIGOPTS(1:1).EQ.'L' .OR.
     +                TIGOPTS(1:1).EQ.'S') .AND.
     +               (INDEX(TIGOPTS,'POL').GT.0 .OR.
     +                INDEX(TIGOPTS,'CYL').GT.0 .OR.
     +                INDEX(TIGOPTS,'SPH').GT.0 .OR.
     +                INDEX(TIGOPTS,'PSD').GT.0)) THEN
                  NLEG = 9
              ELSEIF(TIGOPTS(1:1).EQ.'L' .OR.
     +               TIGOPTS(1:1).EQ.'S') THEN
                  NLEG = 8
              ELSE
                  NLEG = 7
              ENDIF
              NSYM = 1
              NHAT = 0
              NPAT = 0
              nscol = icols(7)
              nhcol = icols(8)
              npcol = icols(9)
C
C             GET THE ANGLES FOR THE LEGO PLOT
C
              IF(COMND2.EQ.'LEGO' .OR. COMND2.EQ.'SURFACE' .OR.
     +           COMND2.EQ.'2DIM' .AND.
     +           (TIGOPTS(1:1).EQ.'L' .OR. TIGOPTS(1:1).EQ.'S')) THEN
                  NNUM = 0
 4000             CONTINUE
                  TEXT = 'Give viewing angle theta,phi (<CR>=   ,   ): '
                  if(comnd2.eq.'2DIM') then
                      NTHETA = NINT(AIGPARS(1))
                  else
                      NTHETA = NINT(ALEGS(1))
                  endif
                  WRITE(TEXT(36:38),'(I3)',IOSTAT=IOERR) NTHETA
                  if(comnd2.eq.'2DIM') then
                      NPHI = NINT(AIGPARS(2))
                  else
                      NPHI = NINT(ALEGS(2))
                  endif
                  WRITE(TEXT(40:42),'(I3)',IOSTAT=IOERR) NPHI
                  CALL WAITYQ(TEXT(1:LNBLNK(TEXT)+1))
C
                  RVAL = VALTYQ(.TRUE.,IDELIM)
                  CALL MN_RCK(RVAL,IDELIM,IERR)
                  IF(IERR.EQ.2) GOTO 4100
                  IF(IERR.NE.0) THEN
                      IF(IERR.NE.2) CALL RESTYQ
                      GOTO 4100
                  ENDIF
                  NNUM = NNUM + 1
                  if(comnd2.eq.'2DIM') then
                    AIGPARS(NNUM) = RVAL
                    NIGPARS       = NNUM
                    IF(IDELIM.EQ.0 .AND. NNUM.LT.MIGPAR) GOTO 4000
                  else
                    if(rval.lt.0.0 .or. rval.ge.90.0) then
                      txterr = 'Angles must be between 0 and 90 degrees'
                      call mn_err('MN_HIS',txterr)
                      goto 9000
                    endif
                    ALEGS(NNUM)   = RVAL
                    IF(IDELIM.EQ.0 .AND. NNUM.LT.2) GOTO 4000
                  endif
 4100             CONTINUE
C
C             Get any parameters for 2DIM command
C
              ELSEIF(COMND2.EQ.'2DIM') THEN
                  call m_sigpar(tigopt(1),aigpars,nigpars,idelim,ierr)
                  if(ierr.ne.0) goto 9000
              ENDIF
C
C         L3 DETECTOR DISPLAY
C
          ELSEIF(COMND2.EQ.'DISPLAY') THEN
              QLEGO = .TRUE.
              NLEG = 11
              IF(.NOT.QCLEAR) MODECL = 0
              NSYM = NSYMS
              NHAT = NHATS
              NPAT = NPATS
              nscol = icols(7)
              nhcol = icols(8)
              npcol = icols(9)
              CALL MN_DSX(IDELIM,IERR,NSYM,NHAT,NPAT)
              IF(IERR.NE.0) GOTO 9000
          ENDIF
C
          IF(COMND2.EQ.'PLOT' .OR. COMND2.EQ.'OVERLAY') THEN
            IF(.NOT.QRNGE .OR. (QRNGE.AND.NNHP.EQ.1)) THEN
              IF(IDELIM.GE.0 .OR.
     +         (COMND2.EQ.'OVERLAY' .AND. .NOT.QRFILE)) THEN
                if(comnd2.eq.'OVERLAY' .and. idelim.lt.0) then
                  write(text,'(
     +             '' Default symbol, hatch and pattern are:''
     +             ,I3,''/'',A
     +             ,'','',I4,''/'',A,'','',I4,''/'',A)',iostat=ioerr)
     +             NSYM,colnam(nscol)
     +             ,NHAT,colnam(nhcol)
     +             ,NPAT,colnam(npcol)
                  LENT = LNBLNK(text)
                  call csqmbl(text,1,lent)
                  LENT = LNBLNK(text)
                  call mn_mes(luntto,'ME',text(:lent))
                endif
                call waityq(
     +           'Give symbol, hatch and pattern for plot' //
     +           ' (<CR> = default):')
                NNUM = 0
 4500           CONTINUE
                NVAL = IVLTYQ(.TRUE.,IDELIM)
*
*               See if the colour is specified
*
                call m_qual(idelim,colnam(1),mcol,iqual,nqual)
                if(nqual.lt.0) goto 9000
                CALL MN_NCK(NVAL,IDELIM,IERR)
                IF(IERR.EQ.2) GOTO 4600
                IF(IERR.GT.0) THEN
                  GOTO 9000
                ELSE
                  NNUM = NNUM + 1
                  IF(NNUM.EQ.1) THEN
                    NSYM = NVAL
                    if(nqual.gt.0) nscol = iqual(1)
                  ELSE IF(NNUM.EQ.2) THEN
                    NHAT = NVAL
                    if(nqual.gt.0) nhcol = iqual(1)
                  ELSE IF(NNUM.EQ.3) THEN
                    NPAT = NVAL
                    if(nqual.gt.0) npcol = iqual(1)
                  ENDIF
                ENDIF
                IF(NNUM.LT.3 .AND. IDELIM.EQ.0) GOTO 4500
 4600           CONTINUE
                IF(NSYM.EQ.0) NSYM = NSYMS
              ENDIF
            ELSE
              NSYM = NSYML
              NHAT = NHATL
              NPAT = NPATL
            ENDIF
          ENDIF
C
          IF(QPNTPL) NLEG = NLEG + 100
C
          QDFUN = .FALSE.
          IPLTIA(NHPLT) = IDA
          IPLTIB(NHPLT) = IDB
          IPLTSY(NHPLT) = NSYM
          IPLTHA(NHPLT) = NHAT
          IPLTPA(NHPLT) = NPAT
          IPLTCO(1,NHPLT) = nscol
          IPLTCO(2,NHPLT) = nhcol
          IPLTCO(3,NHPLT) = npcol
          IPLTFL(NHPLT) = MODEH
          IPLTCL(NHPLT) = MODECL
          IPLTLG(NHPLT) = NLEG
C
          NFLAG = 0
          CALL MN_DRW(NFLAG,NDERR)
C
          IF(QRNGE .AND. NDERR.GE.0) THEN
              NSYML = NSYM
              NHATL = NHAT
              NPATL = NPAT
              GOTO 3000
          ENDIF
C
C     DUMP THE HISTOGRAM CONTENTS
C
      ELSEIF(COMND2.EQ.'DUMP') THEN
          CALL WAITYQ('Give histogram number: ')
          CALL MN_HNO(IDA,IDB,IDELIM,NNID)
          IF(IDA.LE.0) GOTO 9000
          CALL MN_DMP(IDA,IDB,LUNDMP)

C
C     CHANGE THE ERRORS ON A HISTOGRAM
C
      ELSEIF(COMND2.EQ.'ERRORS') THEN
          CALL WAITYQ('Give histogram number: ')
          CALL MN_HNO(IDA,IDB,IDELIM,NNID)
          IF(NNID.LE.0) GOTO 9000
          IF(IDA.LE.0) GOTO 9000
C
          IF(.NOT.QRFILE .AND. IDELIM.LT.0) WRITE(LUNTTO
     +     ,'('' Mode =-1 means errors deleted''
     +     ,/,'' Mode = 0 means errors are set to 0''
     1     ,/,'' Mode = 1 means errors are square root''
     2       ,'' of the number of entries''
     3     ,/,'' Mode = 2 is the same as 1, except the''
     4       ,'' error on zero is set to one''
     +     ,/,'' Mode = 3 means the error you give''
     +       ,'' will be put on all points'')')
          CALL WAITYQ('Give mode: ')
          NVAL = INTTYQ(.TRUE.,IDELIM)
          CALL MN_NCK(NVAL,IDELIM,IERR)
          IF(IERR.EQ.2) GOTO 9000
          IF(IERR.NE.0) GOTO 9000
          NMODE = NVAL
          err   = 0.0
          IF(NMODE.LT.-1 .OR. NMODE.GT.3) THEN
              WRITE(LUNTTO,'('' *** MN_HIS: Illegal mode'',I4)') NMODE
              GOTO 9000
          elseif(nmode.eq.3) then
              call waityq('Give the error: ')
              err = valtyq(.true.,idelim)
              call mn_rck(err,idelim,ierr)
              if(ierr.eq.2) goto 9000
              if(ierr.ne.0) goto 9000
          ENDIF
C
          CALL MN_ERC(IDA,IDB,NMODE,err)
C
C     EXTRACT PART OF AN HBOOK HISTOGRAM
C
      ELSEIF(COMND2.EQ.'EXTRACT') THEN
 7000     CONTINUE
          QHBPRT = .TRUE.
          CALL WAITYQ('Give HBOOK histogram number and part: ')
          CALL MN_HNO(IDA,IDB,IDELIM,NNID)
          QHBPRT = .FALSE.
          IF(NNID.LE.0) GOTO 9000
          IF(IDA.LE.0) THEN
              IF(QRFILE) THEN
                  GOTO 9000
              ELSE
                  GOTO 7000
              ENDIF
          ENDIF
C
          IF(IDB.GE.0 .OR. NNID.EQ.1) THEN
 7100         CONTINUE
              CALL WAITYQ('Give histogram part: ')
              KCMD = ICMTYQ(.TRUE.,IDELIM,HBPNAM)
              IF(KCMD.LT.0) GOTO 9000
              CALL MN_DCK(IDELIM,KCMD,MHBP,HBPNAM,IERR)
              IF(IERR.EQ.2) CALL MN_UNK('MN_HIS')
              IF(IDELIM.GT.0 .OR. KCMD.LE.0) THEN
                  IF(QRFILE) THEN
                      GOTO 9000
                  ELSE
                      GOTO 7100
                  ENDIF
              ENDIF
          ELSE
              KCMD = -IDB
          ENDIF
C
          IDB = NDIDB
          CALL MN_HBP(IDA,IDB,HBPNAM(KCMD),IDELIM,IERR)
C
C     BOOK A NEW PLOT
C
      ELSE IF(COMND2.EQ.'BOOK') THEN
          IDB = NDIDB
          CALL WAITYQ('Give plot number: ')
          CALL MN_HNO(IDA,IDB,IDELIM,NNID)
C
C         CHECK FOR QUALIFIER
C
          QQUAL = NNID.EQ.0 .AND. IDELIM.EQ.ICHAR('/')
          IF(QQUAL) GOTO 2100
          IF(IDA.LE.0 .OR. NNID.LE.0) GOTO 9000
C
          TBIN = 'binned'
          IF(.NOT.QBIN) TBIN = 'unbinned'
          LENB = LNBLNK(TBIN)
          TERR = 'with errors'
          IF(.NOT.QERRS) TERR = 'without errors'
          IF(QERRA) TERR = 'with asymmetric errors'
          LENE = LNBLNK(TERR)
          WRITE(LUNTTO,'('' I will book a new '',A,'' plot'',I7,I4
     1     ,1X,A)') TBIN(1:LENB),IDA,IDB,TERR(1:LENE)
C
          TITLE = ' '
          CALL WAITYQ('Give plot title: ')
          NCHTIT = IQSTYQ(.TRUE.,IDELIM,TEXT)
C
C         See if there are any registers, parameters etc to convert
C         
          CALL MN_TVL(TEXT,TITLE)
C
          CALL WAITYQ('Give number of dimensions: ')
          NDIM = IVLTYQ(.TRUE.,IDELIM)
          CALL MN_NCK(NDIM,IDELIM,IERR)
          IF(IERR.NE.0) GOTO 9000
*
          NTMODE = 0
          nsdate = 0
          nstime = 0
*
*         See if the x-axis mode is date or time
*
          if(ismods(1).eq.3 .or. ismods(1).eq.4) then
              ntmode = nmtime
              nsdate = ndtref
              nstime = ntmref
          endif
C
          IF(QBIN) THEN
              NPNT = 1
              NWPPT = 1
              IF(QERRS .AND. .NOT.QERRA) NWPPT = 2*NWPPT
              IF(QERRA) NWPPT = 3*NWPPT
              NDIM = IABS(NDIM)
              DO 7300 ND=1,NDIM
                  TEXT = CONCAT(TNDEF(ND),'axis:')
                  LENT = LNBLNK(TEXT)
                  IF(IDELIM.LT.0) WRITE(LUNTTO,'(1X,A)') TEXT(1:LENT)
                  CALL MN_BLM(1,ntmode,IDELIM,COMND1 // ' ' // COMND2
     +             ,IDBIN(ND),ADLO(ND),ADHI(ND),NNUM,IERR)
                  IDBIN(ND) = IABS(IDBIN(ND))
                  IF(IDBIN(ND).LE.0 .OR. IERR.NE.0) GOTO 9000
                  NPNT = NPNT * IDBIN(ND)
7300          CONTINUE
              NPMAX = NPNT
C
          ELSE
              NDIM  = -IABS(NDIM)
              NPNT  = 0
              NWPPT = IABS(NDIM)
              IF(NDIM.EQ.-1) NWPPT = NWPPT + 1
              IF(QERRS .AND. .NOT.QERRA) NWPPT = 2*NWPPT
              IF(QERRA) NWPPT = 3*NWPPT
              CALL VZERO_i(IDBIN(1),IABS(NDIM))
              CALL UFILL(ADLO,1,IABS(NDIM), 1.0E+30)
              CALL UFILL(ADHI,1,IABS(NDIM),-1.0E+30)
C
              CALL WAITYQ('Give maximum number of points in plot: ')
              NPMAX = IVLTYQ(.TRUE.,IDELIM)
              CALL MN_NCK(NPMAX,IDELIM,IERR)
              IF(IERR.NE.0) NPMAX = 100
          ENDIF
C
          NBPPT = 0
          NWRD  = NPMAX * NWPPT
          EDENT = 0.0
          IF(NDIM.EQ.-1) THEN
              EDLO =  1.0E+30
              EDHI = -1.0E+30
          ELSE
              EDLO = 0.0
              EDHI = 1.0
          ENDIF
          CALL VZERO_r(ACONT(1),3**MIN0(IABS(NDIM),3))
C
          NBPPT  = 0
          CALL MN_HNW(IDA,IDB,NDIM,NWRD,NH,NPTRH,NPTRD,NWH,NBPPT,NTMODE)
          IF(NH.LE.0) GOTO 9000
C
C         CLEAR THE DATA ARRAY
C
          CALL VZERO_r(RDAT(NPTRD),NWRD)
C
          NWTOT = NWH + NWRD
          CALL M_RTIM(NHDATE,NHTIME)
          CALL MN_HDU(RDAT(NPTRH),NWTOT,NWH,NWRD,IDA,IDB,NDIM,NWPPT,NPNT
     1     ,NHDATE,NHTIME,NSDATE,NSTIME,NTMODE
     +     ,EDENT,EDLO,EDHI,IDBIN,ADLO,ADHI,NBPPT,ACONT)
          if(ndim.ge.-1) then
              CALL MN_PTU(NH,NWTOT,IDA,IDB,NPTRH,NPTRD,TITLE(1:NCHTIT)
     1         ,'Generated internally',' ',TNDEF)
          else
              CALL MN_PTU(NH,NWTOT,IDA,IDB,NPTRH,NPTRD,TITLE(1:NCHTIT)
     1         ,'Generated internally',' ',TNNTP)
          endif
          CALL MN_MSU(IDA,IDB,NDIM,NWH,NH)
C
C     FILL A NEW PLOT
C
      ELSE IF(COMND2.EQ.'FILL') THEN
          CALL WAITYQ('Give plot number: ')
          CALL MN_HNO(IDA,IDB,IDELIM,NNID)
          IF(IDA.LE.0) GOTO 9000
C
          CALL MN_HGT(IDA,IDB,NH)
C     +     ,NPTRH,NPTRD,NDIM,NWPPT,NPNT
C     1     ,EDENT,EDLO,EDHI,IDBIN,ADLO,ADHI,NBPPT)
          IF(NH.LE.0) THEN
              WRITE(TXTERR,'(''Plot'',I7,I4
     1         ,'' does not exist'')') IDA,IDB
              CALL MN_ERR('MN_HIS',TXTERR)
              GOTO 9000
          ENDIF
C
          CALL AMNOFF(NDIM,NWPPT,NOFF,NOFFL,NOFFH,QERRL,QERRH)
          NLOOP = 1
          IF(NDIM.LT.0 .AND. QERRL) NLOOP = NLOOP + 1
          IF(NDIM.LT.0 .AND. QERRH) NLOOP = NLOOP + 1
          IF(NDIM.GT.0) THEN
              NWW = IABS(NDIM) + 1
          ELSE
              NWW = NWPPT / NLOOP
          ENDIF
C
          CALL VZERO_r(ADAT(1),MDIMMX)
          CALL VZERO_r(AERN(1),MDIMMX)
          CALL VZERO_r(AERP(1),MDIMMX)
          NDIMO = NDIM
C
          DO 7600 NL=1,NLOOP
              NNUM = 0
7500          CONTINUE
              IF(NL.EQ.1) THEN
                  CALL WAITYQ('Give data: ')
              ELSE IF(NL.EQ.2 .AND. .NOT.QERRH) THEN
                  CALL WAITYQ('Give errors: ')
              ELSE IF(NL.EQ.2 .AND. QERRH) THEN
                  CALL WAITYQ('Give negative errors: ')
              ELSE IF(NL.EQ.3) THEN
                  CALL WAITYQ('Give positive errors: ')
              ENDIF
              RVAL = VALTYQ(.TRUE.,IDELIM)
              CALL MN_RCK(RVAL,IDELIM,IERR)
              IF(IERR.EQ.2) GOTO 7550
              IF(IERR.NE.0) THEN
                  CALL MN_ERR('MN_HIS','Error in data')
                  GOTO 9000
              ENDIF
              NNUM = NNUM + 1
              IF(NL.EQ.1) THEN
                  RNUM(NNUM) = RVAL
              ELSE
                  RNUM(NNUM) = ABS(RVAL)
              ENDIF
              IF(NNUM.LT.NWW .AND. IDELIM.EQ.0) GOTO 7500
C
7550          CONTINUE
              IF(NL.EQ.1 .AND. NNUM.LT.IABS(NDIMO)) THEN
                  WRITE(TXTERR,'(''Plot'',I7,I4
     1             ,'' has'',I4,'' dimensions,'')') IDA,IDB,IABS(NDIMO)
                  CALL M_EMSG('MN_HIS',TXTERR)
                  WRITE(TXTERR,'(''but you only gave me'',I4
     2             ,'' co-ordinates'')') NNUM
                  CALL MN_ERR('MN_HIS',TXTERR)
                  GOTO 9000
              ENDIF
C
              IF(NL.EQ.1) THEN
                  CALL UCOPY_r(RNUM,ADAT,NNUM)
C
C                 IF WEIGHT IS GIVEN THEN INTERPRET IT OTHERWISE SET IT
C                 TO  1
C
                  IF(NDIMO.GT.0) THEN
                      IF(NNUM.LT.NWW) THEN
                          WEIGHT = 1.0
                      ELSE
                          WEIGHT = RNUM(NWW)
                      ENDIF
                  ELSE
                      WEIGHT = 1.0
                  ENDIF
              ELSE IF(NL.EQ.2) THEN
                  CALL UCOPY_r(RNUM,AERN,NNUM)
              ELSE IF(NL.EQ.3) THEN
                  CALL UCOPY_r(RNUM,AERP,NNUM)
              ENDIF
7600      CONTINUE
C
          IF(NDIMO.LT.0 .AND. QERRL) THEN
              CALL M_FILF(IDA,IDB,ADAT,AERN,AERP)
          ELSE
              CALL M_FILB(IDA,IDB,ADAT,WEIGHT)
          ENDIF
      ENDIF
C
 9000 CONTINUE
      END
