      SUBROUTINE MN_PSP(NTYPFL,NP,IERR)
C
C     SUBROUTINE TO SAVE THE CURRENT SET OF PARAMETERS BEFORE A FIT DISPLAY
C     NTYPFL = 0 MEANS DRAW THE LATEST PLOT
C     NTYPFL = 1 MEANS DRAW ALL THE PLOTS BEING STORED
C     NTYPFL = 2 MEANS REDRAW
C     NTYPFL = 3 MEANS HARDCOPY
C
      implicit none
*
#include "mnpar.inc"
#include "mnhpj.inc"
#include "mnlun.inc"
*
      integer ntypfl,np,ierr
*
      integer ida,idb,novefl,nodiff,nn,npi,nax
      real szew
C
      IERR = 0
      IDA  = IPLTIA(NP)
      IDB  = IPLTIB(NP)
      NOVEFL = IPLTFL(NP)
C
C     PLOT SYMBOL, CLEAR AND LEGO FLAG
C
      NSYMU    = IPLTSY(NP)
      NHATU    = IPLTHA(NP)
      NPATU    = IPLTPA(NP)
      NCLRU    = IPLTCL(NP)
      NLEGU    = IPLTLG(NP)
C
C     PICTURE MARGIN AND SIZE
C
      SIZEU(1) = SIZES(1)
      SIZEU(2) = SIZES(2)
      AMRGU(1) = AMRGS(1)
      AMRGU(2) = AMRGS(2)
C
C     OVERLAY FIND THE LAST PROPER PLOT AND GET STUFF FROM THERE
C
      IF((IABS(NTYPFL).EQ.0 .OR. IABS(NTYPFL).EQ.1) .AND.
     1   (NOVEFL.EQ.2 .OR. NOVEFL.EQ.3)) THEN
          NODIFF = 0
          DO 1000 NN=NP-1,1,-1
              IF(IPLTFL(NN).EQ.3) NODIFF = NODIFF + 1
              IF(IPLTFL(NN).EQ.1) THEN
                  NPI = NN
                  GOTO 1010
              ENDIF
1000      CONTINUE
          CALL MN_ERR('MN_PSP'
     1     ,' You are trying to overlay before you have made a plot')
          IERR = 1
          GOTO 9000
1010      CONTINUE
C
C         SIZES AND MARGINS
C
          AMRGU(1) = AMRGP(1,NPI)
          AMRGU(2) = AMRGP(2,NPI)
          HSZEU(1) = HSZEP(1,NPI)
          HSZEU(2) = HSZEP(2,NPI)
C
          IF(QWIND) THEN
              IPWNDU(1) = IPWNDP(1,NPI)
              IPWNDU(2) = IPWNDP(2,NPI)
          ENDIF
          WMRGU(1) = WMRGP(1,NPI)
          WMRGU(2) = WMRGP(2,NPI)
          WSZEU(1) = WSZEP(1,NPI)
          WSZEU(2) = WSZEP(2,NPI)
C
C         LEGO PLOT ANGLES
C
          CALL UCOPY_r(ALEGS(1),ALEGU(1),10)
C
C         PLOT LIMITS
C
          IF(NOVEFL.EQ.2) THEN
              CALL UCOPY_r(ALIMP(1,1,NPI),ALIMU(1,1),2*3)
          ELSE
              CALL UCOPY_r(ALIMS(1,1),ALIMU(1,1),2*3)
          ENDIF
C
C         TEXT AND SYMBOL SIZES
C
          CALL UCOPY_r(TSZES(1),TSZEU(1),10)
C
C         DRAW LINE AT X OR Y = 0 AND SYMBOL
C
          QZEROU(1) = QZEROS(1)
          IZEROU(1) = IZEROS(1)
          QZEROU(2) = QZEROS(2)
          IZEROU(2) = IZEROS(2)
C
C         Draw a grid
C
          IGRIDU(1,1) = IGRIDS(1,1)
          IGRIDU(2,1) = IGRIDS(2,1)
          IGRIDU(1,2) = IGRIDS(1,2)
          IGRIDU(2,2) = IGRIDS(2,2)
          IGRIDU(1,3) = IGRIDS(1,3)
          IGRIDU(2,3) = IGRIDS(2,3)
C
C         FRAME ROUND THE PLOT
C
          CALL QCOPY(QFRAMS(1,1),QFRAMU(1,1),10*3)
C
C         TICKS
C
          CALL UCOPY_r(TICKS(1,1),TICKU(1,1),10*3)
          CALL QCOPY(QTICKS(1,1),QTICKU(1,1),10*3)
C
C         SCALE
C
          CALL UCOPY_i(ISMODS(1),ISMODU(1),3)
          CALL UCOPY_r(SCALS(1,1),SCALU(1,1),10*3)
          CALL QCOPY(QSCALS(1,1),QSCALU(1,1),10*3)
C
C         LABELS
C
          CALL UCOPY_r(ALABLS(1,1),ALABLU(1,1),10*3)
          CALL QCOPY(QLABLS(1,1),QLABLU(1,1),10*3)
          CALL UCOPY_i(ILABLS(1),ILABLU(1),3)
          CALL TCOPY(TLABLS(1),TLABLU(1),3)
C
C         TITLE POSITION AND OPTIONS
C
          CALL UCOPY_r(TITLS(1),TITLU(1),10)
          CALL UCOPY_r(TITGS(1),TITGU(1),10)
          CALL QCOPY(QTITLS(1),QTITLU(1),10)
C
C         Colours
C         Override set colours with those given in command line
C
          CALL UCOPY_i(ICOLS(1),ICOLU(1),20)
          ICOLU(7) = IPLTCO(1,NP)
          ICOLU(8) = IPLTCO(2,NP)
          ICOLU(9) = IPLTCO(3,NP)
C
C         Line thicknesses
C
          CALL UCOPY_r(ATHKS(1),ATHKU(1),10)
C
C         Fonts
C
          CALL UCOPY_i(IFNTS(1),IFNTU(1),10)
C
C         Bin scale factor and offset
C
          CALL UCOPY_r(ABINS(1),ABINU(1),10)
C
C         Interface to IGTABL
C
          NIGPARU = NIGPARS
          CALL UCOPY_r(AIGPARS,AIGPARU,MIGPAR)
          TIGOPTU = TIGOPTS
          LIGOPTU = LIGOPTS
C
C         Parameters for special displays - implemented for L3
C
          CALL MN_DSP(NTYPFL,NOVEFL,NP)
C
C         FOR AN OVERLAY
C         TURN OFF LINES AT X OR Y = 0
C         LEAVE ON THE FRAME
C         TURN OFF ALL TICKS
C         TURN OFF THE SCALE
C         TURN OFF THE LABEL
C         TURN OFF THE TITLE
C
          QZEROU(1) = .FALSE.
          QZEROU(2) = .FALSE.
          DO 1100 NAX=1,3
CICB              QFRAMU(1,NAX) = .FALSE.
CICB              QFRAMU(2,NAX) = .FALSE.
              QTICKU(1,NAX) = .FALSE.
              QTICKU(2,NAX) = .FALSE.
              QTICKU(3,NAX) = .FALSE.
              QTICKU(4,NAX) = .FALSE.
              QSCALU(1,NAX) = .FALSE.
              QSCALU(2,NAX) = .FALSE.
              QLABLU(1,NAX) = .FALSE.
              QLABLU(2,NAX) = .FALSE.
1100      CONTINUE
          QTITLU(1) = .FALSE.
C
C         FOR AN OVERLAY ON A DIFFERENT SCALE
C         IF WE ARE DRAWING THE ORIGINAL SCALE ON THE LEFT
C         AND THIS IS THE FIRST PLOT WITH A DIFFERENT SCALE
C         TURN OFF THE TICKS, SCALE AND LABEL ON THE RIGHT FOR THE ORIGINAL PLOT
C         For the new plot use the standard settings, except for the scale and
C         label for which I use the setting for the bottom (left) as the
C         top (right) is off by default.
C         Also set lines at x or y = 0 to standard settings
C
          IF(NOVEFL.EQ.3) THEN
              IF(QFRAMS(2,2) .AND.
     1           (QTICKS(3,2) .OR. QTICKS(4,2)) .AND.
     1           NODIFF.EQ.0) THEN
                  QZEROU(2)    = QZEROS(2)
                  QFRAMU(2,2)  = QFRAMS(2,2)
                  QTICKU(3,2)  = QTICKS(3,2)
                  QTICKU(4,2)  = QTICKS(4,2)
                  QSCALU(2,2)  = QSCALS(1,2)
                  IF(.NOT.QLABLS(3,2)) QLABLU(2,2)  = QLABLS(1,2)
C
                  IF(QTICKU(3,2) .OR. QTICKU(4,2)) THEN
                      QTICKP(3,2,NPI) = .FALSE.
                      QTICKP(4,2,NPI) = .FALSE.
                      QSCALP(2,2,NPI) = .FALSE.
                      QLABLP(2,2,NPI) = .FALSE.
                  ENDIF
              ENDIF
          ENDIF
C
C     NEW PLOT - GET EVERYTHING FROM THE SET VALUES
C
      ELSE IF((IABS(NTYPFL).EQ.0 .OR. IABS(NTYPFL).EQ.1) .AND.
     1        NOVEFL.EQ.1) THEN
C
C         SET NECESSARY FLAGS
C
C         QLIMCP(1,NP) = .TRUE.
C         QLIMCP(2,NP) = .TRUE.
C         QLIMCP(3,NP) = .TRUE.
C
C         SIZES AND MARGINS
C
          AMRGU(1) = AMRGS(1)
          AMRGU(2) = AMRGS(2)
          HSZEU(1) = HSZES(1)
          HSZEU(2) = HSZES(2)
C
C         IF WE ARE WINDOWING INCREASE THE WINDOW NUMBER AND RECALCULATE
C         THE MARGIN AND PLOT SIZE
C         HOWEVER IF THE NOCLEAR FLAG IS SET, THIS IS THE SAME AS
C         AN OVERLAY SO DONT INCREASE WINDOW NUMBER
C
          IF(QWIND) THEN
              IF(NCLRU.EQ.1) THEN
                  IF(IPWNDS(1).LT.IWIND(1)) THEN
                      IPWNDS(1) = IPWNDS(1) + 1
                  ELSEIF(IPWNDS(2).LT.IWIND(2)) THEN
                      IPWNDS(2) = IPWNDS(2) + 1
                      IPWNDS(1) = 1
                  ELSE
                      IPWNDS(1) = 1
                      IPWNDS(2) = 1
                  ENDIF
                  IF(IPWNDS(1).LE.0) IPWNDS(1) = 1
                  IF(IPWNDS(2).LE.0) IPWNDS(2) = 1
              ENDIF
C
              IPWNDU(1) = IPWNDS(1)
              IPWNDU(2) = IPWNDS(2)
C
              DO 2100 NAX=1,2
                  SZEW = (HSZES(NAX) -
     1             FLOAT(IWIND(NAX)-1)*WSPACE(NAX)) / FLOAT(IWIND(NAX))
                  IF(WSZES(NAX).EQ.0.0) WSZES(NAX) = SZEW
                  WSZEU(NAX) = WSZES(NAX)
C
                  IF(WMRGS(NAX).EQ.0.0) THEN
                      IF(NAX.EQ.1) THEN
                          WMRGU(NAX) = FLOAT(IPWNDU(NAX)-1) *
     1                     (WSPACE(NAX) + SZEW)
                      ELSE
                          WMRGU(NAX) = FLOAT(IWIND(NAX)-IPWNDU(NAX)) *
     1                     (WSPACE(NAX) + SZEW)
                      ENDIF
                  ELSE
                      WMRGU(NAX) = WMRGS(NAX)
                  ENDIF
2100          CONTINUE
C
C             IF THIS IS NOT THE FIRST WINDOW
C             AND THIS IS NOT THE FIRST PLOT IN THE BUFFER
C             THEN RESET THE CLEAR FLAG
C
              IF(NP.GT.1 .AND.
     +           (IPWNDU(1).NE.1 .OR. IPWNDU(2).NE.1)) NCLRU = 0
          ELSE
              WMRGU(1) = WMRGS(1)
              WMRGU(2) = WMRGS(2)
              WSZEU(1) = WSZES(1)
              WSZEU(2) = WSZES(2)
          ENDIF
C
C         PLOT LIMITS
C
          CALL UCOPY_r(ALIMS(1,1),ALIMU(1,1),2*3)
C
C         LEGO PLOT ANGLES
C
          CALL UCOPY_r(ALEGS(1),ALEGU(1),10)
C
C         TEXT AND SYMBOL SIZES
C
          CALL UCOPY_r(TSZES(1),TSZEU(1),10)
C
C         Colours
C
          CALL UCOPY_i(ICOLS(1),ICOLU(1),20)
          ICOLU(7) = IPLTCO(1,NP)
          ICOLU(8) = IPLTCO(2,NP)
          ICOLU(9) = IPLTCO(3,NP)
C
C         Line thicknesses
C
          CALL UCOPY_r(ATHKS(1),ATHKU(1),10)
C
C         Fonts
C
          CALL UCOPY_i(IFNTS(1),IFNTU(1),10)
C
C         Bin scale factor and offset
C
          CALL UCOPY_r(ABINS(1),ABINU(1),10)
C
C         Interface to IGTABL
C
          NIGPARU = NIGPARS
          CALL UCOPY_r(AIGPARS,AIGPARU,MIGPAR)
          TIGOPTU = TIGOPTS
          LIGOPTU = LIGOPTS
C
C         DRAW LINE AT X OR Y = 0 AND SYMBOL
C
          QZEROU(1) = QZEROS(1)
          IZEROU(1) = IZEROS(1)
          QZEROU(2) = QZEROS(2)
          IZEROU(2) = IZEROS(2)
C
C         Draw a grid
C
          IGRIDU(1,1) = IGRIDS(1,1)
          IGRIDU(2,1) = IGRIDS(2,1)
          IGRIDU(1,2) = IGRIDS(1,2)
          IGRIDU(2,2) = IGRIDS(2,2)
          IGRIDU(1,3) = IGRIDS(1,3)
          IGRIDU(2,3) = IGRIDS(2,3)
C
C         FRAME ROUND THE PLOT
C
          CALL QCOPY(QFRAMS(1,1),QFRAMU(1,1),10*3)
C
C         TICKS
C
          CALL UCOPY_r(TICKS(1,1),TICKU(1,1),10*3)
          CALL QCOPY(QTICKS(1,1),QTICKU(1,1),10*3)
C
C         SCALE
C
          CALL UCOPY_i(ISMODS(1),ISMODU(1),3)
          CALL UCOPY_r(SCALS(1,1),SCALU(1,1),10*3)
          CALL QCOPY(QSCALS(1,1),QSCALU(1,1),10*3)
C
C         TURN OFF THE SCALE IF THE WINDOW SPACING IS ZERO AND THIS IS
C         NOT A LEGO PLOT
C
          IF(QWIND .AND. (NLEGU.LE.0 .OR. NLEGU.EQ.7)) THEN
              DO 2300 NAX=1,2
                  IF((NAX.EQ.1 .AND. WSPACE(2).EQ.0.0 .AND.
     1                IPWNDU(2).LT.IWIND(2) .AND. IWIND(2).GT.1) .OR.
     2               (NAX.EQ.2 .AND. WSPACE(1).EQ.0.0 .AND.
     2                IPWNDU(1).GT.1)) THEN
                      QSCALU(1,NAX) = .FALSE.
                      QSCALU(2,NAX) = .FALSE.
                  ENDIF
2300          CONTINUE
          ENDIF
C
C         LABELS
C
          CALL UCOPY_r(ALABLS(1,1),ALABLU(1,1),10*3)
          CALL QCOPY(QLABLS(1,1),QLABLU(1,1),10*3)
          CALL UCOPY_i(ILABLS(1),ILABLU(1),3)
          CALL TCOPY(TLABLS(1),TLABLU(1),3)
C
C         TURN OFF LABELS FOR ALL EXCEPT THE FIRST PLOT IF WE
C         ARE PLOTTING ONE LABEL PER PAGE
C
          DO 2400 NAX=1,3
              IF(QLABLS(3,NAX)) THEN
                  IF(NCLRU.NE.1) THEN
                      QLABLU(1,NAX) = .FALSE.
                      QLABLU(2,NAX) = .FALSE.
                  ENDIF
              ENDIF
2400      CONTINUE
C
C         TITLE POSITION AND OPTIONS
C
          CALL UCOPY_r(TITLS(1),TITLU(1),10)
          CALL UCOPY_r(TITGS(1),TITGU(1),10)
          CALL QCOPY(QTITLS(1),QTITLU(1),10)
C
C         Parameters for special displays - implemented for L3
C
          CALL MN_DSP(NTYPFL,NOVEFL,NP)
C
C     REDRAW OR HARDCOPY - GET EVERYTHING FROM THE PLOT VALUES
C
      ELSE IF(IABS(NTYPFL).EQ.2 .OR. IABS(NTYPFL).EQ.3) THEN
C
C         SIZES AND MARGINS
C
          AMRGU(1) = AMRGP(1,NP)
          AMRGU(2) = AMRGP(2,NP)
          HSZEU(1) = HSZEP(1,NP)
          HSZEU(2) = HSZEP(2,NP)
C
          IF(QWIND) THEN
              IPWNDU(1) = IPWNDP(1,NP)
              IPWNDU(2) = IPWNDP(2,NP)
          ENDIF
          WMRGU(1) = WMRGP(1,NP)
          WMRGU(2) = WMRGP(2,NP)
          WSZEU(1) = WSZEP(1,NP)
          WSZEU(2) = WSZEP(2,NP)
C
C         PLOT LIMITS
C
          CALL UCOPY_r(ALIMP(1,1,NP),ALIMU(1,1),2*3)
C
C         LEGO PLOT ANGLES
C
          CALL UCOPY_r(ALEGP(1,NP),ALEGU(1),10)
C
C         TEXT AND SYMBOL SIZES
C
          CALL UCOPY_r(TSZEP(1,NP),TSZEU(1),10)
C
C         COLOURS
C
          CALL UCOPY_i(ICOLP(1,NP),ICOLU(1),20)
C
C         LINE THICKNESSES
C
          CALL UCOPY_r(ATHKP(1,NP),ATHKU(1),10)
C
C         Fonts
C
          CALL UCOPY_i(IFNTP(1,NP),IFNTU(1),10)
C
C         Bin scale factor and offset
C
          CALL UCOPY_r(ABINP(1,NP),ABINU(1),10)
C
C         Interface to IGTABL
C
          NIGPARU = NIGPARP(NP)
          CALL UCOPY_r(AIGPARP(1,NP),AIGPARU,MIGPAR)
          TIGOPTU = TIGOPTP(NP)
          LIGOPTU = LIGOPTP(NP)
C
C         DRAW LINE AT X OR Y = 0 AND SYMBOL
C
          QZEROU(1) = QZEROP(1,NP)
          IZEROU(1) = IZEROP(1,NP)
          QZEROU(2) = QZEROP(2,NP)
          IZEROU(2) = IZEROP(2,NP)
C
C         Draw a grid
C
          IGRIDU(1,1) = IGRIDP(1,1,NP)
          IGRIDU(2,1) = IGRIDP(2,1,NP)
          IGRIDU(1,2) = IGRIDP(1,2,NP)
          IGRIDU(2,2) = IGRIDP(2,2,NP)
          IGRIDU(1,3) = IGRIDP(1,3,NP)
          IGRIDU(2,3) = IGRIDP(2,3,NP)
C
C         FRAME ROUND THE PLOT
C
          CALL QCOPY(QFRAMP(1,1,NP),QFRAMU(1,1),10*3)
C
C         TICKS
C
          CALL UCOPY_r(TICKP(1,1,NP),TICKU(1,1),10*3)
          CALL UCOPY(QTICKP(1,1,NP),QTICKU(1,1),10*3)
C
C         SCALE
C
          CALL UCOPY_i(ISMODP(1,NP),ISMODU(1),3)
          CALL UCOPY_r(SCALP(1,1,NP),SCALU(1,1),10*3)
          CALL QCOPY(QSCALP(1,1,NP),QSCALU(1,1),10*3)
C
C         LABELS
C
          CALL UCOPY_r(ALABLP(1,1,NP),ALABLU(1,1),10*3)
          CALL QCOPY(QLABLP(1,1,NP),QLABLU(1,1),10*3)
          CALL UCOPY_i(ILABLP(1,NP),ILABLU(1),3)
          CALL TCOPY(TLABLP(1,NP),TLABLU(1),3)
C
C         TITLE POSITION AND OPTIONS
C
          CALL UCOPY_r(TITLP(1,NP),TITLU(1),10)
          CALL UCOPY_r(TITGP(1,NP),TITGU(1),10)
          CALL QCOPY(QTITLP(1,NP),QTITLU(1),10)
C
C         Parameters for special displays - implemented for L3
C
          CALL MN_DSP(NTYPFL,NOVEFL,NP)
      ELSE
          WRITE(LUNTTO,'('' MN_PSP: Unknown flags for plot''
     1     ,'' NTYPFL'',I4,''  NOVEFL'',I4)')
     1     NTYPFL,NOVEFL
          IERR = 1
          GOTO 9000
      ENDIF
C
      QLIMCU(1) = QLIMCP(1,NP)
      QLIMCU(2) = QLIMCP(2,NP)
      QLIMCU(3) = QLIMCP(3,NP)
C
9000  CONTINUE
      RETURN
      END
