      subroutine m_slim(idelim,qplot,qzero,nax,nps1,nps2,qprdrw,ierr)
*
*-----------------------------------------------------------------------
*
*     Sets the limits for a plot axis
*
*     Called by MN_SET
*
*-----------------------------------------------------------------------
*
      implicit none
*
#include "mnpar.inc"
#include "mnhpj.inc"
#include "mncmd.inc"
#include "mnlun.inc"
*
      integer idelim,nax,nps1,nps2,ierr
      logical qplot,qzero,qprdrw
*
      character thelp*80,thead*80
      real alo,ahi,rnum(10)
      integer nnum,ioerr,np,ii,jlimn(10)
*
      ierr = 0
*
      if(qplot) then
          if(ipltfl(nps1).eq.2) then
              ierr = 1
              txterr = 'You cannot change the limits' //
     1         ' for an overlayed plot on the same scale'
              call mn_err('M_SLIM',txterr)
              goto 9000
          endif
      endif
*
      thelp = 'SET LIMITS'
      thead = ' '
      call ucopy_i(ilimn,jlimn,10)
*
*     If the axis should be plotted in time mode, let mn_enm know
*
      if(qplot) then
          if(ismodp(nax,nps1).eq.3) then
              jlimn(1) = 6
              jlimn(2) = 6
          elseif(ismodp(nax,nps1).eq.4) then
              jlimn(1) = 7
              jlimn(2) = 7
          endif
      else
          if(ismods(nax).eq.3) then
              jlimn(1) = 6
              jlimn(2) = 6
          elseif(ismods(nax).eq.4) then
              jlimn(1) = 7
              jlimn(2) = 7
          endif
      endif
*
      if(qplot) then
          alo = alimp(1,nax,nps1)
          ahi = alimp(2,nax,nps1)
          call mn_enm(idelim,thelp,thead,10
     1     ,tlimn,jlimn,alimp(1,nax,nps1)
     1     ,nnum,rnum,ierr)
      else
          alo = alims(1,nax)
          ahi = alims(2,nax)
          call mn_enm(idelim,thelp,thead,10
     1     ,tlimn,jlimn,alims(1,nax)
     1     ,nnum,rnum,ierr)
      endif
      if(ierr.ne.0) goto 9000
      do 1000 ii=1,nnum
          if(ii.eq.1) then
              alo = rnum(ii)
          else if(ii.eq.2) then
              ahi = rnum(ii)
          endif
 1000 continue
C
      if(ahi.lt.alo) then
          ierr = 2
          write(txterr,'('' Error in limits.''
     1     ,'' Lower limit ='',F8.2,'' Upper ='',F8.2)',iostat=ioerr)
     2     alo,ahi
          call mn_err('M_SLIM',txterr)
          goto 9000
      endif
C
      if(alo.eq.0.0) alo = alimd(1,nax)
      if(ahi.eq.0.0) ahi = alimd(2,nax)
      if(qplot) then
          do 2000 np=nps1,nps2
              qprdrw = .true.
              if(np.ne.nps1 .and. ipltfl(np).eq.3 .and.
     1         .not.qzero) goto 2000
              qlimcp(nax,np) = .true.
              if(ismodp(nax,np).eq.2 .and.
     1         (alo.le.0.0 .or. ahi.le.0.0)) then
                  txterr = 'Limits cannot be =< 0' //
     1             ' with a log scale'
                  call m_emsg('M_SLIM',txterr)
                  txterr = 'They will be set to 1 and 1000'
                  call m_emsg('M_SLIM',txterr)
                  alimp(1,nax,np) = 1.0
                  alimp(2,nax,np) = 1000.0
              else
                  alimp(1,nax,np) = alo
                  alimp(2,nax,np) = ahi
              endif
 2000     continue
      endif
c
      if(.not.qplot .or. qzero) then
          if(ismods(nax).eq.2 .and.
     1     (alo.le.0.0 .or. ahi.le.0.0)) then
              txterr = 'Limits cannot be =< 0 with a log scale'
              call m_emsg('M_SLIM',txterr)
              txterr = 'They will be set to 1 and 1000'
              call m_emsg('M_SLIM',txterr)
              alims(1,nax) = 1.0
              alims(2,nax) = 1000.0
          else
              alims(1,nax) = alo
              alims(2,nax) = ahi
          endif
      endif
*
 9000 continue
*
      end
