      SUBROUTINE M_TTIM(TXT1,TXT2)
C
C     Gets the date and time into standard Mn_Fit format
C     Mn_Fit format is DD-MMM-YYYY HH:MM
C     This routine is machine independent
C
      CHARACTER*(*) TXT1,TXT2
C
      INTEGER ID, IT, YY, MM, DD, HH, MN, SS
C
      CHARACTER*3 TMNTH(12)
C
      DATA TMNTH/'JAN','FEB','MAR','APR','MAY','JUN'
     +          ,'JUL','AUG','SEP','OCT','NOV','DEC'/
C
      TXT1 = ' '
      TXT2 = ' '
C
      CALL DATIME(ID,IT)

C     ID is a six digit integer of the form yymmdd.  Break it into its parts.
C     Add the century to the year

      CALL M_TPRTy(ID, YY, MM, DD, IER)
      if(yy.lt.80) then
        yy = 2000 + yy
      else
        yy = 1900 + yy
      endif

      IF(IER .NE. 0) GO TO 999

C     IT is a four digit integer of the form hhmm.  Break it into its parts.

      CALL M_TPRTh(IT, HH, MN, SS, IER)

      IF(IER .NE. 0) GO TO 999

      WRITE(TXT1,'(I2,''-'',A,''-'',I4.4)',IOSTAT=IOERR)
     +  DD, TMNTH(MM), YY
      WRITE(TXT2,'(I2.2,'':'',I2.2)',IOSTAT=IOERR)
     +  HH, MN

C
 999  CONTINUE
      END
