      SUBROUTINE MN_LIN(XD,YD,NPT,MMODE,XUNITI,NCOL,THICK)
C------------------------------------------------------------------------------
C     AUTHOR  IAN C. BROCK    2ND AUGUST 1986
C     LAST CHANGED    ICB     12.1.87  PROTECT AGAINST RD=0
C
C     SUBROUTINE TO DRAW VARIOUS SORTS OF LINES USING PLTSUB ROUTINES
C     CHANGED TO MAKE THE CORRECT GKS CALLS AND THEN GKS-PLTSUB
C     INTERFACE IS PROVIDED
C     MODES ALLOWED ARE 1   SOLID LINE
C                       2   DASHED LINE
C                       3   DOTTED LINE
C                       4   DASH DOT LINE
C                       5   HIGZ line type 12
C                       6   HIGZ line type 13
C                       7   HIGZ line type 14
C                       8   HIGZ line type 15
C     UNITS OF LENGTH FOR REPETITION ARE 0.2 INCHES
C
C------------------------------------------------------------------------------
*
      implicit none
*
#include "mngrn.inc"
C
      integer npt,mmode,ncol
      REAL XD(*),YD(*),xuniti,thick
*
      integer nmmax
      PARAMETER (NMMAX=8)
      integer nmode
      real xunit
C
      IF(NPT.LE.1) RETURN
C
C     Check if LPDEV <= 1 then no or null device selected so should not
C     draw the text
C
      IF(LPDEV.LE.1) RETURN
C
C     CHECK THAT THE UNIT SIZE IS REASONABLE - it is in NDC!
C
      xunit = xuniti
      IF(XUNIT.LT.0.001 .OR. XUNIT.GT.1.0) XUNIT = 0.01
C
      IF(MMODE.LE.0 .OR. MMODE.GT.NMMAX) THEN
          RETURN
      ENDIF
      IF(MMODE.LE.4) THEN
          NMODE = MMODE
      ELSEIF(MMODE.LE.8) THEN
          NMODE = MMODE + 7
      ELSE
          NMODE = 1
      ENDIF
C
      call igset('BASL',xunit)
      CALL ISPLCI(NCOL)
      CALL ISLWSC(THICK)
      CALL ISLN(NMODE)
      CALL IPL(NPT,XD,YD)
C
      RETURN
      END
