      SUBROUTINE cleo_GETLUN( ILUN, CRNAME )
C.......................................................................
C.
C. GETLUN - Allocate ILUN or next available LUN
C.
C. Inputs    : ILUN   - Unit number to allocate
C.           : CRNAME - CHARACTER name of calling routine
C. Outputs   : ILUN   - Unchanged if ILUN was allocated, else, set to
C.           :          the value of the first available LUN
C.
C. COMMON    : LUNMCI LUNMCC
C. Calls     : CHKLUN CLTOU  ERRLUN
C. Called    : <USER>
C.
C.......................................................................
C
C------------------------- Argument declarations -----------------------
C
      CHARACTER*(*) CRNAME
      INTEGER ILUN
C
C------------------------- EXTERNAL declarations -----------------------
C
* None
C
C------------------------- SEQUENCE declarations -----------------------
C
C
* LUNMIN - Smallest allowed LUN number
* LUNMAX - Largest  allowed LUN number
* MAXLUN - Length of the    LUN number allocation table
*
      INTEGER    LUNMIN,     LUNMAX
      PARAMETER( LUNMIN = 1, LUNMAX = 99 )
*
      INTEGER    MAXLUN
      PARAMETER( MAXLUN = LUNMAX - LUNMIN + 1 )
*
* LISUSE - Flag for LUN is in use
* LISFRE - Flag for LUN is free
* LISLOK - Flag for LUN is locked
*
      INTEGER    LISUSE,     LISFRE,     LISLOK
      PARAMETER( LISUSE = 1, LISFRE = 0, LISLOK = -1 )
*
* LUSEER - Error, LUN in use
* LRNGER - Error, LUN number out of range
* LTABER - Error, LUN allocation table corrupted
* LFULER - Error, LUN allocation table full
* LLOKER - Error, LUN is already locked
* LFLKER - Error, LUN is locked, cannot be freed
* LINIER - Error, in initialization
* LUALER - Error, found unalloacted unit connected to file
* LNONAM - Warning, Allocator name is blank
* LDIFER - Warning, Allocator and deallocator are different
*
      INTEGER    LUSEER,     LRNGER,     LTABER,     LFULER
      PARAMETER( LUSEER = 1, LRNGER = 2, LTABER = 3, LFULER = 4 )
      INTEGER    LLOKER,     LFLKER,     LINIER,     LUALER
      PARAMETER( LLOKER = 5, LFLKER = 6, LINIER = 7, LUALER = 8 )
      INTEGER    LNONAM,     LDIFER
      PARAMETER( LNONAM = 9, LDIFER =10                         )
*
* LUNTBL - The LUN allocation table
* LUNOWN - The LUN allocation owner table
*
      INTEGER         LUNTBL
      COMMON /LUNMCI/ LUNTBL(LUNMIN:LUNMAX)
      CHARACTER*8     LUNOWN
      COMMON /LUNMCC/ LUNOWN(LUNMIN:LUNMAX)
C
C------------------------- Local    declarations -----------------------
C
      INTEGER I
      LOGICAL LFIRST
C
C------------------------- SAVE     declarations -----------------------
C
      SAVE LFIRST
C
C------------------------- DATA  initializations -----------------------
C
      DATA LFIRST / .TRUE. /
C
C---------------------- Executable code starts here --------------------
C

      IF( LFIRST ) THEN
         LFIRST = .FALSE.
         CALL CLEO_INILUN
      ENDIF
C
C== Check integrity of allocation table
C
      CALL CLEO_CHKLUN( 'GETLUN' )
      IF( ILUN.GE.LUNMIN .AND. ILUN.LE.LUNMAX ) THEN
C
C== If ILUN is in range and free, allocate it
C
         IF( LUNTBL(ILUN).EQ.LISFRE ) THEN
            LUNTBL(ILUN) = LISUSE
            IF( CRNAME.EQ.' ' ) THEN
               CALL CLEO_ERRLUN( 'GETLUN', ILUN, LNONAM, ' ' )
            ENDIF
            LUNOWN(ILUN) = CRNAME
            CALL CLTOU( LUNOWN(ILUN) )
            GOTO 999
         ENDIF
      ENDIF
C
C== Else, look for first free unit and allocate it
C
      DO 10 I = LUNMIN, LUNMAX
         ILUN = I
         IF( LUNTBL(ILUN).EQ.LISFRE ) THEN
            LUNTBL(ILUN) = LISUSE
            IF( CRNAME.EQ.' ' ) THEN
               CALL CLEO_ERRLUN( 'GETLUN', ILUN, LNONAM, ' ' )
            ENDIF
            LUNOWN(ILUN) = CRNAME
            CALL CLTOU( LUNOWN(ILUN) )
            GO TO 999
         ENDIF
   10 CONTINUE
C
C== If we get here, the table is full
C
      CALL CLEO_ERRLUN( 'GETLUN', ILUN, LFULER, ' ' )
      ILUN = -1
C
      RETURN
  999 END
