/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#ifndef _UDM_SEARCH_TOOL_H
#define _UDM_SEARCH_TOOL_H

#define UDM_FAST_PRESORT_DOCS	300

extern void UdmWrdTopSort(UDM_URL_CRD *wrd, size_t nwrd,size_t topcount);
extern void UdmSortSearchWordsByURL(UDM_URL_CRD *wrd,size_t num);
extern void UdmSortSearchWordsByWeight(UDM_URL_CRD *wrd,size_t num);
extern void UdmSortSearchWordsBySite(UDM_URLCRDLIST *L, size_t num);
extern void UdmSortSearchWordsByPattern(UDM_RESULT *Res, UDM_URLCRDLIST *L, size_t num, const char *pattern);

extern void UdmGroupByURL(UDM_AGENT *Agent,UDM_RESULT *Res);
extern void UdmGroupBySite(UDM_AGENT *Agent, UDM_RESULT *Res);

extern int  UdmPrepare(UDM_AGENT *query,UDM_RESULT *res);
extern __C_LINK int __UDMCALL UdmParseQueryString(UDM_AGENT * Agent,UDM_VARLIST * vars,char * query_string);

extern char *UdmHlConvert(UDM_WIDEWORDLIST *L,const char * src, UDM_CHARSET * lcs, UDM_CHARSET * bcs);
extern char *UdmHlConvertExt(UDM_WIDEWORDLIST *L, const char * src,
                             UDM_CHARSET * lcs, UDM_CHARSET * bcs,
                             int hilight_stopwords);
extern int  UdmConvert(UDM_ENV *Conf, UDM_RESULT *Res,UDM_CHARSET *lcs,UDM_CHARSET *bcs);
extern char* UdmRemoveHiLightDup(const char *s);

extern int UdmCatToTextBuf(UDM_CATEGORY *C, char *textbuf, size_t len);
extern int UdmCatFromTextBuf(UDM_CATEGORY *C, char *textbuf);

int   *UdmUniSegment(UDM_AGENT *Indexer, int *s, const char *lang);

int UdmResWordInfo(UDM_ENV *Env, UDM_RESULT *Res);

#endif
