#ifndef SDLCALLS_H
#define SDLCALLS_H

#include <SDL.h>
#include <SDL_rotozoom.h>


//----------------------------------------------------------------------------
#define ZAP_SURFACE(s) \
    SDL_CALLS::FreeSurface(s); \
    s = NULL


//----------------------------------------------------------------------------
/**
 * This namespace contains wrappers to most needed SDL calls.
 * Each wrapper will call the related SDL function
 * and will check the return code for errors.
 * If an error occured, an SDLException will be thrown.
 * This way, the application never needs to check return codes.
 */
namespace SDL_CALLS
{
    //------------------------------------------------------------------------
    void Init(Uint32 flags);

    //------------------------------------------------------------------------
    void BlitSurface(const SDL_Surface *src, const SDL_Rect *srcrect,
                     SDL_Surface *dst, const SDL_Rect *dstrect);

    //------------------------------------------------------------------------
    SDL_Surface *ConvertSurface(const SDL_Surface *src,
                                const SDL_PixelFormat *fmt,
                                Uint32 flags);

    //------------------------------------------------------------------------
    SDL_Surface *CreateRGBSurface(
        Uint32 flags, int width, int height, int depth,
        Uint32 Rmask=0, Uint32 Gmask=0, Uint32 Bmask=0, Uint32 Amask=0);

    //------------------------------------------------------------------------
    SDL_Surface *CreateRGBSurfaceFrom(
        void *pixels, int width, int height, int depth, int pitch,
        Uint32 Rmask=0, Uint32 Gmask=0, Uint32 Bmask=0, Uint32 Amask=0);

    //------------------------------------------------------------------------
    void UpdateRect(Sint32 x, Sint32 y, Sint32 w, Sint32 h);

    //------------------------------------------------------------------------
    void UpdateRects(int numrects, const SDL_Rect *rects);

    //------------------------------------------------------------------------
    void Flip();

    //------------------------------------------------------------------------
    void FreeSurface(SDL_Surface *surface);

    //------------------------------------------------------------------------
    void SetColorKey(SDL_Surface *surface, Uint32 flag, Uint32 key);

    //------------------------------------------------------------------------
    void SetPalette(SDL_Surface *surface, int flags,
                    SDL_Color *colors, int firstcolor, int ncolors);

    //------------------------------------------------------------------------
    SDL_Surface *LoadBMP(const char *file);

    //------------------------------------------------------------------------
    void SetAlpha(SDL_Surface *surface, Uint32 flag, Uint8 alpha);

    //------------------------------------------------------------------------
    SDL_Surface *SetVideoMode(int width, int height, int bpp, Uint32 flags);

    //------------------------------------------------------------------------
    void FillRect(SDL_Surface *surface, const SDL_Rect *rect, Uint32 color);


    //------------------------------------------------------------------------
    SDL_Surface *rotozoomSurface(const SDL_Surface *src, double angle,
                                 double zoom, int smooth);
    
    //------------------------------------------------------------------------
    void PushEvent(const SDL_Event &event);
}

#endif //SDLCALLS_H
