#ifndef GAMERECORDER_H
#define GAMERECORDER_H

#include <vector>

#include "Tools.h"
#include "File.h"
#include "ObjectVisitors.h"
#include "PDUs.h"


//----------------------------------------------------------------------------
class GameRecorder
{
    SINGLETON_OBJECT(GameRecorder);

    //------------------------------------------------------------------------
    typedef std::map<Uint16, PDUBase*> PDUs;
    typedef std::map<Uint16, ObjectPDUBase*> ObjectPDUs;

  public:
    //------------------------------------------------------------------------
    class PreparePDUsConstVisitor : public ObjectConstVisitor
    {
      public:
        //--------------------------------------------------------------------
        PreparePDUsConstVisitor(GameRecorder *recorder)
            : m_recorder(recorder) {}
        ~PreparePDUsConstVisitor() { m_recorder = NULL; }

      private:
        //--------------------------------------------------------------------
        void do_visit(const Barrier *b);
        void do_visit(const BlackHole *b);
        void do_visit(const Crate *c);
        void do_visit(const Grenade *g);
        void do_visit(const Grinder *g);
        void do_visit(const MagnetBase *m);
        void do_visit(const Missile *m);
        void do_visit(const MortarBase *m);
        //void do_visit(const ParticleBase *p);
        void do_visit(const ParticleFountainBase *f);
        void do_visit(const Platform *p);
        void do_visit(const ProjectileBase *p);
        void do_visit(const SAMBatteryBase *s);
        void do_visit(const Ship *s);
        void do_visit(const SwitchBase *s);
        void do_visit(const Tank *t);
        void do_visit(const Thorn *t);
        void do_visit(const TurretBase *t);

        //--------------------------------------------------------------------
        GameRecorder *m_recorder;
    };


    //------------------------------------------------------------------------
    class AppendToBufferConstVisitor : public PDUConstVisitor
    {
      protected:
        //--------------------------------------------------------------------
        AppendToBufferConstVisitor(std::vector<char> &buffer)
            : m_buffer(buffer) {}

      public:
        //--------------------------------------------------------------------
        virtual ~AppendToBufferConstVisitor() {}

      protected:
        //--------------------------------------------------------------------
        void appendUint8(const Uint8 value);
        void appendUint16(const Uint16 value);
        void appendUint32(const Uint32 value);

        //--------------------------------------------------------------------
        std::vector<char> &m_buffer;
    };

    //------------------------------------------------------------------------
    class AppendCreatePDUToBufferConstVisitor : public AppendToBufferConstVisitor
    {
      public:
        //--------------------------------------------------------------------
        AppendCreatePDUToBufferConstVisitor(std::vector<char> &buffer)
            : AppendToBufferConstVisitor(buffer) {}
        ~AppendCreatePDUToBufferConstVisitor() {}

      private:
        //--------------------------------------------------------------------
        void do_visit(const BarrierPDU *pdu);
        void do_visit(const BlackHolePDU *pdu);
        void do_visit(const CratePDU *pdu);
        void do_visit(const GrenadePDU *pdu);
        void do_visit(const GrinderPDU *pdu);
        void do_visit(const MagnetBasePDU *pdu);
        void do_visit(const MissilePDU *pdu);
        void do_visit(const MortarBasePDU *pdu);
        void do_visit(const ParticleFountainBasePDU *pdu);
        void do_visit(const PlatformPDU *pdu);
        void do_visit(const ProjectileBasePDU *pdu);
        void do_visit(const SAMBatteryBasePDU *pdu);
        void do_visit(const ShipPDU *pdu);
        void do_visit(const SwitchBasePDU *pdu);
        void do_visit(const TankPDU *pdu);
        void do_visit(const ThornPDU *pdu);
        void do_visit(const TurretBasePDU *pdu);

        //--------------------------------------------------------------------
        void do_visit(const HeaderPDU *pdu);
        void do_visit(const DeleteObjectPDU *pdu);

        //--------------------------------------------------------------------
        void do_objectPDUBase(const ObjectPDUBase *pdu);
        void do_staticDecorationObjectPDUBase(const StaticDecorationObjectPDUBase *pdu);
    };

    //------------------------------------------------------------------------
    class AppendUpdatePDUToBufferConstVisitor : public AppendToBufferConstVisitor
    {
      public:
        //--------------------------------------------------------------------
        AppendUpdatePDUToBufferConstVisitor(std::vector<char> &buffer)
            : AppendToBufferConstVisitor(buffer) {}
        ~AppendUpdatePDUToBufferConstVisitor() {}

      private:
        //--------------------------------------------------------------------
        void do_visit(const BarrierPDU *pdu);
        void do_visit(const BlackHolePDU *pdu);
        void do_visit(const CratePDU *pdu);
        void do_visit(const GrenadePDU *pdu);
        void do_visit(const GrinderPDU *pdu);
        void do_visit(const MagnetBasePDU *pdu);
        void do_visit(const MissilePDU *pdu);
        void do_visit(const MortarBasePDU *pdu);
        void do_visit(const ParticleFountainBasePDU *pdu);
        void do_visit(const PlatformPDU *pdu);
        void do_visit(const ProjectileBasePDU *pdu);
        void do_visit(const SAMBatteryBasePDU *pdu);
        void do_visit(const ShipPDU *pdu);
        void do_visit(const SwitchBasePDU *pdu);
        void do_visit(const TankPDU *pdu);
        void do_visit(const ThornPDU *pdu);
        void do_visit(const TurretBasePDU *pdu);

        //--------------------------------------------------------------------
        void do_visit(const HeaderPDU *pdu);
        void do_visit(const DeleteObjectPDU *pdu);
    };


    //------------------------------------------------------------------------
    GameRecorder();
    ~GameRecorder();

    //------------------------------------------------------------------------
    void writeFrame();

  private:
    //------------------------------------------------------------------------
    void convertCreatePDUs2UpdatePDUs();
    void processObjects();
    void convertNotVisitedUpdatePDUs2DeletePDUs();
    void encodePDUs(std::vector<char> &buffer);

    //------------------------------------------------------------------------
    File *m_file;

    //------------------------------------------------------------------------
    ObjectPDUs m_createPDUs;
    ObjectPDUs m_updatePDUs;
    PDUs m_deletePDUs;
};

#endif //GAMERECORDER_H
