#ifndef SOUND_MIXER_H
#define SOUND_MIXER_H

#include "SDLMixerCalls.h"

//----------------------------------------------------------------------------
class SoundMixer
{
  public:
    //------------------------------------------------------------------------
    static void init();
    static void destroy();

    static inline SoundMixer* getInstance() 
    {
        return sm_instance;
    }

    //------------------------------------------------------------------------
    inline void enableSound()
    {
        m_enableSound = true;
    }

    inline void disableSound()
    {
        m_enableSound = false;
    }

    inline bool isSoundEnabled() const
    {
        return m_enableSound;
    }

    //------------------------------------------------------------------------
    void setSoundVolume(Uint8 percentage);
    inline int getSoundVolume() { return m_soundVolume; }

    void setMusicVolume(Uint8 percentage);
    inline int getMusicVolume() { return m_musicVolume; }

    /**
     * Called from the JukeBox after every Mix_PlayMusic() call
     * to set always the right (current) music volume.
     */
    void setCurrentMusicVolume();

  protected:

    //------------------------------------------------------------------------
    SoundMixer(int rate, Uint16 format, int channels, int buffers);
    ~SoundMixer();

  private:
    //------------------------------------------------------------------------
    bool m_enableSound;

    //------------------------------------------------------------------------
    int m_soundVolume;
    int m_musicVolume;

    //------------------------------------------------------------------------
    static SoundMixer* sm_instance;
};

#endif // SOUND_MIXER_H
