#! /usr/bin/perl -w
# 
# Copyright (C) 2005 Yann Droneaud <ydroneaud@meuh.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#

#
# Encode in base64ufs using perl library
#

use MIME::Base64;

open(FILE, '<', $ARGV[0]) || die ;

binmode(FILE);

my $buffer = join('', <FILE>);

if (!defined $buffer) {
    $buffer = '';
}

$buffer = MIME::Base64::encode($buffer);

# translate base64 MIME in base64 URL and File System
$buffer =~ y,+/,-_,  ;

if ($buffer eq '') {
    $buffer = "\n";
}

print $buffer;

close(FILE);
