#!/bin/sh

# $Id: create_datatype.sh,v 1.2 2001/06/04 22:20:05 jk Exp $

if [ $# = 0 ]; then
	echo "Usage:"
	echo "  $0 <name> [<type>]"
	exit
fi


## getting the vars
name=$1

if (echo "testing\c"; echo 1,2,3) | grep c >/dev/null; then
  # Stardent Vistra SVR4 grep lacks -e, says ghazi@caip.rutgers.edu.
  if (echo -n testing; echo 1,2,3) | sed s/-n/xn/ | grep xn >/dev/null; then
    ac_n= ac_c='
' ac_t='	'
  else
    ac_n=-n ac_c= ac_t=
  fi
else
  ac_n= ac_c='\c' ac_t=
fi

echo $ac_n "Detecting basedir... $ac_c" 
basedir=`pwd | sed "s/src.*//;s/doc.*//;s/po.*//;s/intl.*//"`

if [ ! -e $basedir/modlogan.spec.in ]; then
	echo "Couldn't detect modlogan basedir - aborting"
	exit
fi

echo "$basedir"

workdir="$basedir/src/datatypes"

if [ ! -d $workdir/skeleton ]; then
	echo "skeleton not found - aborting"
	exit
fi

if [ -e $workdir/$name ]; then
	echo "plugin '$name' already exists - aborting"
	exit
fi

echo $ac_n "Creating subdirectory... $ac_c" 
mkdir $workdir/$name
echo "done"

def=`echo $name | sed "y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/"`
bfc=`echo $def | sed 's/^\(.\).*/\1/'`
slc=`echo $name | sed 's/^.\(.*\)/\1/'`
lll="$bfc$slc"



echo $ac_n "Copying skeleton code... ($def, $lll) $ac_c" 
cat $workdir/skeleton/datatype.c | sed "s/SKELETON/$def/;s/skeleton/$name/g;s/Skeleton/$lll/" > $workdir/$name/datatype.c
cat $workdir/skeleton/datatype.h | sed "s/SKELETON/$def/;s/Skeleton/$lll/"                   > $workdir/$name/datatype.h
echo "done"

echo $ac_n "Preparing infrastructure... $ac_c" 
cat $workdir/skeleton/Makefile.am | grep "^#" | sed "s/^#//;s/skeleton/$name/" > $workdir/$name/Makefile.am
cat $workdir/skeleton/.cvsignore | sed "s/skeleton/$name/" > $workdir/$name/.cvsignore
cat $workdir/skeleton/STATUS | sed "s/skeleton/$name/" > $workdir/$name/STATUS
echo "done"

echo $ac_n "Updating $workdir/Makefile.am... $ac_c" 
cp $workdir/Makefile.am $workdir/Makefile.am.orig
cat $workdir/Makefile.am.orig | sed "/SUBDIRS/s/$/ $name/;" > $workdir/Makefile.am
echo "done"

echo $ac_n "Updating $basedir/configure.in... $ac_c" 
cp $basedir/configure.in $basedir/configure.in.orig
cat $basedir/configure.in.orig | sed "/AC_CONFIG_FILES(/,/)/{/src\/datatypes\/Makefile/a\\
	src/datatypes/$name/Makefile 
}" > $basedir/configure.in
echo "done"

echo "--> successfully finished"
