#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>

#include "mlocale.h"
#include "mhash.h"

#include "datatypes/count/datatype.h"

#include "mail.h"
#include "plugin_config.h"
#include "pictures.h"
#include "template.h"
#include "generate.h"

#define M_REPORT_MAIL_SENDER      "mail_sender"
#define M_REPORT_MAIL_RECEIPIENT  "mail_receipient"
#define M_REPORT_MAIL_DOM_IN      "mail_incomming_domains"
#define M_REPORT_MAIL_DOM_OUT     "mail_outgoing_domains"
#define M_REPORT_MAIL_DAILY       "mail_daily"
#define	M_REPORT_MAIL_HOURLY      "mail_hourly"
#define	M_REPORT_MAIL_QUEUE_POLLUTION "mail_qmail_queue_pollution"
#define M_REPORT_MAIL_VIRUS       "mail_virus"
#define	M_REPORT_MAIL_SUBJECT     "mail_subject"
#define	M_REPORT_MAIL_SCANNER     "mail_scanner"

#define HIGHLIGHT	1
#define GROUPING	2
#define VISITS		4
#define INDEX		8
#define BROKEN_LINK	16
#define PERCENT		32
#define RESOLVE_TLD     64
#define VISITS_TRAFFIC  128
#define SORT_BY_KEY     256
#define VIEW_DURATION   512
#define TIME            1024

#define BOTTOM_THRESHOLD	16

int show_mhash_mail (mconfig *ext_conf, tmpl_main *tmpl, mhash *h, int count, int opt) {
	int i;
	config_output *conf = ext_conf->plugin_conf;
	long sum = 0;
	mdata **md;

	if (!h) return 0;
	
	sum = mhash_sumup(h);
	
	if (opt & SORT_BY_KEY) {
		md = mhash_sorted_to_marray(h, M_SORTBY_KEY, M_SORTDIR_ASC);
	} else {
		md = mhash_sorted_to_marray(h, M_SORTBY_COUNT, M_SORTDIR_DESC);
	}

	for (i = 0; md[i] && (i < count); i++) {
		mdata *data = md[i];

		if (data) {
			unsigned int c = 0;
			char buf[255];
			
			if (opt & INDEX) {
				sprintf(buf,"%d", i+1);
				
				tmpl_set_current_block(tmpl, "report_cell");
				tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
				tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
				tmpl_parse_current_block(tmpl);
			}

			c = mdata_get_count(data);

			tmpl_set_current_block(tmpl, "report_cell");
			tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
			if (opt & TIME) {
				/*tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", get_duration_string(c));*/
			} else {
				sprintf(buf,"%d", c);
				tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
			}
			tmpl_parse_current_block(tmpl);
			
			if (opt & PERCENT && sum) {
				tmpl_set_current_block(tmpl, "report_cell");
				tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
				sprintf(buf,"%.2f", c * 100.0 / sum);
				tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
				tmpl_parse_current_block(tmpl);
			}
			
			if (opt & VISITS && data->type == M_DATA_TYPE_VISITED ) {
				tmpl_set_current_block(tmpl, "report_cell");
				tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
				
				/* if the vcount is used as 'traffic' */
				if (opt & VISITS_TRAFFIC) {
					char c = ' ';
					double tr = data->data.visited.vcount;
					if (tr > 1024) {tr /= 1024; c = 'k';}
					if (tr > 1024) {tr /= 1024; c = 'M';}
					if (tr > 1024) {tr /= 1024; c = 'G';}
					sprintf(buf,"%.2f&nbsp;%cB", tr, c);
				} else {
					sprintf(buf,"%d", data->data.visited.vcount);
				}
				tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
				tmpl_parse_current_block(tmpl);
			}
#if 0
			if (opt & VIEW_DURATION && data->type == M_DATA_TYPE_VISITED ) {
				/* use count as duration and vcount as hits per page view */
				
				tmpl_set_current_block(tmpl, "report_cell");
				tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
				sprintf(buf, "%d", data->data.visited.vcount);
				tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
				tmpl_parse_current_block(tmpl);
				
				tmpl_set_current_block(tmpl, "report_cell");
				tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
				tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", data->data.visited.vcount ?
					     get_duration_string(data->data.visited.count / data->data.visited.vcount) :
					     "--");
				tmpl_parse_current_block(tmpl);
			}
#endif
			if ((opt & GROUPING) && mdata_is_grouped(data)) {
				tmpl_set_current_block(tmpl, "report_cell");
				tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "left");
				tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "grouping");
				tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", data->key);
				tmpl_parse_current_block(tmpl);
				
				tmpl_clear_var(tmpl, "TABLE_ROW_CLASS");
			} else {
				if (opt & HIGHLIGHT) {
					tmpl_set_current_block(tmpl, "report_cell");
					tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "left");
					sprintf(buf,"<a href=\"mailto:%s\">%s</a>", 
						data->key, 
						data->key);
					tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
					tmpl_parse_current_block(tmpl);
				} else {
					/* added option to resolve tlds on the fly */
					if (opt & RESOLVE_TLD) {
						tmpl_set_current_block(tmpl, "report_cell");
						tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "left");
						tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", misoname(data->key));
						tmpl_parse_current_block(tmpl);
					} else {
						tmpl_set_current_block(tmpl, "report_cell");
						tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "left");
						tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", data->key);
						tmpl_parse_current_block(tmpl);
					}
				}
			}

			if (opt & BROKEN_LINK && data->type == M_DATA_TYPE_BROKENLINK) {
				struct tm *_tm;
				char timebuf[32] = "";
				
				if (data->data.brokenlink.referrer && 
				    (0 != strcmp(data->data.brokenlink.referrer, "-"))) {
					tmpl_set_current_block(tmpl, "report_cell");
					tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "left");
					tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", "<a href=\"");
					tmpl_append_var(tmpl, "TABLE_ROW_CONTENT", data->data.brokenlink.referrer);
					tmpl_append_var(tmpl, "TABLE_ROW_CONTENT", "\">");
					tmpl_append_var(tmpl, "TABLE_ROW_CONTENT", data->data.brokenlink.referrer);
					tmpl_append_var(tmpl, "TABLE_ROW_CONTENT", "</a>");
					tmpl_parse_current_block(tmpl);
				} else {
					tmpl_set_current_block(tmpl, "report_cell");
					tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "left");
					tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", "-");
					tmpl_parse_current_block(tmpl);
				}

				_tm = localtime(&(data->data.brokenlink.timestamp));
				if (strftime(timebuf, sizeof(timebuf)-1, "%x", _tm) == 0) {
					fprintf(stderr, "output::modlogan.show_mhash: strftime failed\n");
				}
				tmpl_set_current_block(tmpl, "report_cell");
				tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "left");
				tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", timebuf);
				tmpl_parse_current_block(tmpl);
			}

			tmpl_set_current_block(tmpl, "report_row");
			tmpl_parse_current_block(tmpl);
			tmpl_clear_block(tmpl, "report_cell");
		}
	}
	
	free(md);

	return 0;
}

/**
 * data container for the coloums of the tables
 * 
 */

typedef struct {
	const char *name;  /*< visible name of the coloumn */
	const char *class; /*< CSS class, may be NULL */
} fields_def;

/**
 * data container for generic reports 
 * 
 */

typedef struct {
	char *key; /*< type of report */
	mhash *data;       /*< data source (staweb->...) */
	const char *title; /*< visible title of the table */
	int options;       /*< options for show_mhash */
	int show_graph;    /*< for the graph ? (conf->show...) */
	char * (*draw_graph)(mconfig * ext_conf, mstate * state, const char *subpath);
	                   /*< graph function (may be NULL) */
	fields_def fields[5];
	                   /*< coloumns */
} reports_def;

reports_def *get_reports_mail () {
	static reports_def * r_static = NULL;
	reports_def reports[] = {
		/* 0 */
		  /* id             data  title */
		{ M_REPORT_MAIL_SENDER, NULL, "Mails by Sender",
			/* options */
			HIGHLIGHT | GROUPING | INDEX | PERCENT | VISITS | VISITS_TRAFFIC,
				0, /* show graph */
				NULL, /* graph function */
			{ /* fields */
				{ _("Hits"), "hits" },
				{ _("Traffic"), "traffic" },
				{ _("Mail-Address"), NULL },
				{ NULL, NULL },
				{ NULL, NULL }
			}
		},
		/* 1 */
		{ M_REPORT_MAIL_RECEIPIENT, NULL, "Mails by Receipient",
			/* options */
			HIGHLIGHT | GROUPING | INDEX | PERCENT | VISITS | VISITS_TRAFFIC,
				0, /* show graph */
				NULL, /* graph function */
			{ /* fields */
				{ _("Hits"), "hits" },
				{ _("Traffic"), "traffic" },
				{ _("Mail-Address"), NULL },
				{ NULL, NULL },
				{ NULL, NULL }
			}
		},
		
		/* 2 */
		{ M_REPORT_MAIL_DOM_IN, NULL, "Domains - (to)",
			/* options */
			HIGHLIGHT | GROUPING | INDEX | PERCENT | VISITS | VISITS_TRAFFIC,
				0, /* show graph */
				NULL, /* graph function */
			{ /* fields */
				{ _("Hits"), "hits" },
				{ _("Traffic"), "traffic" },
				{ _("Domain"), NULL },
				{ NULL, NULL },
				{ NULL, NULL }
			}
		},
		
		/* 3 */
		{ M_REPORT_MAIL_DOM_OUT, NULL, "Domains - (from)",
			/* options */
			HIGHLIGHT | GROUPING | INDEX | PERCENT | VISITS | VISITS_TRAFFIC,
				0, /* show graph */
				NULL, /* graph function */
			{ /* fields */
				{ _("Hits"), "hits" },
				{ _("Traffic"), "traffic" },
				{ _("Domain"), NULL },
				{ NULL, NULL },
				{ NULL, NULL }
			}
		},
		
		/* 4 */
		{ M_REPORT_MAIL_VIRUS, NULL, "Virus",
			/* options */
			HIGHLIGHT | GROUPING | INDEX | PERCENT,
				0, /* show graph */
				NULL, /* graph function */
			{ /* fields */
				{ _("Hits"), "hits" },
				{ _("Mail-Address"), NULL },
				{ NULL, NULL },
				{ NULL, NULL },
				{ NULL, NULL }
			}
		},
		
		/* 5 */
		{ M_REPORT_MAIL_SUBJECT, NULL, "Subject used by a Virus",
			/* options */
			HIGHLIGHT | GROUPING | INDEX | PERCENT,
				0, /* show graph */
				NULL, /* graph function */
			{ /* fields */
				{ _("Hits"), "hits" },
				{ _("Domain"), NULL },
				{ NULL, NULL },
				{ NULL, NULL },
				{ NULL, NULL }
			}
		},
		
		/* 6 */
		{ M_REPORT_MAIL_SCANNER, NULL, "Virus Scanner",
			/* options */
			HIGHLIGHT | GROUPING | INDEX | PERCENT,
				0, /* show graph */
				NULL, /* graph function */
			{ /* fields */
				{ _("Hits"), "hits" },
				{ _("Domain"), NULL },
				{ NULL, NULL },
				{ NULL, NULL },
				{ NULL, NULL }
			}
		},

		{0, NULL, NULL, 0, 0, NULL,
			{
				{ NULL, NULL },
				{ NULL, NULL },
				{ NULL, NULL },
				{ NULL, NULL },
				{ NULL, NULL }
			}
		}
	};
	
	if (r_static == NULL) {
		r_static = malloc(sizeof(reports));
		memcpy(r_static, reports, sizeof(reports));
	}
	
	return r_static;
}

char * generate_mail_daily(mconfig * ext_conf, mstate * state, const char *current, int max, const char *subpath) {
	int i;
	tmpl_main *tmpl;
	char *s, *ref, buf[255], *fn;
	mstate_mail *stamail = NULL;
	marray_mail sum;
	char c;
	double tr;
	
	if (state == NULL)
		return NULL;
	
	if (state->ext == NULL)
		return NULL;
	
	if (state->ext_type != M_STATE_TYPE_MAIL)
		return NULL;
	
	stamail = state->ext;
	
	sum.incomming_mails = 0;
	sum.outgoing_mails = 0;
	sum.incomming_bytes = 0;
	sum.outgoing_bytes = 0;
	
	tmpl = tmpl_init();
	assert(tmpl);
	
	if ((fn = generate_template_filename(ext_conf, M_TMPL_TABLE)) == NULL) {
		fprintf(stderr, "generating filename failed for '%s'\n", current);
		tmpl_free(tmpl);
		return NULL;
	}
	
	if (tmpl_load_template(tmpl, fn) != 0) {
		free(fn);
		fprintf(stderr, "parsing template failed for '%s'\n", current);
		tmpl_free(tmpl);
		return NULL;
	}
	free(fn);
	
	/* header */
	
	tmpl_set_current_block(tmpl, "header_cell");
	tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", _("Hour"));
	tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
	tmpl_parse_current_block(tmpl);
	
	tmpl_set_current_block(tmpl, "header_cell");
	tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", _("Mail - incomming"));
	tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "hits");
	tmpl_parse_current_block(tmpl);
	
	tmpl_set_current_block(tmpl, "header_cell");
	tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", _("Mail - outgoing"));
	tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "hits");
	tmpl_parse_current_block(tmpl);
	
	tmpl_set_current_block(tmpl, "header_cell");
	tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", _("Traffic - incomming"));
	tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "traffic");
	tmpl_parse_current_block(tmpl);
	
	tmpl_set_current_block(tmpl, "header_cell");
	tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", _("Traffic - outgoing"));
	tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "traffic");
	tmpl_parse_current_block(tmpl);
	
	tmpl_set_current_block(tmpl, "report_row");
	tmpl_parse_current_block(tmpl);
		
	tmpl_clear_block(tmpl, "header_cell");	
	
	for ( i = 0; i < 31; i++) {
		tmpl_set_current_block(tmpl, "report_cell");
		sprintf(buf, "%d", i);
		tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
		tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
		tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
		tmpl_parse_current_block(tmpl);
		
		tmpl_set_current_block(tmpl, "report_cell");
		sprintf(buf, "%ld", stamail->days[i].incomming_mails);
		tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
		tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
		tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
		tmpl_parse_current_block(tmpl);
		
		tmpl_set_current_block(tmpl, "report_cell");
		sprintf(buf, "%ld", stamail->days[i].outgoing_mails);
		tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
		tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
		tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
		tmpl_parse_current_block(tmpl);
		
		tmpl_set_current_block(tmpl, "report_cell");
		c = ' ';
		tr = stamail->days[i].incomming_bytes;
		if (tr > 1024) {tr /= 1024; c = 'k';}
		if (tr > 1024) {tr /= 1024; c = 'M';}
		if (tr > 1024) {tr /= 1024; c = 'G';}
		sprintf(buf,"%.2f&nbsp;%cB", tr, c);
		tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
		tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
		tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
		tmpl_parse_current_block(tmpl);
		
		tmpl_set_current_block(tmpl, "report_cell");
		c = ' ';
		tr = stamail->days[i].outgoing_bytes;
		if (tr > 1024) {tr /= 1024; c = 'k';}
		if (tr > 1024) {tr /= 1024; c = 'M';}
		if (tr > 1024) {tr /= 1024; c = 'G';}
		sprintf(buf,"%.2f&nbsp;%cB", tr, c);
		tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
		tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
		tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
		tmpl_parse_current_block(tmpl);
		
		tmpl_set_current_block(tmpl, "report_row");
		tmpl_parse_current_block(tmpl);
		
		tmpl_clear_block(tmpl, "report_cell");
		
		sum.incomming_mails += stamail->days[i].incomming_mails;
		sum.outgoing_mails += stamail->days[i].outgoing_mails;
		sum.incomming_bytes += stamail->days[i].incomming_bytes;
		sum.outgoing_bytes += stamail->days[i].outgoing_bytes;
	}
	
	sprintf(buf, "%d", 6);
	tmpl_set_var(tmpl, "TABLE_TITLE", _("Mails and Traffic per hour"));
	tmpl_set_var(tmpl, "TABLE_COL_SPAN", buf);
	
	s = tmpl_replace(tmpl);
	
	/* cleanup */
	
	/* - the template */
	tmpl_free(tmpl);
	
	return s;
}

char * generate_mail_hourly(mconfig * ext_conf, mstate * state, const char *current, int max, const char *subpath) {
	int i;
	tmpl_main *tmpl;
	char *s, *ref, buf[255], *fn;
	mstate_mail *stamail = NULL;
	marray_mail sum;
	char c;
	double tr;
	
	if (state == NULL)
		return NULL;
	
	if (state->ext == NULL)
		return NULL;
	
	if (state->ext_type != M_STATE_TYPE_MAIL)
		return NULL;
	
	stamail = state->ext;
	
	sum.incomming_mails = 0;
	sum.outgoing_mails = 0;
	sum.incomming_bytes = 0;
	sum.outgoing_bytes = 0;
	
	tmpl = tmpl_init();
	assert(tmpl);
	
	if ((fn = generate_template_filename(ext_conf, M_TMPL_TABLE)) == NULL) {
		fprintf(stderr, "generating filename failed for '%s'\n", current);
		tmpl_free(tmpl);
		return NULL;
	}
	
	if (tmpl_load_template(tmpl, fn) != 0) {
		free(fn);
		fprintf(stderr, "parsing template failed for '%s'\n", current);
		tmpl_free(tmpl);
		return NULL;
	}
	free(fn);
	
	/* header */
	
	tmpl_set_current_block(tmpl, "header_cell");
	tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", _("Hour"));
	tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
	tmpl_parse_current_block(tmpl);
	
	tmpl_set_current_block(tmpl, "header_cell");
	tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", _("Mail - incomming"));
	tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "hits");
	tmpl_parse_current_block(tmpl);
	
	tmpl_set_current_block(tmpl, "header_cell");
	tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", _("Mail - outgoing"));
	tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "hits");
	tmpl_parse_current_block(tmpl);
	
	tmpl_set_current_block(tmpl, "header_cell");
	tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", _("Traffic - incomming"));
	tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "traffic");
	tmpl_parse_current_block(tmpl);
	
	tmpl_set_current_block(tmpl, "header_cell");
	tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", _("Traffic - outgoing"));
	tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "traffic");
	tmpl_parse_current_block(tmpl);
	
	tmpl_set_current_block(tmpl, "report_row");
	tmpl_parse_current_block(tmpl);
		
	tmpl_clear_block(tmpl, "header_cell");	
	
	for ( i = 0; i < 24; i++) {
		tmpl_set_current_block(tmpl, "report_cell");
		sprintf(buf, "%d", i);
		tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
		tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
		tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
		tmpl_parse_current_block(tmpl);
		
		tmpl_set_current_block(tmpl, "report_cell");
		sprintf(buf, "%ld", stamail->hours[i].incomming_mails);
		tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
		tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
		tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
		tmpl_parse_current_block(tmpl);
		
		tmpl_set_current_block(tmpl, "report_cell");
		sprintf(buf, "%ld", stamail->hours[i].outgoing_mails);
		tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
		tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
		tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
		tmpl_parse_current_block(tmpl);
		
		tmpl_set_current_block(tmpl, "report_cell");
		c = ' ';
		tr = stamail->hours[i].incomming_bytes;
		if (tr > 1024) {tr /= 1024; c = 'k';}
		if (tr > 1024) {tr /= 1024; c = 'M';}
		if (tr > 1024) {tr /= 1024; c = 'G';}
		sprintf(buf,"%.2f&nbsp;%cB", tr, c);
		tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
		tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
		tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
		tmpl_parse_current_block(tmpl);
		
		tmpl_set_current_block(tmpl, "report_cell");
		c = ' ';
		tr = stamail->hours[i].outgoing_bytes;
		if (tr > 1024) {tr /= 1024; c = 'k';}
		if (tr > 1024) {tr /= 1024; c = 'M';}
		if (tr > 1024) {tr /= 1024; c = 'G';}
		sprintf(buf,"%.2f&nbsp;%cB", tr, c);
		tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
		tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
		tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
		tmpl_parse_current_block(tmpl);
		
		tmpl_set_current_block(tmpl, "report_row");
		tmpl_parse_current_block(tmpl);
		
		tmpl_clear_block(tmpl, "report_cell");
		
		sum.incomming_mails += stamail->hours[i].incomming_mails;
		sum.outgoing_mails += stamail->hours[i].outgoing_mails;
		sum.incomming_bytes += stamail->hours[i].incomming_bytes;
		sum.outgoing_bytes += stamail->hours[i].outgoing_bytes;
	}
	
	sprintf(buf, "%d", 6);
	tmpl_set_var(tmpl, "TABLE_TITLE", _("Mails and Traffic per hour"));
	tmpl_set_var(tmpl, "TABLE_COL_SPAN", buf);
	
	s = tmpl_replace(tmpl);
	
	/* cleanup */
	
	/* - the template */
	tmpl_free(tmpl);
	
	return s;
}

char * generate_mail_qmail_queue(mconfig * ext_conf, mstate * state, const char *current, int max, const char *subpath) {
	int i;
	tmpl_main *tmpl;
	char *s, *ref, buf[255], *fn;
	mstate_mail *stamail = NULL;
	
	if (state == NULL)
		return NULL;
	
	if (state->ext == NULL)
		return NULL;
	
	if (state->ext_type != M_STATE_TYPE_MAIL)
		return NULL;
	
	stamail = state->ext;
	
	tmpl = tmpl_init();
	assert(tmpl);
	
	if ((fn = generate_template_filename(ext_conf, M_TMPL_TABLE)) == NULL) {
		fprintf(stderr, "generating filename failed for '%s'\n", current);
		tmpl_free(tmpl);
		return NULL;
	}
	
	if (tmpl_load_template(tmpl, fn) != 0) {
		free(fn);
		fprintf(stderr, "parsing template failed for '%s'\n", current);
		tmpl_free(tmpl);
		return NULL;
	}
	free(fn);
	
	/* header */
	
	tmpl_set_current_block(tmpl, "header_cell");
	tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", _("Day"));
	tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
	tmpl_parse_current_block(tmpl);
	
	tmpl_set_current_block(tmpl, "header_cell");
	tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", _("Hour"));
	tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
	tmpl_parse_current_block(tmpl);
	
	tmpl_set_current_block(tmpl, "header_cell");
	tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", _("Local - cur"));
	tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "hits");
	tmpl_parse_current_block(tmpl);
	
	tmpl_set_current_block(tmpl, "header_cell");
	tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", _("Local - max"));
	tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "hits");
	tmpl_parse_current_block(tmpl);
	
	tmpl_set_current_block(tmpl, "header_cell");
	tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", _("Remote - cur"));
	tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "hits");
	tmpl_parse_current_block(tmpl);
	
	tmpl_set_current_block(tmpl, "header_cell");
	tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", _("Remote - max"));
	tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "hits");
	tmpl_parse_current_block(tmpl);
	
	tmpl_set_current_block(tmpl, "header_cell");
	tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", _("Delivery - cur"));
	tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "hits");
	tmpl_parse_current_block(tmpl);
	
	tmpl_set_current_block(tmpl, "header_cell");
	tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", _("Queue - cur"));
	tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "hits");
	tmpl_parse_current_block(tmpl);
	
	
	tmpl_set_current_block(tmpl, "report_row");
	tmpl_parse_current_block(tmpl);
		
	tmpl_clear_block(tmpl, "header_cell");	
	
	for (i = 0; i < 31; i++) {
		int j;
		for (j = 0; j < 24; j++) {
			if (stamail->qstat[i][j].count) {
				tmpl_set_current_block(tmpl, "report_cell");
				sprintf(buf, "%d", i + 1);
				tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
				tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
				tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
				tmpl_parse_current_block(tmpl);
				
				tmpl_set_current_block(tmpl, "report_cell");
				sprintf(buf, "%d", j);
				tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
				tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
				tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
				tmpl_parse_current_block(tmpl);
		
				tmpl_set_current_block(tmpl, "report_cell");
				sprintf(buf, "%.0f", stamail->qstat[i][j].local_cur / stamail->qstat[i][j].count);
				tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
				tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
				tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
				tmpl_parse_current_block(tmpl);
				
				tmpl_set_current_block(tmpl, "report_cell");
				sprintf(buf, "%.0f", stamail->qstat[i][j].local_max / stamail->qstat[i][j].count);
				tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
				tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
				tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
				tmpl_parse_current_block(tmpl);
				
				tmpl_set_current_block(tmpl, "report_cell");
				sprintf(buf, "%.0f", stamail->qstat[i][j].remote_cur / stamail->qstat[i][j].count);
				tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
				tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
				tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
				tmpl_parse_current_block(tmpl);
				
				tmpl_set_current_block(tmpl, "report_cell");
				sprintf(buf, "%.0f", stamail->qstat[i][j].remote_max / stamail->qstat[i][j].count);
				tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
				tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
				tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
				tmpl_parse_current_block(tmpl);
				
				tmpl_set_current_block(tmpl, "report_cell");
				sprintf(buf, "%.0f", stamail->qstat[i][j].deliver_cur / stamail->qstat[i][j].count);
				tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
				tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
				tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
				tmpl_parse_current_block(tmpl);
				
				tmpl_set_current_block(tmpl, "report_cell");
				sprintf(buf, "%.0f", stamail->qstat[i][j].queue_cur / stamail->qstat[i][j].count);
				tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", buf);
				tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
				tmpl_set_var(tmpl, "TABLE_ROW_ALIGN", "right");
				tmpl_parse_current_block(tmpl);
				
				tmpl_set_current_block(tmpl, "report_row");
				tmpl_parse_current_block(tmpl);
		
				tmpl_clear_block(tmpl, "report_cell");
			}
		}
	}
	
	sprintf(buf, "%d", 8);
	tmpl_set_var(tmpl, "TABLE_TITLE", _("Qmail Queue Pollution"));
	tmpl_set_var(tmpl, "TABLE_COL_SPAN", buf);
	
	s = tmpl_replace(tmpl);
	
	/* cleanup */
	
	/* - the template */
	tmpl_free(tmpl);
	
	return s;
}



int register_reports_mail (tmpl_reports *r) {
	int i, j;
	
	reports_def *reports = get_reports_mail();
	const char *bla[] = { 
		M_REPORT_MAIL_DAILY, 
			M_REPORT_MAIL_HOURLY,
			M_REPORT_MAIL_QUEUE_POLLUTION,
			NULL };
	
	for (i = 0; i < M_TMPL_MAX_REPORTS && r[i].key != NULL; i++);
	
	if (i != M_TMPL_MAX_REPORTS) {
		for (j = 0; reports[j].key && i < M_TMPL_MAX_REPORTS; j++, i++) {
			r[i].key = reports[j].key;
			r[i].func = generate_mail;
			r[i].title = reports[j].title;
		}
	}
	
	if (i < M_TMPL_MAX_REPORTS) {
		r[i].key = bla[0];
		r[i].func = generate_mail_hourly;
		r[i].title = _("Hourly Statistics");
	}
	
	if (++i < M_TMPL_MAX_REPORTS) {
		r[i].key = bla[1];
		r[i].func = generate_mail_daily;
		r[i].title = _("Daily Statistics");
	}
	
	if (++i < M_TMPL_MAX_REPORTS) {
		r[i].key = bla[2];
		r[i].func = generate_mail_qmail_queue;
		r[i].title = _("Qmail Queue Stats");
	}
	
	
	return 0;
}

char * generate_mail(mconfig * ext_conf, mstate * state, const char *current, int max, const char *subpath) {
	config_output *conf = ext_conf->plugin_conf;
	mstate_mail *stamail = NULL;
	int i,j;
	int w = 0;
	char *s = NULL;
	char buf[255];
	tmpl_main *tmpl;
	reports_def *reports;
	char *fn;
	mhash *data;
	
	if (state == NULL) {
		M_DEBUG0(ext_conf->debug_level, M_DEBUG_SECTION_PARSING, M_DEBUG_LEVEL_ERRORS,
			"state = NULL\n");
		return NULL;
	}
	
	if (state->ext == NULL) {
		M_DEBUG3(ext_conf->debug_level, M_DEBUG_SECTION_PARSING, M_DEBUG_LEVEL_ERRORS,
			"state->ext = NULL, (%d, %d, %d)\n", 
			 state->year,
			 state->month,
			 state->ext_type
			 );
		return NULL;
	}
	
	if (state->ext_type != M_STATE_TYPE_MAIL) {
		M_DEBUG0(ext_conf->debug_level, M_DEBUG_SECTION_PARSING, M_DEBUG_LEVEL_ERRORS,
			"state extension != web\n");
		return NULL;
	}

	stamail = state->ext;
	
	reports = get_reports_mail();
	
	for (i = 0; reports[i].key; i++) {
		if (0 == strcmp(reports[i].key, current)) 
			break;
	}
	
	/* unknown report */
	if (reports[i].key == NULL) {
		M_DEBUG1(ext_conf->debug_level, M_DEBUG_SECTION_PARSING, M_DEBUG_LEVEL_ERRORS,
			 "report '%s' no found here\n", current);
		return NULL;
	}
	
	switch(i) {
	case 0: data = stamail->sender; break;
	case 1: data = stamail->receipient; break;
	case 2: data = stamail->recp_domain; break;
	case 3: data = stamail->send_domain; break;
	case 4: data = stamail->virus; break;
	case 5: data = stamail->subject; break;
	case 6: data = stamail->scanner; break;
	default:
		M_DEBUG1(ext_conf->debug_level, M_DEBUG_SECTION_PARSING, M_DEBUG_LEVEL_ERRORS,
			 "report '%s' no found here - what's up ??\n", current);
		return NULL;
	}
	
	tmpl = tmpl_init();
	assert(tmpl);
	
	if ((fn = generate_template_filename(ext_conf, M_TMPL_TABLE)) == NULL) {
		M_DEBUG1(ext_conf->debug_level, M_DEBUG_SECTION_PARSING, M_DEBUG_LEVEL_ERRORS,
			 "generating filename failed for '%s'\n", current);
		tmpl_free(tmpl);
		return NULL;
	}
	
	if (tmpl_load_template(tmpl, fn) != 0) {
		free(fn);
		M_DEBUG1(ext_conf->debug_level, M_DEBUG_SECTION_PARSING, M_DEBUG_LEVEL_ERRORS,
			 "parsing template failed for '%s'\n", current);
		tmpl_free(tmpl);
		return NULL;
	}
	free(fn);
	
	/* only create the report if we have data */
	if (mhash_count(data)) {
		if (reports[i].show_graph && reports[i].draw_graph) {
			char *ref = reports[i].draw_graph(ext_conf, state, subpath);
			
			if (ref && strlen(ref)) {
				tmpl_set_var(tmpl, "IMAGE", ref);
			}
		}
		
		/* calculate the number coloumns */
		for (w = 0; reports[i].fields[w].name != NULL; w++);
		if (reports[i].options & INDEX) w++;
		if (reports[i].options & PERCENT) w++;
		
		if (reports[i].options & INDEX) {
			tmpl_set_current_block(tmpl, "header_cell");
			tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", "#");
			tmpl_parse_current_block(tmpl);
		}
		
		for (j = 0; reports[i].fields[j].name != NULL; j++) {
			tmpl_set_current_block(tmpl, "header_cell");
			
			if (reports[i].fields[j].class) {
				tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", reports[i].fields[j].name);
				tmpl_set_var(tmpl, "TABLE_ROW_CLASS", reports[i].fields[j].class);
			} else {
				tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", reports[i].fields[j].name);
				tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
			}
			tmpl_parse_current_block(tmpl);
			
			if (j == 0 && reports[i].options & PERCENT) {
				tmpl_set_current_block(tmpl, "header_cell");
				tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", "%");
				tmpl_parse_current_block(tmpl);
			}
		}
		
		tmpl_set_current_block(tmpl, "report_row");
		tmpl_parse_current_block(tmpl);
		
		tmpl_clear_block(tmpl, "header_cell");
	
#if 0
		fprintf(stderr, "%s.%d: %d (%s - %d)\n", __FILE__, __LINE__, i, reports[i].title, max);
#endif
		if (show_mhash_mail(ext_conf, tmpl, data, max, reports[i].options)) {
			fprintf(stderr, "show mhash web failed for '%s'\n", current);
		}
		
		tmpl_clear_var(tmpl, "TABLE_ROW_ALIGN");
		if (max > BOTTOM_THRESHOLD) {
			if (reports[i].options & INDEX) {
				tmpl_set_current_block(tmpl, "header_cell");
				tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", "#");
				tmpl_parse_current_block(tmpl);
			}
			
			for (j = 0; reports[i].fields[j].name != NULL; j++) {
				tmpl_set_current_block(tmpl, "header_cell");
				
				if (reports[i].fields[j].class) {
					tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", reports[i].fields[j].name);
					tmpl_set_var(tmpl, "TABLE_ROW_CLASS", reports[i].fields[j].class);
				} else {
					tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", reports[i].fields[j].name);
					tmpl_set_var(tmpl, "TABLE_ROW_CLASS", "none");
				}
				tmpl_parse_current_block(tmpl);
				
				if (j == 0 && reports[i].options & PERCENT) {
					tmpl_set_current_block(tmpl, "header_cell");
					tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", "%");
					tmpl_parse_current_block(tmpl);
				}
			}
			
			tmpl_set_current_block(tmpl, "report_row");
			tmpl_parse_current_block(tmpl);
			tmpl_clear_block(tmpl, "header_cell");
		}
	} else {
		/* generate a dummy page if we have no data to process */
		w = 1;
		
		tmpl_set_current_block(tmpl, "header_cell");
		tmpl_set_var(tmpl, "TABLE_ROW_CONTENT", _("Sorry, no data to display"));
		tmpl_parse_current_block(tmpl);
		
		tmpl_set_current_block(tmpl, "report_row");
		tmpl_parse_current_block(tmpl);
		tmpl_clear_block(tmpl, "header_cell");
	}
	
	
	sprintf(buf, "%d", w);
	tmpl_set_var(tmpl, "TABLE_TITLE", reports[i].title);
	tmpl_set_var(tmpl, "TABLE_COL_SPAN", buf);
	
	s = tmpl_replace(tmpl);
	
	/* cleanup */
	
	/* - the template */
	tmpl_free(tmpl);

#ifdef MTIMER_ENABLED	
	MTIMER_STOP(timer);
	MTIMER_CALC(timer);
	
	fprintf(stderr, "timer %s: %ld msec\n",
		__FUNCTION__, timer.span );
#endif
	return s;
}

void generate_mail_cleanup() {
	free((void *)get_reports_mail());
}
