/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.c,v 1.8 2001/09/08 17:13:01 ostborn Exp $
*/

#include <libintl.h>
#include <locale.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>

#include "mconfig.h"
#include "mstate.h"
#include "mlocale.h"
#include "mhash.h"
#include "mlist.h"
#include "mdatatypes.h"
#include "mplugins.h"

#include "plugin_config.h"

int mplugins_output_tkcontrol_dlinit(mconfig *ext_conf) {
	config_output *conf = NULL;
	
	conf = malloc(sizeof(config_output));
	
	memset(conf, 0, sizeof(config_output));
	
	ext_conf->plugin_conf = conf;
	
	return 0;
}

int mplugins_output_tkcontrol_dlclose(mconfig *ext_conf) {
	config_output *conf = ext_conf->plugin_conf;
	
	if (conf->col_outgoing)	free(conf->col_outgoing);
	if (conf->col_incomming)	free(conf->col_incomming);
	if (conf->col_body)	free(conf->col_body);
	if (conf->col_backgnd)	free(conf->col_backgnd);
	if (conf->col_shadow)	free(conf->col_shadow);
	if (conf->col_calls)	free(conf->col_calls);
	if (conf->col_xfer)	free(conf->col_xfer);
	if (conf->col_grouping)	free(conf->col_grouping);
	if (conf->page_style)	free(conf->page_style);

	free(ext_conf->plugin_conf);
	ext_conf->plugin_conf = NULL;
	
	return 0;
}

int mplugins_output_tkcontrol_parse_config(mconfig *ext_conf, const char *filename, const char *section) {
	config_output *conf = ext_conf->plugin_conf;
	
	const mconfig_values config_values[] = {
	/* color tripples */
		{"background",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_backgnd)},
		{"shadow",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_shadow)},
		{"incomming",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_incomming)},
		{"outgoing",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_outgoing)},
		{"calls",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_calls)},
		{"xfer",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_xfer)},
		{"grouping",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_grouping)},
	/* integer */
		{"maxcallingnumbers", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_calling_numbers)},
		{"maxcallednumbers", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_called_numbers)},
		
	/* strings */	
		{"pagestyle", M_CONFIG_TYPE_STRING,	M_CONFIG_VALUE_OVERWRITE, &(conf->page_style)},
		{"hostname", M_CONFIG_TYPE_STRING,	M_CONFIG_VALUE_OVERWRITE, &(conf->hostname)},
		
		{NULL, M_CONFIG_TYPE_INT, 0, NULL}
	};
	
	return mconfig_parse_section(ext_conf, filename, section, config_values);
}

int mplugins_output_tkcontrol_set_defaults(mconfig *ext_conf) {
	config_output *conf = ext_conf->plugin_conf;
#define LOCALHOST	"localhost"
	
	if (conf->hostname == NULL) {
		conf->hostname = malloc(strlen(LOCALHOST)+1);
		strcpy(conf->hostname, LOCALHOST);
	}

#define LIMIT(x,y) \
	if (x < y) x = y;
	
	LIMIT(conf->max_calling_numbers,0);
	LIMIT(conf->max_called_numbers,0);
#undef LIMIT	

	return 0;
}

int mplugins_init(mplugin *func) {
	func->dlinit = mplugins_output_tkcontrol_dlinit;
	func->dlclose = mplugins_output_tkcontrol_dlclose;
	func->parse_config = mplugins_output_tkcontrol_parse_config;
	func->set_defaults = mplugins_output_tkcontrol_set_defaults;
	func->get_next_record = NULL;
	func->insert_record = NULL;
	func->gen_report = NULL;
        func->gen_history = NULL;
	
	return 0;
}
