/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.c,v 1.12 2001/09/08 17:13:02 ostborn Exp $
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <errno.h>

#include "mlocale.h"
#include "mplugins.h"
#include "mrecord.h"
#include "mdatatypes.h"
#include "misc.h"

#include "plugin_config.h"

int mplugins_processor_telecom_dlinit(mconfig *ext_conf) {
	config_processor *conf = NULL;
	
	conf = malloc(sizeof(config_processor));
	memset(conf, 0, sizeof(config_processor));
	
	conf->sub_processor	= NULL;
	conf->sub_procname	= NULL;

	ext_conf->plugin_conf = conf;
	
	return 0;
}

int mplugins_processor_telecom_dlclose(mconfig *ext_conf) {
	config_processor *conf = ext_conf->plugin_conf;
	
	if (conf->sub_processor) {
		conf->sub_processor->dlclose(ext_conf);
	}
	
	if (conf->sub_procname) free(conf->sub_procname);

	free(ext_conf->plugin_conf);
	ext_conf->plugin_conf = NULL;
	
	return 0;
}

int mplugins_processor_telecom_parse_config(mconfig *ext_conf, const char *filename, const char *section) {
	config_processor *conf = ext_conf->plugin_conf;
	
	const mconfig_values config_values[] = {
		{"subprocessor", M_CONFIG_TYPE_STRING, M_CONFIG_VALUE_OVERWRITE, &(conf->sub_procname)},
		{"price_per_unit", M_CONFIG_TYPE_INT, M_CONFIG_VALUE_OVERWRITE, &(conf->price_per_unit)},
		{NULL, M_CONFIG_TYPE_INT, 0, NULL}
	};
	
	return mconfig_parse_section(ext_conf, filename, section, config_values);
}


int mplugins_processor_telecom_set_defaults(mconfig *ext_conf) {
	config_processor *conf = ext_conf->plugin_conf;
	
	if (conf->sub_processor) {
		conf->sub_processor->set_defaults(ext_conf);
	}
	
	return 0;
}

int mplugins_init(mplugin *func) {
	func->dlinit = mplugins_processor_telecom_dlinit;
	func->dlclose = mplugins_processor_telecom_dlclose;
	func->parse_config = mplugins_processor_telecom_parse_config;
	func->set_defaults = mplugins_processor_telecom_set_defaults;
	func->get_next_record = NULL;
	func->insert_record = NULL;
	func->gen_report = NULL;
        func->gen_history = NULL;
	
	return 0;
}
