/* 
 *   Creation Date: <2003/05/27 15:45:23 samuel>
 *   Time-stamp: <2003/05/27 16:38:38 samuel>
 *   
 *	<alloc.h>
 *	
 *	Memory allocation and mappings
 *   
 *   Copyright (C) 2002, 2003 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   version 2
 *   
 */

#ifndef _H_ALLOC
#define _H_ALLOC

#ifdef __cplusplus
extern "C" {
#endif

//#include <IOKit/IOLib.h>
extern void 	*kmalloc_mol( int size );
extern void 	kfree_mol( void *addr );
extern void 	*vmalloc_mol( int size );
extern void 	vfree_mol( void *p );
extern void 	*kmalloc_cont_mol( int size );
extern void 	kfree_cont_mol( void *addr );
extern ulong 	tophys_mol( void *addr );
extern void 	memory_allocator_cleanup( void );

static inline ulong alloc_page_mol( void ) {
	char *p = (char*)IOMallocAligned( 0x1000, 0x1000 );
	if( p )
		memset( p, 0, 0x1000 );
	return (ulong)p;
}
static inline void free_page_mol( ulong addr ) {
	IOFreeAligned( (void*)addr, 0x1000 );
}
static inline void flush_icache_mol( ulong start, ulong stop ) {
	flush_dcache( (vm_offset_t)start, stop-start, FALSE /* virt addr */ );
	invalidate_icache( (vm_offset_t)start, stop-start, FALSE /* virt addr */);
}
extern void *map_phys_range( ulong paddr, ulong size, char **ret_addr );
extern void unmap_phys_range( void *handle );

static inline unsigned int copy_to_user_mol( void *to, const void *from, ulong len ) {
	return copyout( (void*)from, to, len );
}
static inline unsigned int copy_from_user_mol( void *to, const void *from, ulong len ) {
	return copyin( (void*)from, to, len );
}

static inline unsigned int copy_int_to_user( int *to, int val ) {
	return copy_to_user_mol( to, &val, sizeof(int) );
}
static inline unsigned int copy_int_from_user( int *retint, int *userptr ) {
	return copy_from_user_mol( retint, userptr, sizeof(int) );
}

#ifdef __cplusplus
}
#endif

#endif   /* _H_ALLOC */
