/* mondo-newt.c                   Hugo Rabson                       02/20/2002


02/28
- allow up to 50 chars in popup_and_get_string()'s input field

02/20
- if g_current_progress > g_maximum_progress then g_current_progress=g_max...
  to stop the progress bar from shooting off the RHS of the screen :)

02/15
- beefed up the RAID-related logging a bit

02/11
- don't complain if partition format is a number (1-255)

02/10
- if hard disk does not exist then warn user when editing mountlist
- when running 'eject -t', log its output

01/23
- adding edit_filelist()

01/16
- minor issue in update_evalcall_form() - don't go from 100% to 0%...

01/15
- improved eval_call()'s handling of 0-4%
- improved progress_form()'s handling of 0-1%
- improved ask_me_yes_or_no() and ask_me_OK_or_cancel()'s text-mode interaction
- check that the mountlist's filesystems are supported by kernel; complain
  loudly if they're not :)

01/09
- improved get_isodir_info(), to make it use NFS settings by default if
  they exist
- don't let the user edit mountlist entry unless >0 mountlist entries :)

01/06
- if user changes partition from regular to 'image' then don't multiply size
  by 1024 :) ... just leave as-is

09/01 - 12/31
- fixed bugs in open_progress_form() which prevented text mode from operating
  properly
- if g_text_mode is TRUE then use 'printf' instead of newt/ncurses stuff
- changed &> /dev/null to 2> /dev/null
- only try to unmount CD-ROM if it is mounted
- don't report filesystem type 'image' as weird
- do not let user edit partition's size if it is 'image'
- clean up some cosmetic bugs in the raidlist editor
- removed all '/ /' comments
- disabled the gotoxy()-type thingy in update_progress_form_full
- when user selects RAID level, verify that level is available
- if user changes a partition's device, change it in raidtab too
- popup_and_get_string() is 2 chars wider
- added rudimentary 'get_isodir_info()' for iso_mode
- made 'popup_and_OK()' 10 chars wider & 5 farther to left
- let user edit device_str in edit_mountpoint_entry()
- if user changes device_str then don't let them edit RAID settings until
  they have saved the change to the device_str
- log whatever prompt is sent to popup_and_OK()
- insist_on_this_cd_number() now won't eject CD if ISO_mode is enabled
- functions sorted alphabetically
- minor code clean-up
- used '-Wall' compiler switch to find cruft; removed said cruft
- adding facilities to edit RAID partitions properly
- added plumbing to delete raidlist entry if /dev/md* mountlist entry deleted
- formats 'raid' and 'lvm' are no longer reported as weird, cos they might be
  part of a grander scheme of things (e.g. part of a RAID device)
- when user clicks OK when editing mountlist, ask them if they really want to
  save and continue; don't do either if user says no

08/09
- created
*/

#include "my-stuff.h"
#define NO_FLAWS_DETECTED "No flaws detected in mountlist at this time. Hit 'OK' to proceed."

/* external subroutines and global vars */

extern long get_time(void);
extern char *last_line_of_file(char*);
extern void center_string(char*,int);
extern bool does_file_exist(char*);
extern void finish(int);
extern long get_phys_size_of_drive(char*);
extern bool is_this_device_mounted(char*);
extern void strip_spaces(char*);
extern void initialize_raidrec(struct raid_device_record*);
extern int make_list_of_drives(struct mountlist_itself*,char[ARBITRARY_MAXIMUM][MAX_STR_LEN]);
char *number_to_text(int);
extern void reload_filelist(struct s_node*);
extern int run_program_and_log_output(char*);
extern void toggle_all_root_dirs_on(struct s_node*);
extern void toggle_path_expandability(struct s_node*, char*, bool);
extern void toggle_path_selection(struct s_node*, char*, bool);
extern void toggle_node_selection(struct s_node*, bool);
extern struct s_node *find_node_in_filelist(struct s_node*, char*filename);
extern int what_number_cd_is_this(void);
extern void log_it(char*);
extern void fatal_error(char*);
extern void sort_mountlist_by_device(struct mountlist_itself*);
extern int load_mountlist(struct mountlist_itself*a,char*b);
extern bool g_text_mode;


/* hacks */
extern int load_raidtab_into_raidlist(struct raidlist_itself*a, char*b);



extern long g_start_time, g_minimum_progress, g_maximum_progress, 
  g_current_progress, g_currentY;
extern bool g_ISO_mode;


/* my global variables */

newtComponent g_progressForm, g_blurb1, g_blurb2, g_blurb3, g_label, g_timeline, g_percentline, g_scale;
char err_log_lines[NOOF_ERR_LINES][MAX_STR_LEN], g_blurb_str_1[MAX_STR_LEN]="", g_blurb_str_2[MAX_STR_LEN]="",g_blurb_str_3[MAX_STR_LEN]="";
newtComponent g_isoform_main=NULL, g_isoform_header, g_isoform_scale, g_isoform_timeline, g_isoform_pcline;
long g_isoform_starttime;
int g_isoform_old_progress=-1;
char g_isoform_header_str[MAX_STR_LEN];
int g_mysterious_dot_counter;





/* my subroutines */

void add_disklist_entry(struct list_of_disks *, char*, struct mountlist_itself *);
void add_mountlist_entry(struct mountlist_itself *, struct raidlist_itself *, newtComponent, int, void *keylist[]);
void add_varslist_entry(struct raid_device_record *);
int ask_me_yes_or_no(char*);
int ask_me_OK_or_cancel(char*);
long calculate_raid_device_size(struct mountlist_itself *, struct raidlist_itself *, char *);
void choose_raid_level(struct raid_device_record *);
void close_evalcall_form(void);
void close_progress_form(void);
void del_partns_listed_in_disklist(struct mountlist_itself *, struct raidlist_itself *, struct list_of_disks *);
void delete_disklist_entry(struct list_of_disks *, char *, int);
void delete_mountlist_entry(struct mountlist_itself *, struct raidlist_itself *, newtComponent, int, void *keylist[]);
void delete_raidlist_entry(struct mountlist_itself *, struct raidlist_itself *, char *);
void delete_varslist_entry(struct raid_device_record *, int);
char *disklist_entry_to_string(struct list_of_disks *, int);
int edit_filelist(struct s_node*);
void edit_mountlist_entry(struct mountlist_itself *, struct raidlist_itself *, newtComponent, int, void *keylist[]);
void edit_raidlist_entry(struct mountlist_itself *, struct raidlist_itself *, struct raid_device_record *, int);
void edit_varslist_entry(struct raid_device_record *, int);
int edit_mountlist(struct mountlist_itself *, struct raidlist_itself *);
void edit_raidrec_additional_vars(struct raid_device_record *);
int evaluate_drive_within_mountlist(struct mountlist_itself *, char*, char*);
int evaluate_mountlist(struct mountlist_itself *, char*, char*,char*);
int find_device_in_mountlist(struct mountlist_itself *, char*);
int find_next_free_index_in_disklist(struct list_of_disks *);
int find_raid_device_in_raidlist(struct raidlist_itself *, char *);
bool get_isodir_info(char*,char*,char*);
void initiate_new_raidlist_entry(struct raidlist_itself *, struct mountlist_itself *, int, char*);
void insert_essential_additionalvars(struct raid_device_record *);
void insist_on_this_cd_number(int);
bool is_this_raid_personality_registered(int);
void log_file_end_to_screen(char*,char*);
void log_to_screen(char *);
int look_for_duplicate_mountpoints(struct mountlist_itself *, char*);
int look_for_weird_formats(struct mountlist_itself *, char*);
void make_list_of_unallocated_raid_partitions(struct mountlist_itself *, struct mountlist_itself *, struct raidlist_itself *);
char *mountlist_entry_to_string(struct mountlist_itself *, int);
void mvaddstr_and_log_it(int, int, char *);
void nuke_mode_dummy();
char *number_of_disks_as_string(int,char*);
void open_evalcall_form(char*);
void open_progress_form(char*, char*, char*, char*, long);
void popup_and_OK(char*);
bool popup_and_get_string(char*, char*, char*);
int popup_with_buttons(char*, char *, char*);
void redraw_disklist(struct list_of_disks *, void*keylist[], newtComponent);
void redraw_mountlist(struct mountlist_itself*, void *keylist[], newtComponent);
void redraw_unallocpartnslist(struct mountlist_itself *, void*keylist[], newtComponent);
void redraw_varslist(struct additional_raid_variables *, void*keylist[], newtComponent);
int read_variableINT_and_remove_from_raidvars(struct raid_device_record *, char*);
void refresh_log_screen(void);
void rejig_partition_name_in_raidlist_if_necessary(struct raidlist_itself *, char *, char *);
void remove_essential_additionalvars(struct raid_device_record *);
void select_raid_disks(struct mountlist_itself *, struct raidlist_itself *, struct raid_device_record *, char *, struct list_of_disks *);
void setup_newt_stuff(void);
long size_of_specific_device(struct mountlist_itself *, char*);
bool spread_flaws_across_three_lines(char*,char*,char*,char*, int);
char *turn_raid_level_number_to_string(int);
void update_evalcall_form(int);
void update_progress_form(char *);
void update_progress_form_full(char *, char*, char*);
char which_restore_mode(void);
int which_raid_device_is_using_this_partition(struct raidlist_itself *, char*);
void write_variableINT_to_raid_var_line(struct raid_device_record *, int, char*, int);
int where_in_drivelist_is_drive(struct list_of_disks *, char*);




/* -------------------------------------------------------------------- */





void add_disklist_entry(struct list_of_disks *disklist, char*raid_device, struct mountlist_itself *unallocated_raid_partitions)
{
  char tmp[MAX_STR_LEN];
  newtComponent myForm, bOK, bCancel, b_res, partitionsListbox, headerMsg;
  void* keylist[ARBITRARY_MAXIMUM];
  void*curr_choice;
  int i,index,currline,items;

  newtPushHelpLine("   Add one of the following unallocated RAID partitions to this RAID device.");
  sprintf(tmp,"%-26s %s","Device","Size");
  headerMsg=newtLabel(1,1,tmp);
  partitionsListbox=newtListbox(1,2,6,NEWT_FLAG_SCROLL|NEWT_FLAG_RETURNEXIT);
  redraw_unallocpartnslist(unallocated_raid_partitions,keylist,partitionsListbox);
  i=7;
  bOK  =  newtCompactButton(i,   9,"  OK  ");
  bCancel=newtCompactButton(i+=9,9,"Cancel");
  newtOpenWindow(22,6,36,10,"Unallocated RAID partitions");
  myForm=newtForm(NULL,NULL,0);
  newtFormAddComponents(myForm,headerMsg,partitionsListbox,bOK,bCancel,NULL);
  b_res=newtRunForm(myForm);
  if (b_res != bCancel)
    {
      curr_choice = newtListboxGetCurrent(partitionsListbox);
      for(currline=0; currline<unallocated_raid_partitions->entries && keylist[currline]!=curr_choice; currline++);
      if (currline == unallocated_raid_partitions->entries && unallocated_raid_partitions->entries>0)
	{
	  log_it("I don't know what this button does");
	}
      else
	{
	  index=find_next_free_index_in_disklist(disklist);
	  /*
	    sprintf(sz_out,"%d",index);
	    sprintf(tmp,"What should %s's index be?", unallocated_raid_partitions->el[currline].device);
	    done=popup_and_get_string("Get index",tmp,sz_out);
	    if (done)
	    {
	      index = atoi(sz_out);
	  */
	      items = disklist->entries;
	      strcpy(disklist->el[items].device, unallocated_raid_partitions->el[currline].device);
	      disklist->el[items].index = index;
	      disklist->entries = ++items;
	  /*
	    }
	  */
	}
    }
  newtFormDestroy(myForm);
  newtPopWindow();
  newtPopHelpLine();
}





void add_mountlist_entry(struct mountlist_itself *mountlist, struct raidlist_itself *raidlist, newtComponent listbox, int currline, void *keylist[])
{
  int i, num_to_add;
  newtComponent myForm, bOK, bCancel, b_res, mountpointComp, label0, label1, label2, label3, sizeComp, deviceComp, formatComp;
  char drive_to_add[MAX_STR_LEN], mountpoint_str[MAX_STR_LEN], size_str[MAX_STR_LEN], *mountpoint_here, *size_here, device_str[MAX_STR_LEN], *device_here, format_str[MAX_STR_LEN], *format_here;
  strcpy(device_str,"/dev/");
  strcpy(mountpoint_str,"/");
  strcpy(format_str,"ext2");
  size_str[0]='\0';
  /* sprintf(size_str,""); */
  newtOpenWindow(20,5,40,10,"Add entry");
  label0=newtLabel(2,1,"Device:    ");
  label1=newtLabel(2,2,"Mountpoint:");
  label2=newtLabel(2,3,"Size (MB): ");
  label3=newtLabel(2,4,"Format:    ");
  deviceComp=newtEntry(14,1,device_str,22,&device_here,0);
  mountpointComp=newtEntry(14,2,mountpoint_str,22,&mountpoint_here,0);
  formatComp=newtEntry(14,4,format_str,10,&format_here,0);
  sizeComp=newtEntry(14,3,size_str,8,&size_here,0);
  bOK=newtButton(5,6,"  OK  ");
  bCancel=newtButton(17,6,"Cancel");
  newtPushHelpLine("To add an entry to the mountlist, please fill in these fields and then hit 'OK'");
  myForm=newtForm(NULL,NULL,0);
  newtFormAddComponents(myForm,deviceComp,mountpointComp,sizeComp,formatComp,label0,label1,label2,label3,bOK,bCancel,NULL);
  for(b_res=NULL; b_res!=bOK && b_res!=bCancel;)
    {
      b_res=newtRunForm(myForm);
      strcpy(device_str,device_here);
      strcpy(mountpoint_str,mountpoint_here);
      strcpy(format_str,format_here);
      strcpy(size_str,size_here);
      strip_spaces(device_str);
      strip_spaces(mountpoint_str);
      strip_spaces(format_str);
      strip_spaces(size_str);
      if (b_res == bOK)
	{
	  if (device_str[strlen(device_str)-1]=='/')
	    {
	      popup_and_OK("You left the device nearly blank!");
	      b_res = NULL;
	    }
	  if (size_of_specific_device(mountlist,device_str)>=0)
	    {
	      popup_and_OK("Can't add this - you've got one already!");
	      b_res = NULL;
	    }
	}
    }
  newtFormDestroy(myForm);
  newtPopHelpLine();
  newtPopWindow();
  if (b_res == bCancel) {return;}
  strcpy(drive_to_add,device_str);
  for(i=strlen(drive_to_add); isdigit(drive_to_add[i-1]); i--);
  num_to_add = atoi(drive_to_add+i);
  drive_to_add[i]='\0';
  currline = mountlist->entries;
  strcpy(mountlist->el[currline].device, device_str);
  strcpy(mountlist->el[currline].mountpoint, mountpoint_str);
  strcpy(mountlist->el[currline].format, format_str);
  mountlist->el[currline].size = atol(size_str)*1024;
  mountlist->entries ++;
  if (strstr(mountlist->el[currline].device,"/dev/md"))
    { initiate_new_raidlist_entry(raidlist,mountlist,currline,device_str); }
  redraw_mountlist(mountlist,keylist,listbox);
}




void add_varslist_entry(struct raid_device_record *raidrec)
{
  char sz_out[MAX_STR_LEN];
  int items,i;

  sz_out[0]='\0';
  if (popup_and_get_string("Add variable","Enter the name of the variable to add",sz_out))
    {
      strip_spaces(sz_out);
      items = raidrec->additional_vars.entries;
      for(i=0; i<items && strcmp(raidrec->additional_vars.el[i].label, sz_out); i++);
      if (i<items)
	{
	  popup_and_OK("No need to add that variable. It is already listed here.");
	}
      else
	{
	  strcpy(raidrec->additional_vars.el[items].label, sz_out);
	  edit_varslist_entry(raidrec, items);
	  raidrec->additional_vars.entries = ++items;
	}
    } 
}



int ask_me_yes_or_no(char*prompt)
{
  char tmp[MAX_STR_LEN];
  if (g_text_mode)
    {
      printf("%s\n[yes] [no]\n-->",prompt);
      scanf("%s",tmp);
      if (strstr("yesYES",tmp)) {return(TRUE);}
      else {return(FALSE);}
    }
  else
    {
      return(popup_with_buttons(prompt,"Yes","No"));
    }
}



int ask_me_OK_or_cancel(char*prompt)
{
  char tmp[MAX_STR_LEN];
  if (g_text_mode)
    {
      printf("%s\n[OK] [Cancel]\n-->",prompt);
      scanf("%s",tmp);
      if (strstr("okOKOkYESyes",tmp)) {return(TRUE);}
      else {return(FALSE);}
    }
  else
    {
      return(popup_with_buttons(prompt," Okay ","Cancel"));
    }
}


long calculate_raid_device_size(struct mountlist_itself *mountlist, struct raidlist_itself *raidlist, char *raid_device)
{
  struct raid_device_record *raidrec;
  int i, noof_partitions;
  long total_size, smallest_partition=999999999,sp;
  char tmp[MAX_STR_LEN];
  for(i=0; i<raidlist->entries && strcmp(raidlist->el[i].raid_device, raid_device); i++);
  if (i==raidlist->entries)
    {
      sprintf(tmp,"Cannot calc size of raid device %s - cannot find it in raidlist",raid_device);
      log_it(tmp);
      return(999999999);
    }
  raidrec=&raidlist->el[i];
  noof_partitions=raidrec->data_disks.entries;
  if (raidrec->raid_level == -1 || raidrec->raid_level == 0)
    {
      for(total_size = 0, i = 0; i < noof_partitions; i++)
	{
	  total_size += size_of_specific_device(mountlist,raidrec->data_disks.el[i].device);
	}
    }
  else
    {
      for(i=0; i<noof_partitions;i++)
	{ 
	  sp = size_of_specific_device(mountlist,raidrec->data_disks.el[i].device);
	  if (smallest_partition > sp) { smallest_partition = sp; }
	}
      total_size = smallest_partition * (noof_partitions-1);
    }
  sprintf(tmp,"I have calculated %s's real size to be %ld",raid_device,(long)total_size);
  log_it(tmp);
  return(total_size);
}




void choose_raid_level(struct raid_device_record *raidrec)
{
  int res,out;
  char tmp[MAX_STR_LEN], personalities[MAX_STR_LEN], prompt[MAX_STR_LEN], sz[MAX_STR_LEN];

  system("cat /proc/mdstat | grep Pers > /tmp/raid-personalities.txt 2> /dev/null");
  strcpy(personalities,last_line_of_file("/tmp/raid-personalities.txt"));
  sprintf(prompt,"Please enter the RAID level you want. %s",personalities);
  if (raidrec->raid_level==-1)
    { strcpy(tmp,"linear"); }
  else
    { sprintf(tmp,"%d",raidrec->raid_level); }
  for(out=999;out!=-1 && out!=0 && out!=1 && out!=4 && out!=5 && out!=10;)
    {
      res=popup_and_get_string("Specify RAID level",prompt,tmp);
      if (!res) { return; }
      strip_spaces(tmp);
      if (tmp[0]=='[' && tmp[strlen(tmp)-1]==']')
	{ 
	  strcpy(sz,tmp);
	  strncpy(tmp,sz+1,strlen(sz)-2); 
	  tmp[strlen(sz)-2]='\0';
	}
      if (!strcmp(tmp,"linear"))
	{ out=-1; }
      else if (!strncmp(tmp,"raid",4))
	{ out=atoi(tmp+4); }
      else
	{ out=atoi(tmp); }
      log_it(tmp);
      if (is_this_raid_personality_registered(out))
	{ log_it("Groovy. You've picked a RAID personality which is registered."); }
      else
	{
	  if (ask_me_yes_or_no("You have chosen a RAID personality which is not registered with the kernel. Make another selection?"))
            { out=999; }
	}
    }
  raidrec->raid_level = out;
}




void close_evalcall_form(void)
{
  if (g_isoform_main==NULL) { return; }
  update_evalcall_form(100);
  usleep(500000);
  if (g_text_mode) {log_it("Closing evalcall form");return;}
  newtPopHelpLine();
  newtFormDestroy(g_isoform_main);
  newtPopWindow();
  g_isoform_main=NULL;
  g_isoform_old_progress=-1;
}




void close_progress_form()
{
  if (g_current_progress==-999)
    {
      log_it("Trying to close the progress form when it ain't open!");
      return;
    }
  g_current_progress = g_maximum_progress;
  update_progress_form("Complete");
  sleep(1);
  if (g_text_mode) {log_it("Closing progress form");return;}
  newtPopHelpLine();
  newtFormDestroy(g_progressForm);
  newtPopWindow();
  g_progressForm=NULL;
  g_current_progress=-999;
}








void del_partns_listed_in_disklist(struct mountlist_itself *mountlist, struct raidlist_itself *raidlist, struct list_of_disks *disklist)
{
  int i, pos;
  char tmp[MAX_STR_LEN];
  for(i=0; i < disklist->entries; i++)
    {
      for(pos=0; pos<mountlist->entries && strcmp(mountlist->el[pos].device,disklist->el[i].device); pos++);
      if (pos < mountlist->entries)
	{
	  sprintf(tmp,"Deleting partition %s cos it was part of a now-defunct RAID",mountlist->el[pos].device); 
	  log_it(tmp);
	  memcpy((void*)&mountlist->el[pos], (void*)&mountlist->el[mountlist->entries -1], sizeof(struct mountlist_line));
	  mountlist->entries --;
	}
    }
}




void delete_disklist_entry(struct list_of_disks *disklist, char *raid_device, int currline)
{
  int pos;
  char tmp[MAX_STR_LEN];
  sprintf(tmp,"Delete %s from RAID device %s - are you sure?",disklist->el[currline].device, raid_device);
  if (!ask_me_yes_or_no(tmp)) {return;}
  for(pos=currline; pos < disklist->entries -1; pos++)
    { 
      /* memcpy((void*)&disklist->el[pos], (void*)&disklist->el[pos+1], sizeof(struct s_disk)); */
      strcpy(disklist->el[pos].device, disklist->el[pos+1].device);
    }
  disklist->entries --;
}




void delete_mountlist_entry(struct mountlist_itself *mountlist, struct raidlist_itself *raidlist, newtComponent listbox, int currline, void *keylist[])
{
  int pos;
  char tmp[MAX_STR_LEN], device[MAX_STR_LEN];
  pos=which_raid_device_is_using_this_partition(raidlist, mountlist->el[currline].device);
  if (pos>=0)
    {
      sprintf(tmp,"Cannot delete %s: it is in use by RAID device %s", mountlist->el[currline].device, raidlist->el[pos].raid_device);
      popup_and_OK(tmp);
      return;
    }
  sprintf(tmp,"Delete %s - are you sure?",mountlist->el[currline].device);
  if (!ask_me_yes_or_no(tmp)) { return; }
  if (strstr(mountlist->el[currline].device, "/dev/md"))
    {
      strcpy(device, mountlist->el[currline].device);
      delete_raidlist_entry(mountlist, raidlist, device);
      for(currline=0; currline < mountlist->entries && strcmp(mountlist->el[currline].device,device);currline++);
      if (currline == mountlist->entries)
	{ log_it("Dev is gone. I can't delete it. Ho-hum"); return; }
    }
  memcpy((void*)&mountlist->el[currline], (void*)&mountlist->el[mountlist->entries-1], sizeof(struct mountlist_line));
  mountlist->entries --;
  redraw_mountlist(mountlist,keylist,listbox);
}








void delete_raidlist_entry(struct mountlist_itself *mountlist, struct raidlist_itself *raidlist, char *device)
{
  int i,items;
  bool delete_partitions_too;
  char tmp[MAX_STR_LEN];
  i=find_raid_device_in_raidlist(raidlist,device);
  if (i<0) { return; }
  sprintf(tmp,"Do you want me to delete %s's partitions, too?",device);
  delete_partitions_too=ask_me_yes_or_no(tmp);
  if (delete_partitions_too)
    {
      del_partns_listed_in_disklist(mountlist,raidlist,&raidlist->el[i].data_disks);
      del_partns_listed_in_disklist(mountlist,raidlist,&raidlist->el[i].spare_disks);
      del_partns_listed_in_disklist(mountlist,raidlist,&raidlist->el[i].parity_disks);
      del_partns_listed_in_disklist(mountlist,raidlist,&raidlist->el[i].failed_disks);
    }
  items=raidlist->entries;
  if (items==1)
    {
      items=0;
    }
  else
    {
      log_it(tmp);
      memcpy((void*)&raidlist->el[i], (void*)&raidlist->el[items-1], sizeof(struct raid_device_record));
      items --;
    }
  raidlist->entries = items;
}




void delete_varslist_entry(struct raid_device_record *raidrec, int lino)
{
  char tmp[MAX_STR_LEN];
  struct additional_raid_variables *av;

  av=&raidrec->additional_vars;
  sprintf(tmp,"Delete %s - are you sure?",av->el[lino].label);
  if (ask_me_yes_or_no(tmp))
    {
      if (!strcmp(av->el[lino].label,"persistent-superblock") || !strcmp(av->el[lino].label,"chunk-size"))
	{
	  sprintf(tmp,"%s must not be deleted. It would be bad.",av->el[lino].label);
	  popup_and_OK(tmp);
	}
      else
	{
	  memcpy((void*)&av->el[lino],(void*)&av->el[av->entries--],sizeof(struct raid_var_line));
	}
    }
}






char *disklist_entry_to_string(struct list_of_disks *disklist, int lino)
{
  static char output[MAX_STR_LEN];
  sprintf(output,"%-24s %8d",disklist->el[lino].device, disklist->el[lino].index);
  return(output);
}




bool is_this_a_valid_disk_format(char*format)
{
  char good_formats[MAX_STR_LEN], command[MAX_STR_LEN], format_sz[MAX_STR_LEN];
  FILE*pin;

  sprintf(format_sz,"%s ",format);
  sprintf(command,"cat /proc/filesystems | grep -v nodev | tr -s '\t' ' ' | cut -d' ' -f2 | tr -s '\n' ' '");
  pin=popen(command,"r");
  if (pin)
    { strcpy(good_formats," "); fgets(good_formats+1,MAX_STR_LEN,pin); pclose(pin); }
  else
    { log_to_screen("Unable to read good formats"); return(FALSE); }
  strip_spaces(good_formats);
  strcat(good_formats," swap lvm raid ");
  if (strstr(good_formats,format_sz)) { return(TRUE); } else { return(FALSE); }
}



/* zzz */


char g_strings_of_flist_window[ARBITRARY_MAXIMUM][MAX_STR_LEN];
bool g_is_path_selected[ARBITRARY_MAXIMUM];
bool g_is_path_expanded[ARBITRARY_MAXIMUM];



int redraw_filelist(struct s_node *filelist, void *keylist[ARBITRARY_MAXIMUM], newtComponent listbox)
{
  static int lines_in_flist_window=0;
  static int depth=0;
  struct s_node *node;
  static char current_filename[MAX_STR_LEN];
  char tmp[MAX_STR_LEN+2];
  int i;
/*  void*dummyptr; */
  bool dummybool;
  static bool warned_already;

  if (depth==0)
    {
      lines_in_flist_window=0;
      warned_already=FALSE;
      for(i=0; i<ARBITRARY_MAXIMUM; i++)
      {
        g_strings_of_flist_window[i][0]='\0';
        g_is_path_selected[i]=FALSE;
      }
    }
  for(node=filelist; node!=NULL; node=node->right)
    {
      current_filename[depth] = node->ch;
      if (node->down) {depth++; i=redraw_filelist(node->down, keylist, listbox); depth--; }
      if (node->ch == '\0' && node->expanded)
        {
          if (lines_in_flist_window == ARBITRARY_MAXIMUM)
            {
              if (!warned_already)
                {
                  warned_already = TRUE;
                  sprintf(tmp,"Too many lines. Displaying first %d entries only. Close a directory to see more.", ARBITRARY_MAXIMUM);
                  popup_and_OK(tmp);
                }
            }
          else
            {
              strcpy(g_strings_of_flist_window[lines_in_flist_window], current_filename);
              g_is_path_selected[lines_in_flist_window] = node->selected;
              lines_in_flist_window++;
            }
        }
    }
  if (depth==0)
    {
      if (lines_in_flist_window>ARBITRARY_MAXIMUM) {lines_in_flist_window=ARBITRARY_MAXIMUM;}
/* do an elementary sort */
      for(i=1; i<lines_in_flist_window; i++)
        {
          if (strcmp(g_strings_of_flist_window[i], g_strings_of_flist_window[i-1]) < 0)
            {
              strcpy(tmp, g_strings_of_flist_window[i]);
              strcpy(g_strings_of_flist_window[i], g_strings_of_flist_window[i-1]);
              strcpy(g_strings_of_flist_window[i-1], tmp);
              dummybool=g_is_path_selected[i]; g_is_path_selected[i]=g_is_path_selected[i-1]; g_is_path_selected[i-1]=dummybool;
              i=0;
            }
        }
/* write list to screen */
      newtListboxClear(listbox);
      for(i=0; i<lines_in_flist_window; i++)
        {
          sprintf(tmp,"%c%c %-80s",(g_is_path_selected[i]?'*':' '), (g_is_path_expanded[i]?'+':'-'), g_strings_of_flist_window[i]);
          tmp[70]='\0';
          keylist[i]=(void*)i;
          newtListboxAppendEntry(listbox, tmp, keylist[i]);
        }
      return(lines_in_flist_window);
    }
  else
    { return(0); }
}




int edit_filelist(struct s_node *filelist)
{
  newtComponent myForm, bLess, bMore, bToggle, bOK, bCancel, b_res, filelistListbox, bRegex;
  void*curr_choice;
  int finished=FALSE, lines_in_flist_window=0, indexno, j;
  void *keylist[ARBITRARY_MAXIMUM];
  char tmp[MAX_STR_LEN];
  bool dummybool;
/*  struct s_node *node; */

  log_to_screen("Editing filelist");
  newtPushHelpLine("   Please edit the filelist to your satisfaction, then click OK or Cancel.");
  j=4;
  bLess  = newtCompactButton(j,    17," Less ");
  bMore  = newtCompactButton(j+=12,17," More ");
  bToggle= newtCompactButton(j+=12,17,"Toggle");
  bRegex = newtCompactButton(j+=12,17,"RegEx");
  bCancel= newtCompactButton(j+=12,17,"Cancel");
  bOK    = newtCompactButton(j+=12,17,"  OK  ");
  filelistListbox=newtListbox(2,1,15,NEWT_FLAG_SCROLL|NEWT_FLAG_RETURNEXIT);
  toggle_all_root_dirs_on(filelist);
  lines_in_flist_window = redraw_filelist(filelist,keylist,filelistListbox);
  newtOpenWindow(1,3,77,18,"Editing filelist");
  myForm=newtForm(NULL,NULL,0);
  newtFormAddComponents(myForm,filelistListbox,bLess,bMore,bToggle,bRegex,bCancel,bOK,NULL);
  while(!finished)
    {
      b_res = newtRunForm(myForm);
      if (b_res == bOK)
	{
          finished=ask_me_yes_or_no("Are you happy with your file selection?");
	}
      else if (b_res == bCancel)
	{
	  finished=TRUE;
	}
      else if (b_res == bRegex)
	{
          popup_and_OK("I haven't implemented this yet...");
	}
      else
	{
	  curr_choice = newtListboxGetCurrent(filelistListbox);
          for(indexno=0; indexno<lines_in_flist_window && keylist[indexno]!=curr_choice; indexno++);
          if (indexno==lines_in_flist_window)
            {
              log_it("I don't know what this button does; assuming I am to toggle 1st entry");
              indexno=0;
            }
          sprintf(tmp,"You selected '%s'",g_strings_of_flist_window[indexno]);
          log_it(tmp);
          if (b_res == bMore)
	    {
              g_is_path_expanded[indexno] = TRUE;
              toggle_path_expandability(filelist, g_strings_of_flist_window[indexno], TRUE);
              lines_in_flist_window = redraw_filelist(filelist,keylist,filelistListbox);
              newtListboxSetCurrentByKey(filelistListbox, curr_choice);
	    }
	  else if (b_res == bLess)
	    {
              g_is_path_expanded[indexno] = FALSE;
              toggle_path_expandability(filelist, g_strings_of_flist_window[indexno], FALSE);
              lines_in_flist_window = redraw_filelist(filelist,keylist,filelistListbox);
              newtListboxSetCurrentByKey(filelistListbox, curr_choice);
	    }
          else
	    {
              if (!strcmp(g_strings_of_flist_window[indexno],"/"))
                {
                  dummybool = !g_is_path_selected[indexno];
                  for(j=1; j<lines_in_flist_window; j++) {toggle_path_selection(filelist, g_strings_of_flist_window[j], dummybool);}
                }
              else
                {
                  toggle_path_selection(filelist, g_strings_of_flist_window[indexno], !g_is_path_selected[indexno]);
                  lines_in_flist_window = redraw_filelist(filelist,keylist,filelistListbox);
                }
              newtListboxSetCurrentByKey(filelistListbox, curr_choice);
	    }
          for(indexno=0; indexno<lines_in_flist_window && keylist[indexno]!=curr_choice; indexno++);
          if (indexno==lines_in_flist_window)
            {
              log_it("Layout of table has changed. Y pointer is reverting to zero.");
              indexno=0;
            }
	}
    }
  newtFormDestroy(myForm);
  newtPopWindow();
  newtPopHelpLine();
  if (b_res == bOK) { return(0); }
  else
    {
/*    popup_and_OK("You pushed 'cancel'. I shall now abort."); */
    return(1); 
    }
}



void edit_mountlist_entry(struct mountlist_itself *mountlist, struct raidlist_itself *raidlist, newtComponent listbox, int currline, void *keylist[])
{
  struct raidlist_itself bkp_raidlist;
  newtComponent myForm, bOK, bCancel, b_res, mountpointComp, label0, label1, label2, label3, sizeComp, deviceComp, formatComp, b_raid=NULL;
  char device_str[MAX_STR_LEN], mountpoint_str[MAX_STR_LEN], 
    size_str[MAX_STR_LEN], format_str[MAX_STR_LEN], *device_here,
    *mountpoint_here, *size_here, tmp[MAX_STR_LEN], *format_here,
    device_used_to_be[MAX_STR_LEN],
    mountpt_used_to_be[MAX_STR_LEN];
  int j;
  memcpy((void*)&bkp_raidlist, (void*)raidlist, sizeof(struct raidlist_itself));
  strcpy(device_str,mountlist->el[currline].device);
  strcpy(device_used_to_be,mountlist->el[currline].device);
  strcpy(mountpoint_str,mountlist->el[currline].mountpoint);
  strcpy(mountpt_used_to_be,mountlist->el[currline].mountpoint);
  strcpy(format_str,mountlist->el[currline].format);
  sprintf(size_str,"%ld",mountlist->el[currline].size/1024);
  newtOpenWindow(20,5,40,10,"Edit entry");
  label0=newtLabel(2,1,"Device:");
  label1=newtLabel(2,2,"Mountpoint:");
  label2=newtLabel(2,3,"Size (MB): ");
  label3=newtLabel(2,4,"Format:    ");
  deviceComp=newtEntry(14,1,device_str,22,&device_here,0);
  mountpointComp=newtEntry(14,2,mountpoint_str,22,&mountpoint_here,0);
  formatComp=newtEntry(14,4,format_str,10,&format_here,0);
   if (strstr(mountlist->el[currline].device,"/dev/md") || !strcmp(mountlist->el[currline].mountpoint,"image"))
    { sizeComp=newtLabel(14,3,size_str); }
  else
    { sizeComp=newtEntry(14,3,size_str,8,&size_here,0); } 
  bOK=newtButton(2,6,"  OK  ");
  bCancel=newtButton(14,6,"Cancel");
  if (strstr(mountlist->el[currline].device,"/dev/md"))
    { b_raid=newtButton(26,6,"RAID.."); }
  newtPushHelpLine("       Edit this partition's mountpoint, size and format; then click 'OK'.");
  myForm=newtForm(NULL,NULL,0);
  newtFormAddComponents(myForm,deviceComp,mountpointComp,sizeComp,formatComp,label0,label1,label2,label3,bOK,bCancel,b_raid,NULL);
  for(b_res=NULL; b_res!=bOK && b_res!=bCancel;)
    {
      b_res=newtRunForm(myForm);
      strcpy(device_str, device_here);
      strip_spaces(device_str);
      strcpy(mountpoint_str, mountpoint_here);
      strip_spaces(mountpoint_str);
      strcpy(format_str, format_here);
      strip_spaces(format_str);
      if (b_res==bOK && strstr(device_str,"/dev/md") && strstr(device_used_to_be,"/dev/md") && strcmp(device_str,device_used_to_be))
        { 
          popup_and_OK("You can't change /dev/mdX to /dev/mdY.");
	  b_res=NULL;
          continue;
        }
      else if (b_res==bOK && !strcmp(mountpoint_str,"image") && strcmp(mountpt_used_to_be,"image"))
	{
	  popup_and_OK("You can't change a regular device to an image.");
	  b_res=NULL;
	  continue;
	}
      if (!strstr(mountlist->el[currline].device,"/dev/md") && strcmp(mountlist->el[currline].mountpoint,"image"))
	{
	  strcpy(size_str, size_here); 
	  strip_spaces(size_str); 
	}
      else
	{
	  sprintf(size_str, "%ld", calculate_raid_device_size(mountlist,raidlist,mountlist->el[currline].device)/1024);
	  newtLabelSetText(sizeComp,size_str);
	}
      /* do not let user click RAID button if user has changed device_str */
      if (b_res==b_raid)
        {
          if (strcmp(device_str, mountlist->el[currline].device))
	    {
	      /*
 can't change mountlist's entry from /dex/mdX to /dev/mdY: it would ugly 
 when you try to map the changes over to the raidtab list, trust me
	      */
	      popup_and_OK("You cannot edit the RAID settings until you have OK'd your change to the device node.");
            }
          else
            {
	      j=find_raid_device_in_raidlist(raidlist, mountlist->el[currline].device);
	      if (j<0)
	        {
	          sprintf(tmp,"/etc/raidtab does not have an entry for %s; please delete it and add it again",mountlist->el[currline].device);
                  popup_and_OK(tmp);
	        }
	      else
	        {
	          log_it("edit_raidlist_entry - calling");
	          edit_raidlist_entry(mountlist, raidlist, &raidlist->el[j], currline);
	        }
	    }
	}
    }
  newtFormDestroy(myForm);
  newtPopHelpLine();
  newtPopWindow();
  if (b_res == bCancel)
    {
      memcpy((void*)raidlist, (void*)&bkp_raidlist, sizeof(struct raidlist_itself));
      return;
    }
  strcpy(mountlist->el[currline].device,device_str);
  strcpy(mountlist->el[currline].mountpoint,mountpoint_str);
  strcpy(mountlist->el[currline].format,format_str);
  if (strstr(mountlist->el[currline].device,"/dev/md") || !strcmp(mountlist->el[currline].mountpoint,"image"))
    { mountlist->el[currline].size = calculate_raid_device_size(mountlist,raidlist,mountlist->el[currline].device); }
  else
    { mountlist->el[currline].size = atol(size_str)*1024; }
  newtListboxSetEntry(listbox,(int)keylist[currline],mountlist_entry_to_string(mountlist,currline));
  /* if new /dev/md RAID device then do funky stuff */
  if (strstr(mountlist->el[currline].device,"/dev/md") && !strstr(device_used_to_be,"/dev/md"))
    { initiate_new_raidlist_entry(raidlist,mountlist,currline,device_str); }
  /* if moving from RAID to non-RAID then do funky stuff */
  else if (strstr(device_used_to_be,"/dev/md") && !strstr(device_str,"/dev/md"))
    { delete_raidlist_entry(mountlist, raidlist, device_str); }
  /* if moving a non-RAID to another non-RAID then re-jig any RAID disks, if necessary */
  else if (!strstr(device_used_to_be,"/dev/md") && !strstr(device_str,"/dev/md"))
    { rejig_partition_name_in_raidlist_if_necessary(raidlist, device_used_to_be, device_str); }
/* else, moving a RAID to another RAID; bad idea, or so I thought */
  else if (strcmp(device_used_to_be, device_str))
    {
      popup_and_OK("You are renaming a RAID device as another RAID device. I don't like it but I'll allow it.");
    }
  redraw_mountlist(mountlist,keylist,listbox);
}





void edit_raidlist_entry(struct mountlist_itself *mountlist, struct raidlist_itself *raidlist, struct raid_device_record *raidrec, int currline)
{
  struct raid_device_record bkp_raidrec;
  char title_of_editraidForm_window[MAX_STR_LEN], sz_raid_level[MAX_STR_LEN], sz_data_disks[MAX_STR_LEN], sz_spare_disks[MAX_STR_LEN], sz_parity_disks[MAX_STR_LEN], sz_failed_disks[MAX_STR_LEN];
  newtComponent editraidForm, bOK, bCancel, bAdditional, bChangeRaid, bSelectData, bSelectSpare, bSelectParity, bSelectFailed, b_res;

  log_it("Started edit_raidlist_entry");
  memcpy((void*)&bkp_raidrec,(void*)raidrec,sizeof(struct raid_device_record));
  sprintf(title_of_editraidForm_window,"%s",raidrec->raid_device);
  newtOpenWindow(20,5,40,14,title_of_editraidForm_window);
  for(;;)
    {
      sprintf(title_of_editraidForm_window,"Edit %s",raidrec->raid_device);
      strcpy(sz_raid_level,turn_raid_level_number_to_string(raidrec->raid_level));
      strcpy(sz_data_disks,number_of_disks_as_string(raidrec->data_disks.entries,"data"));
      strcpy(sz_spare_disks,number_of_disks_as_string(raidrec->spare_disks.entries,"spare"));
      strcpy(sz_parity_disks,number_of_disks_as_string(raidrec->parity_disks.entries,"parity"));
      strcpy(sz_failed_disks,number_of_disks_as_string(raidrec->failed_disks.entries,"failed"));
      bSelectData=newtButton(1,1,sz_data_disks);
      bSelectSpare=newtButton(20,1,sz_spare_disks);
      bSelectParity=newtButton(1,5,sz_parity_disks);
      bSelectFailed=newtButton(20,5,sz_failed_disks);
      bChangeRaid=newtButton(1,9,sz_raid_level);
      bOK=newtButton(16+(raidrec->raid_level==-1),9,"  OK  ");
      bCancel=newtButton(28,9,"Cancel");
      bAdditional=newtCompactButton(1,13,"Additional settings and information");
      newtPushHelpLine("  Edit the RAID device's settings to your heart's content, then hit OK/Cancel.");
      editraidForm=newtForm(NULL,NULL,0);
      newtFormAddComponents(editraidForm,bSelectData,bSelectParity,bChangeRaid,bSelectSpare,bSelectFailed,bOK,bCancel,bAdditional);
      b_res=newtRunForm(editraidForm);
      if (b_res==bChangeRaid)
	{ choose_raid_level(raidrec); }
      else if (b_res==bSelectData)
	{ select_raid_disks(mountlist,raidlist,raidrec,"data",&raidrec->data_disks); }
      else if (b_res==bSelectSpare)
	{ select_raid_disks(mountlist,raidlist,raidrec,"spare",&raidrec->spare_disks); }
      else if (b_res==bSelectParity)
	{ select_raid_disks(mountlist,raidlist,raidrec,"parity",&raidrec->parity_disks); }
      else if (b_res==bSelectFailed)
	{ select_raid_disks(mountlist,raidlist,raidrec,"failed",&raidrec->failed_disks); }
      else if (b_res==bAdditional)
	{ edit_raidrec_additional_vars(raidrec); }
      newtFormDestroy(editraidForm);
      if (b_res==bOK || b_res==bCancel) 
	{ break; }
    }
  if (b_res==bCancel)
    {
      memcpy((void*)raidrec, (void*)&bkp_raidrec, sizeof(struct raid_device_record)); 
    }
  newtPopHelpLine();
  newtPopWindow();
  mountlist->el[currline].size = calculate_raid_device_size(mountlist, raidlist, raidrec->raid_device);
}



void edit_varslist_entry(struct raid_device_record *raidrec, int lino)
{
  char header[MAX_STR_LEN], comment[MAX_STR_LEN], sz_out[MAX_STR_LEN];

  strcpy(sz_out, raidrec->additional_vars.el[lino].value);
  sprintf(header,"Edit %s",raidrec->additional_vars.el[lino].label);
  sprintf(comment,"Please set %s's value (currently '%s')",raidrec->additional_vars.el[lino].label, sz_out);
  if (popup_and_get_string(header,comment,sz_out))
    {
      strip_spaces(sz_out);
      strcpy(raidrec->additional_vars.el[lino].value, sz_out);
    }
}


/* I'm not racist against white people. I just don't like people who think Liberia is near Spain.       - Hugo, 09/01/2001 */




int edit_mountlist(struct mountlist_itself *mountlist, struct raidlist_itself *raidlist)
{
  newtComponent myForm, bAdd, bEdit, bDelete, bOK, bCancel, b_res, partitionsListbox, headerMsg, flawsLabelA, flawsLabelB, flawsLabelC, bReload;
  void*curr_choice;
  int i, currline, finished=FALSE;
  void* keylist[ARBITRARY_MAXIMUM];
  char tmp[MAX_STR_LEN], flaws_str_A[MAX_STR_LEN], flaws_str_B[MAX_STR_LEN], flaws_str_C[MAX_STR_LEN];
  strcpy(flaws_str_A,"xxxxxxxxx");
  strcpy(flaws_str_B,"xxxxxxxxx");
  strcpy(flaws_str_C,"xxxxxxxxx");
  if (mountlist->entries > ARBITRARY_MAXIMUM)
    {
      log_to_screen("Arbitrary limits suck, man!"); 
      finish(1); 
    }
  newtPushHelpLine("   Please edit the mountlist to your satisfaction, then click OK or Cancel.");
  i=4;
  bAdd =    newtCompactButton(i,    17," Add ");
  bEdit =   newtCompactButton(i+=11,17," Edit ");
  bDelete = newtCompactButton(i+=12,17,"Delete");
  bReload = newtCompactButton(i+=12,17,"Reload");
  bCancel = newtCompactButton(i+=12,17,"Cancel");
  bOK =     newtCompactButton(i+=12,17,"  OK  ");
  sprintf(tmp,"%-24s %-24s %-8s  %s","Device","Mountpoint","Format","Size (MB)");
  headerMsg=newtLabel(2,1,tmp);
  flawsLabelA=newtLabel(2,13,flaws_str_A);
  flawsLabelB=newtLabel(2,14,flaws_str_B);
  flawsLabelC=newtLabel(2,15,flaws_str_C);
  partitionsListbox=newtListbox(2,2,10,NEWT_FLAG_SCROLL|NEWT_FLAG_RETURNEXIT);
  redraw_mountlist(mountlist,keylist,partitionsListbox);
  newtOpenWindow(1,3,77,18,"Editing mountlist");
  myForm=newtForm(NULL,NULL,0);
  newtFormAddComponents(myForm,headerMsg,partitionsListbox,flawsLabelA,flawsLabelB,flawsLabelC,bAdd,bEdit,bDelete,bReload,bCancel,bOK,NULL);
  while(!finished)
    {
      evaluate_mountlist(mountlist,flaws_str_A,flaws_str_B,flaws_str_C);
      newtLabelSetText(flawsLabelA,flaws_str_A);
      newtLabelSetText(flawsLabelB,flaws_str_B);
      newtLabelSetText(flawsLabelC,flaws_str_C);
      b_res = newtRunForm(myForm);
      if (b_res == bOK)
	{
	  if (!evaluate_mountlist(mountlist,flaws_str_A,flaws_str_B,flaws_str_C))
	    {finished=ask_me_yes_or_no("Your mountlist might not work. Continue anyway?");}
	  else
	    {finished=ask_me_yes_or_no("Are you sure you want to save your mountlist and continue?");}
	}
      else if (b_res == bCancel)
	{
	  finished=TRUE;
	}
      else if (b_res == bReload)
	{
	  if (ask_me_yes_or_no("Reload original mountlist?"))
	    {
	      load_mountlist(mountlist,MOUNTLIST_FNAME);
	      load_raidtab_into_raidlist(raidlist,RAIDTAB_FNAME);
	      redraw_mountlist(mountlist,keylist,partitionsListbox);
	    }
	}
      else
	{
	  curr_choice = newtListboxGetCurrent(partitionsListbox);
	  for(i=0; i<mountlist->entries && keylist[i]!=curr_choice; i++);
	  if (i == mountlist->entries && mountlist->entries>0)
	    { log_to_screen("I don't know what that button does!"); }
	  else
	    {
	      currline=i;
	      if (b_res == bAdd)
		{
		  add_mountlist_entry(mountlist,raidlist,partitionsListbox,currline,keylist);
		}
	      else if (b_res == bDelete)
		{
		  delete_mountlist_entry(mountlist,raidlist,partitionsListbox,currline,keylist);
		}
	      else
		{
		  if (mountlist->entries > 0)
		    { edit_mountlist_entry(mountlist,raidlist,partitionsListbox,currline,keylist); }
		  else
		    { popup_and_OK("Please add an entry. Then press ENTER to edit it."); }
		}
	    }
	}
    }
  newtFormDestroy(myForm);
  newtPopWindow();
  newtPopHelpLine();
  if (b_res == bOK) { return(0); }
  else
    {
  /* popup_and_OK("You pushed 'cancel'. I shall now abort."); */
    return(1); 
    }
}




void edit_raidrec_additional_vars(struct raid_device_record *raidrec)
{
  struct raid_device_record bkp_raidrec;
  newtComponent myForm, bAdd, bEdit, bDelete, bOK, bCancel, b_res, varsListbox, headerMsg;
  void *keylist[ARBITRARY_MAXIMUM], *curr_choice;
  char title_of_window[MAX_STR_LEN];
  int i, currline;

  memcpy((void*)&bkp_raidrec,(void*)raidrec,sizeof(struct raid_device_record));
  sprintf(title_of_window,"Additional variables");
  newtPushHelpLine("  Edit the additional fields to your heart's content, then click OK or Cancel.");
  headerMsg=newtLabel(1,1,"Label                            Value");
  varsListbox=newtListbox(1,2,6,NEWT_FLAG_SCROLL|NEWT_FLAG_RETURNEXIT);
  i=1;
  bAdd =   newtCompactButton(i,    9," Add ");
  bEdit=   newtCompactButton(i+=8, 9," Edit ");
  bDelete= newtCompactButton(i+=9, 9,"Delete");
  bOK =    newtCompactButton(i+=9, 9,"  OK  ");
  bCancel= newtCompactButton(i+=9, 9,"Cancel");
  newtOpenWindow(17,7,46,10,title_of_window);
  myForm=newtForm(NULL,NULL,0);
  newtFormAddComponents(myForm,headerMsg,varsListbox,bAdd,bEdit,bDelete,bOK,bCancel,NULL);
  insert_essential_additionalvars(raidrec);
  redraw_varslist(&raidrec->additional_vars,keylist,varsListbox);
  for(b_res=NULL; b_res!=bOK && b_res!=bCancel;)
    {
      b_res=newtRunForm(myForm);
      curr_choice = newtListboxGetCurrent(varsListbox);
      for(currline=0; currline<raidrec->additional_vars.entries && keylist[currline]!=curr_choice; currline++);
      if (currline==raidrec->additional_vars.entries && raidrec->additional_vars.entries>0) { log_it("Warning - I don't know what this button does"); }
      if (b_res == bOK) { /* do nothing */ }
      else if (b_res == bCancel) { /* do nothing */ }
      else if (b_res == bAdd)
	{
	  add_varslist_entry(raidrec);
	}
      else if (b_res == bDelete)
	{
	  delete_varslist_entry(raidrec,currline);
	}
      else
	{
	  edit_varslist_entry(raidrec,currline);
	}
      redraw_varslist(&raidrec->additional_vars,keylist,varsListbox);
    }
  remove_essential_additionalvars(raidrec);
  newtFormDestroy(myForm);
  newtPopWindow();
  newtPopHelpLine();
  if (b_res==bCancel)
    {
      memcpy((void*)raidrec,(void*)&bkp_raidrec,sizeof(struct raid_device_record));
    }
  return;
}




int evaluate_drive_within_mountlist(struct mountlist_itself *mountlist, char*drive, char*flaws_str)
{
  int prev_part_no, curr_part_no, pos, res=0, mountpoint_copies, device_copies, i;
  char tmp[MAX_STR_LEN], device[MAX_STR_LEN], mountpoint[MAX_STR_LEN];
  long physical_drive_size=0, amount_allocated=0;

  flaws_str[0]='\0';
  prev_part_no=0;
  tmp[0]='\0';
  physical_drive_size=get_phys_size_of_drive(drive);
  if (physical_drive_size < 0)
    {
      sprintf(tmp," %s does not exist.",drive);
      strcat(flaws_str,tmp);
    }
  else
    {
      sprintf(tmp,"%s is %ld MB",drive,physical_drive_size);
    }
  log_it(tmp);

  for(curr_part_no=1; curr_part_no<99; curr_part_no++)
    {
      sprintf(device,"%s%d",drive,curr_part_no);
      pos=find_device_in_mountlist(mountlist,device);
      if (pos<0) { continue; }
      strcpy(mountpoint,mountlist->el[pos].mountpoint);
      /* gap in the partition list? */
      if (curr_part_no-prev_part_no>1)
	{
	  if (prev_part_no == 0)
	    {
	      sprintf(tmp," Gap prior to %s.",device);
	      log_it(tmp); strcat(flaws_str,tmp); res++;
	    }
	  else if (curr_part_no >5 || (curr_part_no <=4 && prev_part_no>0))
	    {
	      sprintf(tmp," Gap between %s%d and %d.",drive,prev_part_no,curr_part_no);
	      log_it(tmp); strcat(flaws_str,tmp); res++;
	    }
	}
      /* no spare primary partitions to help accommodate the logical(s)? */
      if (curr_part_no>=5 && prev_part_no==4)
	{
	  sprintf(tmp," Partition %s4 is occupied.",drive);
	  log_it(tmp); strcat(flaws_str,tmp); res++;
	}
      /* does partition /dev/hdNX exist more than once in the mountlist? */
      for(i=0, mountpoint_copies=0, device_copies=0; i < mountlist->entries; i++)     
	{
	  if (!strcmp(device,mountlist->el[i].device)) { device_copies++; }
	}
      if (device_copies > 1)
	{
	  sprintf(tmp," %s %s's.",number_to_text(device_copies),device);
	  if (!strstr(flaws_str,tmp)) {log_it(tmp);strcat(flaws_str,tmp);res++;}
	}
      /* silly partition size? */
      if (mountlist->el[pos].size < 8192 && strcmp(mountlist->el[pos].mountpoint,"lvm"))
	{
	  sprintf(tmp," %s is tiny!",device);
	  log_it(tmp);strcat(flaws_str,tmp);res++;
	}
      /* mountpoint should begin with / unless it is swap, lvm or raid */
      if (strcmp(mountlist->el[pos].mountpoint,"swap") && strcmp(mountlist->el[pos].mountpoint,"lvm") && strcmp(mountlist->el[pos].mountpoint,"raid") && strcmp(mountlist->el[pos].mountpoint,"image") && mountlist->el[pos].mountpoint[0]!='/')
	{
	  sprintf(tmp," %s has a weird mountpoint.",device);
	  log_it(tmp);strcat(flaws_str,tmp);res++;
	}
      /* is format sensible? */
      if (!is_this_a_valid_disk_format(mountlist->el[pos].format))
        {
          sprintf(tmp," %s has unsupported format.",device);
          log_it(tmp);strcat(flaws_str,tmp);res++;
        }
      /* OK, continue with main loop */
      amount_allocated += mountlist->el[pos].size/1024;
      prev_part_no=curr_part_no;
    }

  /* Over-allocated the disk? Unallocated space on disk? */
  if (amount_allocated > physical_drive_size+1)
    {
      sprintf(tmp," %ld MB over-allocated on %s.",amount_allocated-physical_drive_size,drive);
      log_it(tmp); strcat(flaws_str,tmp); res++;
    }
  else if (amount_allocated < physical_drive_size-1)
    { /* NOT AN ERROR, JUST A WARNING :-) */
      sprintf(tmp," %ld MB unallocated on %s.",physical_drive_size-amount_allocated,drive);
      log_it(tmp), strcat(flaws_str,tmp);
    }
  if (res) { return(FALSE); } else { return(TRUE); }
}






int evaluate_mountlist(struct mountlist_itself *mountlist, char*flaws_str_A, char*flaws_str_B,char*flaws_str_C)
{
  char list_of_drives[ARBITRARY_MAXIMUM][MAX_STR_LEN], tmp[MAX_STR_LEN], flaws_str[MAX_STR_LEN];
  int noof_drives, i, res=0;
  noof_drives=make_list_of_drives(mountlist,list_of_drives);
  flaws_str[0]='\0';
  log_it("Evaluating mountlist...");
  for(i=0; i<noof_drives; i++)
    {
      if (strstr(list_of_drives[i],"/dev/md"))
	{
	  sprintf(tmp," Not evaluating %s (I don't know how yet)",list_of_drives[i]);
	  log_it(tmp);
	  tmp[0]='\0';
	}
      else
	{
	  if (!evaluate_drive_within_mountlist(mountlist,list_of_drives[i],tmp))
	    { res++; }
	}
      strcat(flaws_str,tmp);
    }
  res+=look_for_duplicate_mountpoints(mountlist,flaws_str);
/*  res+=look_for_weird_formats(mountlist,flaws_str); .. not necessary, now that we can check to see
 which formarts are actually _supported_ by the kernel */ 
  /* log_it(flaws_str); */
  return(spread_flaws_across_three_lines(flaws_str,flaws_str_A,flaws_str_B,flaws_str_C,res));
}




int find_device_in_mountlist(struct mountlist_itself *mountlist, char*device)
{
  int i;
  for(i=0; i< mountlist->entries && strcmp(mountlist->el[i].device, device)!=0; i++);
  if (i==mountlist->entries)
    {
      return(-1);
    }
  else
    {
      return(i);
    }
}



int find_next_free_index_in_disklist(struct list_of_disks *disklist)
{
  int index=-1,pos;
  bool done;
  for(done=FALSE;!done;)
    {
      for(pos=0;pos<disklist->entries && disklist->el[pos].index <= index; pos++);
      if (pos>=disklist->entries)
	{
	  done=TRUE;
	}
      else
	{
	  index = disklist->el[pos].index;
	}
    }
  return(index+1);
}





int find_raid_device_in_raidlist(struct raidlist_itself *raidlist, char *device)
{
  int i;
  for(i=0; strcmp(raidlist->el[i].raid_device, device) && i<raidlist->entries; i++);
  if (i==raidlist->entries)
    { return(-1); }
  else
    { return(i); }
}





bool get_isodir_info(char*isodir_device, char*isodir_format, char*isodir_path)
{
  isodir_format[0] = '\0';
  strcpy(isodir_device,"/dev/");
  strcpy(isodir_path,"/");
  if (does_file_exist("/tmp/NFS-SERVER-PATH"))
    {
      strcpy(isodir_device, last_line_of_file("/tmp/NFS-SERVER-MOUNT"));
      strcpy(isodir_format, "nfs");
      strcpy(isodir_path, last_line_of_file("/tmp/NFS-SERVER-PATH"));
    }
  if(popup_and_get_string("ISO Mode - device","On what device do the ISO files live?",isodir_device))
    {
      if (popup_and_get_string("ISO Mode - format","What is the disk format of the device? (Hit ENTER if you don't know.)",isodir_format))
        {
          if (popup_and_get_string("ISO Mode - path","At what path on this device can the ISO files be found?",isodir_path))
            {
              strip_spaces(isodir_device);
              strip_spaces(isodir_format);
              strip_spaces(isodir_path);
              return(TRUE);
            }
        }
    }
  return(FALSE);
}



void initiate_new_raidlist_entry(struct raidlist_itself *raidlist, struct mountlist_itself *mountlist, int currline, char*device)
{
  struct raid_device_record *raidrec;
  int pos_in_raidlist;

  pos_in_raidlist = find_raid_device_in_raidlist(raidlist,mountlist->el[currline].device);
  if (pos_in_raidlist >= 0)
    { fatal_error("Sorry, that RAID device already exists. Weird."); }
  pos_in_raidlist = raidlist->entries ++;
  raidrec = &raidlist->el[pos_in_raidlist];
  initialize_raidrec(raidrec);
  strcpy(raidrec->raid_device,device);
  choose_raid_level(raidrec);
   select_raid_disks(mountlist,raidlist,raidrec,"data",&raidrec->data_disks);
  edit_raidlist_entry(mountlist,raidlist,raidrec,currline);
}



void insert_essential_additionalvars(struct raid_device_record *raidrec)
{
  int items;
  items = raidrec->additional_vars.entries;
  write_variableINT_to_raid_var_line(raidrec,items++,"persistent-superblock", raidrec->persistent_superblock);
  write_variableINT_to_raid_var_line(raidrec,items++,"chunk-size", raidrec->chunk_size);
  raidrec->additional_vars.entries = items;
}




void insist_on_this_cd_number(int cd_number_i_want)
{
  int res;
  char tmp[MAX_STR_LEN],request[MAX_STR_LEN];

  if (what_number_cd_is_this()!=cd_number_i_want)
    {
      /*
      if (!does_file_exist("/mnt/cdrom/archives/NOT-THE-LAST")) 
	{
	  log_to_screen("This is the last CD. Why am I asking for 'next'?");
	  return;
	}
      */
      sprintf(tmp,"Insisting on CD #%d",cd_number_i_want);
      sprintf(request,"Please insert CD #%d and press Enter.",cd_number_i_want);
      log_it(tmp);
      while (what_number_cd_is_this()!=cd_number_i_want)
	{
	  system("sync");
	  if (is_this_device_mounted("/mnt/cdrom")) { res=run_program_and_log_output("umount /mnt/cdrom"); } else { res=0; }
	  if (res) { log_to_screen("WARNING - failed to unmount CD-ROM drive"); }
          if (!g_ISO_mode)
            {
              res=run_program_and_log_output("eject /dev/cdrom");
              if (res) { log_to_screen("WARNING - failed to eject CD-ROM disk"); }
              popup_and_OK(request);
              run_program_and_log_output("eject -t /dev/cdrom");
            }
          system("sync");
	}
      log_it("Thankyou. Proceeding...");
    }
}




bool is_this_raid_personality_registered(int raidno)
{
  char command[MAX_STR_LEN], tmp[MAX_STR_LEN];
  strcpy(command,"cat /proc/mdstat | grep \"");
  if (raidno==-1) { strcat(command,"linear"); }
  else { sprintf(command+strlen(command),"raid%d",raidno); }
  strcat(command,"\" > /dev/null 2> /dev/null");
  sprintf(tmp,"Is raid %d registered? Command = '%s'",raidno,command);
  log_it(tmp);
  if (system(command))
    { return(FALSE); }
  else
    { return(TRUE); }
}




void log_file_end_to_screen(char*filename,char*grep_for_me)
{
  char command[MAX_STR_LEN+1], tmp[MAX_STR_LEN+1];
  FILE*fin;
  int i;
  if (!does_file_exist(filename))
    {return;}
  if (grep_for_me[0]!='\0') 
    {
      sprintf(command,"cat %s | grep \"%s\" | tail -n%d", filename, grep_for_me, NOOF_ERR_LINES);
    }
  else
    {
      sprintf(command,"cat %s | tail -n%d", filename, NOOF_ERR_LINES);
    }
  fin=popen(command,"r");
  if (fin)
    {
      for(i=0;i<NOOF_ERR_LINES;i++)
	{
          for(err_log_lines[i][0]='\0'; strlen(err_log_lines[i])<2 && !feof(fin);)
            {
              fgets(err_log_lines[i],MAX_STR_LEN,fin);
              strip_spaces(err_log_lines[i]);
              if (!strncmp(err_log_lines[i],"root:",5))
                {
                  strcpy(tmp,err_log_lines[i]+6);
                  strcpy(err_log_lines[i],tmp);
                }
	      if (feof(fin)) {break;}
            }
	}
      pclose(fin);
    }
  refresh_log_screen();
}



void log_to_screen(char *op)
{
  int i, j;
  char output[MAX_STR_LEN];
  strcpy(output,op);
  i=strlen(output);
  if (output[i-1]<32) { output[i-1]='\0'; }
  log_it(output);
  for(i=1; i< NOOF_ERR_LINES; i++)
    {
      strcpy(err_log_lines[i-1],"                                                                                ");
      strcpy(err_log_lines[i-1],err_log_lines[i]);
    }
  output[80]='\0';
  while( output[strlen(output)-1]<32)
    { output[strlen(output)-1]='\0'; }
  for(j=0; j<strlen(output); j++)
    {
      if (output[j]<32)
	{
	      output[j]=' ';
	}
    }
  strcpy(err_log_lines[NOOF_ERR_LINES-1],output);
  refresh_log_screen();
}





int look_for_duplicate_mountpoints(struct mountlist_itself *mountlist, char*flaws_str)
{
  int res=0, currline, i, copies,last_copy;
  char curr_mountpoint[MAX_STR_LEN],tmp[MAX_STR_LEN];
  for(currline=0;currline < mountlist->entries; currline++)
    {
      strcpy(curr_mountpoint,mountlist->el[currline].mountpoint);
      for(i=0,copies=0,last_copy=-1;i<mountlist->entries;i++)
	{
	  if (!strcmp(mountlist->el[i].mountpoint,curr_mountpoint) && strcmp(mountlist->el[i].mountpoint,"lvm") && strcmp(mountlist->el[i].mountpoint,"swap"))
	    {
	      last_copy=i;
	      copies++;
	    }
	}
      if (copies > 1 && last_copy==currline && strcmp(curr_mountpoint,"raid"))
	{
	  sprintf(tmp," %s %s's.",number_to_text(copies),curr_mountpoint); strcat(flaws_str,tmp); log_it(tmp); res++;
	}
    }
  return(res);
}



int look_for_weird_formats(struct mountlist_itself *mountlist, char*flaws_str)
{
  int i, res=0;
  char tmp[MAX_STR_LEN], format_sz[MAX_STR_LEN];

  for(i=0;i < mountlist->entries; i++)
    {
      sprintf(format_sz," %s ",mountlist->el[i].format);
      if (!strstr("swap image vfat ext2 ext3 xfs vfs jfs reiserfs dos minix coda nfs ntfs hpfs raid lvm",format_sz) && strcmp(mountlist->el[i].mountpoint,"image")!=0)
	{
	  sprintf(tmp," %s has unknown format.",mountlist->el[i].device);
	  log_it(tmp); strcat(flaws_str,tmp); res++;
	}
      else if ((!strcmp(mountlist->el[i].format,"swap") && strcmp(mountlist->el[i].mountpoint,"swap")) || (strcmp(mountlist->el[i].format,"swap") && !strcmp(mountlist->el[i].mountpoint,"swap")))
	{
	  sprintf(tmp," %s is half-swap.",mountlist->el[i].device);
	  log_it(tmp); strcat(flaws_str,tmp); res++;
	}
    }
  return(res);
}




void make_list_of_unallocated_raid_partitions(struct mountlist_itself *output_list, struct mountlist_itself *mountlist, struct raidlist_itself *raidlist)
{
  int items,i,used_by;
  char tmp[MAX_STR_LEN];
  log_it("MLOURP -- starting");
  items=0;
  for(i=0; i<mountlist->entries; i++)
    {
      if (strstr(mountlist->el[i].mountpoint,"raid"))
	{
	  used_by = which_raid_device_is_using_this_partition(raidlist, mountlist->el[i].device);
	  if (used_by < 0)
	    {
	      memcpy((void*)&output_list->el[items++], (void*)&mountlist->el[i], sizeof(struct mountlist_line));
	      sprintf(tmp,"%s is available; user may choose to add it to raid device",output_list->el[items-1].device);
	      log_it(tmp);
	    }
	}
    }
  output_list->entries = items;
  log_it("MLUORP -- ending");
}




char *mountlist_entry_to_string(struct mountlist_itself *mountlist, int lino)
{
  static char output[MAX_STR_LEN];
  sprintf(output,"%-24s %-24s %-10s %8ld",mountlist->el[lino].device, mountlist->el[lino].mountpoint, mountlist->el[lino].format, mountlist->el[lino].size/1024);
  return(output);
}




void mvaddstr_and_log_it(int y, int x, char *output)
{
  log_it(output);
  if (g_text_mode)
    {
      printf("%s\n",output);
    }
  else
    {
      newtDrawRootText(x,y,output);
      newtRefresh();
    }
}




void nuke_mode_dummy()
{
  newtComponent myForm, b1, b2, b3, b_res;
  newtPushHelpLine("This is where I nuke your hard drives. Mhahahahaha. No-one can stop Mojo Jojo!");
  newtOpenWindow(24,3,32,13,"Nuking");
  b1=newtButton(7,1,"Slowly");
  b2=newtButton(7,5,"Medium");
  b3=newtButton(7,9,"Quickly");
  myForm = newtForm(NULL,NULL,0);
  newtFormAddComponents(myForm,b1,b2,b3,NULL);
  b_res=newtRunForm(myForm);
  newtFormDestroy(myForm);
  newtPopWindow();
  newtPopHelpLine();
}



char *number_of_disks_as_string(int noof_disks,char*label)
{
  static char output[MAX_STR_LEN];
  char p;
  if (noof_disks>1) {p='s';} else {p=' ';}
  sprintf(output,"%d %s disk%c",noof_disks,label,p);
  while(strlen(output)<14) {strcat(output," ");}
  return(output);
}


void open_evalcall_form(char*title)
{
  char tmp[MAX_STR_LEN];

  g_isoform_old_progress=-1;
  g_mysterious_dot_counter=0;
  strcpy(tmp,title);
  strcpy(g_isoform_header_str,title);
  center_string(tmp,80);
  if (g_text_mode) {log_it(tmp);} else {newtPushHelpLine(tmp);}
  center_string(g_isoform_header_str,36);
  g_isoform_starttime=get_time();
  if (g_text_mode)
    {
      log_it(g_isoform_header_str);
    }
  else
    {
      g_isoform_header=newtLabel(1,1,g_isoform_header_str);
      g_isoform_scale=newtScale(3,3,34,100);
      newtOpenWindow(20,6,40,7,"Please Wait");
      g_isoform_main=newtForm(NULL,NULL,0);
      g_isoform_timeline=newtLabel(1,5,"This is the timeline");
      g_isoform_pcline=newtLabel(1,6,"This is the pcline");
      newtFormAddComponents(g_isoform_main, g_isoform_timeline, g_isoform_pcline, g_isoform_header, g_isoform_scale, NULL);
      newtRefresh();
    }
  update_evalcall_form(0);
}



void open_progress_form(char*title, char*b1, char*b2, char*b3, long max_val)
{
  char b1c[MAX_STR_LEN],blurb1[MAX_STR_LEN], blurb2[MAX_STR_LEN], blurb3[MAX_STR_LEN];

  g_mysterious_dot_counter=0;
  strcpy(blurb1,b1);
  strcpy(blurb2,b2);
  strcpy(blurb3,b3);
  strcpy(b1c,b1);
  center_string(b1c,80);
  if (max_val<=0) { max_val=1; }
  g_start_time=get_time();
  g_maximum_progress=max_val;
  g_current_progress=0;
  strcpy(g_blurb_str_1,blurb1);
  strcpy(g_blurb_str_2,blurb2);
  strcpy(g_blurb_str_3,blurb3);
  if (g_text_mode)
    {
      log_it(blurb1);
      log_it(blurb2);
      log_it(blurb3);
    }
  else
    {
      g_blurb1 = newtLabel(2,1,blurb1);
      g_blurb2 = newtLabel(2,2,blurb2);
      g_blurb3 = newtLabel(2,4,blurb3);
      newtOpenWindow(10,4,60,11,title);
      g_scale = newtScale(3,6,54,g_maximum_progress);
      g_progressForm = newtForm(NULL,NULL,0);
      g_percentline = newtLabel(10,9,"This is the percentline");
      g_timeline = newtLabel(10,8,"This is the timeline");
      newtFormAddComponents(g_progressForm, g_percentline, g_timeline, g_scale, g_blurb1, g_blurb2, g_blurb3, NULL);
      newtPushHelpLine(b1c);
      newtRefresh();
    }
  update_progress_form_full(blurb1,blurb2,blurb3);
}






void popup_and_OK(char*prompt)
{
  char tmp[MAX_STR_LEN];
  log_it(prompt);
  if (g_text_mode)
    {
      printf("%sBTW, because this is text mode, you'll have to type 'OK' to continue...\n",prompt);
      scanf("%s",tmp);
    }
  else
    {
      popup_with_buttons(prompt," OK ","");
    }
}


bool popup_and_get_string(char*title, char*b, char*output)
{
  newtComponent myForm, b_1, b_2, b_res, text, type_here;
  char *entry_value, blurb[MAX_STR_LEN], original_contents[MAX_STR_LEN];
  if (g_text_mode)
    {
      printf("%s\n%s\n--> ",title,b);
      scanf("%s",output);
      return(TRUE);
    }
  strcpy(blurb,b);
  text = newtTextboxReflowed(2,1,blurb,48,5,5,0);
  strcpy(original_contents,output);
  output[0]='\0';
  type_here = newtEntry(2, newtTextboxGetNumLines(text)+2, original_contents, 50, &entry_value, NEWT_FLAG_RETURNEXIT);
  b_1 = newtButton(6, newtTextboxGetNumLines(text)+4,"  OK  ");
  b_2 = newtButton(18,newtTextboxGetNumLines(text)+4,"Cancel");
  newtOpenWindow(8,5,54,newtTextboxGetNumLines(text)+9,title);
  myForm=newtForm(NULL,NULL,0);
  newtFormAddComponents(myForm, text, type_here, b_1, b_2, NULL);
  center_string(blurb,80);
  newtPushHelpLine(blurb);
  b_res = newtRunForm(myForm);
  strcpy(output,entry_value);
  newtPopHelpLine();
  newtFormDestroy(myForm);
  newtPopWindow();
  if (b_res == b_2)
    {
      strcpy(output,original_contents);
      return(FALSE);
    }
  else
    {
      return(TRUE); 
    }
}


int popup_with_buttons(char*p, char *button1, char*button2)
{
  char prompt[MAX_STR_LEN];
  newtComponent myForm, b_1, b_2, b_res, text;
  if (g_text_mode) {fatal_error("popup_with_buttons doesn't like text mode");}
  strcpy(prompt,p);
  text = newtTextboxReflowed(1,1,prompt,40,5,5,0);
  b_1 = newtButton(20 - ((button2[0]!='\0') ? strlen(button1)+2 : strlen(button1)/2), newtTextboxGetNumLines(text)+3,button1);
  if (button2[0]!='\0') { b_2 = newtButton(24, newtTextboxGetNumLines(text)+3,button2); } else { b_2 = NULL; }
  newtOpenWindow(25,5,46,newtTextboxGetNumLines(text)+7,"Alert");
  myForm = newtForm(NULL,NULL,0);
  newtFormAddComponents(myForm, text, b_1, b_2, NULL);
  center_string(prompt,80);
  newtPushHelpLine(prompt);
  b_res = newtRunForm(myForm);
  newtPopHelpLine();
  newtFormDestroy(myForm);
  newtPopWindow();
  if (b_res == b_1) { return(TRUE); } else { return(FALSE); }
}




void redraw_disklist(struct list_of_disks *disklist, void*keylist[ARBITRARY_MAXIMUM], newtComponent listbox)
{
  int i;
  newtListboxClear(listbox);
  for(i=0; i<ARBITRARY_MAXIMUM; i++) { keylist[i]=(void*)i; }
  for(i=0; i<disklist->entries; i++)
    {
      newtListboxAppendEntry(listbox,disklist_entry_to_string(disklist,i),keylist[i]);
    }
}



void redraw_mountlist(struct mountlist_itself*mountlist, void *keylist[ARBITRARY_MAXIMUM], newtComponent listbox)
{
  int i;
  newtListboxClear(listbox);
  sort_mountlist_by_device(mountlist);
  for(i=0; i<ARBITRARY_MAXIMUM; i++) { keylist[i]=(void*)i; }
  for(i=0; i<mountlist->entries; i++)
    {
      newtListboxAppendEntry(listbox,mountlist_entry_to_string(mountlist,i),keylist[i]);
    }
}





void redraw_unallocpartnslist(struct mountlist_itself *unallocated_raid_partitions, void*keylist[ARBITRARY_MAXIMUM], newtComponent listbox)
{
  int i;
  char tmp[MAX_STR_LEN];
  newtListboxClear(listbox);
  for(i=0; i<ARBITRARY_MAXIMUM; i++) { keylist[i]=(void*)i;}
  for(i=0; i<unallocated_raid_partitions->entries; i++)
    {
      sprintf(tmp,"%-22s %8ld",unallocated_raid_partitions->el[i].device, unallocated_raid_partitions->el[i].size/1024);
      newtListboxAppendEntry(listbox,tmp,keylist[i]);
    }
}



void redraw_varslist(struct additional_raid_variables *additional_vars, void*keylist[], newtComponent listbox)
{
  int i;
  char tmp[MAX_STR_LEN];
  newtListboxClear(listbox);
  for(i=0; i<ARBITRARY_MAXIMUM; i++) {keylist[i]=(void*)i;}
  for(i=0; i<additional_vars->entries; i++)
    {
      sprintf(tmp,"%-32s %-8s",additional_vars->el[i].label, additional_vars->el[i].value);
      newtListboxAppendEntry(listbox,tmp,keylist[i]);
    }
}




int read_variableINT_and_remove_from_raidvars(struct raid_device_record *raidrec, char*label)
{
  int i, res;
  for(i=0; i<raidrec->additional_vars.entries && strcmp(raidrec->additional_vars.el[i].label, label); i++);
  if (i==raidrec->additional_vars.entries)
    { res=-1; }
  else
    {
      res=atoi(raidrec->additional_vars.el[i].value);
      for(i++;i<raidrec->additional_vars.entries;i++)
	{
	  memcpy((void*)&raidrec->additional_vars.el[i-1], (void*)&raidrec->additional_vars.el[i], sizeof(struct raid_var_line));
	}
      raidrec->additional_vars.entries--;
    }
  return(res);
}







void refresh_log_screen()
{
  int i;
  if (g_text_mode) {return;}
  for(i=NOOF_ERR_LINES-1; i>=0; i--)
    {
      newtDrawRootText(0,i+23-NOOF_ERR_LINES,"                                                                                ");
      newtDrawRootText(0,i+23-NOOF_ERR_LINES,err_log_lines[i]);
    }
  newtRefresh();
}



void rejig_partition_name_in_raidlist_if_necessary(struct raidlist_itself *raidlist, char *old_dev, char *new_dev)
{
  char tmp[MAX_STR_LEN];
  int pos,j;

  pos=which_raid_device_is_using_this_partition(raidlist,old_dev);
  if (pos<0)
    {
      sprintf(tmp,"No need to rejig %s in raidlist: it's not listed.",old_dev);
      log_it(tmp);
    }
  else
    {
      if ((j=where_in_drivelist_is_drive(&raidlist->el[pos].data_disks,old_dev)) >= 0)
        { strcpy(raidlist->el[pos].data_disks.el[j].device, new_dev); }
      else if ((j=where_in_drivelist_is_drive(&raidlist->el[pos].spare_disks,old_dev)) >= 0)
        { strcpy(raidlist->el[pos].spare_disks.el[j].device, new_dev); }
      else if ((j=where_in_drivelist_is_drive(&raidlist->el[pos].parity_disks,old_dev)) >= 0)
        { strcpy(raidlist->el[pos].parity_disks.el[j].device, new_dev); }
      else if ((j=where_in_drivelist_is_drive(&raidlist->el[pos].failed_disks,old_dev)) >= 0)
        { strcpy(raidlist->el[pos].failed_disks.el[j].device, new_dev); }
      else
        {
          sprintf(tmp,"%s is supposed to be listed in this raid dev but it's not...",old_dev);
          log_it(tmp);
        }
    }
}



void remove_essential_additionalvars(struct raid_device_record *raidrec)
{
  int res;
  res=read_variableINT_and_remove_from_raidvars(raidrec,"persistent-superblock");
  if (res>0) { raidrec->persistent_superblock=res; }
  res=read_variableINT_and_remove_from_raidvars(raidrec,"chunk-size");
  if (res>0) { raidrec->chunk_size=res; }
  res=read_variableINT_and_remove_from_raidvars(raidrec,"block-size");
}



void select_raid_disks(struct mountlist_itself *mountlist_dontedit, struct raidlist_itself *raidlist, struct raid_device_record *raidrec, char *description_of_list, struct list_of_disks *disklist)
{
  void*curr_choice;
  struct raidlist_itself bkp_raidlist;
  struct raid_device_record bkp_raidrec;
  struct list_of_disks bkp_disklist;
  struct mountlist_itself URP, *unallocated_raid_partitions;
  newtComponent myForm, bAdd, bDelete, bOK, bCancel, b_res, partitionsListbox, headerMsg;
  void* keylist[ARBITRARY_MAXIMUM];
  char tmp[MAX_STR_LEN], help_text[MAX_STR_LEN], title_of_window[MAX_STR_LEN], sz_res[MAX_STR_LEN], header_text[MAX_STR_LEN];
  int i,currline;

  memcpy((void*)&bkp_raidlist,(void*)raidlist,sizeof(struct raidlist_itself));
  memcpy((void*)&bkp_raidrec,(void*)raidrec,sizeof(struct raid_device_record));
  memcpy((void*)&bkp_disklist,(void*)disklist,sizeof(struct list_of_disks));
  unallocated_raid_partitions=&URP;
  strcpy(help_text,"   Edit this RAID device's list of partitions. Choose OK or Cancel when done.");
  sprintf(header_text,"%-24s    %s","Device","Index");
  sprintf(title_of_window,"%s contains...", raidrec->raid_device);
  newtPushHelpLine(help_text);
  for(b_res=(newtComponent)12345; b_res!=bOK && b_res!=bCancel;)
    {
      headerMsg=newtLabel(1,1,header_text);
      partitionsListbox=newtListbox(1,2,6,NEWT_FLAG_SCROLL|NEWT_FLAG_RETURNEXIT);
      redraw_disklist(disklist,keylist,partitionsListbox);
      i=1;
      bAdd =  newtCompactButton(i,    9," Add ");
      bDelete=newtCompactButton(i+=8, 9,"Delete");
      bOK =   newtCompactButton(i+=9, 9,"  OK  ");
      bCancel=newtCompactButton(i+=9, 9,"Cancel");
      newtOpenWindow(21,7,38,10,title_of_window);
      myForm=newtForm(NULL,NULL,0);
      if (disklist->entries == 0)
	{ newtFormAddComponents(myForm,headerMsg,bAdd,bDelete,bOK,bCancel,NULL); }
      else
	{ newtFormAddComponents(myForm,headerMsg,partitionsListbox,bAdd,bDelete,bOK,bCancel,NULL); }
      b_res=newtRunForm(myForm);
      if (b_res == bOK || b_res == bCancel) 
	{ /* do nothing */ }
      else
	{
	  curr_choice = newtListboxGetCurrent(partitionsListbox);
	  for(i=0; i<disklist->entries && keylist[i]!=curr_choice; i++);
	  if (i == disklist->entries && disklist->entries>0)
	    { log_to_screen("I don't know what that button does!"); }
	  else
	    {
	      currline=i;
	      if (b_res == bAdd)
		{
                  log_it("Making list of unallocated RAID slices");
		  make_list_of_unallocated_raid_partitions(unallocated_raid_partitions,mountlist_dontedit,raidlist);
                  if (unallocated_raid_partitions->entries <= 0)
                    { popup_and_OK("There are no unallocated partitions marked for RAID."); }
                  else
                    {
                      log_it("Done. The user may add one or more of the above to RAID device");
		      add_disklist_entry(disklist,raidrec->raid_device,unallocated_raid_partitions);
                      log_it("I have finished adding a disklist entry.");
		      redraw_disklist(disklist,keylist,partitionsListbox);
                    }
		}
	      else if (b_res == bDelete)
		{ 
		  delete_disklist_entry(disklist,raidrec->raid_device,currline); 
		  redraw_disklist(disklist,keylist,partitionsListbox);
		}
	      else
		{
		  sprintf(tmp,"%s's index is %d. What should it be?",raidrec->raid_device,disklist->el[currline].index);
		  sprintf(sz_res,"%d",disklist->el[currline].index);
		  if (popup_and_get_string("Set index",tmp,sz_res))
		    { disklist->el[currline].index = atoi(sz_res); }
		  redraw_disklist(disklist,keylist,partitionsListbox);
		}
	    }
	}
      newtFormDestroy(myForm);
      newtPopWindow();
    }
  newtPopHelpLine();
  if (b_res == bCancel)
    {
      memcpy((void*)raidlist,(void*)&bkp_raidlist,sizeof(struct raidlist_itself));
      memcpy((void*)raidrec,(void*)&bkp_raidrec,sizeof(struct raid_device_record));
      memcpy((void*)disklist,(void*)&bkp_disklist,sizeof(struct list_of_disks)); 
    }
}



void setup_newt_stuff()
{
  int i;
  for(i=0;i<NOOF_ERR_LINES;i++)
    {
      err_log_lines[i][0]='\0';
    }
  if (!g_text_mode)
    {
      newtInit();
      newtCls();
      newtPushHelpLine("Welcome to Mondo Rescue, by Hugo Rabson and the Internet. All rights reversed.");
  /*  newtDrawRootText(28,0,"Welcome to Mondo Rescue"); */
      newtDrawRootText(18,0,"W E L C O M E   T O   M O N D O   R E S C U E");
      newtRefresh();
    }
}



long size_of_specific_device(struct mountlist_itself *mountlist, char*device)
{
  int i;
  for(i=0; i<mountlist->entries && strcmp(mountlist->el[i].device, device); i++);
  if (i==mountlist->entries)
    { return(-1); }
  else
    { return(mountlist->el[i].size); }
}




bool spread_flaws_across_three_lines(char*flaws_str,char*flaws_str_A,char*flaws_str_B,char*flaws_str_C, int res)
{
  int i;
  flaws_str_A[0]=flaws_str_B[0]=flaws_str_C[0]='\0';
  if (!res && !strlen(flaws_str)) { return(TRUE); }
  if (strlen(flaws_str)>0) { sprintf(flaws_str_A,"%s",flaws_str+1); }
  if (strlen(flaws_str_A)>=74)
    {
      for(i=74; flaws_str_A[i]!=' '; i--);
      strcpy(flaws_str_B,flaws_str_A+i+1);
      flaws_str_A[i]='\0';
    }
  if (strlen(flaws_str_B)>=74)
    {
      for(i=74; flaws_str_B[i]!=' '; i--);
      strcpy(flaws_str_C,flaws_str_B+i+1);
      flaws_str_B[i]='\0';
    }
  if (res) { return(FALSE); } else { return(TRUE); }
}







char *turn_raid_level_number_to_string(int raid_level)
{
  static char output[MAX_STR_LEN];
  if (raid_level>=0)
    {
      sprintf(output," RAID %-2d ",raid_level);
    }
  else
    {
      sprintf(output,"Linear RAID");
    }
  return(output);
}




int special_dot_char(int i)
{
  switch(i%4)
    {
      case 0: return('/');
      case 1: return('-');
      case 2: return('\\');
      case 3: return('|');
      default: return('.');
    }
  return('.');
}





void update_evalcall_form(int curr)
{
  long current_time,time_taken,time_total_est,time_remaining;
  char timeline_str[MAX_STR_LEN], pcline_str[MAX_STR_LEN], taskprogress[MAX_STR_LEN];
  int percentage, i, j;
  /*  log_it("update_eval_call_form called"); */
  if (curr<1) {percentage=1;} else {percentage=curr;}
  current_time=get_time();
  time_taken = current_time - g_isoform_starttime;
  time_total_est = time_taken * 100L / percentage;
  time_remaining = time_total_est - time_taken;
  if (!g_text_mode)
    { newtLabelSetText(g_isoform_header,g_isoform_header_str); }
  g_mysterious_dot_counter = (g_mysterious_dot_counter+1) % 27;
  if ((percentage<3 && g_isoform_old_progress<3) || percentage > g_isoform_old_progress)
    {
      g_isoform_old_progress=percentage;
      sprintf(timeline_str,"%2ld:%02ld taken            %2ld:%02ld remaining",time_taken / 60, time_taken % 60, time_remaining / 60, time_remaining % 60);
      if (percentage<3)
        {
          sprintf(pcline_str," Working");
          for(j=0;j<g_mysterious_dot_counter; j++) {strcat(pcline_str,".");}
          for(;j<27;j++) {strcat(pcline_str," ");}
          sprintf(pcline_str+strlen(pcline_str)," %c",special_dot_char(g_mysterious_dot_counter));
        }
      else
        { sprintf(pcline_str,     " %3d%% done              %3d%% to go",percentage,100-percentage); }
      if (g_text_mode)
        {
          sprintf(taskprogress,"TASK:  [");
          for(i=0;i<percentage;i+=5) {strcat(taskprogress,"*");}
          for(;i<100;i+=5) {strcat(taskprogress,".");}
          if (percentage>=3)
            {
              sprintf(taskprogress+strlen(taskprogress),"] %3d%% done; %2ld:%02ld to go",percentage, time_remaining / 60, time_remaining % 60);
              log_it(taskprogress);
            }
        }
      else
        {
          newtScaleSet(g_isoform_scale,percentage);
          newtLabelSetText(g_isoform_pcline,pcline_str);
          if (percentage>=3) {newtLabelSetText(g_isoform_timeline,timeline_str);}
        }
    }
  if (!g_text_mode) {newtRefresh();}
}




void update_progress_form(char *blurb3)
{
  /*  log_it("update_progress_form --- called"); */
  if (g_current_progress==-999)
    {
      /* log_it("You're trying to update progress form when it ain't open. Aww, that's OK. I'll let it go. It's a bit naughty but it's a nonfatal error. No prob, Bob."); */
      return;
    }
  strcpy(g_blurb_str_3,blurb3);
  update_progress_form_full(g_blurb_str_1, g_blurb_str_2, g_blurb_str_3);
}






void update_progress_form_full(char *blurb1, char*blurb2, char*blurb3)
{
  long current_time, time_taken=0, time_remaining=0, time_total_est=0;
  int percentage, i;
  char percentline_str[MAX_STR_LEN], timeline_str[MAX_STR_LEN],
    taskprogress[MAX_STR_LEN], tmp[MAX_STR_LEN];

  current_time=get_time();
  time_taken = current_time - g_start_time;
  if (g_maximum_progress==0)
    {
      percentage=0;
    }
  else
    {
      if (g_current_progress > g_maximum_progress)
	{
          sprintf(tmp,"update_progress_form_full(%s,%s,%s) --- g_current_progress=%ld; g_maximum_progress=%ld", blurb1, blurb2, blurb3, g_current_progress, g_maximum_progress);
          log_it(tmp);
          g_current_progress = g_maximum_progress;
        }
      percentage = (int)((g_current_progress * 100L) / g_maximum_progress);
    }
  if (percentage<1) { percentage=1; }
  if (percentage > 100) { percentage = 100; }
  time_total_est = time_taken * 100L / (long)(percentage);
  time_remaining = time_total_est - time_taken;
  g_mysterious_dot_counter = (g_mysterious_dot_counter+1) % 27;
  sprintf(timeline_str,"%2ld:%02ld taken               %2ld:%02ld remaining  ",time_taken / 60, time_taken % 60, time_remaining / 60, time_remaining % 60);
  /*
  if (percentage<2)
    {
      log_it("percentage < 2");
      sprintf(percentline_str," Working");
      for(j=0;j<g_mysterious_dot_counter; j++) {strcat(percentline_str,".");}
      for(;j<27;j++) {strcat(percentline_str," ");}
      sprintf(percentline_str+strlen(percentline_str)," %c",special_dot_char(g_mysterious_dot_counter));
    }
  else
  {*/
 sprintf(percentline_str," %3d%% done                 %3d%% to go",percentage,100-percentage);
 /* }*/
  if (g_text_mode)
    {
      log_it(blurb3);
      sprintf(taskprogress,"TASK:  [");
      for(i=0;i<percentage;i+=5) {strcat(taskprogress,"*");}
      for(;i<100;i+=5) {strcat(taskprogress,".");}
      sprintf(taskprogress+strlen(taskprogress),"] %3d%% done; %2ld:%02ld to go",percentage, time_remaining / 60, time_remaining % 60);
      log_it(taskprogress);
    }
  else
    {
      center_string(blurb1,54);
      center_string(blurb2,54);
      center_string(blurb3,54);
      newtLabelSetText(g_blurb1, blurb1);
      newtLabelSetText(g_blurb2, blurb2);
      newtLabelSetText(g_blurb3, blurb3);
      newtScaleSet(g_scale, g_current_progress);
      if (percentage>=2) 
        {
          newtLabelSetText(g_timeline, timeline_str);
        }
      newtLabelSetText(g_percentline, percentline_str);
      newtRefresh();
    }
}




char which_restore_mode()
{
  char output;
  newtComponent b1,b2,b3,b4,b_res, myForm;

  newtPushHelpLine("   Do you want to 'nuke' your system, restore interactively, or just compare?");
  newtOpenWindow(24,3,32,17,"How should I restore?");
  b1 = newtButton(7,1,"Automatically");
  b2 = newtButton(7,5,"Interactively");
  b3 = newtButton(7,9,"Compare only!");
  b4 = newtButton(7,13,"Exit to shell");
  myForm = newtForm(NULL, NULL, 0);
  newtFormAddComponents(myForm, b1, b2, b3, b4, NULL);
  b_res = newtRunForm(myForm);
  newtFormDestroy(myForm);
  newtPopWindow();
  if (b_res == b1) { output='N'; }
  if (b_res == b2) { output='I'; }
  if (b_res == b3) { output='C'; }
  if (b_res == b4) { output='E'; }
  newtPopHelpLine();
  return(output);
}



int which_raid_device_is_using_this_partition(struct raidlist_itself *raidlist, char*device)
{
  int current_raiddev;
  for(current_raiddev = 0; current_raiddev < raidlist->entries; current_raiddev++)
    {
      if
	(where_in_drivelist_is_drive(&raidlist->el[current_raiddev].data_disks,device) >= 0 ||
	 where_in_drivelist_is_drive(&raidlist->el[current_raiddev].spare_disks, device) >= 0 ||
	 where_in_drivelist_is_drive(&raidlist->el[current_raiddev].parity_disks, device) >= 0 ||
	 where_in_drivelist_is_drive(&raidlist->el[current_raiddev].failed_disks, device) >= 0) 
	{ 
	  break;
	}
    }
  if (current_raiddev == raidlist->entries)
    { return(-1); }
  else
    { return(current_raiddev); }
}






void write_variableINT_to_raid_var_line(struct raid_device_record *raidrec, int lino, char* label, int value)
{
  char sz_value[MAX_STR_LEN];
  sprintf(sz_value,"%d",value);
  strcpy(raidrec->additional_vars.el[lino].label, label);
  strcpy(raidrec->additional_vars.el[lino].value, sz_value);
}





int where_in_drivelist_is_drive(struct list_of_disks *disklist, char*device)
{
  int i;
  for(i=0; i<disklist->entries; i++)
    {
      if (!strcmp(disklist->el[i].device, device)) { break; }
    }
  if (i==disklist->entries)
    { return(-1); }
  else
    { return(i); }
}













