/* mondo-tools.c                     Hugo Rabson                     03/03/2002


03/03
- default compression level is now 2

02/21
- misc clean-ups
- 1MB buffer when reading from cdstream (was 13MB)
- disable 'checksum=' echo at end of each write to tape

02/20
- added lots of cdstream-related code
- unzip all.tar.gz to get mondo-restore.cfg, when openin'ing tape/cdstrema

02/19
- added "author can and will..." msg to fatal_error()
- added a 2nd buffer to the output (tape)

02/10
- removed '-w' from call to find size of partition

02/09
- changed Four, Five, Six, etc. to four, five, six, etc. in subroutine
  number_to_text()
- changed get_phys_size_of_drive() to read value from fdisk, not dmesg

02/04
- added size_of_all_bigfiles()
- fixed bug in size_of_all_biggiefiles_K()

02/01
- added write_cfg_var(char *label, char *value)
- added read_cfg_var(char *label, char *value)

01/31
- commented out, "Let's see what happens, shall we?" in two places

01/30
- don't make log_it() check last line of logfile before logging
- fixed silly bug in find_cdrom_device()

01/28
- handles files >2GB in size

01/24
- added load_filelist(), save_filelist(), free_filelist()
- disabled block-level checksums in read_file..() and write_file..()

01/20
- fixed silly bug in slice_fname()
- improved fatal_error()'s feedback

01/18
- changed g_tape_position to g_tape_posK
- I was implementing a FIFO and a fork but I changed my mind

01/15
- sleep()-related fix to eval_call()
- does_file_exist() is more sane with devices now
- improved visual feedback when writing/skipping data disks at start of tape

01/13
- added calc_checksum_list_file() stuff
- improved log_file_to_screen()

01/08
- added prototype write_file_to_tape_from_stream()
- stopped an fread() from returning an error when in fact it was just
  returning the number of bytes read

01/05
- tweaked is_this_device_mounted()
- tweaked run_program_and_log_output()

01/03
- log_it() won't log a blank (zero-length) line anymore
- fixed silly bug in last_line_of_file()
- added calc_checksum_of_file(), {write,read}_header_block_to_tape()
- adding some tape tools

12/01 - 12/30
- in text mode, don't write string to screen if it matches last line
  of log file (i.e. don't double-bounce)
- some g_text_mode-related enhancements
- replaced &> /dev/null with 2> /dev/null
- replaced '/tmp/run-prog.txt' with '/tmp/mondo-run-prog.txt'
- look at /proc/mounts, not the output of 'mount', when trying to establish
  whether a partition is mounted or not
- found several popen/pclose-type errors; fixed them
- subtract 5% from get_phys_size_of_drive()'s output
- took out all '/ /' comments
- now, log_it() only writes \n on end of line if line doesn't
  have \n on the end already
- all greps pipe 2> /dev/null or &> /dev/null, now
- fixed obscure bug in count_lines_in_file()
- don't say, "Press ENTER to quit" if finish(0) called. Just quit.
- call_program_and_log_output() doesn't put extra \n on everything
- fdisk -l 2> /dev/null --- note the '2> /dev/null' to quieten down
  does_partition_exist()
- minor code clean-ups; turned on '-Wall'

11/01 - 11/30
- moved strip_spaces() from mondo-newt.c to mondo-tools.c
- preliminary code review

Created on Sept 1st, 2001
*/



#include "my-stuff.h"



/* global vase - er, vars */
long g_maximum_progress=999, g_current_progress=-999, g_start_time=0;
int g_currentY=3, g_current_media_number=1;



extern FILE *g_tape_stream;
extern long long g_tape_posK;
extern int g_current_media_number;


/* externs */
extern void setup_newt_stuff(void);
extern char which_restore_mode(void);
extern int ask_me_yes_or_no(char*);
extern void log_to_screen(char*);
extern void log_file_end_to_screen(char*,char*);
extern void update_progress_form(char*);
extern void open_progress_form(char*,char*,char*,char*,long);
extern void close_progress_form(void);
extern void close_evalcall_form(void);
extern void popup_and_OK(char*);
extern int  popup_and_get_string(char*,char*,char*);
extern char err_log_lines[NOOF_ERR_LINES][MAX_STR_LEN];
extern bool g_text_mode;
extern void open_evalcall_form(char*);
extern void update_evalcall_form(int);


/* ------------------ my tools ------------------ */
char *calc_checksum_of_file(char*filename);
char *call_program_and_get_last_line_of_output(char *call);
void center_string(char*in_out,int width);
int closein_cdstream(struct s_bkpinfo*);
int closein_tape(struct s_bkpinfo*);
long count_lines_in_file(char*);
bool does_file_exist(char*);
int does_partition_exist(char*device,int partno);
void exclude_nonexistent_files(char*);
void fatal_error(char*);
int find_and_mount_actual_cd(struct s_bkpinfo*, char*);
int find_cdrom_device(char*);
void free_filelist(struct s_node*);
void free_shared_memory(void);
long friendly_sizestr_to_sizelong(char*);
long get_time(void);
int get_last_filelist_number(struct s_bkpinfo *);
long get_phys_size_of_drive(char*drive);
int grab_percentage_from_last_line_of_file(char*);
void initialize_raidrec(struct raid_device_record*);
int is_this_device_mounted(char*);
char *last_line_of_file(char*);
struct s_node *load_filelist(char*);
void log_it(char*);
long long length_of_file(char*);
void log_tape_pos(void);
int make_hole_for_file(char*);
int make_checksum_list_file(char *filelist, char*cksumlist, char*comppath);
char *marker_to_string(int);
int mount_CDROM_here(char*,char*);
long noof_lines_that_match_wildcard(char*,char*);
char *number_to_text(int i);
int openin_cdstream(struct s_bkpinfo *);
int openin_tape(struct s_bkpinfo *);
int openout_cdstream(char*,int);
int openout_tape(char*);
int read_cfg_var(char*,char*,char*);
int read_file_from_tape_to_file(struct s_bkpinfo*, char*, long long);
int read_file_from_tape_to_stream(struct s_bkpinfo*, FILE*, long long);
int read_file_from_tape_FULL(struct s_bkpinfo*, char*, FILE*, long long);
int read_header_block_from_tape(long long *, char*, int *);
void reload_filelist(struct s_node*);
void reset_bkpinfo(struct s_bkpinfo*);
int run_program_and_log_output(char*);
int run_program_and_log_to_screen(char*, char*);
void save_filelist(struct s_node*, char*);
void setup_shared_memory(void);
bool should_we_write_to_next_tape(long, long long);
long size_of_all_biggiefiles_K(struct s_bkpinfo *);
char *slice_fname(long, long, char*, char*);
void sort_mountlist_by_device(struct mountlist_itself*);
long long space_occupied_by_cd(char*);
int start_to_read_from_next_tape(struct s_bkpinfo*);
int start_to_write_to_next_tape(struct s_bkpinfo*);
int strcmp_inc_numbers(char*,char*);
char *strip_afio_output_line(char*);
void strip_spaces(char*);
void toggle_all_root_dirs_on(struct s_node*);
void toggle_branch_selection(struct s_node*, char*, bool);
void toggle_node_selection(struct s_node*, bool);
void toggle_path_expandability(struct s_node *, char*, bool);
char *trim_empty_quotes(char*);
char which_boot_loader(char*);
int write_cfg_var(char*,char*,char*);
int write_data_disks_to_tape(char*);
int write_file_to_tape_from_file(struct s_bkpinfo*, char*);
int write_file_to_tape_from_stream(struct s_bkpinfo*, FILE*);
int write_header_block_to_tape(long long, char*, int);
int write_one_liner_data_file(char*fname,char*contents);
void wrong_marker(int,int);
int zero_out_a_device(char*);



/* ------------------ subroutines ------------------ */


long g_original_noof_lines_in_filelist=0;




/* function declarations */
unsigned int updcrc(unsigned int,unsigned int);
unsigned int updcrcr(unsigned int,unsigned int);


/* variables */
unsigned int crc16tab[256] =
{
	0x0000, 0xC0C1, 0xC181, 0x0140, 0xC301, 0x03C0, 0x0280, 0xC241,
	0xC601, 0x06C0, 0x0780, 0xC741, 0x0500, 0xC5C1, 0xC481, 0x0440,
	0xCC01, 0x0CC0, 0x0D80, 0xCD41, 0x0F00, 0xCFC1, 0xCE81, 0x0E40,
	0x0A00, 0xCAC1, 0xCB81, 0x0B40, 0xC901, 0x09C0, 0x0880, 0xC841,
	0xD801, 0x18C0, 0x1980, 0xD941, 0x1B00, 0xDBC1, 0xDA81, 0x1A40,
	0x1E00, 0xDEC1, 0xDF81, 0x1F40, 0xDD01, 0x1DC0, 0x1C80, 0xDC41,
	0x1400, 0xD4C1, 0xD581, 0x1540, 0xD701, 0x17C0, 0x1680, 0xD641,
	0xD201, 0x12C0, 0x1380, 0xD341, 0x1100, 0xD1C1, 0xD081, 0x1040,
	0xF001, 0x30C0, 0x3180, 0xF141, 0x3300, 0xF3C1, 0xF281, 0x3240,
	0x3600, 0xF6C1, 0xF781, 0x3740, 0xF501, 0x35C0, 0x3480, 0xF441,
	0x3C00, 0xFCC1, 0xFD81, 0x3D40, 0xFF01, 0x3FC0, 0x3E80, 0xFE41,
	0xFA01, 0x3AC0, 0x3B80, 0xFB41, 0x3900, 0xF9C1, 0xF881, 0x3840,
	0x2800, 0xE8C1, 0xE981, 0x2940, 0xEB01, 0x2BC0, 0x2A80, 0xEA41,
	0xEE01, 0x2EC0, 0x2F80, 0xEF41, 0x2D00, 0xEDC1, 0xEC81, 0x2C40,
	0xE401, 0x24C0, 0x2580, 0xE541, 0x2700, 0xE7C1, 0xE681, 0x2640,
	0x2200, 0xE2C1, 0xE381, 0x2340, 0xE101, 0x21C0, 0x2080, 0xE041,
	0xA001, 0x60C0, 0x6180, 0xA141, 0x6300, 0xA3C1, 0xA281, 0x6240,
	0x6600, 0xA6C1, 0xA781, 0x6740, 0xA501, 0x65C0, 0x6480, 0xA441,
	0x6C00, 0xACC1, 0xAD81, 0x6D40, 0xAF01, 0x6FC0, 0x6E80, 0xAE41,
	0xAA01, 0x6AC0, 0x6B80, 0xAB41, 0x6900, 0xA9C1, 0xA881, 0x6840,
	0x7800, 0xB8C1, 0xB981, 0x7940, 0xBB01, 0x7BC0, 0x7A80, 0xBA41,
	0xBE01, 0x7EC0, 0x7F80, 0xBF41, 0x7D00, 0xBDC1, 0xBC81, 0x7C40,
	0xB401, 0x74C0, 0x7580, 0xB541, 0x7700, 0xB7C1, 0xB681, 0x7640,
	0x7200, 0xB2C1, 0xB381, 0x7340, 0xB101, 0x71C0, 0x7080, 0xB041,
	0x5000, 0x90C1, 0x9181, 0x5140, 0x9301, 0x53C0, 0x5280, 0x9241,
	0x9601, 0x56C0, 0x5780, 0x9741, 0x5500, 0x95C1, 0x9481, 0x5440,
	0x9C01, 0x5CC0, 0x5D80, 0x9D41, 0x5F00, 0x9FC1, 0x9E81, 0x5E40,
	0x5A00, 0x9AC1, 0x9B81, 0x5B40, 0x9901, 0x59C0, 0x5880, 0x9841,
	0x8801, 0x48C0, 0x4980, 0x8941, 0x4B00, 0x8BC1, 0x8A81, 0x4A40,
	0x4E00, 0x8EC1, 0x8F81, 0x4F40, 0x8D01, 0x4DC0, 0x4C80, 0x8C41,
	0x4400, 0x84C1, 0x8581, 0x4540, 0x8701, 0x47C0, 0x4680, 0x8641,
	0x8201, 0x42C0, 0x4380, 0x8341, 0x4100, 0x81C1, 0x8081, 0x4040
};
unsigned int crctttab[256] =
{
	0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50A5, 0x60C6, 0x70E7,
	0x8108, 0x9129, 0xA14A, 0xB16B, 0xC18C, 0xD1AD, 0xE1CE, 0xF1EF,
	0x1231, 0x0210, 0x3273, 0x2252, 0x52B5, 0x4294, 0x72F7, 0x62D6,
	0x9339, 0x8318, 0xB37B, 0xA35A, 0xD3BD, 0xC39C, 0xF3FF, 0xE3DE,
	0x2462, 0x3443, 0x0420, 0x1401, 0x64E6, 0x74C7, 0x44A4, 0x5485,
	0xA56A, 0xB54B, 0x8528, 0x9509, 0xE5EE, 0xF5CF, 0xC5AC, 0xD58D,
	0x3653, 0x2672, 0x1611, 0x0630, 0x76D7, 0x66F6, 0x5695, 0x46B4,
	0xB75B, 0xA77A, 0x9719, 0x8738, 0xF7DF, 0xE7FE, 0xD79D, 0xC7BC,
	0x48C4, 0x58E5, 0x6886, 0x78A7, 0x0840, 0x1861, 0x2802, 0x3823,
	0xC9CC, 0xD9ED, 0xE98E, 0xF9AF, 0x8948, 0x9969, 0xA90A, 0xB92B,
	0x5AF5, 0x4AD4, 0x7AB7, 0x6A96, 0x1A71, 0x0A50, 0x3A33, 0x2A12,
	0xDBFD, 0xCBDC, 0xFBBF, 0xEB9E, 0x9B79, 0x8B58, 0xBB3B, 0xAB1A,
	0x6CA6, 0x7C87, 0x4CE4, 0x5CC5, 0x2C22, 0x3C03, 0x0C60, 0x1C41,
	0xEDAE, 0xFD8F, 0xCDEC, 0xDDCD, 0xAD2A, 0xBD0B, 0x8D68, 0x9D49,
	0x7E97, 0x6EB6, 0x5ED5, 0x4EF4, 0x3E13, 0x2E32, 0x1E51, 0x0E70,
	0xFF9F, 0xEFBE, 0xDFDD, 0xCFFC, 0xBF1B, 0xAF3A, 0x9F59, 0x8F78,
	0x9188, 0x81A9, 0xB1CA, 0xA1EB, 0xD10C, 0xC12D, 0xF14E, 0xE16F,
	0x1080, 0x00A1, 0x30C2, 0x20E3, 0x5004, 0x4025, 0x7046, 0x6067,
	0x83B9, 0x9398, 0xA3FB, 0xB3DA, 0xC33D, 0xD31C, 0xE37F, 0xF35E,
	0x02B1, 0x1290, 0x22F3, 0x32D2, 0x4235, 0x5214, 0x6277, 0x7256,
	0xB5EA, 0xA5CB, 0x95A8, 0x8589, 0xF56E, 0xE54F, 0xD52C, 0xC50D,
	0x34E2, 0x24C3, 0x14A0, 0x0481, 0x7466, 0x6447, 0x5424, 0x4405,
	0xA7DB, 0xB7FA, 0x8799, 0x97B8, 0xE75F, 0xF77E, 0xC71D, 0xD73C,
	0x26D3, 0x36F2, 0x0691, 0x16B0, 0x6657, 0x7676, 0x4615, 0x5634,
	0xD94C, 0xC96D, 0xF90E, 0xE92F, 0x99C8, 0x89E9, 0xB98A, 0xA9AB,
	0x5844, 0x4865, 0x7806, 0x6827, 0x18C0, 0x08E1, 0x3882, 0x28A3,
	0xCB7D, 0xDB5C, 0xEB3F, 0xFB1E, 0x8BF9, 0x9BD8, 0xABBB, 0xBB9A,
	0x4A75, 0x5A54, 0x6A37, 0x7A16, 0x0AF1, 0x1AD0, 0x2AB3, 0x3A92,
	0xFD2E, 0xED0F, 0xDD6C, 0xCD4D, 0xBDAA, 0xAD8B, 0x9DE8, 0x8DC9,
	0x7C26, 0x6C07, 0x5C64, 0x4C45, 0x3CA2, 0x2C83, 0x1CE0, 0x0CC1,
	0xEF1F, 0xFF3E, 0xCF5D, 0xDF7C, 0xAF9B, 0xBFBA, 0x8FD9, 0x9FF8,
	0x6E17, 0x7E36, 0x4E55, 0x5E74, 0x2E93, 0x3EB2, 0x0ED1, 0x1EF0
};




/* update crc */
unsigned int updcrc(unsigned int crc,unsigned int c)
{
	unsigned int tmp;
	tmp=(crc>>8)^c;
	crc=(crc<<8)^crctttab[tmp&255];
	return crc;
}

/* update crc reverse */
unsigned int updcrcr(crc,c)
unsigned int crc; unsigned int c;
{
	unsigned int tmp;
	tmp=crc^c;
	crc=(crc>>8)^crc16tab[tmp & 0xff];
	return crc;
}






char *calc_checksum_of_file(char*filename)
{
  static char output[MAX_STR_LEN];
  char command[MAX_STR_LEN], tmp[MAX_STR_LEN], *p;
  FILE*fin;
  p=output;
  if (does_file_exist(filename))
    {
      sprintf(command,"md5sum \"%s\"",filename);
      fin=popen(command,"r");
      if (fin)
        {
	  fgets(output,MAX_STR_LEN,fin);
	  p=strchr(output,' ');
	  pclose(fin);
        }
    }
  else
    {
      sprintf(tmp,"File '%s' not found; cannot calc checksum",filename);
      log_it(tmp);
    }
  if (p) {*p='\0';}
  return(output);
}








char *calc_file_ugly_minichecksum(char *curr_fname)
{
  static char curr_cksum[1000];
  char 
    *sz_ptr;

  struct stat buf;
  curr_cksum[0]='\0';
  
  if (lstat(curr_fname,&buf))
    {return(curr_cksum);}

  sprintf(curr_cksum,"%ld-%ld-%ld",(long)(buf.st_size),(long)(buf.st_mtime),(long)(buf.st_ctime));
  return(curr_cksum); 
      /*
    }
  CalcCksum(curr_cksum,curr_fname);
*/
  /*
  sprintf(syscall,"cksum \"%s\" 2> /dev/null",curr_fname);

  pout=popen(syscall,"r");
  if (!pout)
    {return(curr_cksum);}
  fgets(curr_cksum,999,pout);
  pclose(pout);
  */

  sz_ptr=(char*)strchr(curr_cksum,' ');
  if (!sz_ptr) { sz_ptr=curr_cksum; }
  *sz_ptr='\0';
  return(curr_cksum);
}



char *call_program_and_get_last_line_of_output(char *call)
{
  static char result[MAX_STR_LEN];
  char tmp[MAX_STR_LEN];
  FILE*fin;

  result[0]='\0';
  if ((fin=popen(call,"r")))
    {
      for(fgets(tmp,MAX_STR_LEN,fin); !feof(fin); fgets(tmp,MAX_STR_LEN,fin))
        {
          if (strlen(tmp)>1) {strcpy(result,tmp);}
        }
      pclose(fin);
    }
  strip_spaces(result);
  return(result);
}




void center_string(char*in_out,int width)
{
  char scratch[MAX_STR_LEN],*p;
  int i,len,mid,x;

  if (strlen(in_out)==0) {return;}
  for(p=in_out; *p==' '; p++);
  strcpy(scratch,p);
  len=strlen(scratch);
  mid = width/2;
  x = mid - len/2;
  for(i=0;i<x;i++)
    { in_out[i]=' '; }
  in_out[i]='\0';
  strcat(in_out,scratch);
}





int closein_cdstream(struct s_bkpinfo *bkpinfo)
{
  return(closein_tape(bkpinfo));
}



int closein_tape(struct s_bkpinfo *bkpinfo)
{
  int retval=0,res=0,ctrl_chr='\0';
  char fname[MAX_STR_LEN];
  long long size;

  res=read_header_block_from_tape(&size, fname, &ctrl_chr);
  retval+=res;
  if (ctrl_chr != BLK_END_OF_BACKUP) { wrong_marker(BLK_END_OF_BACKUP, ctrl_chr); }
  res=read_header_block_from_tape(&size, fname, &ctrl_chr);
  retval+=res;
  if (ctrl_chr != BLK_END_OF_TAPE) { wrong_marker(BLK_END_OF_TAPE,ctrl_chr); }
  pclose(g_tape_stream);
  return(retval);
}






long count_lines_in_file(char *filename)
{
  char command[MAX_STR_LEN],incoming[MAX_STR_LEN],tmp[MAX_STR_LEN];
  long noof_lines=-1L;
  FILE*fin;
  incoming[0]='\0';

/*
  sprintf(tmp,"Counting the lines in file '%s'",filename);
  log_it(tmp);
*/
  if (!does_file_exist(filename))
    {
      sprintf(tmp,"%s does not exist, so I cannot found the number of lines in it",filename);
      log_it(tmp);
      return(0);
    }
  sprintf(command,"grep -n \"\" %s | tail -n1 | cut -d':' -f1 2> /dev/null",filename);
  fin=popen(command,"r");
  if (fin)
    {
      if (feof(fin))
        {
          noof_lines=0;
        }
      else
        {
          fgets(incoming,MAX_STR_LEN-1,fin);
          while (strlen(incoming)>0 && incoming[strlen(incoming)-1]<32)
            { incoming[strlen(incoming)-1]='\0'; }
          noof_lines=atol(incoming);
        }
      pclose(fin);
    }
/*
  sprintf(tmp,"File '%s' has %ld lines in it",filename,noof_lines);
  log_it(tmp);
*/
  return(noof_lines);
}




bool does_file_exist(char*filename)
{
  struct stat buf;

  if (lstat(filename,&buf))
    {
      return(FALSE);
    }
  else
    {
      return(TRUE);
    }
}





int does_partition_exist(char *drive, int partno)
{
  char program[MAX_STR_LEN], incoming[MAX_STR_LEN], searchstr[MAX_STR_LEN];
  int res=0;
  FILE *fin;
  sprintf(searchstr,"%s%d ",drive,partno);
  sprintf(program,"fdisk -l %s 2> /dev/null",drive);
  fin=popen(program,"r");
  if (!fin) {return(0);}
  fgets(incoming,MAX_STR_LEN-1,fin);
  for(res=0; !feof(fin) && !res; fgets(incoming,MAX_STR_LEN-1,fin))
    {
      if (strstr(incoming,searchstr))
	{
	  res=1;
	}
    }
  pclose(fin);
  return(res);
}




bool does_string_exist_in_boot_block(char*dev, char*str)
{
  char command[MAX_STR_LEN];

  sprintf(command,"dd if=%s bs=446 count=1 2> /dev/null | strings | grep \"%s\" > /dev/null 2> /dev/null",dev,str);
  if (system(command))
    { return(FALSE); }
  else
    { return(TRUE); }
}





void exclude_nonexistent_files(char*inout)
{
  char infname[MAX_STR_LEN], outfname[MAX_STR_LEN], tmp[MAX_STR_LEN],
    incoming[MAX_STR_LEN];
  int i;
  FILE*fin,*fout;
  sprintf(infname,"%s.in",inout);
  sprintf(outfname,"%s",inout);
  sprintf(tmp,"cp -f %s %s",inout,infname);
  run_program_and_log_output(tmp);
  fin=fopen(infname,"r");
  fout=fopen(outfname,"w");
  for(fgets(incoming,MAX_STR_LEN,fin);!feof(fin);fgets(incoming,MAX_STR_LEN,fin))
    {
      i=strlen(incoming)-1;
      if (i>=0 && incoming[i]<32) {incoming[i]='\0';}
      if (does_file_exist(incoming)) {fprintf(fout,"%s\n",incoming);}
      else {sprintf(tmp,"Excluding '%s'-nonexistent\n",incoming);log_it(tmp);}
    }
  fclose(fout);
  fclose(fin);
  unlink(infname);
}






void fatal_error(char*error_string)
{
  char fatalstr[MAX_STR_LEN]="-------FATAL ERROR---------";
/* log_it("bloody bugger from the inner most hot corners of hell!"); */
  if (!g_text_mode)
    {
      log_it(fatalstr);
      log_it(error_string);
      newtFinished();
    }
  printf("%s\n",fatalstr);
  printf("%s\n",error_string);
  printf("Author can and will render assistance only to users who include a gzipped copy of\n");
  printf("/var/log/mondo-archive.log in their bug report and who have already read the FAQ.\n");
  printf("Mondo-archive has aborted.\n");
  exit(1);
}





int find_and_mount_actual_cd(struct s_bkpinfo *bkpinfo, char*mountpoint)
{
  char tmp[MAX_STR_LEN];
  int res;

  mvaddstr_and_log_it(g_currentY,0,"");
/*  if (bkpinfo->media_device[0]=='\0')
    {
*/
      res=find_cdrom_device(bkpinfo->media_device);
      sprintf(tmp,"g_cdrom_device = %s",bkpinfo->media_device);
      log_it(tmp);
      if (res)
	{
	  if (!popup_and_get_string("CD-RW device","Please enter your CD-RW's /dev device",bkpinfo->media_device))
	    { res=1; }
	  else
	    { res=0; }
	}
//    }
  if (res) { return(res); }
  if (mount_CDROM_here(bkpinfo->media_device,mountpoint))
    {
      strcpy(bkpinfo->media_device,"/dev/scd0");
      if ((res=mount_CDROM_here(bkpinfo->media_device,mountpoint)))
	{
	  strcpy(bkpinfo->media_device,"/dev/sr0");
	  if ((res=mount_CDROM_here(bkpinfo->media_device,mountpoint)))
	    {
	      strcpy(bkpinfo->media_device,"/dev/scd1");
	      if ((res=mount_CDROM_here(bkpinfo->media_device,mountpoint)))
		{
		  strcpy(bkpinfo->media_device,"/dev/sr1");
                  if ((res=mount_CDROM_here(bkpinfo->media_device,mountpoint)))
		    {
		      if (!popup_and_get_string("CDRW device","Please enter your CDRW's /dev device",bkpinfo->media_device))
			{ res=1; }
		      else
			{
                          res=mount_CDROM_here(bkpinfo->media_device,mountpoint);
                        }
		    }
		}
	    }
	}
    }
  return(res);
}




int find_cdrom_device(char*output)
{
  FILE*fin;
  bool found_it=FALSE;
  char tmp[MAX_STR_LEN], *p, *q, *r, phrase_one[MAX_STR_LEN],phrase_two[MAX_STR_LEN], command[MAX_STR_LEN];
  output[0]=phrase_one[0]=phrase_two[0]='\0';
  fin=popen("cdrecord -scanbus","r");
  if (!fin) { return(1); }
  for(fgets(tmp,MAX_STR_LEN,fin); !feof(fin); fgets(tmp,MAX_STR_LEN,fin))
    {
      p=strchr(tmp,'\'');
      if (p)
	{
	  q=strchr(++p,'\'');
	  if (q)
	    {
	      for(r=q;*(r-1)==' ';r--);
	      *r='\0';
	      strcpy(phrase_one,p);
	      p=strchr(++q,'\'');
	      if (p)
		{
		  q=strchr(++p,'\'');
		  if (q)
		    {
		      while(*(q-1)==' ') {q--;}
		      *q='\0';
		      strcpy(phrase_two,p);
		    }
		}
	    }
	}
    }
  pclose(fin);
  sprintf(command,"dmesg | grep %s",phrase_two);
  fin=popen(command,"r");
  if (fin)
    {
      for(fgets(tmp,MAX_STR_LEN,fin); !feof(fin); fgets(tmp,MAX_STR_LEN,fin))
	{
	  if (tmp[0]!=' ' && tmp[1]!=' ')
	    {
	      p=strchr(tmp,':');
	      if (p)
		{
		  *p='\0';
		  sprintf(output,"/dev/%s",tmp);
		  found_it=TRUE;
		}
	    }
	}
      pclose(fin);
    }
  if (found_it) { return(0); } else { return(1); }
}







void finish(int signal)
{
  /*  if (signal==0) { popup_and_OK("Please press <enter> to quit."); } */

  /* newtPopHelpLine(); */

  if (!g_text_mode) { newtFinished(); }
  /* system("clear"); */
  if (does_file_exist("/tmp/mondo-restore.log"))
    {
      printf("Type 'less /tmp/mondo-restore.log' to see the output log\n");
    }
  exit(signal);
}



void free_filelist(struct s_node*filelist)
{
  static int depth=0;
  static long i=0;
  int percentage;

  if (depth==0) { open_evalcall_form("Freeing memory"); log_to_screen("Freeing memory formerly occupied by filelist"); }
  depth++;

  if (filelist->ch=='\0')
    {
      if (!(i++ % 1111))
        {
          percentage=(int)(i*100/g_original_noof_lines_in_filelist);
          update_evalcall_form(percentage);

        }
    }

  if (filelist->right)
    {
      free_filelist(filelist->right);
      filelist->right = NULL;
    }
  if (filelist->down)
    {
/*      if (!(i++ %39999)) { update_evalcall_form(0); } */
      free_filelist(filelist->down);
      filelist->down = NULL;
    }
  filelist->ch='\0';
  free(filelist);
  depth--;
  if (depth==0) { close_evalcall_form(); log_it("Finished freeing memory"); }
}




long friendly_sizestr_to_sizelong(char*incoming)
{
  long outval;
  int i;
  char tmp[MAX_STR_LEN], ch;
  strcpy(tmp,incoming);
  for(i=0; i<strlen(tmp) && isdigit(tmp[i]); i++);
  ch=tmp[i];
  tmp[i]='\0';
  outval = atol(tmp);
  if (ch=='g') { outval = outval*1024; }
  else if (ch=='k') { outval = outval/1024; }
  return(outval);
}




int get_last_filelist_number(struct s_bkpinfo *bkpinfo)
{
  char val_sz[MAX_STR_LEN], cfg_fname[MAX_STR_LEN], tmp[MAX_STR_LEN];
  long val_i;

  sprintf(cfg_fname, "%s/mondo-restore.cfg", bkpinfo->tmpdir);
  read_cfg_var(cfg_fname, "last-filelist-number", val_sz);
  val_i = atoi(val_sz);
  if (val_i<=0) { val_i = 500; }
  return(val_i);

/*
  FILE*fin;
  char fname[MAX_STR_LEN],incoming[MAX_STR_LEN+1];
  int res=-1,i;
  sprintf(fname, "%s/LAST-FILELIST-NUMBER",bkpinfo->tmpdir);
  fin=fopen(fname,"r");
  if (fin)
    {
      fgets(incoming,MAX_STR_LEN,fin);
      fclose(fin);
      for(i=strlen(incoming); incoming[i-1]<32; i--);
      incoming[i]='\0';
      res=atoi(incoming);
    }
  else
    {
      log_it("WARNING - unable to find LAST-FILELIST-NUMBER");
    }
  return(res);
*/
}





long get_phys_size_of_drive(char*drive)
{
  FILE*fin;
  char tmp[MAX_STR_LEN], command[MAX_STR_LEN], *p, *q, *r;
  long outL, tempLa, tempLb, tempLc;

  sprintf(command, "fdisk -l %s | head -n4 | tr -s '\n' '\t' | tr -s ' ' '\t' | cut -f8,14,16", drive);
  strcpy(tmp, call_program_and_get_last_line_of_output(command));
  if (tmp[0])
    {
      p=tmp;
      q=strchr(p, ' ');
      if (q)
	{
	  *(q++)='\0';
	  r=strchr(q, ' ');
	  if (r)
	    {
	      *(r++)='\0';
	      tempLa=atol(p);
	      tempLb=atol(q);
	      tempLc=atol(r);
              outL=tempLa*tempLb/1024*tempLc/1024;
	      if (outL>100) { return(outL); }
	    }
	}
    }
  /* else, do it the old-fashioned way */
  p=strrchr(drive,(int)'/');
  if (p) { strcpy(tmp,p+1); } else { return(-1); }
  sprintf(command,"dmesg | grep %s 2> /dev/null",tmp);
  fin=popen(command,"r");
  fgets(tmp,MAX_STR_LEN-1,fin);
  while(!feof(fin) && !strstr(tmp,"GB") && !strstr(tmp,"MB"))
    {
      fgets(tmp,MAX_STR_LEN-1,fin);
    }
  pclose(fin);
  if (!(p=strstr(tmp,"GB")) && !(p=strstr(tmp,"MB")))
    {
      sprintf(tmp,"Cannot find %s's size: dmesg isn't helping either.",drive);
      log_it(tmp);
      return(-1);
    }
  for(; !isdigit(*(p-1)); p--);
  *p='\0';
  for(p--; isdigit(*(p-1)); p--);
  outL=atol(p);
  if (outL<=0) { return(-1); }
  if (strstr(tmp,"GB")) { outL=outL*1024; }
  return(outL*20/19);
}




long get_time()
{
  FILE*fin;
  char incoming[MAX_STR_LEN];
  fin=popen("date +%s","r");
  fgets(incoming,MAX_STR_LEN-1,fin);
  pclose(fin);
  return(atol(incoming));
}



int grab_percentage_from_last_line_of_file(char*filename)
{
  char tmp[MAX_STR_LEN],lastline[MAX_STR_LEN], *p;
  int i;
  /* strcpy(lastline,last_line_of_file(filename)); */
  strcpy(lastline,err_log_lines[NOOF_ERR_LINES-1]);
  sprintf(tmp,"lastline = %s",lastline);
  p=strstr(lastline,"% done");
  if (!p) {p=strstr(lastline,"%% Done");}
  if (!p) {p=strstr(lastline,"%% ");}
  if (!p) {return(0);}
  *p='\0';
  /*
 sprintf(tmp,"lastline = '%s'");
 log_to_screen(tmp);
  */
  for(p-=1; *p!=' ' && p!=lastline; p--);
  if (p!=lastline) { p++; }
  i=atoi(p);
  /*
    sprintf(tmp,"'%s' --> %d",p,i);
    log_to_screen(tmp);
  */
  return(i);
}


void initialize_raidrec(struct raid_device_record *raidrec)
{
  raidrec->raid_device[0]='\0';
  raidrec->raid_level=0;
  raidrec->chunk_size=4;
  raidrec->persistent_superblock=1;
  raidrec->data_disks.entries=0;
  raidrec->spare_disks.entries=0;
  raidrec->parity_disks.entries=0;
  raidrec->failed_disks.entries=0;
  raidrec->additional_vars.entries=0;
}





int is_this_device_mounted(char *device_raw)
{
  FILE*fin;
  char incoming[MAX_STR_LEN], device_with_tab[MAX_STR_LEN], device_with_space[MAX_STR_LEN], tmp[MAX_STR_LEN];
  sprintf(device_with_tab,"%s\t",device_raw);
  sprintf(device_with_space,"%s ",device_raw);
  fin=fopen("/proc/mounts","r");
  for(fgets(incoming,MAX_STR_LEN-1,fin); !feof(fin); fgets(incoming,MAX_STR_LEN-1,fin))
    {
      if (strstr(incoming,device_with_space) || strstr(incoming,device_with_tab))
	{
	  fclose(fin);
	  return(1);
	}
    }
  fclose(fin);
  sprintf(tmp,"cat /proc/swaps | grep \"%s\" > /dev/null 2> /dev/null", device_with_space);
  if (!system(tmp)) { return(1); }
  return(0);
}






char *last_line_of_file(char*filename)
{
  static char output[MAX_STR_LEN],command[MAX_STR_LEN],tmp[MAX_STR_LEN];
  FILE*fin;
  if (!does_file_exist(filename))
    {
      sprintf(tmp,"Tring to get last line of nonexistent file (%s)",filename);
      log_it(tmp);
      output[0]='\0';
      return(output);
    }
  sprintf(command,"cat %s | tail -n1",filename);
  fin=popen(command,"r");
  fgets(output,MAX_STR_LEN,fin);
  pclose(fin);
  while (strlen(output)>0 && output[strlen(output)-1]<32)
    { output[strlen(output)-1]='\0'; }
  return(output);
}



char *leftpad_string(char*incoming,int width)
{
  static char output[MAX_STR_LEN];
  int i;
  strcpy(output,incoming);
  for(i=strlen(output); i<width;i++) { output[i]=' '; }
  output[i]='\0';
  return(output);
}




long long length_of_file(char *filename)
{
  FILE*fin;
  long long length;
  fin=fopen(filename,"r");
  if (!fin)
    {return(-1);}
  fseek(fin,0,SEEK_END);
  length=ftell(fin);
  fclose(fin);
  return(length);
}




int add_string_at_node(struct s_node *startnode, char*string_to_add)
{
  int noof_chars, i;
  struct s_node *node, *newnode;
  char char_to_add;
  const bool sosodef=FALSE;

  noof_chars = strlen(string_to_add)+1; /* we include the '\0' */
/* walk across tree */
  node = startnode;
  char_to_add = string_to_add[0];
  for(node=startnode; node->right!=NULL && node->ch < char_to_add; node=node->right);
/* walk down tree if appropriate */
  if (node->ch==char_to_add)
    {
      if (noof_chars==1 && char_to_add=='\0')
        { log_it("Already present. "); return(1); }
      if (!node->down)
        { log_it("Partially listed but it carries on and I don't"); return(1); }
      return(add_string_at_node(node->down, string_to_add+1));
    }
/* else, add node(s) here */
  if (!(newnode = malloc(sizeof(struct s_node))))
    { log_to_screen("failed to malloc"); return(1); }

  memcpy(newnode, node, sizeof(struct s_node));
  node->right = newnode;
  node->ch = char_to_add;
  node->down = NULL;
  node->expanded = node->selected = FALSE;

  if (char_to_add=='\0') { node->selected = sosodef; return(0); }
  for(i=1; i<noof_chars; i++)
    {
      if (!(node->down = malloc(sizeof(struct s_node)))) { log_to_screen("failed to malloc"); return(1); }
      node = node->down;
      char_to_add = string_to_add[i];
      node->ch = char_to_add;
      node->right = node->down = NULL;
      node->expanded = node->selected = FALSE;
    }
  if (char_to_add=='\0') { node->selected = sosodef; return(0); }
  return(0);
}





struct s_node *load_filelist(char*filelist_fname)
{
  struct s_node *filelist;
  FILE*fin;
  char fname[MAX_STR_LEN], tmp[MAX_STR_LEN];
  int percentage;
  long lines_in_filelist, lino=0;

  log_to_screen("Loading filelist");
  lines_in_filelist = count_lines_in_file(filelist_fname);
  g_original_noof_lines_in_filelist = lines_in_filelist;
  if (!(filelist=malloc(sizeof(struct s_node)))) {return(NULL);}
  filelist->ch = '\0';
  filelist->right = filelist->down = NULL;
  filelist->expanded = filelist->selected = FALSE;
  if (!(fin=fopen(filelist_fname,"r"))) {return(NULL);}
  open_evalcall_form("Loading filelist from disk");
  for(fgets(fname, MAX_STR_LEN, fin); !feof(fin); fgets(fname, MAX_STR_LEN, fin))
    {
      strip_spaces(fname);
      if (!strlen(fname)) { continue; }
      if (add_string_at_node(filelist, fname))
        {
          sprintf(tmp,"Did not load '%s' into filelist",fname);
          log_it(tmp);
        }
      if (!(++lino %1111))
        {
          percentage=(int)(lino*100/lines_in_filelist);
          update_evalcall_form(percentage);
        }
    }
  fclose(fin);
  close_evalcall_form();
  log_it("Finished loading filelist");
  return(filelist);
}



void log_it(char *o)
{
  FILE*fout;
  char output[MAX_STR_LEN];
  int i;
  if (o[0]=='\0') {return;}
  strcpy(output,o);
  i=strlen(output);
  if (i<=0) { return; }
  if (output[i-1]<32) { output[i-1]='\0'; }
  if (g_text_mode /* && !strstr(last_line_of_file(MONDO_LOGFILE),output) */) {printf("%s\n",output);}
  fout=fopen(MONDO_LOGFILE,"a");
  if (fout)
    {
      fprintf(fout,"%s\n",output);
      fclose(fout);
    }
}



void log_tape_pos(void)
{
  char tmp[MAX_STR_LEN];
  sprintf(tmp,"Tape position -- %ld KB (%ld MB)",(long) g_tape_posK, (long) g_tape_posK>>10);
  log_it(tmp);
}







int make_checksum_list_file(char *filelist, char*cksumlist, char*comppath)
{
  FILE*fin,
    *fout;
  int percentage,
    i,
    counter=0;
  char stub_fname[1000],
    curr_fname[1000],
    curr_cksum[1000],
    tmp[1000];
  long filelist_length, curr_pos, start_time, current_time, time_taken, time_remaining;
  start_time=get_time();
  filelist_length=length_of_file(filelist);
  sprintf(tmp,"filelist = %s; cksumlist = %s",filelist,cksumlist);
  log_it(tmp);
  fin=fopen(filelist,"r");
  if (fin==NULL) {log_to_screen("Can't open filelist");return(1);}
  fout=fopen(cksumlist,"w");
  if (fout==NULL) {fclose(fin); log_to_screen("Can't open checksum list");return(1);}
  for( fgets(stub_fname,999,fin); !feof(fin); fgets(stub_fname,999,fin) )
    {
      if (stub_fname[(i=strlen(stub_fname)-1)]<32) {stub_fname[i]='\0';}
      sprintf(tmp,"%s%s",comppath,stub_fname);
      strcpy(curr_fname,tmp+1);
      strcpy(curr_cksum,calc_file_ugly_minichecksum(curr_fname));
      fprintf(fout,"%s\t%s\n",curr_fname,curr_cksum);
      if (counter++>12)
	{
	  current_time=get_time();
	  counter=0;
	  curr_fname[37]='\0';
	  curr_pos = ftell(fin)/1024;
	  percentage = (int)(curr_pos*100/filelist_length);
	  time_taken = current_time - start_time;
	  if (percentage==0)
	    {
	      /*	      printf("%0d%% done      \r",percentage); */
	    }
	  else
	    {
	      time_remaining = time_taken*100/(long)(percentage) - time_taken;
	      sprintf(tmp,"%02d%% done   %02d:%02d taken   %02d:%02d remaining  %-37s\r",percentage,(int)(time_taken/60),(int)(time_taken%60),(int)(time_remaining/60),(int)(time_remaining%60),curr_fname);
              log_to_screen(tmp);
	    }
	  sync();
       }
    }
  fclose(fout);
  fclose(fin);
  log_it("Done.");
  return(0);
}









int make_hole_for_file(char*outfile_fname)
{
  char command[MAX_STR_LEN];
  int res=0;
  sprintf(command,"mkdir -p \"%s\" 2> /dev/null",outfile_fname);
  res+=system(command);
  sprintf(command,"rmdir \"%s\" 2> /dev/null",outfile_fname);
  res+=system(command);
  sprintf(command,"rm -f \"%s\" 2> /dev/null",outfile_fname);
  res+=system(command);
  return(0);
}




char *marker_to_string(int marker)
{
  static char outstr[MAX_STR_LEN];
  switch(marker)
    {
      case BLK_START_OF_BACKUP: strcpy(outstr,"BLK_START_OF_BACKUP"); break;
      case BLK_START_OF_TAPE: strcpy(outstr,"BLK_START_OF_TAPE"); break;
      case BLK_START_AN_AFIO_OR_SLICE:   strcpy(outstr,"BLK_START_AN_AFIO_OR_SLICE"); break;
      case BLK_STOP_AN_AFIO_OR_SLICE:    strcpy(outstr,"BLK_STOP_AN_AFIO_OR_SLICE"); break;
      case BLK_START_AFIOBALLS: strcpy(outstr,"BLK_START_AFIOBALLS"); break;
      case BLK_STOP_AFIOBALLS:  strcpy(outstr,"BLK_STOP_AFIOBALLS"); break;
      case BLK_STOP_BIGGIEFILES:strcpy(outstr,"BLK_STOP_BIGGIEFILES"); break;
      case BLK_START_A_BIGGIE:  strcpy(outstr,"BLK_START_A_BIGGIE"); break;
      case BLK_START_BIGGIEFILES:strcpy(outstr,"BLK_START_BIGGIEFILES"); break;
      case BLK_STOP_A_BIGGIE:   strcpy(outstr,"BLK_STOP_A_BIGGIE"); break;
      case BLK_END_OF_TAPE:     strcpy(outstr,"BLK_END_OF_TAPE"); break;
      case BLK_END_OF_BACKUP:   strcpy(outstr,"BLK_END_OF_BACKUP"); break;
      case BLK_ABORTED_BACKUP:  strcpy(outstr,"BLK_ABORTED_BACKUP"); break;
      case BLK_START_FILE:      strcpy(outstr,"BLK_START_FILE"); break;
      case BLK_STOP_FILE:       strcpy(outstr,"BLK_STOP_FILE"); break;
      default:                  sprintf(outstr,"BLK_UNKNOWN (%d)",marker); break;
    }
  return(outstr);
}



int mount_CDROM_here(char*device,char*mountpoint)
{
  char command[MAX_STR_LEN];
  sprintf(command,"mount %s -o ro -t iso9660 %s 2> /dev/null",device,mountpoint);
  log_it(command);
  return(system(command));
}





long noof_lines_that_match_wildcard(char*filelist_fname, char *wildcard)
{
  long matches=0;
  FILE*fin;
  char incoming[MAX_STR_LEN];
  fin=fopen(filelist_fname,"r");
  if (!fin) { return(0); }
  fgets(incoming,MAX_STR_LEN-1,fin);
  while(!feof(fin))
    {
      if (strstr(incoming,wildcard))
	{
	  matches++;
	}
      fgets(incoming,MAX_STR_LEN-1,fin);
    }
  fclose(fin);
  return(matches);
}





char *number_to_text(int i)
{
  static char output[MAX_STR_LEN];
  switch(i)
    {
    case 0:
      strcpy(output,"zero");
      break;
    case 1:
      strcpy(output,"one");
      break;
    case 2:
      strcpy(output,"two");
      break;
    case 3:
      strcpy(output,"three");
      break;
    case 4:
      strcpy(output,"four");
      break;
    case 5:
      strcpy(output,"five");
      break;
    case 6:
      strcpy(output,"six");
      break;
    case 7:
      strcpy(output,"seven");
      break;
    case 8:
      strcpy(output,"eight");
      break;
    case 9:
      strcpy(output,"nine");
    case 10:
      strcpy(output,"ten");
    default:
      sprintf(output,"%d",i);
    }
  return(output);
}





#define BUFFER_EXE_STUFF "-m 13m -p 85"


int openin_cdstream(struct s_bkpinfo *bkpinfo)
{
  return(openin_tape(bkpinfo));
}



int openin_tape(struct s_bkpinfo *bkpinfo)
{
  char fname[MAX_STR_LEN],
    datablock[256*1024], tmp[MAX_STR_LEN], old_cwd[MAX_STR_LEN];
  int i,j,res,retval=0,ctrl_chr;
  long long size;
  char command[MAX_STR_LEN], outfname[MAX_STR_LEN];
  FILE*fout;

  sprintf(outfname,"%s/tmp/all.tar.gz",bkpinfo->tmpdir);
  make_hole_for_file(outfname);
  if (bkpinfo->using_cdstream)
    { sprintf(command,"buffer -i %s -m 1m -p 50 -s %d", bkpinfo->media_device, TAPE_BLOCK_SIZE); /* -u 100 */ }
  else
    { sprintf(command,"buffer -i %s %s -s %d", bkpinfo->media_device, BUFFER_EXE_STUFF, TAPE_BLOCK_SIZE); /* -u 100 */ }
  log_it("Opening IN stream with the command");
  log_it(command);
/*  log_it("Let's see what happens, shall we?"); */
  g_tape_stream = popen(command,"r");
  if (!g_tape_stream) { fatal_error("Cannot openin stream device"); }

  log_to_screen("Reading stream");
  g_current_media_number=1;
  sprintf(tmp,"stream device = '%s'",bkpinfo->media_device);
  log_it(tmp);
  g_tape_posK = 0;
/* skip data disks */
  open_evalcall_form("Skipping data disks on stream");
  log_to_screen("Skipping data disks on stream");
  if (!(fout=fopen(outfname,"w"))) { fatal_error("Cannot openout datadisk all.tar.gz file"); }
  for(i=0;i<32;i++) 
    {
      for(j=0;j<4;j++) 
	{
	  g_tape_posK+=fread(datablock,1,256*1024,g_tape_stream)/1024;
          fwrite(datablock,1,256*1024,fout);
	}
      update_evalcall_form((i*4+j)*100/128);
    }
  fclose(fout);
/* find initial blocks */
  res=read_header_block_from_tape(&size, fname, &ctrl_chr);
  retval+=res;
  if (ctrl_chr != BLK_START_OF_TAPE) { wrong_marker(BLK_START_OF_BACKUP, ctrl_chr); }
  res=read_header_block_from_tape(&size, fname, &ctrl_chr);
  retval+=res;
  if (ctrl_chr != BLK_START_OF_BACKUP) { wrong_marker(BLK_START_OF_BACKUP, ctrl_chr); }
  close_evalcall_form();
  sprintf(tmp,"Saved all.tar.gz to '%s'",outfname);
  log_it(tmp);
/*
  sprintf(tmp,"cp -f %s /tmp", outfname);
  system(tmp);
*/
  getcwd(old_cwd, MAX_STR_LEN);
  chdir(bkpinfo->tmpdir);
  sprintf(tmp,"tar -zxf %s tmp/mondo-restore.cfg",outfname);
  run_program_and_log_output(tmp);
  system("cp -f tmp/mondo-restore.cfg . 2> /dev/null");
  chdir(old_cwd);
  unlink(outfname);
  return(retval);
}




int openout_cdstream(char*cddev, int speed)
{
  char command[MAX_STR_LEN];
/*  add 'dummy' if testing */
  sprintf(command, "cdrecord -eject dev=%s speed=%d fs=24m -waiti - >> %s 2>> %s", cddev, speed, MONDO_LOGFILE, MONDO_LOGFILE);
  log_it("Opening OUT cdstream with the command");
  log_it(command);
/*  log_it("Let's see what happens, shall we?"); */
  g_tape_stream = popen(command,"w");
  if (g_tape_stream) {return(0);} else {log_to_screen("Failed to openout to cdstream (fifo)");return(1);}
}




int openout_tape(char*tapedev)
{
  char command[MAX_STR_LEN];

  sprintf(command,"buffer -o %s %s -s %d", tapedev, BUFFER_EXE_STUFF, TAPE_BLOCK_SIZE);
  log_it("Opening OUT tape with the command");
  log_it(command);
/*  log_it("Let's see what happens, shall we?"); */
  g_tape_stream = popen(command,"w");
  if (g_tape_stream) {return(0);} else {log_to_screen("Failed to openout to tape (fifo)");return(1);}
}






int read_file_from_tape_to_file(struct s_bkpinfo *bkpinfo, char*outfile, long long size)
{
  int res;
  res=read_file_from_tape_FULL(bkpinfo, outfile, NULL, size);
  return(res);
}




int read_file_from_tape_to_stream(struct s_bkpinfo *bkpinfo, FILE*fout, long long size)
{
  int res;
  res=read_file_from_tape_FULL(bkpinfo, NULL, fout, size);
/*  fflush(g_tape_stream);
  fflush(fout);*/
  return(res);
}



int read_file_from_tape_FULL(struct s_bkpinfo *bkpinfo, char*outfname, FILE*foutstream, long long orig_size)
{
  char tmp[MAX_STR_LEN], datablock[TAPE_BLOCK_SIZE], temp_fname[MAX_STR_LEN],
    temp_cksum[MAX_STR_LEN], actual_cksum[MAX_STR_LEN];
  int retval=0,noof_blocks, ctrl_chr,res;
  FILE*fout;
  long bytes_to_write=0/*,i*/;
  long long temp_size, size;
  /*  unsigned int ch; */
  unsigned int crc16,crctt;

  crc16=crctt=0;
  size=orig_size;
  res=read_header_block_from_tape(&temp_size, temp_fname, &ctrl_chr);
  if (orig_size!=temp_size)
    {
      sprintf(tmp,"output file's size should be %ld K but is apparently %ld K",(long)size>>10,(long)temp_size>>10);
      log_to_screen(tmp);
    }
  if (ctrl_chr == BLK_END_OF_TAPE)
    {
      start_to_read_from_next_tape(bkpinfo);
      res=read_header_block_from_tape(&temp_size, temp_fname, &ctrl_chr);
    }
  if (ctrl_chr != BLK_START_FILE) { wrong_marker(BLK_START_FILE, ctrl_chr); }
  sprintf(tmp,"Reading file from tape; writing to '%s'; %ld KB",outfname,(long)size>>10);

  if (foutstream) {fout=foutstream;} else {fout=fopen(outfname,"w");}
  if (!fout) { log_it(outfname); fatal_error("Cannot openout file"); }
  for(noof_blocks=0; size>0; noof_blocks++, size-=bytes_to_write)
    {
      if (size < TAPE_BLOCK_SIZE) { bytes_to_write = size; } else { bytes_to_write = TAPE_BLOCK_SIZE; }
      g_tape_posK += fread(datablock, 1, /*bytes_to_write*/ TAPE_BLOCK_SIZE, g_tape_stream)/1024;
      fwrite(datablock, 1, bytes_to_write, fout);
      /*
      for(i=0;i<bytes_to_write;i++)
        {
	  ch=datablock[i];
          crc16=updcrcr(crc16,ch);
          crctt=updcrc(crctt,ch);
        }
      */
    }
  sprintf(actual_cksum,"%04x%04x",crc16,crctt);
  if (foutstream) {log_it("Finished writing to foutstream");} else {fclose(fout);}
  res=read_header_block_from_tape(&temp_size, temp_cksum, &ctrl_chr);
  if (ctrl_chr != BLK_STOP_FILE) { wrong_marker(BLK_STOP_FILE, ctrl_chr); }
  if (strcmp(temp_cksum,actual_cksum))
    {
      sprintf(tmp,"actual cksum=%s; recorded cksum=%s",actual_cksum,temp_cksum);
      log_to_screen(tmp);
      sprintf(tmp,"%s (%ld K) is corrupt on tape",temp_fname,(long)orig_size>>10);
      fatal_error(tmp);
    }
  else
    {
      sprintf(tmp,"%s is GOOD on tape",temp_fname);
      /*      log_it(tmp); */
    }
  return(retval);
}






int read_header_block_from_tape(long long *plen, char*filename, int *pcontrol_char)
{
  char tempblock[TAPE_BLOCK_SIZE], tmp[MAX_STR_LEN];
  int i;
  for(i=0;i<TAPE_BLOCK_SIZE;i++) {tempblock[i]=0;}
  g_tape_posK += fread(tempblock,1,TAPE_BLOCK_SIZE,g_tape_stream)/1024;
  *pcontrol_char = tempblock[7000];
/*  memcpy((char*)plength_of_incoming_file,(char*)tempblock+7001,sizeof(long long)); */
/*  for(*plen=0,i=7;i>=0;i--) {*plen<<=8; *plen |= tempblock[7001+i];} */
  memcpy((char*)plen, tempblock+7001, sizeof(long long));
  if (strcmp(tempblock+6000+*pcontrol_char,"Mondolicious, baby"))
    {
      sprintf(tmp,"Bad header block at %ld K",(long) g_tape_posK);
      log_it(tmp);
    }
  strcpy(filename,tempblock+1000);
/*  strcpy(cksum,tempblock+5555);*/
  sprintf(tmp,"%s  (reading) fname=%s, filesize=%ld K",marker_to_string(*pcontrol_char), filename,(long )((*plen)>>10));
/*  log_it(tmp); */
  if (*pcontrol_char==BLK_ABORTED_BACKUP) { log_to_screen("I can't verify an aborted backup."); finish(1); }
  return(0);
}




void reset_bkpinfo(struct s_bkpinfo*bkpinfo)
{
  bkpinfo->media_device[0]='\0';
  bkpinfo->media_size=0;
  bkpinfo->boot_loader='\0';
  bkpinfo->boot_device[0]='\0';
  bkpinfo->zip_exe[0]='\0';
  bkpinfo->zip_suffix[0]='\0';
  bkpinfo->compression_level=2; /* default */
  bkpinfo->use_lzo=FALSE;
  bkpinfo->do_not_compress_these[0]='\0';
  bkpinfo->verify_data=FALSE;
  bkpinfo->backup_data=FALSE;
  bkpinfo->isodir[0]='\0';
  bkpinfo->scratchdir[0]='\0';
  bkpinfo->tmpdir[0]='\0';
  bkpinfo->optimal_set_size=0;
  bkpinfo->using_tape=FALSE;
  bkpinfo->include_paths[0]='\0';
  bkpinfo->exclude_paths[0]='\0';
  bkpinfo->call_before_iso[0]='\0';
  bkpinfo->call_make_iso[0]='\0';
  bkpinfo->call_burn_iso[0]='\0';
  bkpinfo->call_after_iso[0]='\0';
  bkpinfo->image_devs[0]='\0';
  bkpinfo->postnuke_tarball[0]='\0';
  bkpinfo->kernel_path[0]='\0';
  bkpinfo->nfs_mount[0]='\0';
  bkpinfo->nfs_remote_dir[0]='\0';
  bkpinfo->wipe_media_first=FALSE;
  bkpinfo->differential=FALSE;
  bkpinfo->cdrw_speed=0;
}




void reload_filelist(struct s_node *filelist)
{
  toggle_node_selection(filelist, FALSE);
  toggle_path_expandability(filelist, "/", FALSE);
  toggle_all_root_dirs_on(filelist);
}




int run_program_and_log_output(char *program)
{
  char callstr[MAX_STR_LEN], *p, incoming[MAX_STR_LEN], tmp[MAX_STR_LEN];
  int res, i, len;
  FILE*fin;
  sprintf(callstr,"%s > /tmp/mondo-run-prog.tmp 2> /tmp/mondo-run-prog.err",program);
  while((p=strchr(callstr,'\r'))) {*p=' ';}
  while((p=strchr(callstr,'\n'))) {*p=' ';} /* single '=' is intentional */
  res=system(callstr);
  len=strlen(program);
  for(i=0;i<35-len/2;i++) { tmp[i]='-'; }
  tmp[i]='\0';
  strcat(tmp," ");
  strcat(tmp,program);
  strcat(tmp," ");
  for(i=0;i<35-len/2;i++) { strcat(tmp,"-"); }
  log_it(tmp);
  system("cat /tmp/mondo-run-prog.err >> /tmp/mondo-run-prog.tmp");
  unlink("/tmp/mondo-run-prog.err");
  fin=fopen("/tmp/mondo-run-prog.tmp","r");
  if (fin)
    {
      for(fgets(incoming,MAX_STR_LEN,fin); !feof(fin); fgets(incoming,MAX_STR_LEN,fin))
	{
/*	  for(i=0; incoming[i]!='\0'; i++);
	  for(; i>0 && incoming[i-1]<=32; i--);
	  incoming[i]='\0';
*/
	  strip_spaces(incoming);
	  log_it(incoming);
	}
      fclose(fin);
    }
  log_it("--------------------------------end of output------------------------------");
  if (res) { log_it("...ran with errors."); }
  /* else { log_it("...ran just fine. :-)"); } */
  return(res);
}




int run_program_and_log_to_screen(char*basic_call, char*what_i_am_doing)
{
  int retval=0,res=0,i;
  FILE*fin;
  char tmp[MAX_STR_LEN], command[MAX_STR_LEN], lockfile[MAX_STR_LEN];

  sprintf(lockfile,"/tmp/mojo-jojo-for-vice-prez");
  sprintf(command,"echo hi > %s ; %s >> %s 2>> %s; res=$?; rm -f %s; exit $res", lockfile, basic_call, MONDO_LOGFILE, MONDO_LOGFILE, lockfile);
  open_evalcall_form(what_i_am_doing);
  sprintf(tmp,"Executing %s",basic_call);
  log_it(tmp);
  fin=popen(command,"r");
  if (!fin)
    {
      sprintf(tmp,"Failed utterly to call '%s'",command);
      log_to_screen(tmp);
      return(1);
    }
  for(i=0; i<3 && !does_file_exist(lockfile); sleep(1),i++)
    {
/*      log_it("So tired.. Tired of waiting..."); */
    }
  for(; does_file_exist(lockfile); sleep(1))
    {
      log_file_end_to_screen(MONDO_LOGFILE,"");
      update_evalcall_form(0); 
   }
  if (pclose(fin)) {res=1;}
  retval+=res;
  close_evalcall_form();
  return(retval);
}








void save_filelist(struct s_node *filelist, char *outfname)
{
  static int len=0;
  static char str[MAX_STR_LEN];
  struct s_node *node;
  static FILE*fout=NULL;
  static long lines_in_filelist=0, lino=0;
  static int percentage, depth=0;

  if (depth==0)
    {
      log_to_screen("Saving filelist");
      fout=fopen(outfname,"w");
      lines_in_filelist = g_original_noof_lines_in_filelist; /* set by load_filelist() */
      open_evalcall_form("Saving selection to disk");
    }
  depth++;
  for(node=filelist; node!=NULL; node=node->right)
    {
      str[len] = node->ch;
      if (!node->ch)
        {
          if (node->selected) {fprintf(fout,"%s\n",str);}
          if (!(++lino %1111))
            {
              percentage=(int)(lino*100/lines_in_filelist);
              update_evalcall_form(percentage);
            }
        }
      if (node->down)
        {
          len++;
          save_filelist(node->down, "");
          len--;
        }
    }
  depth--;
  if (depth==0)
    {
      fclose(fout);
      fout=NULL;
      close_evalcall_form();
      log_it("Finished saving filelist");
    }
}





long size_of_all_biggiefiles_K(struct s_bkpinfo *bkpinfo)
{
  char fname[MAX_STR_LEN], biggielist[MAX_STR_LEN],
    command[MAX_STR_LEN], res_sz[MAX_STR_LEN], comment[MAX_STR_LEN];
  long scratchL=0;
  long file_len_K;
  FILE *fin;

  log_it("Calculating size of all biggiefiles (in total)");
  sprintf(biggielist, "%s/biggielist.txt", bkpinfo->tmpdir);
  if (!(fin=fopen(biggielist,"r")))
    { log_it("Cannot open biggielist. OK, so estimate is based on filesets only."); }
  else
    {
      for(fgets(fname, MAX_STR_LEN, fin); !feof(fin); fgets(fname, MAX_STR_LEN, fin))
        {
          strip_spaces(fname);
          if (0==strncmp(fname, "/dev/", 5))
            {
              sprintf(command,"cat %s/mountlist.txt | grep \"%s \" | head -n1 | cut -d' ' -f4", bkpinfo->tmpdir, fname);
              log_it(command);
              strcpy(res_sz, call_program_and_get_last_line_of_output(command));
              file_len_K = atol(res_sz);
              if (file_len_K>0) { scratchL += file_len_K; }
            }
          else
            {
              file_len_K = (long)(length_of_file(fname)/1024);
              if (file_len_K>0) { scratchL += file_len_K; }
            }
          sprintf(comment,"After adding %s, scratchL+%ld now equals %ld", fname, file_len_K, scratchL);
/*          log_it(comment); */
        }
    }
  fclose(fin);
  log_it("Finished calculating total size of all biggiefiles");
  return(scratchL);
}





char *slice_fname(long bigfileno, long sliceno, char*path, char*s)
{
  static char output[MAX_STR_LEN], suffix[MAX_STR_LEN];
  if (s[0]!='\0') { sprintf(suffix,".%s",s); } else { suffix[0]='\0'; }
  sprintf(output,"%s/slice-%07ld.%05ld.dat%s",path,bigfileno,sliceno,suffix);
  return(output);
}



long long space_occupied_by_cd(char *mountpt)
{
  char tmp[MAX_STR_LEN],command[MAX_STR_LEN],*p;
  FILE*fin;
  sprintf(command,"du -sk %s",mountpt);
  fin=popen(command,"r");
  fgets(tmp,MAX_STR_LEN,fin);
  pclose(fin);
  p=strchr(tmp,'\t');
  if (p) {*p='\0';}
  return(atoll(tmp));
}




bool should_we_write_to_next_tape(long mediasize, long long length_of_incoming_file)
{
  bool we_need_a_new_tape=FALSE;
  if (g_tape_posK>>10 >= mediasize) { we_need_a_new_tape=TRUE; log_to_screen("Should have started a new tape/CD already"); }
  if ((g_tape_posK+length_of_incoming_file/1024)>>10 >= mediasize) { we_need_a_new_tape=TRUE; }
  return (we_need_a_new_tape);
}





int start_to_read_from_next_tape(struct s_bkpinfo *bkpinfo)
{
  int res=0,ctrl_chr='\0';
  char fname[MAX_STR_LEN]; /*cksum[MAX_STR_LEN];*/
  long long size;

  pclose(g_tape_stream);
  log_it("Next tape requested.");
  popup_and_OK("Please insert the next tape/CD in this series.");
  g_current_media_number ++;
  g_tape_stream = fopen(bkpinfo->media_device,"r");
  g_tape_posK = 0;
  res=read_header_block_from_tape(&size, fname, &ctrl_chr);
  if (ctrl_chr != BLK_START_OF_TAPE) { wrong_marker(BLK_START_OF_BACKUP, ctrl_chr); }
  return(res);
}




int start_to_write_to_next_tape(struct s_bkpinfo *bkpinfo)
{
  write_header_block_to_tape(g_current_media_number,"end-of-tape",BLK_END_OF_TAPE);
  pclose(g_tape_stream);
  log_it("New tape requested.");
  popup_and_OK("This tape/CD is full. Please insert another.");
  g_current_media_number ++;
  openout_tape(bkpinfo->media_device); /* sets g_tape_stream */
/*  g_tape_stream = fopen(bkpinfo->media_device,"w"); */
  g_tape_posK = 0;
  write_header_block_to_tape(g_current_media_number,"start-of-tape",BLK_START_OF_TAPE);
  return(0);
}





int strcmp_inc_numbers(char*stringA, char*stringB)
{
  int i, start_of_numbers_in_A, start_of_numbers_in_B, res;
  long numA,numB;
  if (strlen(stringA)==strlen(stringB)) { return(strcmp(stringA,stringB)); }
  for(i=strlen(stringA); i>0 && isdigit(stringA[i-1]); i--);
  if (i==strlen(stringA)) { return(strcmp(stringA,stringB)); }
  start_of_numbers_in_A = i;
  for(i=strlen(stringB); i>0 && isdigit(stringB[i-1]); i--);
  if (i==strlen(stringB)) { return(strcmp(stringA,stringB)); }
  start_of_numbers_in_B = i;
  if (start_of_numbers_in_A != start_of_numbers_in_B)
    { return(strcmp(stringA,stringB)); }
  res=strncmp(stringA,stringB,i);
  if (res) { return(res); }
  numA = atol(stringA+start_of_numbers_in_A);
  numB = atol(stringB+start_of_numbers_in_B);
  /*
    sprintf(tmp,"Comparing %s and %s --> %ld,%ld\n",stringA,stringB,numA,numB);
    log_to_screen(tmp);
  */
  return(numA-numB);
}





char *strip_afio_output_line(char*input)
{
  static char output[MAX_STR_LEN];
  char *p, *q;
  strcpy(output,input);
  p=strchr(input,'\"');
  if (p)
    {
      q=strchr(++p,'\"');
      if (q)
	{
	  strcpy(output,p);
	  *(strchr(output,'\"'))='\0';
	}
    }
  return(output);
}



void strip_spaces(char*in_out)
{
  char tmp[MAX_STR_LEN],*p;
  int i;
  for(i=0; in_out[i]<=' ' && i<strlen(in_out);i++);
  strcpy(tmp,in_out+i);
  for(i=strlen(tmp); tmp[i-1]<=32; i--);
  tmp[i]='\0';
  for(i=0;i<80;i++) {in_out[i]=' ';}
  in_out[i]='\0';
  i=0;
  p=tmp;
  while(*p!='\0')
    {
      in_out[i]=*(p++);
      in_out[i+1]='\0';
      if (in_out[i]<32 && i>0)
       {
         if (in_out[i]==8)
           {i--;}
         else if (in_out[i]==9)
           {in_out[i++]=' ';}
         else if (in_out[i]=='\t')
           {for(i++; i%5; i++);}
         else if (in_out[i]>=10 && in_out[i]<=13)
           {break;}
         else
           {i--;}
       }
      else
       {
         i++;
       }
    }
  in_out[i]='\0';
/*  for(i=strlen(in_out); i>0 && in_out[i-1]<=32; i--) {in_out[i-1]='\0';} */
}




void toggle_all_root_dirs_on(struct s_node *filelist)
{
  struct s_node *node;
  static int depth=0;
  static char filename[MAX_STR_LEN];
  static int root_dirs_expanded;
  if (depth==0)
    {
      log_it("Toggling all root dirs ON");
      root_dirs_expanded = 0;
    }
  for(node=filelist; node!=NULL; node=node->right)
    {
      filename[depth] = node->ch;
      if (node->ch == '\0' && strlen(filename)>1 && (!strchr(filename+1,'/')))
        {
	  node->selected=FALSE;
	  node->expanded=TRUE;
	  log_it(filename);
	  root_dirs_expanded++;
        }
      if (node->down) { depth++; toggle_all_root_dirs_on(node->down); depth--; }
    }
  if (depth==0)
    {
      log_it("Finished toggling all root dirs ON");
    }
}



void toggle_path_expandability(struct s_node *filelist, char*pathname, bool on_or_off)
{
  static int depth=0;
  static int total_expanded;
  static int root_depth;
  struct s_node *node;
  int j;
  static char current_filename[MAX_STR_LEN];
/*  char tmp[MAX_STR_LEN+2]; */

  if (depth==0)
    {
      total_expanded=0;
      log_it("Toggling path's expandability");
      for(root_depth=strlen(pathname); root_depth>0 && pathname[root_depth-1]!='/'; root_depth--);
      if (root_depth<2) {root_depth=strlen(pathname);}
    }
  for(node=filelist; node!=NULL; node=node->right)
    {
      current_filename[depth] = node->ch;
      if (node->down)
        {
          depth++;
          toggle_path_expandability(node->down, pathname, on_or_off);
          depth--;
        }
      if (node->ch == '\0')
        {
          if (!strncmp(pathname, current_filename, strlen(pathname)))
            {
              for(j=root_depth; current_filename[j]!='/' && current_filename[j]!='\0'; j++);
              if (current_filename[j]!='\0')
                { for(j++; current_filename[j]!='/' && current_filename[j]!='\0'; j++); }
              if (current_filename[j]=='\0')
                {
/*                  sprintf(tmp,"j=%d; root_depth=%d; stem(path)=%s; stem(curr)=%s",j,root_depth,pathname+j, current_filename+j);
                  log_it(tmp); */
                  node->expanded = (!strcmp(pathname, current_filename)?TRUE:on_or_off);
                }
            }
        }
      if (node->expanded)
        {
          if (total_expanded<ARBITRARY_MAXIMUM-32 || !strrchr(current_filename + strlen(pathname),'/'))
            { total_expanded++; }
          else
            { node->expanded=FALSE; }
        }
    }
  if (depth==0)
    {
      log_it("Finished toggling expandability");
    }
}


void toggle_path_selection(struct s_node *filelist, char*pathname, bool on_or_off)
{
  static int depth=0;
  struct s_node *node;
  static char current_filename[MAX_STR_LEN];
	  char tmp[MAX_STR_LEN+2];
  int j;

  if (depth==0)
    {
      log_it("Toggling path's selection");
    }
  for(node=filelist; node!=NULL; node=node->right)
    {
      current_filename[depth] = node->ch;
      if (node->down) {depth++; toggle_path_selection(node->down, pathname, on_or_off); depth--; }
      if (node->ch == '\0')
        {
          if (!strncmp(pathname, current_filename, strlen(pathname)))
            {
              for(j=0; pathname[j]!='\0' && pathname[j]==current_filename[j];j++);
              if (current_filename[j]=='/' || current_filename[j]=='\0')
                {
                  node->selected = on_or_off;
                  sprintf(tmp,"%s is now %s\n",current_filename,(on_or_off ? "ON" : "OFF"));
                }
            }
        }
    }
  if (depth==0)
    {
      log_it("Finished toggling selection");
    }
}



void toggle_node_selection(struct s_node *filelist, bool on_or_off)
{
  struct s_node *node;
  for(node=filelist; node!=NULL; node=node->right)
    {
      if (node->ch == '/') { continue; } /* don't go deep */
      if (node->ch == '\0') { node->selected = on_or_off; }
      if (node->down) { toggle_node_selection(node->down, on_or_off); }
    }
}



char *trim_empty_quotes(char*incoming)
{
  static char outgoing[MAX_STR_LEN];
  if (incoming[0]=='\"' && incoming[strlen(incoming)-1]=='\"')
    {
      strcpy(outgoing,incoming+1);
      outgoing[strlen(outgoing)-1]='\0';
    }
  else
    {
      strcpy(outgoing,incoming);
    }
  return(outgoing);
}







char which_boot_loader(char*which_device)
{
  char list_drives_cmd[MAX_STR_LEN],
    tmp[MAX_STR_LEN], current_drive[MAX_STR_LEN];
  FILE*pdrives;
  int count_lilos=0, count_grubs=0;

  sprintf(list_drives_cmd,"fdisk -l | grep /dev | grep cyl | tr ':' ' ' | cut -d' ' -f2");
  if (!(pdrives=popen(list_drives_cmd,"r"))) { fatal_error("Unable to open list of drives"); }
  for(fgets(current_drive,MAX_STR_LEN,pdrives); !feof(pdrives); fgets(current_drive,MAX_STR_LEN,pdrives))
    {
      strip_spaces(current_drive);
      sprintf(tmp,"looking at drive %s's MBR",current_drive);
      log_it(tmp);
      if (does_string_exist_in_boot_block(current_drive,"GRUB"))
        { count_grubs++; strcpy(which_device,current_drive); break; }
      if (does_string_exist_in_boot_block(current_drive,"LILO"))
        { count_lilos++; strcpy(which_device,current_drive); break; }
    }
  pclose(pdrives);
  sprintf(tmp,"%d grubs and %d lilos\n",count_grubs,count_lilos);
  log_it(tmp);
  if (count_grubs && !count_lilos) { return('G'); }
  else if (count_lilos && !count_grubs) { return('L'); }
  else if (count_grubs==1 && count_lilos==1)
    {
      log_it("I'll bet you used to use LILO but switched to GRUB...");
      return('G');
    }
  else
    {
      log_it("Unknown boot loader");
      return('U');
    }
}






int read_cfg_var(char *config_file, char *label, char *value)
{
  char command[MAX_STR_LEN], tmp[MAX_STR_LEN];

  if (!does_file_exist(config_file))
    {
      sprintf(tmp,"(read_cfg_file) Cannot find %s config file", config_file);
      log_to_screen(tmp);
      value[0]='\0';
      return(-1);
    }
  else
    {
      sprintf(command,"cat %s | grep \"%s .*\" | cut -d' ' -f2,3,4,5", config_file, label);
      strcpy(value, call_program_and_get_last_line_of_output(command));
      if (strlen(value)==0) { return(1); } else { return(0); }
    }
}




int write_cfg_var(char *config_file, char *label, char *value)
{
  char command[MAX_STR_LEN], tempfile[MAX_STR_LEN], tmp[MAX_STR_LEN];

  if (!does_file_exist(config_file))
    {
      sprintf(tmp,"(write_cfg_file) Cannot find %s config file", config_file);
      fatal_error(tmp);
    }
  strcpy(tempfile, call_program_and_get_last_line_of_output("mktemp -q /tmp/blah.XXXXXX"));
  if (does_file_exist(config_file))
    {
      sprintf(command,"cat %s | grep -vx \"%s .*\" > %s" , MONDO_CFG_FILE, label, tempfile);
      system(command);
    }
  sprintf(command,"echo \"%s %s\" >> %s", label, value, tempfile);
  system(command);
  sprintf(command,"mv -f %s %s", tempfile, MONDO_CFG_FILE);
  system(command);
  return(0);
}




int write_data_disks_to_tape(char*fname)
{
  FILE *fin;
  long m=-1;
  int i,j;
  char tempblock[256*1024], tmp[MAX_STR_LEN];

  open_evalcall_form("Writing data disks to tape");
  log_to_screen("Writing data disks to tape");
  if (!does_file_exist(fname))
    {
      sprintf(tmp,"Cannot find %s",fname);
      log_to_screen(tmp);
      finish(1);
    }
  if (!(fin=fopen(fname,"r"))) {fatal_error("Cannot openin the data disk");}
  for(i=0;i<32;i++) /* 32MB */
    {
      for(j=0;j<4;j++) /* 256K x 4 = 1MB (1024K) */
        {
	  if (!feof(fin)) { m=fread(tempblock,1,256*1024,fin); }
	  else { m=0; }
          for(;m<256*1024;m++) { tempblock[m]='\0'; }
	  g_tape_posK+=fwrite(tempblock,1,256*1024,g_tape_stream)/1024;
	}
	  update_evalcall_form((i*4+j)*100/128);
    }
  fclose(fin);
  close_evalcall_form();
  return(0);
}



int write_file_to_tape_from_file(struct s_bkpinfo *bkpinfo, char*infile)
{
  char tmp[MAX_STR_LEN], datablock[TAPE_BLOCK_SIZE], *p, checksum[MAX_STR_LEN];
  int retval=0,noof_blocks;
  /*  unsigned int ch; */
  unsigned int crc16,crctt;
  FILE*fin;
  long bytes_to_read=0, i;
  long long filesize;

  crc16=crctt=0;
  filesize=length_of_file(infile);
  if (should_we_write_to_next_tape(bkpinfo->media_size,filesize))
    { start_to_write_to_next_tape(bkpinfo); }
  p=strrchr(infile,'/');
  if (!p) {p=infile;} else {p++;}
  sprintf(tmp,"Writing file '%s' to tape (%ld KB)", p, (long)filesize>>10);
  log_it(tmp);
  write_header_block_to_tape(filesize,infile,BLK_START_FILE);
  fin=fopen(infile,"r");
  for(noof_blocks=0; filesize > 0; noof_blocks++, filesize-=bytes_to_read)
    {
      if (filesize < TAPE_BLOCK_SIZE)
        {
	  bytes_to_read = filesize;
	  for(i=0; i<TAPE_BLOCK_SIZE;i++) {datablock[i]='\0';}
        }
      else
        {
	  bytes_to_read = TAPE_BLOCK_SIZE;
        }
      fread(datablock, 1, bytes_to_read, fin);
      g_tape_posK += fwrite(datablock, 1, /*bytes_to_read*/ TAPE_BLOCK_SIZE, g_tape_stream)/1024;
      /*
      for(i=0;i<bytes_to_read;i++)
        {
	  ch=datablock[i];
          crc16=updcrcr(crc16,ch);
          crctt=updcrc(crctt,ch);
        }
      */
    }
  fclose(fin);
  sprintf(checksum,"%04x%04x",crc16,crctt);
  write_header_block_to_tape(g_current_media_number,checksum,BLK_STOP_FILE);
  sprintf(tmp,"File '%s' written to tape.",infile);
  log_it(tmp);
  return(retval);
}




int write_one_liner_data_file(char*fname,char*contents)
{
  FILE*fout;
  if (!(fout=fopen(fname,"w"))) { return(1); }
  fprintf(fout,"%s\n",contents);
  fclose(fout);
  return(0);
}






int write_header_block_to_tape(long long length_of_incoming_file, char*filename, int control_char)
{
  char tempblock[TAPE_BLOCK_SIZE], tmp[MAX_STR_LEN], *p;
  int i;
  long long olen;
  olen = length_of_incoming_file;
  p=strrchr(filename,'/'); /* Make 'em go, "Unnnh!" Oh wait, that was _Master_ P... */
  if (!p) {p=filename;} else {p++;}
  if (!g_tape_stream) { log_to_screen("You're not backing up to tape. Why write a tape header?"); finish(1); }
  for(i=0;i<TAPE_BLOCK_SIZE;i++) {tempblock[i]=0;}
  sprintf(tempblock+6000+control_char,"Mondolicious, baby");
  tempblock[7000]=control_char;
/*  for(i=0;i<8;i++) {tempblock[7001+i]=olen&0xff; olen>>=8;} */
  memcpy(tempblock+7001, (char*)&olen, sizeof(long long));
/*  if (length_of_incoming_file) {memcpy(tempblock+7001,(char*)&length_of_incoming_file,sizeof(long long));} */
  strcpy(tempblock+1000,filename);
/*  strcpy(tempblock+5555,cksum); */
  g_tape_posK += fwrite(tempblock,1,TAPE_BLOCK_SIZE,g_tape_stream)/1024;
  sprintf(tmp,"%s (fname=%s, size=%ld K)", marker_to_string(control_char), p, (long) length_of_incoming_file>>10);
  /*  log_it(tmp); */
/*  log_tape_pos(); */
  return(0);
}



void wrong_marker(int should_be, int it_is)
{
  char tmp[MAX_STR_LEN];
  sprintf(tmp,"Wrong marker! (Should be %s, ",marker_to_string(should_be));
  sprintf(tmp+strlen(tmp),"is actually %s)",marker_to_string(it_is));
  fatal_error(tmp);
}




int zero_out_a_device(char*device)
{
  FILE*fout;
  char tmp[MAX_STR_LEN];
  int i;
  sprintf(tmp,"Zeroing drive %s",device);
  log_it(tmp);
  fout=fopen(device,"w");
  if (!fout)
    {
      log_it("Unable to open/write to device");
      return(1);
    }
  for(i=0;i<16384;i++)
    {
      fputc('\0',fout);
    }
  fclose(fout);
  log_it("Device successfully zeroed.");
  return(0);
}



/* end of mondo-tools.c */























