module Info_Display :
  sig
    type t
    val fetch_and_display_data : t -> #App.t -> string -> unit
    val get_current_cert_value : t -> string option
  end

module Branch_selector :
  sig
    type t
    type state
    val get_state  : t -> state
    val set_state  : t -> #App.t -> ?id:string -> state -> unit
    val set_branch : t -> #App.t -> ?id:string -> string -> unit
    val present_dialog : t -> unit
  end

module Canvas :
  sig
    type t
    val zoom : t -> #App.t -> [< `IN | `OUT ] -> unit -> unit
    val id_size : t -> #App.t -> int * int * int
    val center_on : t -> #App.t -> string * Viz_types.c_node -> unit
  end

module Find :
  sig
    type t
    val locate : t -> #App.t -> string -> unit
    val focus_find_entry : t -> unit
  end

type t = {
  info     : Info_Display.t;
  selector : Branch_selector.t;
  canvas   : Canvas.t;
  find     : Find.t;
}

val make : 
  aa:bool ->
  parent:#GWindow.window_skel ->
  pack_find_entry:(GObj.widget -> unit) ->
  pack_canvas:(GObj.widget -> unit) -> t
val setup : t -> #App.t -> unit

val clear    : t -> #App.t -> unit
val close_db : t -> #App.t -> unit
val open_db  : t -> #App.t -> unit
val update   : t -> #App.t -> string option -> unit
val get_selected_node : t -> string option
