# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Philippe Normand <philippe@fluendo.com>


from twisted.trial.unittest import TestCase

from elisa.plugins.database import video_parser

class TestVideoParser(TestCase):

    def setUp(self):
        self._parser = video_parser.VideoParser()

    def test_tvshow_regexes(self):
        episodes = [('Day.Break.S01E03.HDTV.XviD-XOR.avi',
                     ('Day.Break.', '01', '03')),
                    ('Dexter - 01x06 (HDTV-LOL) Return to Sender.avi',
                     ('Dexter -', '01', '06')),
                    ('Generation.Kill.S01E01.HDTV.XviD-0TV.avi',
                     ('Generation.Kill.', '01', '01')),
                    ('lost.305.hdtv-lol.avi',
                     ('lost', '3', '05')),
                    ('Weeds - 101.avi',
                     ('Weeds -', '1', '01')),
                    ('weeds.s02e01.vost-fr.avi',
                     ('weeds.', '02', '01')),
                    ('lost.[s3]_[e5].hdtv-lol.avi',
                     ('lost.', '3', '5')),
                    ('Alias S1 E1 Pilot.mp4',
                     ('Alias ', '1', '1')),
                    ('Alias_S1_E02.avi',
                     ('Alias_', '1', '02')),
                    ('Alias - S2 - E13 - English subs.mp4',
                     ('Alias - ', '2', '13')),
                    ]
        for filename, expected_results in episodes:
            match = self._parser.try_tvshow_match(filename)
            self.failUnless(match,
                            "%s should have been matched as TV show episode")
            results = match.groups()[:-1]
            self.assertEquals(results, expected_results)

    def test_video_name_cleanup(self):
        video_names = [("Red's Dream (1987) [Phoenix76 Transcode].avi",
                        "red's dream"),
                       ("South.Park.avi", "south park"),
                       ("Mike's New Car [Monsters, Inc.] (2002) [aXXo].avi",
                        "mike's new car"),
                       ("La_classe_americaine.avi", "la classe americaine"),
                       ("For the Birds (2000) [Phoenix76 Transcode].avi",
                        "for the birds"),
                       ("Luxo Jr. (1986) [Phoenix76 Transcode].avi",
                        "luxo jr"),
                       ]

        for filename, expected_video_name in video_names:
            video_name = self._parser.clean_video_name(filename)
            self.assertEquals(video_name, expected_video_name)
