# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

from elisa.core.utils.i18n import install_translation

from elisa.plugins.poblesec.link import Link

from twisted.internet import defer

from elisa.plugins.poblesec.sections_menu import main_menu_decorate

_ = install_translation('poblesec')

def music_decorator(controller):
    controller_path = "/poblesec/music_menu"
    label = _("Music")
    icon = "elisa.plugins.poblesec.music_section"
    dfr = main_menu_decorate(controller, controller_path, label, icon)
    return dfr


def music_lib_decorator(controller):
    link = Link()
    link.controller_path = "/poblesec/database/music/albums"
    link.label = _('Library')
    controller.model.append(link)
    return defer.succeed(None)


def search_decorator(controller):
    link = Link()
    media_type = 'music'
    link.controller_path = '/poblesec/search/%s' % media_type
    link.controller_args = {'mediatype': media_type}
    link.label = _('Search')
    controller.model.append(link)
    return defer.succeed(None)


def artists_decorator(controller):
    link = Link()
    link.controller_path = "/poblesec/database/music/artists"
    link.label = _("Artists")
    controller.model.append(link)
    return defer.succeed(None)


def tracks_decorator(controller):
    tracks = Link()
    tracks.controller_path = '/poblesec/database/music/tracks'
    tracks.label = _('Tracks')
    controller.model.append(tracks)
    return defer.succeed(None)


def genres_decorator(controller):
    genres = Link()
    genres.controller_path = '/poblesec/database/music/genres'
    genres.label = _('Genres')
    controller.model.append(genres)
    return defer.succeed(None)
