# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Philippe Normand <philippe@fluendo.com>

"""
Models provided by the Shoutcast Resource Provider
"""

from elisa.core.components.model import Model

class ShoutcastRadioStationModel(Model):
    """
    This model represents all the informations we have about a given
    Shoutcast radio station.

    @ivar name:              name of the station (ex: 'foobar FM')
    @type name:              C{unicode}
    @ivar genre:             name of the Genre (ex: 'Alternative')
    @type genre:             C{unicode}
    @ivar bitrate:           audio bitrate at which the station is broadcasted
    @type bitrate:           C{unicode}
    @ivar listeners_count:   number of people currently listening to the station
    @type listeners_count:   C{int}
    @ivar currently_playing: track or event currently being broadcasted
    @type currently_playing: C{unicode}
    @ivar get_playable:      uri used to retrieve the stream url
    @type get_playable:      C{elisa.core.media_uri.MediaUri}
    """

    def __init__(self):
        super(ShoutcastRadioStationModel, self).__init__()
        self.name = None
        self.genre = None
        self.bitrate = None
        self.listeners_count = None
        self.currently_playing = None
        self.get_playable = None

class ShoutcastGenreModel(Model):
    """
    This model represents a Shoutcast genre and storing a list of
    radio stations.

    @ivar name:     name of the genre
    @type name:     C{unicode}
    @ivar stations: radio stations listed as being part of the genre
    @type stations: C{list} of {ShoutcastRadioStationModel}
    """

    def __init__(self):
        super(ShoutcastGenreModel, self).__init__()
        self.name = None
        self.stations = []

class ShoutcastGenresModel(Model):
    """
    This model represents a list of genres.

    TODO: replace this with ListModel
    """

    def __init__(self):
        super(ShoutcastGenresModel, self).__init__()
        self.genres = []
