#ifndef __MOTORFILE_H__
#define __MOTORFILE_H__

#include "motorcommon.h"

__MOTOR_BEGIN_NAMESPACE

class motorfile {
    public:
	enum filekind {
	    source,
	    directory,
	    symbol,
	    project
	};

    protected:
	string fname;

    public:
	motorfile(const string &afname);
	~motorfile();

	string getfname() const;

	void remove();
	    // removes the file from disk

	bool operator == (const string &afname) const;
	bool operator != (const string &afname) const;

	bool operator == (const motorfile &afile) const;
	bool operator != (const motorfile &afile) const;

	bool operator == (regex_t *r) const;
	bool operator != (regex_t *r) const;
};

__MOTOR_END_NAMESPACE

#ifdef __MOTOR_USE_NAMESPACES

using motor::motorfile;

#endif

#endif
