/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 *
 * Copyright (C) 2007 Andris Pavenis <andris.pavenis@iki.fi>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * ***** END OF LICENSE BLOCK ***** */

#ifndef MOZVOIKKO_UTILS_H
#define MOZVOIKKO_UTILS_H

#include <nspr.h>
#include <nsCOMPtr.h>
#include <nsIFile.h>
#include <nsStringAPI.h>

#include <stdarg.h>

extern const char *preloadLibNames[];
extern const unsigned numPreloadedLibs;
extern const char *libvoikkoName;

void logMessage(const char *fmt, ...);

nsCString prGetErrorText(void);

template <class FunctType>
bool LoadSymbol(PRLibrary *library, FunctType *funct,
    const char *symbol_name)
{
    union
    { 
        FunctType funct;
        void *addr; 
    } tmp;

    tmp.addr = PR_FindSymbol(library, symbol_name);
  
    if (tmp.addr)
    {
        *funct = tmp.funct;
        return true;
    }
    else
    {
        logMessage("Failed to get symbol '%s' address from library: %s",
                   symbol_name, prGetErrorText().get());
        return false;
    }
}

nsresult getMozVoikkoLibrary(nsIFile **file);

nsresult checkLeafNameAndGetParent(nsIFile *file, nsIFile **parent,
    const nsACString& expectedLeafName);

nsresult checkLeafNameAndGetParent(nsIFile *file, nsIFile **parent,
    const nsACString& expectedLeafName1, const nsACString& expectedLeafName2);

nsresult findFileInSubdirectory(nsIFile *dir, nsIFile **result,
    const nsACString &subDirName,
    const nsACString &fileName);

class PreloadedLibraries
{
    bool ok;
    int numLibs;
    PRLibrary **libraries;

public:
    PreloadedLibraries(nsIFile *libDir, const char **names, unsigned numLibs);
    ~PreloadedLibraries();

    operator bool() const { return ok; }
};

#ifndef SYSTEM_LIBVOIKKO

nsresult loadExtraLibraries(int numLibs, const char **names);

nsresult getMozVoikkoBaseDirs(nsIFile **libDir, nsIFile **dataDir);

// 2 string constants provided by autogenerated file mozvoikko-target.cpp
//
// They contains extension target string for example
// "Linux" and "Linux_x86_64-gcc3" for Linux on x86_64. 
//
extern const char *mozvoikko_target_short;
extern const char *mozvoikko_target_long;

#endif /* SYSTEM_LIBVOIKKO */

#endif
