/***************************************************************************
                          plview.cpp  -  description
                             -------------------
    begin                : Thu Mar 15 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kprocess.h>
#include <kfiledialog.h>

#include <qtooltip.h>
#include <qfileinfo.h>
#include <qfont.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qheader.h>
#include <qlist.h>

#include <stdlib.h>
#include <iostream.h>

#include "resources.h"
#include "savepl.h"
#include "localpldial.h"
#include "mp3kult.h"
#include "export.h"
#include "plview.h"
#include "rename.h"

PLView::PLView(MyDb* db, QWidget* parent, const char* name) :
          QWidget(parent, name), db(db)
{
     totalLength=0;
     mainGrid = new QGridLayout(this, 3, 1);

     initView();
   // initplName();
    /* initPopup();*/
     saved=true;
     connect (moveUp, SIGNAL(clicked()), this, SLOT(slotMoveUp()));
     connect (moveDown, SIGNAL(clicked()), this, SLOT(slotMoveDown()));
    /* connect (butSave, SIGNAL(clicked()), this, SLOT(slotSave()));
     connect (butNew, SIGNAL(clicked()), this, SLOT(slotNew())); */
     connect (plName, SIGNAL(activated ( const QString & )), this, SLOT(slotChangePl(const QString &)));
    /* connect (listview, SIGNAL(rightButtonPressed ( QListViewItem *, const QPoint &, int )), this, SLOT(slotPopupMenu ( QListViewItem *, const QPoint &, int )));*/
     connect (this, SIGNAL(totalLengthCh(const QString &)), plLength, SLOT(setText(const QString &)));

     QToolTip::add(moveDown,i18n("Move song down"));
     QToolTip::add(moveUp,i18n("Move song up"));
			QToolTip::add(playPL,i18n("Play all songs"));
    // if ((plName->currentText())!= NULL)
    // {
         // cerr << "Load the First PlayList \n";
      //    slotChangePl(plName->currentText());
     //}
}

PLView::~PLView()
{
}

void PLView::initView()
{
     plName = new QComboBox(this);
     mainGrid->addWidget(plName,0,0);

     listview = new Mp3List(this);
     listview->addColumn(i18n("Song"));
     listview->addColumn(i18n("Length"));
     listview->addColumn(i18n("Volume"));

     listview->setSelectionMode (QListView::Extended);
     listview->setAllColumnsShowFocus (true);
     listview->setColumnAlignment (ID_PL_LENGTH, AlignHCenter);

     listview->setSorting(-1);

     mainGrid->addWidget (listview,1,0);

     QHBoxLayout *buttonBar = new QHBoxLayout;
     mainGrid->addLayout(buttonBar,2,0);


     moveUp = new QPushButton(this);
     moveUp->setPixmap(BarIcon("up"));
     buttonBar->addWidget(moveUp,0,AlignLeft);

     playPL = new QPushButton(this);
     playPL->setPixmap(BarIcon("playpl"/*, KIcon::SizeMedium */));
     buttonBar->addWidget(playPL,0, AlignLeft);

     moveDown = new QPushButton(this);
     moveDown->setPixmap(BarIcon("down"/*, KIcon::SizeMedium */));
     buttonBar->addWidget(moveDown,1,AlignLeft);

    /* playPL = new QPushButton(this);
     playPL->setPixmap(BarIcon("playpl"));
     buttonBar->addWidget(playPL,1, AlignLeft);    */

     plLength = new QLabel(this);
     plLength->setFont(QFont("Helvetica", 14, QFont::Bold));
     plLength->setText("0:00:00");
     plLength->setMargin(3);
     buttonBar->addWidget(plLength, 0, AlignRight);
    /* butNew = new QPushButton (this);
     butNew->setPixmap(BarIcon("filenew"));
     buttonBar->addWidget(butNew,0,AlignRight);

     butSave = new QPushButton (this);
     butSave->setPixmap(BarIcon("filesave"));
     buttonBar->addWidget(butSave,0,AlignRight);       */
}

void PLView::viewPL()
{
  initplName();
  if ((plName->currentText())!= NULL)
     {
          cerr << "Load the First PlayList \n";
          slotChangePl(plName->currentText());
     }
}

void PLView::initplName()
{
     MYSQL_ROW row;
    // MyDb db;

    if ((db->getPLName()) > 0)
    {

          while ((row=(db->getRow())))
               plName->insertItem(row[0]);
     }
     db->freeRes();
}

void PLView::setFont(QFont font)
{
     listview->setFont(font);
}

/*void PLView::initPopup()
{
     popup = new QPopupMenu();
     popup->insertItem(i18n("Remove"), this, SLOT(slotRemoveSong()), 0, 0);
} */

void PLView::setMp3KultView(Mp3KultView* view)
{
  mkview=view;
}

bool PLView::getSaved()
{
     return saved;
}

const char* PLView::elabLength(int len)
{
     int min, sec;
     char* lengthchar;
	char buf[6];

	min=len/60;
	sec=len%60;
	     sprintf (buf, "%d:%02d", min, sec);
	lengthchar=strdup (buf);
	return lengthchar;
}

const QString PLView::elabLengthTotal(int len)
{
     int hour, min, sec;
     QString lengthchar;
     char buf[9];

     hour=len/3600;
     min=(len-(hour*3600))/60;
     sec=(len-(hour*3600))%60;
     sprintf (buf, "%d:%02d:%02d", hour, min, sec);
     lengthchar=buf;
     return lengthchar;

}

void PLView::removeSong(PLListItem* item)
{
     totalLength-=(item->getLength());
     //listview->takeItem(item);
		 delete item;
     if(((plName->currentText())== NULL) && ((listview->childCount()) == 0))
          saved = true;
     else
          saved=false;
     cerr << "Remove Song: " << elabLengthTotal(totalLength) << endl;
     emit totalLengthCh (elabLengthTotal(totalLength));
}

void PLView::addSong(Mp3ListItem* mp3item)
{
     QString song, filename;
     PLListItem *after;
    /* Mp3ListItem* mp3item;
     mp3item=mp3ite;*/

     saved=false;

     if(((mp3item->text(ID_ARTIST)).isEmpty()))
          song = mp3item->text(ID_TITLE);
     else
     {
          song = mp3item->text(ID_ARTIST);
          song += " - " + mp3item->text(ID_TITLE);
     }
     filename = mp3item->text(ID_PATH);
     filename += "/" + mp3item->text(ID_FNAME);

     after = (PLListItem*) listview->firstChild();
     while (after!= NULL && (after->itemBelow()))
     {
          after = after->itemBelow();
     }

     if (after == NULL)
          item = new PLListItem (listview, mp3item->getMp3id(), filename,
                            mp3item->getLength());
     else
          item = new PLListItem (listview, after, mp3item->getMp3id(), filename,
                            mp3item->getLength());

     item->setText(ID_PL_SONG, song);
     item->setText(ID_PL_LENGTH, mp3item->text(ID_LENGTH) );
     item->setText(ID_PL_VOLUME, mp3item->text(ID_VOLUME));

     QFileInfo file(filename);

     if((file.exists()))
          item->setPixmap(ID_PL_SONG, UserIcon("greenball"));
     else
          item->setPixmap(ID_PL_SONG, UserIcon("redball"));

     totalLength+=mp3item->getLength();
     emit totalLengthCh (elabLengthTotal(totalLength));

}

Mp3List* PLView::getListView() const
{
     return listview;
}

void PLView::slotRefreshStatus()
{
     PLListItem* item;

     item = (PLListItem*) listview->firstChild();

     while (item)
     {
          QFileInfo file(item->getFileN());

          if((file.exists()))
               item->setPixmap(ID_PL_SONG, UserIcon("greenball"));
          else
               item->setPixmap(ID_PL_SONG, UserIcon("redball"));
          item = item->itemBelow();
     }
}


void PLView::slotMoveUp()
{
     //PLListItem *up, *toMove;
     PLListItem *above, *item;

     saved=false;

   /*  toMove  = (PLListItem*) listview->currentItem();
     if((toMove == (PLListItem*) listview->firstChild()))
          return;
     up = toMove->itemAbove();
     up->moveItem(toMove);      */
     item =  (PLListItem*) listview->currentItem();

     // move "item" pointer at the top of selected songs
     while ((item->itemAbove())!=NULL && (item->itemAbove()->isSelected()))
          item = item->itemAbove();

     // if "item", that is at the top of selected songs, is the first child
     // nothing must be move
     if ((item == listview->firstChild()))
          return;

     // "above" pointer is the song above the selected songs
     above = item->itemAbove();
     while (item && (item->isSelected()))
     {
          above->moveItem(item);
          item = above->itemBelow();
     }
}

void PLView::slotMoveDown()
{
    // PLListItem *down, toMove;
     PLListItem *item, *below;

     saved=false;

    /* toMove  = (PLListItem*)listview->currentItem();
     if(!toMove || !(down =  toMove->itemBelow()))
          return;
     toMove->moveItem(down);  */

     item = (PLListItem*) listview->currentItem();

     // move the pointer at the bottom of selected songs
     while ((item->itemBelow())!=NULL && (item->itemBelow()->isSelected()))
          item = item->itemBelow();
     // if "item" is the last entry in list, noting must be move
     if(!(below = item->itemBelow()))
          return;
     // move down all selected songs above "below" pointer
     while (item && (item->isSelected()))
     {
          item->moveItem(below);
          item = below->itemAbove();
     }
}

void PLView::slotChangePl(const QString& name)
{
     //MYSQL_RES* res;
     MYSQL_ROW row;
     //MyDb db;
     int current;

     if (!saved)
     {
          if((KMessageBox::warningYesNo(this,
                    i18n("This PlayList has been modified \n"
                         "Would you like to save it ?")))== 3)
          {
               current = plName->currentItem();
               plName->setCurrentItem(-1);
               slotSave();
               plName->setCurrentItem(current);
          }
     }

     saved=true;
     totalLength=0;

     listview->clear();
     if (name.isEmpty())
          return;
     // this because the new items are inserted at te top of list
     // if the query was "ASC" the playlist would be inverted all times
     db->getPL(name, "Ord", "DESC");

     while ((row=db->getRow()))
     {
          item = new PLListItem (listview, atoi(row[ID_DB_PL_MP3ID]),
                                   row[ID_DB_PL_FILE], atoi(row[ID_DB_PL_LENGTH]));
          item->setText(ID_PL_SONG, row[ID_DB_PL_SONG]);
          item->setText(ID_PL_LENGTH, elabLength(atoi(row[ID_DB_PL_LENGTH])));
          item->setText(ID_PL_VOLUME, row[ID_DB_PL_VOLUME]);

          QFileInfo file(row[ID_DB_PL_FILE]);
          if((file.exists()))
               item->setPixmap(ID_PL_SONG, UserIcon("greenball"));
          else
               item->setPixmap(ID_PL_SONG, UserIcon("redball"));

          totalLength+=atoi(row[ID_DB_PL_LENGTH]);
      //    cerr << "Show : " << row[ID_DB_PL_SONG] << " Ord: " << row[ID_DB_PL_ORDER] << '\n';
     }
     db->freeRes();
     emit totalLengthCh (elabLengthTotal(totalLength));
}


void PLView::slotSave()
{
     QString name;
     int n;

     if (saved)
          return;
     //MyDb db;
     if ((plName->currentText())== NULL)
     {
          cerr << "Name Null" << endl;
          SavePL savepl(this);

          if ((savepl.exec())==0)
               name = savepl.getPLName();
          else
               return;
          plName->insertItem(name);
          plName->setCurrentItem((plName->count())-1);
     }
     else
     {

          name = plName->currentText();
          db->delPL(name);
     }
     item = (PLListItem*)listview->firstChild();
     n=0;
     cerr << "Name: " << name << endl;
     while (item)
     {
          db->addEntryPL(item->text(ID_PL_SONG), item->getLength(),
          item->text(ID_PL_VOLUME), name, item->getFileN(),
          item->getMp3id(), n);
         // cerr << "Save: " <<  item->text(ID_PL_SONG) << " Ord: " << n << '\n';
          n++;
          item = item->itemBelow();
     }
     cerr << "Saved" << endl;

     saved=true;
}


void PLView::slotNew()
{
     if (!saved)
     {
          if((KMessageBox::warningYesNo(this,
                    i18n("This PlayList has been modified \n"
                         "Would you like to save it ?")))== 3)
               slotSave();
     }
     plName->setCurrentItem(-1);
     listview->clear();
     saved=true;
     totalLength=0;
     emit totalLengthCh (elabLengthTotal(totalLength));
}

// Delete current playlist

void PLView::slotDelete()
{
     if(KMessageBox::questionYesNo(this, i18n("Do you really want \n"
                                             "to delete this Playlist ?"))==3)
     {
          if (!(plName->currentText().isEmpty()))
          {
               //MyDb db;
               db->delPL(plName->currentText());
               plName->currentItem();
               plName->removeItem(plName->currentItem());
               plName->setCurrentItem(-1);
          }
          listview->clear();
          saved = true;
          totalLength=0;
          emit totalLengthCh (elabLengthTotal(totalLength));
     }
}

// Make local copy of a playlist
// doesn't control if the directory is writable ! adding it

void PLView::slotLocalPL()
{
     if (!saved)
     {
          if((KMessageBox::warningYesNo(this,
                    i18n("This PlayList has been modified \n"
                         "to create local copy, you must save it\n"
                         "Would you like to save it ?")))== 3)
               slotSave();
          else
               return;
     }

     mp3kult->slotStatusMsg(i18n("Create Local."));

     LocalPLDial local(db, this, plName->currentText());
     if(local.exec()==0)
     {
          //MYSQL_RES* res;
          MYSQL_ROW row;
          //MyDb db;
          int n=0;
          int mp3num;
          QString cmd, newfile, locName, locPath;

          mp3kult->setCursorBusy(true);

          locName = local.getPLName();
          locPath = local.getDirPath();

          cmd = "mkdir '";
          cmd += locPath + locName + "'";
          system (cmd);

          mp3num = db->getPL(plName->currentText(), "Volume", "ASC");

          //mp3num = db->getNumres();
         // cerr << "Total mp3s in Playlist: " << mp3num << endl;
          mp3kult->initProgBar(mp3num);

          while ((row = db->getRow()))
          {
               QFileInfo file(row[ID_DB_PL_FILE]);
               while (!file.exists())
               {
                    if((KMessageBox::warningContinueCancel(this,
                         i18n("File " + QString(row[ID_DB_PL_FILE]) + "\n"
                         "doesn't exist, " + "before continue mount " + "\n"
                          + QString(row[ID_DB_PL_VOLUME])), i18n("File not found"), i18n("Continue")))== 2)
                         {
                              db->delPL(locName);
                              return;
                         }
               }

               KProcess p;
               p << "cp" << file.filePath() << (locPath + locName);

               //Construct new local file Path !
               newfile=locPath;
               newfile += locName + "/" + file.fileName();
               p.start(KProcess::Block);

               db->addEntryPL (row[ID_DB_PL_SONG], atoi(row[ID_DB_PL_LENGTH]),
                              "Local", locName, newfile,
                              atoi(row[ID_DB_PL_MP3ID]), n);
               n++;
               mp3kult->advProgBar(1);
               kapp->processEvents();
               cerr << "Local File: " << newfile << endl;
          }
          db->freeRes();
          plName->insertItem(locName);
          plName->setCurrentItem((plName->count())-1);
          slotChangePl(locName);
          mp3kult->resetProgBar();
     }
     mp3kult->setCursorBusy(false);
     mp3kult->slotStatusMsg(i18n("Ready."));
}

/*void PLView::slotRemoveSong()
{
     PLListItem* item;
     item = (PLListItem*) listview->currentItem();
     removeSong(item);
}*/

void PLView::slotRemoveSongs()
{

     //PLListItem *item, *itemtmp;

 /*    item = (PLListItem*) listview->currentItem();

     while ((item->itemBelow())!=NULL && (item->itemBelow()->isSelected()))
          item = item->itemBelow();

     while ((item != NULL) && (item->isSelected()))
     {
          itemtmp = item;
          item = item->itemAbove();
          removeSong(itemtmp);
     }*/
	QList<QListViewItem> itemList(listview->selectedItems());
	QListIterator<QListViewItem> itemIt(itemList);

	while (itemIt.current())
	{
		//cerr << "pinser" << endl;
		removeSong((PLListItem*)itemIt.current());
		++itemIt;
	}
}

void PLView::slotExport()
{
    QString file;
    file = KFileDialog::getSaveFileName(QDir::homeDirPath(), "*.m3u|M3u File",
                                                this, i18n("Save File..."));

    if((file.isEmpty ()))
       return;

    if (!(file.contains(".m3u", false)))
            file += ".m3u";

    QFileInfo info(file);
    if (info.exists())
    {
         int res = KMessageBox::warningYesNo (this, i18n("File already exists \n"
                                    "Overwrite ?"), i18n("File already exists"));

        if (res == 4) // Response = No
            return;
        else if (!(info.isWritable()))
             {
                    KMessageBox::error(mp3kult , i18n("File not writable"));
                    return;
             }

    }

    Export exp(listview, file);
    exp.exportM3uPL();
}

void PLView::slotImport()
{
   QString file;
   file = KFileDialog::getOpenFileName(QDir::homeDirPath(), "*.m3u|M3u File",
                                                this, i18n("Open File..."));

   if((file.isEmpty ()))
       return;

 /*  QFileInfo info(file);

   if (!(info.isReadable()))
   {
      KMessageBox::error(mp3kult , i18n("File not readable"));
        return;
   }    */

   QFile fout(file);
    if ( fout.open(IO_ReadOnly) ) {    // file opened successfully
        QTextStream t( &fout );        // use a text stream
        QString s, sName, sPath;
        //QListViewItem* item, *itemtmp;
        Mp3ListItem* item;
        bool first = true/*, found*/;
        //MyDb db;
        MYSQL_ROW row;

        while ( !t.eof() ) {        // until end of file...
            s = t.readLine();       // line of text excluding '\n'
            QFileInfo sInfo(s);
            sName = sInfo.fileName();
            sPath = sInfo.dirPath();
            //found = false;
            //item=mkview->getListView()->firstChild();
            //itemtmp=NULL;
            cerr << "File: " << sName << " Path: " << sPath<<endl;
            if ((db->getMp3(sName, sPath)) < 1)
            {
              cerr << "Niente Nome+Path - Ris: "<< db->getNumres() << endl;
              db->freeRes();
              if ((db->getMp3(sName)) < 1)
              {
                cerr << "Niente nome - Ris: "<< db->getNumres() <<endl;
                db->freeRes();
                continue;
              }
            }
            if (first)
              slotNew();

            row = db->getRow();

            item =new Mp3ListItem(listview, atoi(row[ID_DB_MP3ID]), atoi(row[ID_DB_LENGTH]));
            item->setText (ID_TITLE, row[ID_DB_TITLE]);
            item->setText (ID_ARTIST, row[ID_DB_ARTIST]);
            item->setText (ID_LENGTH, elabLength(atoi(row[ID_DB_LENGTH])));
            item->setText (ID_VOLUME, row[ID_DB_VOLUME]);
            item->setText (ID_PATH, row[ID_DB_PATH]);
            item->setText (ID_FNAME, row[ID_DB_FNAME]);
            addSong(item);
            first=false;
            db->freeRes();
            delete item;
            }
           }
         /*   while (item)
            {
              if (!(strcmp (item->text(ID_FNAME), sName )))
              {
                itemtmp = item;
                if (!(strcmp (item->text(ID_PATH), sPath)))
                {
                  if (first)
                    slotNew();
                  addSong((Mp3ListItem*) item);
                  first = false;
                  found = true;
                  break;
                }
              }
              item = item->itemBelow();
            }
            if (!found && itemtmp)
            {
              if (first)
                slotNew();
              addSong((Mp3ListItem*) itemtmp);
              first=false;
            }
        }  
        fout.close();
    }     */
    else
    {
      KMessageBox::error(mp3kult , i18n("File not readable"));
        return;
    }
}

void PLView::slotRename()
{
	Rename rename(db, this, 0, "PList");
	QString current;

	if (rename.exec() == 0)
	{
		db->renamePL(rename.getNewName(), rename.getOldName());

		if (rename.getOldName() == plName->currentText())
			current = rename.getNewName();
		else
			current = plName->currentText();

		plName->clear();
		initplName();
		for (int i = 0; i < plName->count(); i++)
		{
			if (plName->text(i) == current)
			{
				plName->setCurrentItem(i);
				break;
			}
		}
		cerr << "PlayList renamed: " << rename.getOldName() << endl;
	}
}

#include "plview.moc"
