/************************************************************
*   mpgtx an mpeg toolbox                                      *
*   by Laurent Alacoque <laureck@users.sourceforge.net>     *   
*   (c) 2001                                                *
*   You may copy, modify and redistribute this              *
*   source file under the terms of the GNU Public License   *
************************************************************/
#ifndef _mpegOut_
#define _mpegOut_

#include "common.hh"
#include "mpeg.hh"
#include <unistd.h>		//required by access()

class mpeg;


class mpegOut
{
public:
	mpegOut(char *filename, bool status = true);
	mpegOut(FILE *filehandle, bool status = false);
	virtual ~mpegOut();
	const FILE* OutFile() {return MpegOut;}
	int WriteChunk(mpeg* Mpeg, off_t from, off_t to)
			{return WriteChunk(Mpeg, from, false, to, true);};
	virtual void WriteHeader(mpeg* Mpeg) = 0;
	virtual int WriteChunk (mpeg* Mpeg,
		off_t from, bool from_included,
		off_t to, bool to_included) = 0;
	virtual void Finish() {};

protected:
	mpegOut() {};
	virtual void Copy(FILE* file, off_t from, off_t to) = 0;
	int FileType;
	bool HasAudio,HasVideo;
	FILE* MpegOut;
	byte* buffer;
	bool print_status;
};


class mpegOutWithVideo : public mpegOut
{
protected:
	mpegOutWithVideo(char* filename, bool status=true) : 
		mpegOut(filename, status) {mpeg_version = 0;};
	mpegOutWithVideo(FILE* filehandle, bool status=true) : 
		mpegOut(filehandle, status) {mpeg_version = 0;};

	mpegOutWithVideo(){};
	void CorrectTS(int bufferlength);

	void memReadTS(int offset, double* ts, bool mpeg2pack = false);
	int  memReadPktTS(int* off, double* pts, double* dts, int bufferlength);
	void memWriteTS(int offset, double ts, bool mpeg2pack = false);

	double currentTS;
	double ts_correction;
	bool first_TS_correction;
	
	int mpeg_version;
};

class mpegVideoOut : public mpegOutWithVideo
{
public:
	mpegVideoOut(char* filename, bool status = true) :
		mpegOutWithVideo(filename,status) {};
	mpegVideoOut(FILE* filehandle, bool status = true) :
		mpegOutWithVideo(filehandle,status) {};
		
	void WriteHeader(mpeg* Mpeg);
	int WriteChunk (mpeg* Mpeg,
		off_t from, bool from_included,
		off_t to, bool to_included );
protected:
	mpegVideoOut(){};
	void Copy(FILE* file, off_t from, off_t to);
};


class mpegSystemOut : public mpegOutWithVideo
{
public:
	mpegSystemOut(char* filename, bool status = true) :
		mpegOutWithVideo(filename, status) {partial_packet = 0;};
	mpegSystemOut(FILE* filehandle, bool status = true) :
		mpegOutWithVideo(filehandle, status) {partial_packet = 0;};

	void WriteHeader(mpeg* Mpeg);
	int WriteChunk(mpeg* Mpeg,
		off_t from, bool from_included,
		off_t to, bool to_included );
	void Finish(); 
	
protected:
	mpegSystemOut() {};
	void Copy(FILE* file, off_t from, off_t to);

	//size of data from the end of the packet header to the end of file
	off_t partial_packet_length;
	//keep the partial packet in memory (because stdout is not seekable)
	byte* partial_packet;
};

class mpegAudioOut : public mpegOut
{
public:
	mpegAudioOut(char* filename,bool status=true):
		mpegOut(filename,status){};
	mpegAudioOut(FILE* filehandle,bool status=true):
		mpegOut(filehandle,status){};

	void WriteHeader(mpeg* Mpeg){};
	int WriteChunk(mpeg* Mpeg,
		off_t from, bool from_included,
		off_t to, bool to_included );

	void Finish();
protected:
	mpegAudioOut(){};
	void Copy(FILE* file, off_t from, off_t to);
};

class mpegOutFactory {
public:
	mpegOut* NewMpegFrom(mpeg* MpegIn, char* filename, bool status = true);
	mpegOut* NewMpegFrom(mpeg* MpegIn, FILE* filehandle, bool status = false);
};


class demuxer
{
public:
	demuxer(mpeg* _Mpeg, char* _basename, bool _confirm = true);
	~demuxer();
	int Process();
	
protected:
	int ProcessTransportStream();
	int ProcessProgramStream();
	int DemuxTrPkt(FILE* out, off_t start, off_t end);
	FILE* openfile(char* filename);
	off_t Copy(FILE* into, off_t from, off_t to);
	demuxer() {};
	FILE* AudioFile[16];
	int n_audio;
	FILE* VideoFile[16];
	int n_video;
	int n_programs;
	mpeg* Mpeg;
	char* basename;
	bool confirm;
	byte* buffer;
};

#endif //_mpegOut_
