/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2;

import base.drawable.Composite;
import base.drawable.DrawOrderComparator;
import base.drawable.Drawable;
import base.drawable.Primitive;
import base.drawable.TimeBoundingBox;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;

public class IteratorOfForePrimitives
implements Iterator {
    private static final DrawOrderComparator DRAWING_ORDER = new DrawOrderComparator();
    private ListIterator drawables_itr;
    private TimeBoundingBox timeframe;
    private TreeSet set_primes;
    private Primitive next_primitive;

    public IteratorOfForePrimitives(List list, TimeBoundingBox timeBoundingBox) {
        this.drawables_itr = list.listIterator(0);
        this.timeframe = timeBoundingBox;
        this.set_primes = new TreeSet(DRAWING_ORDER);
        this.next_primitive = this.getNextInQueue();
    }

    private Primitive getNextInQueue() {
        Primitive primitive = null;
        while (this.drawables_itr.hasNext()) {
            Drawable drawable = (Drawable)this.drawables_itr.next();
            if (!drawable.overlaps(this.timeframe)) continue;
            if (drawable instanceof Composite) {
                Composite composite = (Composite)drawable;
                composite.addPrimitivesToSet(this.set_primes, this.timeframe);
                try {
                    primitive = (Primitive)this.set_primes.first();
                    this.set_primes.remove(primitive);
                    return primitive;
                }
                catch (NoSuchElementException noSuchElementException) {
                    continue;
                }
            }
            if (!this.set_primes.isEmpty()) {
                this.set_primes.add(drawable);
                primitive = (Primitive)this.set_primes.first();
                this.set_primes.remove(primitive);
                return primitive;
            }
            primitive = (Primitive)drawable;
            return primitive;
        }
        if (primitive == null && !this.set_primes.isEmpty()) {
            primitive = (Primitive)this.set_primes.first();
            this.set_primes.remove(primitive);
            return primitive;
        }
        return null;
    }

    public boolean hasNext() {
        return this.next_primitive != null;
    }

    public Object next() {
        Primitive primitive = this.next_primitive;
        this.next_primitive = this.getNextInQueue();
        return primitive;
    }

    public void remove() {
    }
}

