//
// int2e.cc
//
// Copyright (C) 1996 Limit Point Systems, Inc.
//
// Author: Curtis Janssen <cljanss@limitpt.com>
// Maintainer: LPS
//
// This file is part of the SC Toolkit.
//
// The SC Toolkit is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// The SC Toolkit is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the SC Toolkit; see the file COPYING.LIB.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The U.S. Government is granted a limited license as per AL 91-7.
//

#ifdef __GNUG__
#pragma implementation
#endif

#include <chemistry/qc/basis/integral.h>
#include <chemistry/qc/intv3/int2e.h>
#include <chemistry/qc/intv3/utils.h>

Int2eV3::Int2eV3(Integral *integral,
                 const Ref<GaussianBasisSet>& b1,
                 const Ref<GaussianBasisSet>& b2,
                 const Ref<GaussianBasisSet>& b3,
                 const Ref<GaussianBasisSet>& b4,
                 int order, int storage) :
  integral_(integral),
  grp_(integral->messagegrp()),
  store(0),
  int_Qvec(0),
  int_Rvec(0)
{
  bs1_ = b1;
  bs2_ = b2;
  bs3_ = b3;
  bs4_ = b4;

  if (bs2_.null()) bs2_ = bs1_;
  if (bs3_.null()) bs3_ = bs2_;
  if (bs4_.null()) bs4_ = bs3_;

  transform_init();
  int_initialize_offsets2();
  int_initialize_erep(storage,order,bs1_,bs2_,bs3_,bs4_);
  if (order==0) {
    init_bounds();
  } else if (order==1) {
    init_bounds_1der();
  }
}

Int2eV3::~Int2eV3()
{
  transform_done();
  int_done_offsets2();
  int_done_erep();
  if (int_integral_storage) {
    done_storage();
  }
  done_bounds();
  done_bounds_1der();
}

/////////////////////////////////////////////////////////////////////////////

// Local Variables:
// mode: c++
// c-file-style: "CLJ-CONDENSED"
// End:
