#ifndef BASIC_3D_OUTPUTTER_TXX_
#define BASIC_3D_OUTPUTTER_TXX_

#include <string>
#include <map>

#include <wx/log.h>

#include "Volume.h"
#include "OutputterBase.h"
#include "BasicVolumeFormat.h"

namespace jcs {


template <class T>
Basic3DConversion<T>::Basic3DConversion(Basic3DOutputter* outputter, SeriesHandler* handler)
: mOutputter(outputter), mHandler(handler)
{
}


template <class T> int
Basic3DConversion<T>::GetSkip()
{
	std::string series_uid = mHandler->GetSeriesUid();
	int nVolumes = mHandler->GetNumberOfVolumes();
	int skip = mOutputter->GetSkip(series_uid);
	if (nVolumes > skip)
	   return skip;
	else
	   return 0;
}

template <class T> int
Basic3DConversion<T>::GetNumberOfVolumes()
{
	int nVolumes = mHandler->GetNumberOfVolumes();
	return nVolumes - GetSkip();
}

template <class T> void
Basic3DConversion<T>::Convert()
{
	typedef std::map <VolId, Volume<T> > vMapType;
	vMapType volumes;
	mHandler->rescale = mOutputter->rescale;
	mHandler->GetVolumes(volumes);

	GetHeaderForSeries();

	std::string series_uid = mHandler->GetSeriesUid();
	int dimensionality = mOutputter->GetDimensionality(series_uid);

	if (dimensionality == 4) {
		
		wxFileName file = mOutputter->GetFileName(series_uid);
		if (file.GetName() == _T("error")) {
			wxLogError(_T("File name error"));
			return;
		}
		file.SetExt(_T(""));
		BasicVolumeFormat* outputVolume = mOutputter->GetOutputVolume(file.GetFullPath().mb_str(wxConvLocal));

		typename vMapType::iterator it = volumes.begin();
		CompleteHeaderForVolume(*it);

		outputVolume->WriteHeader(GetHeader());

		for (int i = 0; i < GetSkip(); ++i) ++it;

		while(it != volumes.end()) {

			typedef std::map<float, std::vector<T> > SliceMap;

			typename SliceMap::iterator slice_it = it->second.begin();
			typename SliceMap::iterator slice_end = it->second.end();

			while (slice_it != slice_end) {
				ProcessSlice(slice_it->second);
				outputVolume->AppendRawData(reinterpret_cast<char*> 
				(&slice_it->second.front()), slice_it->second.size() * sizeof(slice_it->second.front()));
				++slice_it;
			}

			++it;
			wxTheApp->Yield();
		}
		delete outputVolume;

	} else {

		typename vMapType::iterator it = volumes.begin();

		for (int i = 0; i < GetSkip(); ++i) ++it;

		while(it != volumes.end()) {

			CompleteHeaderForVolume(*it);

			wxFileName file = mOutputter->GetFileNameFromVolId(it->first);
			if (file.GetName() == _T("error")) {
				wxLogError(_T("File name error"));
				break;
			}

			file.SetExt(_T(""));
			BasicVolumeFormat* outputVolume = mOutputter->GetOutputVolume(file.GetFullPath().mb_str(wxConvLocal));

			outputVolume->WriteHeader(GetHeader());

			typedef std::map<float, std::vector<T> > SliceMap;

			typename SliceMap::iterator slice_it = it->second.begin();
			typename SliceMap::iterator slice_end = it->second.end();

			while (slice_it != slice_end) {
				ProcessSlice(slice_it->second);
				outputVolume->AppendRawData(reinterpret_cast<char*> 
				(&slice_it->second.front()), slice_it->second.size() * sizeof(slice_it->second.front()));
				++slice_it;
			}

			delete outputVolume;
			++it;
			wxTheApp->Yield();
		}

	}

	if (this->mHandler->IsMoCo()) WriteMoCoFiles();

}


template <class T> void
Basic3DConversion<T>::WriteMoCoFiles()
{

	std::vector<std::string> moco;
	this->mHandler->GetImageComments(moco);

	if (moco.size() == 0) return;

	std::string key = this->mHandler->GetSeriesUid() + "_moco";
	wxFileName fileName = this->mOutputter->mOutputList.GetFullFileName(key);

	if (fileName.GetName() == _T("error")) {
		wxLogError(_T("File name error"));
		return;
	}
	wxFileName::Mkdir(fileName.GetPath(wxPATH_GET_VOLUME), 0777, wxPATH_MKDIR_FULL);

	std::ofstream output;

	output.open(fileName.GetFullPath().mb_str(wxConvLocal));
	std::vector<std::string>::iterator it = moco.begin();
	while (it < moco.end()) {
		output << *it << std::endl;
		++it;
	}

	output.close();


}
}


#endif
