/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* 
 * Author : 
 *  Damon Chaplin <damon@ximian.com>
 *
 * Copyright 1999, Ximian, Inc.
 * Copyright 2001, Ximian, Inc.
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */
/*
 * This code was taken from Evolution, and modified by
 * Thomas Nyberg <thomas@codefactory.se>.
 */
#ifndef __MONTH_VIEW_H__
#define __MONTH_VIEW_H__

#include <gtk/gtktable.h>
#include <libgnomeui/gnome-canvas.h>
#include "libmrproject/GNOME_MrProject.h"
#include "util/corba-utils.h"

/*
 * MonthView - displays the month-views of the calendar
 */

/* The maximum number of weeks we show. 5 is usually enough for 1 month,
   but we allow 6 for longer selections. */
#define MONTH_VIEW_MAX_WEEKS		6

/* The size of the reminder & recurrence icons, and padding around them.
   X_PAD is the padding between icons. R_PAD is the padding on the right of
   the last icon, before the event text. */
#define MONTH_VIEW_ICON_WIDTH		16
#define MONTH_VIEW_ICON_HEIGHT		16
#define MONTH_VIEW_ICON_X_PAD		0
#define MONTH_VIEW_ICON_Y_PAD		0
#define MONTH_VIEW_ICON_R_PAD		2

/* The space on the left & right outside of the event. (The triangle to
   indicate the event continues is displayed in this space). */
#define MONTH_VIEW_EVENT_L_PAD		2
#define MONTH_VIEW_EVENT_R_PAD		2

/* The vertical spacing between rows of events. */
#define MONTH_VIEW_EVENT_Y_SPACING	1

/* The size of the border around long events. */
#define MONTH_VIEW_EVENT_BORDER_WIDTH	1
#define MONTH_VIEW_EVENT_BORDER_HEIGHT	1

/* The padding on the top and bottom of the event text. */
#define MONTH_VIEW_EVENT_TEXT_Y_PAD	1

/* The space between the start and end times. */
#define MONTH_VIEW_EVENT_TIME_SPACING	2

/* The space between the time and the event text or icons. */
#define MONTH_VIEW_EVENT_TIME_X_PAD	2

/* The space between the borders of long events and any text of icons. */
#define MONTH_VIEW_EVENT_EDGE_X_PAD	2

/* The padding above and on the right of the date string at the top of each
   cell. */
#define MONTH_VIEW_DATE_T_PAD		2
#define MONTH_VIEW_DATE_R_PAD		4

/* The padding above and below the line under the date string, in the Week
   view, and also the space on the left of it. */
#define MONTH_VIEW_DATE_LINE_T_PAD	1
#define MONTH_VIEW_DATE_LINE_B_PAD	1
#define MONTH_VIEW_DATE_LINE_L_PAD	10

/* The padding below the date string in the Month view. */
#define MONTH_VIEW_DATE_B_PAD		1

/* We use a 7-bit field to store row numbers in EWeekViewEventSpan, so the
   maximum number or rows we can allow is 127. It is very unlikely to be
   reached anyway. */
#define MONTH_VIEW_MAX_ROWS_PER_CELL	127

/* These index our colors array. */
typedef enum
{
	MONTH_VIEW_COLOR_EVEN_MONTHS,
	MONTH_VIEW_COLOR_ODD_MONTHS,
	MONTH_VIEW_COLOR_EVENT_BACKGROUND,
	MONTH_VIEW_COLOR_EVENT_BORDER,
	MONTH_VIEW_COLOR_EVENT_TEXT,
	MONTH_VIEW_COLOR_SUMMARY_EVENT_BACKGROUND,
	MONTH_VIEW_COLOR_GRID,
	MONTH_VIEW_COLOR_SELECTED,
	MONTH_VIEW_COLOR_DATES,
	MONTH_VIEW_COLOR_DATES_SELECTED,
	
	MONTH_VIEW_COLOR_LAST
} MonthViewColors;

#define MONTH_VIEW_TYPE          month_view_get_type ()
#define MONTH_VIEW(obj)          GTK_CHECK_CAST (obj, MONTH_VIEW_TYPE, MonthView)
#define MONTH_VIEW_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, MONTH_VIEW_TYPE, MonthViewClass)
#define IS_MONTH_VIEW(obj)       GTK_CHECK_TYPE (obj, MONTH_VIEW_TYPE)


typedef struct _MonthView       MonthView;
typedef struct _MonthViewClass  MonthViewClass;
typedef struct _MonthViewPriv   MonthViewPriv;

struct _MonthView {
	GtkTable parent;

	GnomeCanvas *main_canvas;
	GnomeCanvasItem *main_canvas_item;

	GnomeCanvas *titles_canvas;
	GnomeCanvasItem *titles_canvas_item;

	GtkWidget *vscrollbar;

	/* The start of each day displayed. */
	time_t day_starts[MONTH_VIEW_MAX_WEEKS * 7 + 1];

	/* The base date, where the adjustment value is 0. */
	GDate base_date;

	/* The first day shown in the view. */
	GDate first_day_shown;

	/* How many weeks we are showing. This is only relevant if
	   display_month is TRUE. */
	gint weeks_shown;

	/* If Sat & Sun are compressed. Only applicable in month view, since
	   they are always compressed into 1 cell in the week view. */
	gboolean compress_weekend;

	/* The first day of the week, 0 (Monday) to 6 (Sunday). */
	gint week_start_day;

	/* Whether we use 12-hour of 24-hour format. */
	gboolean use_24_hour_format;

	/* The first day of the week we display, 0 (Monday) to 6 (Sunday).
	   This will usually be week_start_day, but if the weekend is
	   compressed, and week_start_day is Sunday we have to use Saturday. */
	gint display_start_day;

	/* The vertical offset of the events from the top of the cells. */
	gint events_y_offset;

	/* The height of the events, not including spacing between them. */
	gint row_height;

	/* The number of rows of events in each cell. */
	gint rows_per_cell;
	gint rows_per_compressed_cell;

	/* The number of rows we have used for each day (i.e. each cell) */
	gint rows_per_day[MONTH_VIEW_MAX_WEEKS * 7];

	/* If the small font is used for displaying the minutes. */
	gboolean use_small_font;

	/* Small font to display the minutes. */
	GdkFont *small_font;

	/* The widths of various pieces of text, used to determine which of
	   several date formats to display, set in e_week_view_style_set(). */
	gint space_width;		/* One space character ' '. */
	gint colon_width;		/* Size of ':' in the font. */
	gint slash_width;		/* Size of '/' in the font. */
	gint digit_width;		/* Size of a '0' digit. */
	gint small_digit_width;		/* Size of a small_font '0' digit. */
	gint day_widths[7];		/* Monday first. */
	gint max_day_width;
	gint abbr_day_widths[7];
	gint max_abbr_day_width;
	gint month_widths[12];
	gint max_month_width;
	gint abbr_month_widths[12];
	gint max_abbr_month_width;

	/* The size of the main grid of days and of the cells. A row
	   corresponds to a compressed day, so normal days usually take
	   up 2 rows. Note that the offsets arrays have one more element
	   than the widths/heights arrays since they also contain the
	   right/bottom edge. */
	gint rows;
	gint columns;
	gint col_widths[7];
	gint col_offsets[8];
	gint *row_heights;
	gint *row_offsets;

	/* The GC used for painting in different colors. */
	GdkGC *main_gc;

	/* The icons. */
	GdkPixmap *reminder_icon;
	GdkBitmap *reminder_mask;
	GdkPixmap *recurrence_icon;
	GdkBitmap *recurrence_mask;
	GdkPixmap *timezone_icon;
	GdkBitmap *timezone_mask;

	/* Colors for drawing. */
	GdkColor colors[MONTH_VIEW_COLOR_LAST];

	MonthViewPriv *priv;
};

struct _MonthViewClass {
	GtkTableClass parent_class;
};


GtkType    month_view_get_type                  (void);
GtkWidget *month_view_new                       (void);

/* The first day shown. Note that it will be rounded down to the start of a
   week when set. The returned value will be invalid if no date has been set
   yet. */
void	   month_view_get_first_day_shown	(MonthView      *month_view,
						 GDate		*date);
void	   month_view_set_first_day_shown	(MonthView      *month_view,
						 GDate		*date);

/*
 * Internal functions called by the associated canvas items.
 */
void       month_view_get_day_position		(MonthView      *month_view,
						 gint		 day,
						 gint		*day_x,
						 gint		*day_y,
						 gint		*day_w,
						 gint		*day_h);
gboolean   month_view_get_span_position	        (MonthView      *month_view,
						 gint            task_num,
						 gint            span_num,
						 gint		*span_x,
						 gint		*span_y,
						 gint		*span_w);
const gchar *month_view_get_task_title          (MonthView      *month_view,
						 gint            task_num);
gboolean   month_view_is_one_day_event		(MonthView      *month_view,
						 gint		 event_num);

void	   month_view_convert_time_to_display	(MonthView      *month_view,
						 gint		 hour,
						 gint		*display_hour,
						 gchar	       **suffix,
						 gint		*suffix_width);
gint	   month_view_get_time_string_width	(MonthView      *month_view);

gint	   month_view_event_sort_func		(const void	*arg1,
						 const void	*arg2);

void       month_view_insert_task               (MonthView      *month_view,
						 GM_Task        *task);
void       month_view_update_task               (MonthView      *month_view,
						 GM_Task        *task);
void       month_view_reparent_task             (MonthView      *month_view,
						 GM_Id          task_id,
						 GM_Id          new_parent_id);
void       month_view_remove_task               (MonthView      *month_view, 
						 GSList         *tasks);
void       month_view_clear                     (MonthView      *month_view);

GM_Task *  month_view_get_task                  (MonthView      *month_view,
						 gint            task_num);
						 
#endif /* __MONTH_VIEW_H__ */
