/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 Thomas Nyberg <thomas@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Thomas Nyberg
 */
#ifndef __RESOURCE_FILTER_H__
#define __RESOURCE_FILTER_H__

#include <glib.h>
#include <gtk/gtktypeutils.h>
#include <gtk/gtkobject.h>
#include "libmrproject/GNOME_MrProject.h"


#define RESOURCE_FILTER_TYPE         (resource_filter_get_type ())
#define RESOURCE_FILTER(o)           (GTK_CHECK_CAST ((o), RESOURCE_FILTER_TYPE, ResourceFilter))
#define RESOURCE_FILTER_CLASS(k)     (GTK_CHECK_CLASS_CAST ((k), RESOURCE_FILTER_TYPE, ResourceFilterClass))
#define IS_RESOURCE_FILTER(o)        (GTK_CHECK_TYPE ((o), RESOURCE_FILTER_TYPE))
#define IS_RESOURCE_FILTER_CLASS(k)  (GTK_CHECK_CLASS_TYPE ((k), RESOURCE_FILTER_TYPE))


typedef struct _ResourceFilter ResourceFilter;
typedef struct _ResourceFilterClass ResourceFilterClass;
typedef struct _ResourceFilterPriv ResourceFilterPriv;

struct _ResourceFilter {
	GtkObject parent;

	ResourceFilterPriv *priv;
};

struct _ResourceFilterClass {
	GtkObjectClass parent_class;
};

GtkType resource_filter_get_type       (void);
ResourceFilter *resource_filter_new    (void);

void resource_filter_add_resource      (ResourceFilter                   *filter, 
				        const GNOME_MrProject_Resource   *resource);
void resource_filter_add_task          (ResourceFilter                   *filter, 
			                const GNOME_MrProject_Task       *task);
void resource_filter_add_allocation    (ResourceFilter                   *filter, 
				        const GNOME_MrProject_Allocation *allocation);
void resource_filter_remove_resource   (ResourceFilter                   *filter, 
				        GNOME_MrProject_Id                id);
void resource_filter_remove_task       (ResourceFilter                   *filter, 
				        GNOME_MrProject_Id                id);
void resource_filter_remove_allocation (ResourceFilter                   *filter, 
					const GNOME_MrProject_Allocation *allocation);

gboolean resource_filter_task_is_visible    (ResourceFilter                *filter,
				             GNOME_MrProject_Id             id);
gboolean resource_filter_resource_get_state (ResourceFilter                *filter, 
					     GNOME_MrProject_Id             id);
void  resource_filter_resource_set_state    (ResourceFilter                *filter, 
					     GNOME_MrProject_Id             id, 
					     gboolean                       visible);
/* this is a lazy-function to ease some of the coding */
void resource_filter_all_resources_set_state (ResourceFilter               *filter, 
					      gboolean                      visible);

#endif /* __RESOURCE_FILTER_H__ */
