/*
 * Copyright (C) 2001  CodeFactory AB
 * Copyright (C) 2001  Richard Hult
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult <rhult@codefactory.se>
 */
#ifndef __GANTT_ARROW_ITEM_H__
#define __GANTT_ARROW_ITEM_H__

#include <gtk/gtk.h>
#include <libgnomeui/gnome-canvas.h>
#include <libgnomeui/gnome-canvas-line.h>

#include "gantt-row-item.h"

#define TYPE_GANTT_ARROW_ITEM			(gantt_arrow_item_get_type ())
#define GANTT_ARROW_ITEM(obj)			(GTK_CHECK_CAST ((obj), TYPE_GANTT_ARROW_ITEM, GanttArrowItem))
#define GANTT_ARROW_ITEM_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), TYPE_GANTT_ARROW_ITEM, GanttArrowItemClass))
#define IS_GANTT_ARROW_ITEM(obj)		(GTK_CHECK_TYPE ((obj), TYPE_GANTT_ARROW_ITEM))
#define IS_GANTT_ARROW_ITEM_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((obj), TYPE_GANTT_ARROW_ITEM))

typedef struct _GanttArrowItem       GanttArrowItem;
typedef struct _GanttArrowItemClass  GanttArrowItemClass;

struct _GanttArrowItem {
	GnomeCanvasLine  parent;

	GanttRowItem    *predecessor;
	GanttRowItem    *item;

	gdouble          x1, y1, x2, y2_top, y2_bottom;
};

struct _GanttArrowItemClass {
	GnomeCanvasLineClass parent_class;
};

GtkType         gantt_arrow_item_get_type (void);
GanttArrowItem *gantt_arrow_item_new      (GanttRowItem *item, GanttRowItem *predecessor);


#endif /* __GANTT_ARROW_ITEM_H__ */

