/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Richard Hult
 * 
 */

#include <gtk/gtk.h>
#include "util/type-utils.h"
#include "util/marshallers.h"
#include "gantt-printable.h"

static void gantt_printable_init	(GanttPrintable	     *map);
static void gantt_printable_class_init	(GanttPrintableClass *klass);
static void gantt_printable_destroy     (GtkObject           *object);

GNOME_CLASS_BOILERPLATE (GanttPrintable, gantt_printable, GtkObject, gtk_object);

enum {
	PRINT_PAGE,
	GET_WIDTH,
	GET_HEIGHT,
	GET_ROW_HEIGHT,
	LAST_SIGNAL
};

static gint signals [LAST_SIGNAL] = { 0, };

static void
gantt_printable_class_init (GanttPrintableClass *klass)
{
	GtkObjectClass *object_class;
	
	object_class = (GtkObjectClass*) klass;
	object_class->destroy = gantt_printable_destroy;
	
	parent_class = gtk_type_class (GTK_TYPE_OBJECT);

	signals [PRINT_PAGE] =
		gtk_signal_new ("print_page",
				GTK_RUN_LAST,
				object_class->type,
				0,
				mrproject_marshal_NONE__POINTER_POINTER_DOUBLE_DOUBLE_INT_INT_INT_INT,
				GTK_TYPE_NONE, 8,
				GTK_TYPE_POINTER,
				GTK_TYPE_POINTER,
				GTK_TYPE_DOUBLE,
				GTK_TYPE_DOUBLE,
				GTK_TYPE_INT,
				GTK_TYPE_INT,
				GTK_TYPE_INT,
				GTK_TYPE_INT);

	signals [GET_WIDTH] =
		gtk_signal_new ("get_width",
				GTK_RUN_LAST,
				object_class->type,
				0,
				mrproject_marshal_DOUBLE__POINTER_INT_INT,
				GTK_TYPE_DOUBLE, 3, 
				GTK_TYPE_POINTER, GTK_TYPE_INT, GTK_TYPE_INT);

	signals [GET_HEIGHT] =
		gtk_signal_new ("get_height",
				GTK_RUN_LAST,
				object_class->type,
				0,
				mrproject_marshal_DOUBLE__POINTER,
				GTK_TYPE_DOUBLE, 1, 
				GTK_TYPE_POINTER);

	signals [GET_ROW_HEIGHT] =
		gtk_signal_new ("get_row_height",
				GTK_RUN_LAST,
				object_class->type,
				0,
				mrproject_marshal_DOUBLE__POINTER,
				GTK_TYPE_DOUBLE, 1, 
				GTK_TYPE_POINTER);

	gtk_object_class_add_signals (object_class, signals, LAST_SIGNAL);
}

static void
gantt_printable_init (GanttPrintable *printable)
{
}

static void
gantt_printable_destroy (GtkObject *object)
{
	GanttPrintable *gantt_printable;

	gantt_printable = GANTT_PRINTABLE (object);
	
	GNOME_CALL_PARENT_HANDLER (GTK_OBJECT_CLASS, destroy, (object));
}

GanttPrintable *
gantt_printable_new (void)
{
	GanttPrintable *printable;

	printable = gtk_type_new (TYPE_GANTT_PRINTABLE);
	return printable;
}

gdouble
gantt_printable_get_width (GanttPrintable *printable,
			   GanttPrintInfo *print_info,
			   time_t          from_time,
			   time_t          to_time)
{
	gdouble width;

	width = 0;
	gtk_signal_emit (GTK_OBJECT (printable),
			 signals[GET_WIDTH],
			 print_info,
			 (int) from_time,
			 (int) to_time,
			 &width);

	return width;
}

gdouble
gantt_printable_get_height (GanttPrintable *printable,
			    GanttPrintInfo *print_info)
{
	gdouble height;

	height = 0;
	gtk_signal_emit (GTK_OBJECT (printable),
			 signals[GET_HEIGHT],
			 print_info,
			 &height);

	return height;
}

gdouble
gantt_printable_get_row_height (GanttPrintable *printable,
				GanttPrintInfo *print_info)
{
	gdouble height;

	height = 0;
	gtk_signal_emit (GTK_OBJECT (printable),
			 signals[GET_ROW_HEIGHT],
			 print_info,
			 &height);
	
	return height;
}

void
gantt_printable_print_page (GanttPrintable *printable,
			    GanttPrintInfo *print_info,
			    ArtDRect       *bbox,
			    gdouble         hscale,
			    gdouble         vscale,
			    time_t          t1,
			    time_t          t2,
			    gint            r1,
			    gint            r2)
{
	/* Clip to our bounds. */
	gnome_print_gsave (print_info->context);

	gnome_print_newpath (print_info->context);
	gnome_print_setlinewidth (print_info->context, 0);

	gnome_print_moveto (print_info->context, bbox->x0, bbox->y0);
	gnome_print_lineto (print_info->context, bbox->x0, bbox->y1);
	gnome_print_lineto (print_info->context, bbox->x1, bbox->y1);
        gnome_print_lineto (print_info->context, bbox->x1, bbox->y0);
        gnome_print_lineto (print_info->context, bbox->x0, bbox->y0);
        gnome_print_closepath (print_info->context);
	gnome_print_gsave (print_info->context);
	gnome_print_setrgbcolor (print_info->context, 255, 0, 0);
        gnome_print_stroke (print_info->context);
	gnome_print_grestore (print_info->context);

	gnome_print_clip (print_info->context);

	gtk_signal_emit (GTK_OBJECT (printable),
			 signals[PRINT_PAGE],
			 print_info,
			 bbox,
			 hscale,
			 vscale,
			 t1,
			 t2,
			 r1,
			 r2);

	gnome_print_grestore (print_info->context);
}



