/*
 * Copyright (C) 2001  CodeFactory AB
 * Copyright (C) 2001  Richard Hult
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult <rhult@codefactory.se>
 */
#ifndef __GANTT_SCALE_H__
#define __GANTT_SCALE_H__

#include <gtk/gtk.h>
#include <time.h>

#define TYPE_GANTT_SCALE			(gantt_scale_get_type ())
#define GANTT_SCALE(obj)			(GTK_CHECK_CAST ((obj), TYPE_GANTT_SCALE, GanttScale))
#define GANTT_SCALE_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), TYPE_GANTT_SCALE, GanttScaleClass))
#define IS_GANTT_SCALE(obj)			(GTK_CHECK_TYPE ((obj), TYPE_GANTT_SCALE))
#define IS_GANTT_SCALE_CLASS(klass)		(GTK_CHECK_CLASS_TYPE ((obj), TYPE_GANTT_SCALE))


typedef struct _GanttScale       GanttScale;
typedef struct _GanttScaleClass  GanttScaleClass;

typedef enum {
	GANTT_UNIT_NONE    = 0,
	GANTT_UNIT_MINUTE,
	GANTT_UNIT_HOUR,
	GANTT_UNIT_DAY,
	GANTT_UNIT_WEEK,
	GANTT_UNIT_MONTH,
	GANTT_UNIT_QUARTER,
	GANTT_UNIT_YEAR,
} GanttUnit;

typedef enum {
	GANTT_UNIT_MINOR,
	GANTT_UNIT_MAJOR
} GanttUnitType;

struct _GanttScale {
	GtkObject parent;

	/* Units. Major must be > minor. */
	GanttUnit major_unit;
	GanttUnit minor_unit;

	/* Horizontal scale factor.
	 * time_t * scale = canvas world coordinates.
	 */
	gdouble   scale;

	/* The horizontal scroll region, a subset of the
	 * total timespan.
	 */
	time_t    t1, t2;

	/* This cached canvas world coordinates of the
	 * above values. FIXME: Remove?
	 */
	gdouble   x1, x2;
	
	/* Minimal viewport width, in canvas coordinates. */
	gdouble   min_width;

	/* Week starts on monday/sunday. */
	gboolean week_starts_on_monday;
};

struct _GanttScaleClass
{
	GtkObjectClass parent_class;
	
	/* Signals. */
	void (*units_changed)			(GanttScale	*gantt_scale);
	void (*scale_changed)			(GanttScale	*gantt_scale);
	void (*viewport_changed)		(GanttScale	*gantt_scale);
};

GtkType    gantt_scale_get_type			(void);
GanttScale *gantt_scale_new			(gdouble	 scale,
						 time_t		 t1,
						 time_t		 t2);

gdouble    gantt_scale_t2w			(GanttScale	*scale,
						 time_t		 t);
time_t     gantt_scale_w2t			(GanttScale	*scale,
						 gdouble	 x);
void       gantt_scale_set_units		(GanttScale	*scale,
						 GanttUnit	 major,
						 GanttUnit	 minor);
void       gantt_scale_set_week_starts_on_monday(GanttScale	*scale,
						 gboolean        monday);
void       gantt_scale_set_min_viewport_width	(GanttScale	*scale,
						 gdouble	 width);

void	   gantt_scale_set_viewport		(GanttScale	*scale,
						 time_t		 t1,
						 time_t		 t2);

void       gantt_scale_move_viewport		(GanttScale	*scale,
						 time_t		 dt);

void       gantt_scale_set_scale_factor		(GanttScale	*scale,
						 gdouble	 scale_factor);

void       gantt_scale_set_scale_factor_ex      (GanttScale     *scale,
						 gdouble         scale_factor,
						 time_t          center);

void       gantt_scale_zoom                     (GanttScale     *scale,
						 time_t          t1,
						 time_t          t2,
						 gdouble         width);

time_t     gantt_scale_snap_time		(GanttScale     *scale,
						 GanttUnitType   type,
						 time_t          t);

gboolean   gantt_scale_is_on_tick               (GanttScale     *scale,
						 GanttUnitType   type,
						 time_t          t);

time_t     gantt_scale_increase_one_tick        (GanttScale     *scale,
						 GanttUnitType   type,
						 time_t          t);

time_t     gantt_scale_unit_get_period          (GanttUnit       unit);

gchar     *gantt_scale_format_time              (GanttScale     *scale,
						 GanttUnitType   type,
						 time_t          t);

void       gantt_scale_show_time                (GanttScale     *scale,
						 time_t          t);

time_t     gantt_scale_get_minor_tick           (GanttScale     *scale);

time_t     gantt_scale_get_major_tick           (GanttScale     *scale);


#endif /* __GANTT_SCALE_H__ */

